/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.PasswordContext;
import com.sun.portal.cli.cert.SRADecoderException;

public class InstallPasswordContextImpl
implements PasswordContext {
    private String jsspass;

    public InstallPasswordContextImpl(String string) {
        this.jsspass = string;
    }

    public String generatePassphrase(JSSContext jSSContext) {
        boolean bl = false;
        if (jSSContext.isPasswordEcrypted()) {
            try {
                bl = CertAdminUtil.writeLine(JSSUtil.encryptPassword(this.jsspass), jSSContext.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
            }
            catch (SRADecoderException sRADecoderException) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m55", "Error!, Could not encode|decode the JSS engine password") + CertAdminConstants.newline + sRADecoderException);
                return null;
            }
        } else {
            bl = CertAdminUtil.writeLine(this.jsspass, jSSContext.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
        }
        if (!bl) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m42", "Could not store the password!"));
        }
        return this.jsspass;
    }
}

