/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminPasswordCallback;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11TokenCert;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class DeleteCertificate
implements Command {
    private JSSContext cntx;

    public boolean execute(JSSContext jSSContext) {
        this.cntx = jSSContext;
        String string = CertAdminUtil.question(CertAdminLocale.getPFString("q17", "Enter the name of the certificate to be deleted ?"));
        if (string.trim().equals("")) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m30", "Certificate name entered is not valid!"));
            return false;
        }
        if (!JSSUtil.certExist(jSSContext, string)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m31", "Specified certificate does not exist!"));
            return false;
        }
        try {
            this.deleteCertificate(string);
            CertAdminUtil.println(CertAdminLocale.getPFString("m26", "Certificate") + " " + string + " " + CertAdminLocale.getPFString("m32", "deleted successfully"));
            return true;
        }
        catch (Exception exception) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m33", "Could not delete the certificate!") + " " + string + " ");
            exception.printStackTrace();
            return false;
        }
    }

    private void deleteCertificate(String string) throws Exception {
        X509Certificate x509Certificate = this.cntx.getCryptoManager().findCertByNickname(string);
        this.deleteCertificate(x509Certificate);
    }

    private void deleteCertificate(X509Certificate x509Certificate) throws Exception {
        Object object;
        String string = this.cntx.getPasswordContext().generatePassphrase(this.cntx);
        CryptoToken cryptoToken = null;
        if (x509Certificate instanceof PK11TokenCert) {
            cryptoToken = ((PK11TokenCert)x509Certificate).getOwningToken();
            object = new ConsolePasswordCallback();
            if (!cryptoToken.passwordIsInitialized()) {
                cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)object);
            }
        } else {
            cryptoToken = this.cntx.getCryptoManager().getInternalKeyStorageToken();
            object = new CertAdminPasswordCallback(string);
            if (!cryptoToken.passwordIsInitialized()) {
                cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)object);
            }
        }
        cryptoToken.login((PasswordCallback)object);
        CryptoStore cryptoStore = cryptoToken.getCryptoStore();
        cryptoStore.deleteCert(x509Certificate);
    }
}

