/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.PimCalendarType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimAppointmentItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimCalendar;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewRecurrencePatternItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimNewReminderItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldRecurrencePatternItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimOldReminderItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimRecurrencePatternItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimReminderItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimBusyStatusTypeMapper;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimImportanceTypeMapper;
import com.aligo.pim.exchangewebdav.util.PropertyHolder;
import com.aligo.pim.exchangewebdav.util.WebDavDate;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.WebDavHelper;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExWebDavPimOldAppointmentItem
extends ExWebDavPimMessageItem
implements ExWebDavPimAppointmentItem {
    private Element m_oElement;
    private ExWebDavPimCalendar m_oPimCalendar;
    private PimCalendarType m_oPimCalendarType;
    private PimBusyStatusType m_oPimBusyStatusType;
    private WebDavDate m_oStartTime;
    private WebDavDate m_oEndTime;
    private boolean m_bIsAllDayEvent;
    private String m_szText;
    private PimImportanceType m_oPimImportanceType;
    private String m_szLocation;
    private String m_szSubject;
    private ExWebDavPimRecurrencePatternItem m_oPimRecurrencePatternItem;
    private ExWebDavPimReminderItem m_oPimReminderItem;
    private boolean m_bIsUpdateDone;

    public ExWebDavPimOldAppointmentItem(ExWebDavPimSession pimSession, ExWebDavPimCalendar pimCalendar, Element element) throws ExWebDavPimException {
        super(pimSession);
        this.m_oElement = element;
        this.m_oPimCalendar = pimCalendar;
        this.isAllDayEvent();
    }

    public ExWebDavPimCalendar getPimCalendar() {
        return this.m_oPimCalendar;
    }

    public String getUserMailbox() {
        return this.getPimCalendar().getUserMailbox();
    }

    public String getFolderName() {
        return this.getPimCalendar().getFolderName();
    }

    public PimReminderItem getReminderItem() throws ExWebDavPimException {
        try {
            return this.addReminderItem();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimReminderItem addReminderItem() throws ExWebDavPimException {
        try {
            if (this.m_oPimReminderItem == null) {
                String reminderOffset = XMLUtilities.getValue(this.m_oElement, WebDavField.REMINDEROFFSET);
                this.m_oPimReminderItem = reminderOffset == null ? new ExWebDavPimNewReminderItem() : new ExWebDavPimOldReminderItem(reminderOffset);
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws ExWebDavPimException {
        try {
            if (this.m_oPimRecurrencePatternItem == null) {
                Element recurStringElement = XMLUtilities.getValueAsElement(this.m_oElement, WebDavField.RRULE);
                Element exDateElement = XMLUtilities.getValueAsElement(this.m_oElement, WebDavField.EXDATE);
                if (recurStringElement != null) {
                    String recurrenceString = XMLUtilities.getValue(recurStringElement, WebDavField.V);
                    if (recurrenceString == null) {
                        this.m_oPimRecurrencePatternItem = new ExWebDavPimNewRecurrencePatternItem(this);
                    } else {
                        this.m_oPimRecurrencePatternItem = new ExWebDavPimOldRecurrencePatternItem(recurrenceString, this);
                        if (exDateElement != null) {
                            int numOfElements = XMLUtilities.getNumOfElements(exDateElement, WebDavField.V);
                            Vector<Date> exDateV = new Vector<Date>();
                            int i = 0;
                            while (i < numOfElements) {
                                String exDate = XMLUtilities.getValue(exDateElement, WebDavField.V, i);
                                WebDavDate webDavDate = new WebDavDate(exDate, this.getPimSession());
                                exDateV.add(webDavDate.getDate());
                                ++i;
                            }
                            if (exDateV.size() > 0) {
                                this.m_oPimRecurrencePatternItem.setExceptionDates(exDateV);
                            }
                        }
                    }
                }
            }
            return this.m_oPimRecurrencePatternItem;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getSubject() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.SUBJECT);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getID() throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(this.m_oElement, WebDavField.UID);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimImportanceType getImportance() throws ExWebDavPimException {
        try {
            String importance = XMLUtilities.getValue(this.m_oElement, WebDavField.PRIORITY);
            if (importance == null) {
                return PimImportanceType.NORMAL;
            }
            return ExWebDavPimImportanceTypeMapper.getType(importance);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getSender() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getDuration() throws ExWebDavPimException {
        try {
            String duration = XMLUtilities.getValue(this.m_oElement, WebDavField.DURATION);
            if (duration == null) {
                return 0;
            }
            long lduration = Long.parseLong(duration);
            return (int)(lduration / 60L);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getLocation() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.LOCATION);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getText() throws ExWebDavPimException {
        try {
            String str = XMLUtilities.getValue(this.m_oElement, WebDavField.TEXTDESCRIPTION);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Date getStartTime() throws ExWebDavPimException {
        try {
            return this.getWebDavStartTime().getDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public WebDavDate getWebDavEndTime() throws ExWebDavPimException {
        String dtEnd = XMLUtilities.getValue(this.m_oElement, WebDavField.DTEND);
        WebDavDate webDavEndDate = new WebDavDate(dtEnd, this.getPimSession());
        return webDavEndDate;
    }

    public WebDavDate getWebDavStartTime() throws ExWebDavPimException {
        String dtStart = XMLUtilities.getValue(this.m_oElement, WebDavField.DTSTART);
        WebDavDate webDavStartDate = new WebDavDate(dtStart, this.getPimSession());
        return webDavStartDate;
    }

    public Date getEndTime() throws ExWebDavPimException {
        try {
            return this.getWebDavEndTime().getDate();
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public boolean isAllDayEvent() throws ExWebDavPimException {
        try {
            String allDayEvent = XMLUtilities.getValue(this.m_oElement, WebDavField.ALLDAYEVENT);
            this.m_bIsAllDayEvent = allDayEvent.equals("1");
            return this.m_bIsAllDayEvent;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setSubject(String subject) throws ExWebDavPimException {
        try {
            this.m_szSubject = subject;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setLocation(String location) throws ExWebDavPimException {
        try {
            this.m_szLocation = location;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setImportance(PimImportanceType importance) throws ExWebDavPimException {
        try {
            this.m_oPimImportanceType = importance;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setBusyStatusType(PimBusyStatusType pimBusyStatusType) throws ExWebDavPimException {
        try {
            this.m_oPimBusyStatusType = pimBusyStatusType;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setText(String text) throws ExWebDavPimException {
        try {
            this.m_szText = text;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setStartTime(Date date) throws ExWebDavPimException {
        try {
            if (date != null) {
                this.m_oStartTime = new WebDavDate(date, this.getPimSession());
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setEndTime(Date date) throws ExWebDavPimException {
        try {
            if (date != null) {
                this.m_oEndTime = new WebDavDate(date, this.getPimSession());
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete() throws ExWebDavPimException {
        try {
            this.getPimSession().getHttpConnector().delete(this.getFileName());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public PimAddressEntryItem getOrganizer() throws ExWebDavPimException {
        return null;
    }

    public void setMeetingStatus(int meetingStatus) throws ExWebDavPimException {
    }

    public void setAllDayEvent(boolean isAllDayEvent) throws ExWebDavPimException {
        try {
            this.m_bIsAllDayEvent = isAllDayEvent;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private void checkValidity() throws ExWebDavPimException {
        Date startTime = new Date();
        Date endTime = new Date();
        endTime = this.m_oEndTime == null ? this.getEndTime() : this.m_oEndTime.getDate();
        int result = endTime.compareTo(startTime = this.m_oStartTime == null ? this.getStartTime() : this.m_oStartTime.getDate());
        if (result < 0) {
            throw new ExWebDavPimException(13L);
        }
    }

    public void update() throws ExWebDavPimException {
        try {
            ExWebDavPimRecurrencePatternItem pimRecurrencePatternItem;
            this.m_bIsUpdateDone = false;
            this.checkValidity();
            Vector<PropertyHolder> toSend = new Vector<PropertyHolder>();
            if (this.m_szSubject != null) {
                toSend.add(new PropertyHolder(WebDavField.SUBJECT, this.m_szSubject));
            }
            if (this.m_szText != null) {
                toSend.add(new PropertyHolder(WebDavField.TEXTDESCRIPTION, this.m_szText));
            }
            if (this.m_oPimImportanceType != null) {
                toSend.add(new PropertyHolder(WebDavField.PRIORITY, ExWebDavPimImportanceTypeMapper.getType(this.m_oPimImportanceType)));
            }
            if (this.m_szLocation != null) {
                toSend.add(new PropertyHolder(WebDavField.LOCATION, this.m_szLocation));
            }
            if (this.m_oPimRecurrencePatternItem != null && (pimRecurrencePatternItem = this.m_oPimRecurrencePatternItem).isItRecurringItem()) {
                toSend.add(new PropertyHolder(WebDavField.INSTANCETYPE, "1"));
                String recurrenceString = pimRecurrencePatternItem.getRecurrencePatternString();
                PropertyHolder propHolder = new PropertyHolder(WebDavField.V, recurrenceString);
                toSend.add(new PropertyHolder(WebDavField.RRULE, propHolder));
                Vector exceptionDates = this.m_oPimRecurrencePatternItem.getExceptionDates();
                if (exceptionDates != null) {
                    Vector<PropertyHolder> properties = new Vector<PropertyHolder>();
                    int i = 0;
                    while (i < exceptionDates.size()) {
                        WebDavDate webDavDate = new WebDavDate((Date)exceptionDates.elementAt(i), this.getPimSession());
                        properties.add(new PropertyHolder(WebDavField.V, webDavDate.getFormattedDate()));
                        ++i;
                    }
                    toSend.add(new PropertyHolder(WebDavField.EXDATE, properties));
                }
            }
            if (!this.m_bIsAllDayEvent) {
                if (this.m_oEndTime != null) {
                    toSend.add(new PropertyHolder(WebDavField.DTEND, this.m_oEndTime.getFormattedDate()));
                }
                if (this.m_oStartTime != null) {
                    toSend.add(new PropertyHolder(WebDavField.DTSTART, this.m_oStartTime.getFormattedDate()));
                }
                if (this.m_oPimReminderItem != null && this.m_oPimReminderItem.isReminderSet()) {
                    toSend.add(new PropertyHolder(WebDavField.REMINDEROFFSET, this.m_oPimReminderItem.getNoOfSecondsBeforeStart() + ""));
                }
                toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "0"));
                if (this.m_oPimBusyStatusType == null) {
                    toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "BUSY"));
                }
            } else {
                if (this.m_oEndTime != null) {
                    this.m_oEndTime.resetToNextDay();
                    toSend.add(new PropertyHolder(WebDavField.DTEND, this.m_oEndTime.getFormattedDate()));
                }
                if (this.m_oStartTime != null) {
                    this.m_oStartTime.resetToThisDay();
                    toSend.add(new PropertyHolder(WebDavField.DTSTART, this.m_oStartTime.getFormattedDate()));
                }
                toSend.add(new PropertyHolder(WebDavField.ALLDAYEVENT, "1"));
                if (this.m_oPimBusyStatusType == null) {
                    toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, "FREE"));
                }
            }
            if (this.m_oPimBusyStatusType != null) {
                toSend.add(new PropertyHolder(WebDavField.BUSYSTATUS, ExWebDavPimBusyStatusTypeMapper.getType(this.m_oPimBusyStatusType)));
            }
            if (this.m_oPimCalendarType != null) {
                if (this.m_oPimCalendarType.equals(PimCalendarType.APPOINTMENT)) {
                    toSend.add(new PropertyHolder(WebDavField.MEETINGSTATUS, "TENTATIVE"));
                } else if (this.m_oPimCalendarType.equals(PimCalendarType.MEETING)) {
                    toSend.add(new PropertyHolder(WebDavField.MEETINGSTATUS, "CONFIRMED"));
                }
            }
            String xmlString = WebDavHelper.createPropertyUpdateXml(toSend);
            String fileName = this.getFileName();
            HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest("PROPPATCH", fileName, xmlString);
            this.m_bIsUpdateDone = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    private String getFileName() throws ExWebDavPimException {
        try {
            return "/" + this.getPimSession().getRootFolderName() + "/" + this.getUserMailbox() + "/" + this.getFolderName() + "/" + XMLUtilities.getValue(this.m_oElement, WebDavField.DISPLAYNAME);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimRecipientItems getRecipientItems() throws ExWebDavPimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void send() throws ExWebDavPimException {
    }

    public void setType(PimCalendarType pimCalendarType) throws ExWebDavPimException {
        this.m_oPimCalendarType = pimCalendarType;
    }

    public PimCalendarType getType() throws ExWebDavPimException {
        try {
            String meetingStatus = XMLUtilities.getValue(this.m_oElement, WebDavField.MEETINGSTATUS);
            if (meetingStatus.equals("TENTATIVE")) {
                return PimCalendarType.APPOINTMENT;
            }
            if (meetingStatus.equals("CONFIRMED")) {
                return PimCalendarType.MEETING;
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimMessageItem forward() throws ExWebDavPimException {
        return null;
    }

    public String getName() throws ExWebDavPimException {
        return "Appointment: " + this.getSubject() + " in " + this.getLocation();
    }
}

