/*
 * Decompiled with CFR 0.152.
 */
package com.sun.addressbook.ldap;

import com.sun.addressbook.ABDebug;
import com.sun.addressbook.ABSearchTerm;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.ldap.LdapABConstants;
import java.lang.reflect.Field;

public class LdapABSearchTerm
extends ABSearchTerm {
    public LdapABSearchTerm(String name, String value, boolean exact) {
        super(name, value, exact);
    }

    public LdapABSearchTerm(ABSearchTerm term, int op) throws ABStoreException {
        super(term, op);
    }

    public LdapABSearchTerm(ABSearchTerm[] terms, int op) throws ABStoreException {
        super(terms, op);
    }

    public Object compute() throws ABStoreException {
        String searchFilter = null;
        if (this.terms != null) {
            String operator;
            if (this.op == 0) {
                searchFilter = "(!" + this.terms[0].compute() + ")";
                return searchFilter;
            }
            if (this.op == 2) {
                operator = "&";
            } else if (this.op == 1) {
                operator = "|";
            } else {
                String msg = "LdapABSearchTerm: Invalid operator - " + this.op + ". Operator can only be one of AND/OR/NOT";
                throw new ABStoreException(msg);
            }
            searchFilter = "(" + operator;
            int i = 0;
            while (i < this.terms.length) {
                searchFilter = searchFilter + this.terms[i].compute();
                ++i;
            }
            searchFilter = searchFilter + ")";
        } else {
            searchFilter = this.computeTerm(this);
        }
        ABDebug.logMessage("LdapABSearchTerm.compute: searchFilter = " + searchFilter);
        return searchFilter;
    }

    private String computeTerm(ABSearchTerm searchTerm) {
        String term = null;
        String newValue = null;
        String searchVal = searchTerm.getValue();
        newValue = !searchTerm.isExact() && searchVal != null && searchVal.indexOf(42) < 0 ? "*" + searchVal + "*" : searchVal;
        if (searchTerm.getName().equals("any")) {
            term = "(|(givenname=" + newValue + ")" + "(" + "sn" + "=" + newValue + ")" + "(" + "cn" + "=" + newValue + ")" + "(" + "mail" + "=" + newValue + ")" + "(" + "telephonenumber" + "=" + newValue + ")" + "(" + "homephone" + "=" + newValue + ")" + "(" + "facsimiletelephonenumber" + "=" + newValue + ")" + "(" + "mobile" + "=" + newValue + ")" + "(" + "pager" + "=" + newValue + "))";
        } else {
            LdapABConstants constants = new LdapABConstants();
            try {
                Field attr = constants.getClass().getField("ATTR_" + searchTerm.getName());
                String attrName = (String)attr.get(null);
                ABDebug.logMessage("LdapABSearchTerm.computeTerm: attrName = " + attrName);
                term = "(" + attrName + "=" + newValue + ")";
            }
            catch (IllegalAccessException iae) {
                ABDebug.logError("LdapABSearchTerm.computeTerm: Cannot access ATTR_" + searchTerm.getName());
            }
            catch (NoSuchFieldException nfe) {
                ABDebug.logError("LdapABSearchTerm.computeTerm: Field ATTR_" + searchTerm.getName() + " not found");
            }
        }
        ABDebug.logMessage("LdapABSearchTerm.computeTerm: term = " + term);
        return term;
    }
}

