/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.config;

import com.sun.ssoadapter.config.ConfigUtil;
import com.sun.ssoadapter.config.ConfigurationConstants;
import com.sun.ssoadapter.config.ConfigurationListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.mail.URLName;
import javax.servlet.http.HttpUtils;

public class Configuration
implements ConfigurationConstants {
    private HashMap configHash = new HashMap(10);
    private String configName = null;
    private String configDesc = null;
    private Vector listenerVector = new Vector(2);

    public Configuration() {
    }

    public Configuration(String configURLString) {
        String[] arrayVal;
        int iPort;
        String[] arrayVal2;
        String[] configDescArray;
        String[] configNameArray;
        URLName configURL = new URLName(configURLString);
        String val = null;
        Hashtable queryHash = null;
        int qi = configURLString.indexOf(63);
        if (qi >= 0) {
            val = configURLString.substring(qi + 1);
        }
        if (val != null) {
            queryHash = HttpUtils.parseQueryString(val);
        }
        if (queryHash != null) {
            this.configHash.putAll(queryHash);
        }
        if ((configNameArray = (String[])this.configHash.get("configName")) != null) {
            this.configName = configNameArray[0];
            this.configHash.remove("configName");
        }
        if ((configDescArray = (String[])this.configHash.get("configDesc")) != null) {
            this.configDesc = configDescArray[0];
            this.configHash.remove("configDesc");
        }
        if ((val = configURL.getHost()) != null && val.length() > 0 && (arrayVal2 = new String[]{val}) != null && arrayVal2[0].indexOf("=") == -1) {
            this.configHash.put("host", arrayVal2);
        }
        if ((iPort = configURL.getPort()) >= 0) {
            arrayVal = new String[]{Integer.toString(iPort)};
            this.configHash.put("port", arrayVal);
        }
        if ((val = configURL.getProtocol()) != null) {
            arrayVal = new String[]{val};
            this.configHash.put("protocol", arrayVal);
        }
        if ((val = configURL.getUsername()) != null) {
            arrayVal = new String[]{val};
            this.configHash.put("uid", arrayVal);
        }
        if ((val = configURL.getPassword()) != null) {
            arrayVal = new String[]{val};
            this.configHash.put("password", arrayVal);
        }
    }

    public String getProperty(String key) {
        String[] props = (String[])this.configHash.get(key);
        return props != null ? props[0] : null;
    }

    public String getProperty(String key, String defaultVal) {
        String[] props = (String[])this.configHash.get(key);
        return props != null ? props[0] : defaultVal;
    }

    public String[] getPropertyArray(String key) {
        return (String[])this.configHash.get(key);
    }

    public HashMap getHashMap() {
        return this.configHash;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        HashMap cmap = this.getHashMap();
        Iterator it = cmap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] value = (String[])cmap.get(key);
            String val = value != null ? value[0] : null;
            props.setProperty(key, val);
        }
        props.setProperty("configName", this.configName);
        props.setProperty("configDesc", this.configDesc);
        return props;
    }

    public void setProperty(String key, String value) {
        String[] valArray = new String[]{value};
        this.configHash.put(key, valArray);
        this.notifyListeners();
    }

    public void setPropertyArray(String key, String[] values) {
        this.configHash.put(key, values);
        this.notifyListeners();
    }

    public void setHashMap(HashMap hashMap) {
        this.configHash = hashMap;
        this.notifyListeners();
    }

    public String getConfigurationName() {
        return this.configName;
    }

    public void setConfigurationName(String name) {
        this.configName = name;
    }

    public String getConfigurationDescription() {
        return this.configDesc;
    }

    public void setConfigurationDescription(String desc) {
        this.configDesc = desc;
    }

    private void notifyListeners() {
        Vector<ConfigurationListener> removeVector = new Vector<ConfigurationListener>(2);
        Enumeration listenerEnum = this.listenerVector.elements();
        while (listenerEnum.hasMoreElements()) {
            ConfigurationListener listener = (ConfigurationListener)listenerEnum.nextElement();
            try {
                if (!listener.configurationChanged(null)) continue;
                removeVector.add(listener);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Enumeration removeEnum = removeVector.elements();
        while (removeEnum.hasMoreElements()) {
            this.listenerVector.remove(removeEnum.nextElement());
        }
    }

    public void addListener(ConfigurationListener listener) {
        if (listener != null) {
            this.listenerVector.addElement(listener);
        }
    }

    public String getConfigurationURL() {
        int portInt;
        String[] hostArray = (String[])this.configHash.get("host");
        String[] protocolArray = (String[])this.configHash.get("protocol");
        String[] portArray = (String[])this.configHash.get("port");
        String[] uidArray = (String[])this.configHash.get("uid");
        String[] passwordArray = (String[])this.configHash.get("password");
        String host = hostArray != null ? hostArray[0] : null;
        String protocol = protocolArray != null ? protocolArray[0] : null;
        String port = portArray != null ? portArray[0] : null;
        String uid = uidArray != null ? uidArray[0] : null;
        String password = passwordArray != null ? passwordArray[0] : null;
        this.configHash.remove("host");
        this.configHash.remove("protocol");
        this.configHash.remove("port");
        this.configHash.remove("uid");
        this.configHash.remove("password");
        if (protocol == null || protocol.length() == 0) {
            protocol = "undef";
            String[] tmpArray = new String[]{protocol};
            protocolArray = tmpArray;
        }
        try {
            portInt = Integer.parseInt(port);
        }
        catch (Exception ee) {
            portInt = -1;
        }
        URLName configURL = new URLName(protocol, host, portInt, null, uid, password);
        String urlString = configURL.toString();
        if (urlString.charAt(urlString.length() - 1) != '/') {
            urlString = urlString + "/";
        }
        if (this.configName != null || this.configDesc != null) {
            urlString = urlString + "?";
        }
        if (this.configName != null) {
            urlString = urlString + "configName" + "=" + ConfigUtil.encode(this.configName);
            if (this.configDesc != null) {
                urlString = urlString + "&";
            }
        }
        if (this.configDesc != null) {
            urlString = urlString + "configDesc" + "=" + ConfigUtil.encode(this.configDesc);
        }
        Iterator configIter = this.configHash.keySet().iterator();
        while (configIter.hasNext()) {
            String propName = (String)configIter.next();
            String[] propVals = (String[])this.configHash.get(propName);
            if (propVals == null || propVals.length == 0) continue;
            int i = 0;
            while (i < propVals.length) {
                urlString = urlString + "&" + propName + "=" + ConfigUtil.encode(propVals[i]);
                ++i;
            }
        }
        if (hostArray != null) {
            this.configHash.put("host", hostArray);
        }
        if (protocolArray != null) {
            this.configHash.put("protocol", protocolArray);
        }
        if (portArray != null) {
            this.configHash.put("port", portArray);
        }
        if (uidArray != null) {
            this.configHash.put("uid", uidArray);
        }
        if (passwordArray != null) {
            this.configHash.put("password", passwordArray);
        }
        return urlString;
    }

    public String toString() {
        return this.getConfigurationURL();
    }
}

