/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.crypto;

import com.sun.portal.rewriter.util.StringHelper;
import java.security.SecureRandom;
import java.util.Vector;

public final class RandomString {
    private static final char[] NUMBERS_AND_LETTERS_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] NONCONFUSING_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'w', 'x', 'y', 'z', '2', '3', '4', '5', '6', '7', '8', '9'};
    private SecureRandom rand = new SecureRandom();
    private int repetition = -1;
    private char[] alphabet = NONCONFUSING_ALPHABET;
    private char[] firstAlphabet;
    private char[] lastAlphabet;
    private Vector requirements = null;
    private boolean[] touched = null;
    private int[] available = null;

    private RandomString() {
    }

    private void addRequirement(char[] alphabet, int num) {
        if (this.requirements == null) {
            this.requirements = new Vector();
        }
        this.requirements.add(new Requirement(alphabet, num));
    }

    private void setAlphabet(char[] alphabet) {
        if (alphabet == null) {
            throw new NullPointerException("Null alphabet");
        }
        if (alphabet.length == 0) {
            throw new ArrayIndexOutOfBoundsException("No characters in alphabet");
        }
        this.alphabet = alphabet;
    }

    public void setFirstAlphabet(char[] alphabet) {
        this.firstAlphabet = (char[])(alphabet == null || alphabet.length == 0 ? null : alphabet);
    }

    public void setLastAlphabet(char[] alphabet) {
        this.lastAlphabet = (char[])(alphabet == null || alphabet.length == 0 ? null : alphabet);
    }

    public void setMaxRepetition(int rep) {
        this.repetition = rep - 1;
    }

    public char[] getPassChars(char[] pass) {
        boolean verified = false;
        while (!verified) {
            int length = pass.length;
            int i = 0;
            while (i < length) {
                char[] useAlph = this.alphabet;
                if (i == 0 && this.firstAlphabet != null) {
                    useAlph = this.firstAlphabet;
                } else if (i == length - 1 && this.lastAlphabet != null) {
                    useAlph = this.lastAlphabet;
                }
                int size = RandomString.avoidRepetition(useAlph, pass, i, this.repetition, useAlph.length);
                pass[i] = useAlph[this.rand.nextInt(size)];
                ++i;
            }
            if (this.requirements != null) {
                this.applyRequirements(pass);
            }
            verified = true;
        }
        return pass;
    }

    private void applyRequirements(char[] pass) {
        int size = this.requirements.size();
        if (size > 0) {
            int length = pass.length;
            if (this.touched == null || this.touched.length < length) {
                this.touched = new boolean[length];
            }
            if (this.available == null || this.available.length < length) {
                this.available = new int[length];
            }
            int i = 0;
            while (i < length) {
                this.touched[i] = false;
                ++i;
            }
            int reqNum = 0;
            while (reqNum < size) {
                Requirement req = (Requirement)this.requirements.elementAt(reqNum);
                int reqUsedInd = req.alphabet.length;
                int fufilledInd = 0;
                int availableInd = 0;
                int i2 = 0;
                while (i2 < length) {
                    if (RandomString.arrayContains(req.alphabet, pass[i2]) && fufilledInd < req.num) {
                        ++fufilledInd;
                        this.touched[i2] = true;
                        if (this.repetition >= 0 && (reqUsedInd -= RandomString.moveto(req.alphabet, reqUsedInd, pass[i2])) < 0) {
                            reqUsedInd = req.alphabet.length;
                        }
                    } else if (!this.touched[i2]) {
                        this.available[availableInd] = i2;
                        ++availableInd;
                    }
                    ++i2;
                }
                int toDo = req.num - fufilledInd;
                int i3 = 0;
                while (i3 < toDo && availableInd > 0) {
                    char passChar;
                    int slot = this.rand.nextInt(availableInd);
                    pass[this.available[slot]] = passChar = req.alphabet[this.rand.nextInt(reqUsedInd)];
                    this.touched[this.available[slot]] = true;
                    this.available[slot] = this.available[--availableInd];
                    if (this.repetition >= 0 && (reqUsedInd -= RandomString.moveto(req.alphabet, reqUsedInd, passChar)) < 0) {
                        reqUsedInd = req.alphabet.length;
                    }
                    ++i3;
                }
                ++reqNum;
            }
        }
    }

    private static boolean arrayContains(char[] alph, char c) {
        int i = 0;
        while (i < alph.length) {
            if (alph[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int avoidRepetition(char[] alph, char[] pass, int passSize, int repetition, int alphSize) {
        if (repetition > -1) {
            int repPos = 0;
            while ((repPos = RandomString.findRep(pass, repPos, passSize, repetition)) != -1) {
                alphSize -= RandomString.moveto(alph, alphSize, pass[repPos + repetition]);
                ++repPos;
            }
            if (alphSize == 0) {
                alphSize = alph.length;
            }
        }
        return alphSize;
    }

    private static int findRep(char[] pass, int start, int end, int length) {
        int i = start;
        while (i < end - length) {
            boolean onTrack = true;
            int j = 0;
            while (onTrack && j < length) {
                if (pass[i + j] != pass[end - length + j]) {
                    onTrack = false;
                }
                ++j;
            }
            if (onTrack) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int moveto(char[] alph, int numGood, char c) {
        int count = 0;
        int i = 0;
        while (i < numGood) {
            if (alph[i] == c) {
                char temp = alph[--numGood];
                alph[numGood] = alph[i];
                alph[i] = temp;
                ++count;
            }
            ++i;
        }
        return count;
    }

    private String getPass(int length) {
        return new String(this.getPassChars(new char[length]));
    }

    public static String create(String aSeed) {
        if (aSeed == null || aSeed.length() < 8) {
            aSeed = "Use Nagendra" + aSeed + "as Password";
        }
        aSeed = StringHelper.searchAndReplace(aSeed, " ", "raja");
        char[] alphabet = NONCONFUSING_ALPHABET;
        char[] firstAlphabet = NUMBERS_AND_LETTERS_ALPHABET;
        char[] lastAlphabet = aSeed.toCharArray();
        Vector reqs = new Vector();
        int length = lastAlphabet.length > 8 || lastAlphabet.length < 6 ? 8 : lastAlphabet.length;
        RandomString randPass = new RandomString();
        randPass.setAlphabet(alphabet);
        randPass.setFirstAlphabet(firstAlphabet);
        randPass.setLastAlphabet(lastAlphabet);
        int i = 0;
        while (i < reqs.size()) {
            randPass.addRequirement(((String)reqs.elementAt(i)).toCharArray(), 1);
            ++i;
        }
        return randPass.getPass(length);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(RandomString.create("Nawrerwerwerewrewrewrwewrerwrwrewrewerwrwerwehgdurtxfgdsg"));
    }

    private static class Requirement {
        private char[] alphabet;
        private int num;

        public Requirement(char[] alphabet, int num) {
            this.alphabet = alphabet;
            this.num = num;
        }
    }
}

