/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.simplewebservice.rpc;

import com.sun.portal.providers.simplewebservice.ParameterDescriptor;
import com.sun.portal.providers.simplewebservice.WebServiceDescriptor;
import com.sun.portal.providers.simplewebservice.rpc.RPCCallFactory;
import com.sun.portal.providers.simplewebservice.rpc.SerializationContext;
import com.sun.portal.providers.simplewebservice.rpc.XMapSerializer;
import com.sun.portal.providers.simplewebservice.util.XList;
import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.ReferenceableSerializerImpl;
import com.sun.xml.rpc.encoding.SimpleTypeArraySerializer;
import com.sun.xml.rpc.encoding.SimpleTypeSerializer;
import com.sun.xml.rpc.encoding.SingletonDeserializerFactory;
import com.sun.xml.rpc.encoding.SingletonSerializerFactory;
import com.sun.xml.rpc.encoding.soap.CollectionSerializer;
import java.util.AbstractList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class RPCCallFactoryImpl
implements RPCCallFactory {
    private static final String ENCODING_STYLE_URI_PROPERTY = "javax.xml.rpc.encodingstyle.namespace.uri";
    private static final int COMPLEX_TYPE_SERIALIZER = 1;
    private static final int COMPLEX_ARRAY_TYPE_SERIALIZER = 2;
    private static final RPCCallFactoryImpl factory = new RPCCallFactoryImpl();

    private RPCCallFactoryImpl() {
    }

    public static RPCCallFactory getFactory() {
        return factory;
    }

    public Call createCallObject(Service service, WebServiceDescriptor webServiceDescriptor) throws ServiceException, JAXRPCException {
        CallHandler callHandler = new CallHandler();
        Call call = callHandler.createCall(service, webServiceDescriptor);
        this.setCallProperties(call, webServiceDescriptor);
        return call;
    }

    private void setCallProperties(Call call, WebServiceDescriptor webServiceDescriptor) throws JAXRPCException {
        call.setTargetEndpointAddress(webServiceDescriptor.getEndPointURL());
        String string = webServiceDescriptor.getSOAPBindingStyle();
        if (string == null) {
            string = "rpc";
        }
        call.setProperty("javax.xml.rpc.soap.operation.style", (Object)string);
        String string2 = webServiceDescriptor.getSOAPAction();
        if (string2 == null) {
            string2 = "";
        }
        call.setProperty("javax.xml.rpc.soap.http.soapaction.use", (Object)new Boolean(true));
        call.setProperty("javax.xml.rpc.soap.http.soapaction.uri", (Object)string2);
        String string3 = webServiceDescriptor.getInputEncodingStyleURI();
        if (string3 != null && !string3.equals("")) {
            call.setProperty(ENCODING_STYLE_URI_PROPERTY, (Object)webServiceDescriptor.getInputEncodingStyleURI());
        }
    }

    class ComplexTypeHandler {
        TypeMappingRegistry registry = null;
        TypeMapping typeMapping = null;
        Service service = null;
        String encoding = "http://www.w3.org/2001/XMLSchema";
        SerializationContext context = null;
        static /* synthetic */ Class class$com$sun$xml$rpc$util$StructMap;
        static /* synthetic */ Class class$java$util$ArrayList;

        public ComplexTypeHandler(Service service, String string) {
            this.service = service;
            this.encoding = string;
        }

        public void registerComplexTypeHandler(ParameterDescriptor parameterDescriptor, int n) {
            this.context = SerializationContext.createComplexSerializationContext(parameterDescriptor);
            if (this.isAlreadyRegistered(this.context.typeHolderClass, this.context.typeQName)) {
                return;
            }
            CombinedSerializer combinedSerializer = null;
            combinedSerializer = this.createComplexSerializer(parameterDescriptor, n);
            SingletonSerializerFactory singletonSerializerFactory = new SingletonSerializerFactory((Serializer)combinedSerializer);
            SingletonDeserializerFactory singletonDeserializerFactory = new SingletonDeserializerFactory((Deserializer)combinedSerializer);
            if (n == 1) {
                this.typeMapping.register(class$com$sun$xml$rpc$util$StructMap == null ? (class$com$sun$xml$rpc$util$StructMap = ComplexTypeHandler.class$("com.sun.xml.rpc.util.StructMap")) : class$com$sun$xml$rpc$util$StructMap, this.context.typeQName, (SerializerFactory)singletonSerializerFactory, (DeserializerFactory)singletonDeserializerFactory);
            } else if (n == 2) {
                this.typeMapping.register(class$java$util$ArrayList == null ? (class$java$util$ArrayList = ComplexTypeHandler.class$("java.util.ArrayList")) : class$java$util$ArrayList, this.context.typeQName, (SerializerFactory)singletonSerializerFactory, (DeserializerFactory)singletonDeserializerFactory);
            }
        }

        private CombinedSerializer createComplexSerializer(ParameterDescriptor parameterDescriptor, int n) {
            CombinedSerializer combinedSerializer = null;
            if (n == 1) {
                combinedSerializer = this.createComplexTypeSerializer(this.context, parameterDescriptor);
                combinedSerializer = new ReferenceableSerializerImpl(true, combinedSerializer);
            } else if (n == 2) {
                combinedSerializer = this.createComplexTypeArraySerializer(this.context, parameterDescriptor);
                combinedSerializer = new ReferenceableSerializerImpl(true, combinedSerializer);
            }
            return combinedSerializer;
        }

        private CombinedSerializer createComplexTypeArraySerializer(SerializationContext serializationContext, ParameterDescriptor parameterDescriptor) {
            CollectionSerializer collectionSerializer = null;
            collectionSerializer = new CollectionSerializer(serializationContext.typeQName, class$java$util$ArrayList == null ? (class$java$util$ArrayList = ComplexTypeHandler.class$("java.util.ArrayList")) : class$java$util$ArrayList, true, true, this.encoding, null, serializationContext.typeArrayQName, class$com$sun$xml$rpc$util$StructMap == null ? (class$com$sun$xml$rpc$util$StructMap = ComplexTypeHandler.class$("com.sun.xml.rpc.util.StructMap")) : class$com$sun$xml$rpc$util$StructMap);
            return collectionSerializer;
        }

        private CombinedSerializer createComplexTypeSerializer(SerializationContext serializationContext, ParameterDescriptor parameterDescriptor) {
            XMapSerializer xMapSerializer = null;
            xMapSerializer = new XMapSerializer(serializationContext.typeQName, true, true, this.encoding, parameterDescriptor);
            return xMapSerializer;
        }

        private boolean isAlreadyRegistered(Class clazz, QName qName) {
            if (this.registry == null && this.typeMapping == null) {
                this.registry = this.service.getTypeMappingRegistry();
                this.typeMapping = this.registry.getTypeMapping(this.encoding);
            }
            return this.typeMapping.isRegistered(clazz, qName);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class SimpleTypeHandler {
        Service service = null;
        String encoding = "http://www.w3.org/2001/XMLSchema";
        SerializationContext context = null;
        static /* synthetic */ Class class$com$sun$portal$providers$simplewebservice$util$XList;

        public SimpleTypeHandler(Service service, String string) {
            this.service = service;
            this.encoding = string;
        }

        public void registerSimpleTypeHandlers(ParameterDescriptor parameterDescriptor) {
            CombinedSerializer combinedSerializer;
            this.context = SerializationContext.createSimpleSerializationContext(parameterDescriptor);
            TypeMappingRegistry typeMappingRegistry = this.service.getTypeMappingRegistry();
            TypeMapping typeMapping = typeMappingRegistry.getTypeMapping(this.encoding);
            if (typeMapping.isRegistered(this.context.typeHolderClass, this.context.typeArrayQName)) {
                return;
            }
            this.context.serializer = combinedSerializer = this.getPrimitiveTypeSerializer(this.context);
            SingletonSerializerFactory singletonSerializerFactory = new SingletonSerializerFactory((Serializer)combinedSerializer);
            SingletonDeserializerFactory singletonDeserializerFactory = new SingletonDeserializerFactory((Deserializer)combinedSerializer);
            typeMapping.register(this.context.typeHolderClass, this.context.typeArrayQName, (SerializerFactory)singletonSerializerFactory, (DeserializerFactory)singletonDeserializerFactory);
        }

        public void registerSimpleTypeArrayHandlers(ParameterDescriptor parameterDescriptor) {
            CombinedSerializer combinedSerializer;
            this.context = SerializationContext.createSimpleSerializationContext(parameterDescriptor);
            TypeMappingRegistry typeMappingRegistry = this.service.getTypeMappingRegistry();
            TypeMapping typeMapping = typeMappingRegistry.getTypeMapping(this.encoding);
            if (typeMapping.isRegistered(class$com$sun$portal$providers$simplewebservice$util$XList == null ? (class$com$sun$portal$providers$simplewebservice$util$XList = SimpleTypeHandler.class$("com.sun.portal.providers.simplewebservice.util.XList")) : class$com$sun$portal$providers$simplewebservice$util$XList, this.context.typeQName)) {
                return;
            }
            this.context.serializer = combinedSerializer = this.getPrimitiveTypeSerializer(this.context);
            CombinedSerializer combinedSerializer2 = this.getPrimitiveTypeArraySerializer(this.context);
            combinedSerializer2 = new ReferenceableSerializerImpl(true, combinedSerializer2);
            SingletonSerializerFactory singletonSerializerFactory = new SingletonSerializerFactory((Serializer)combinedSerializer2);
            SingletonDeserializerFactory singletonDeserializerFactory = new SingletonDeserializerFactory((Deserializer)combinedSerializer2);
            typeMapping.register(class$com$sun$portal$providers$simplewebservice$util$XList == null ? (class$com$sun$portal$providers$simplewebservice$util$XList = SimpleTypeHandler.class$("com.sun.portal.providers.simplewebservice.util.XList")) : class$com$sun$portal$providers$simplewebservice$util$XList, this.context.typeQName, (SerializerFactory)singletonSerializerFactory, (DeserializerFactory)singletonDeserializerFactory);
        }

        private CombinedSerializer getPrimitiveTypeSerializer(SerializationContext serializationContext) {
            SimpleTypeSerializer simpleTypeSerializer = null;
            simpleTypeSerializer = new SimpleTypeSerializer(serializationContext.typeArrayQName, false, true, "http://www.w3.org/2001/XMLSchema", serializationContext.primitiveTypeEncoder);
            return simpleTypeSerializer;
        }

        private CombinedSerializer getPrimitiveTypeArraySerializer(SerializationContext serializationContext) {
            SimpleTypeArraySerializer simpleTypeArraySerializer = null;
            simpleTypeArraySerializer = new SimpleTypeArraySerializer(serializationContext.typeQName, true, true, "http://www.w3.org/2001/XMLSchema", null, serializationContext.typeArrayQName, serializationContext.typeHolderClass, 1, null, (SimpleTypeSerializer)serializationContext.serializer);
            return simpleTypeArraySerializer;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class CallHandler {
        CallHandler() {
        }

        public Call createCall(Service service, WebServiceDescriptor webServiceDescriptor) throws ServiceException {
            String string;
            ParameterDescriptor[] parameterDescriptorArray;
            ParameterDescriptor[] parameterDescriptorArray2 = webServiceDescriptor.getInputParams();
            if (parameterDescriptorArray2 != null) {
                int n = 0;
                while (n < parameterDescriptorArray2.length) {
                    this.registerSerializers(service, parameterDescriptorArray2[n], webServiceDescriptor.getInputEncodingStyleURI());
                    ++n;
                }
            }
            if ((parameterDescriptorArray = webServiceDescriptor.getOutputParams()) != null) {
                this.registerSerializers(service, parameterDescriptorArray[0], webServiceDescriptor.getInputEncodingStyleURI());
            }
            if ((string = webServiceDescriptor.getInputNamespace()) == null) {
                string = "";
            }
            QName qName = new QName(webServiceDescriptor.getPortName());
            QName qName2 = new QName(string, webServiceDescriptor.getMethodName());
            Call call = service.createCall(qName, qName2);
            return call;
        }

        private void registerSerializers(Service service, ParameterDescriptor parameterDescriptor, String string) {
            block4: {
                block3: {
                    this.registerParameterDescriptor(service, parameterDescriptor, string);
                    if (!parameterDescriptor.isArrayType()) break block3;
                    if (parameterDescriptor.isSimpleTypeArray()) break block4;
                    XList xList = (XList)parameterDescriptor.getValue();
                    Iterator iterator = ((AbstractList)xList).iterator();
                    while (iterator.hasNext()) {
                        ParameterDescriptor parameterDescriptor2 = (ParameterDescriptor)iterator.next();
                        if (parameterDescriptor2.isSimpleType()) continue;
                        this.registerSerializers(service, parameterDescriptor2, string);
                    }
                    break block4;
                }
                if (!parameterDescriptor.isSimpleType()) {
                    XList xList = (XList)parameterDescriptor.getValue();
                    Iterator iterator = ((AbstractList)xList).iterator();
                    while (iterator.hasNext()) {
                        ParameterDescriptor parameterDescriptor3 = (ParameterDescriptor)iterator.next();
                        if (parameterDescriptor3.isSimpleType()) continue;
                        this.registerSerializers(service, parameterDescriptor3, string);
                    }
                }
            }
        }

        private void registerParameterDescriptor(Service service, ParameterDescriptor parameterDescriptor, String string) {
            if (parameterDescriptor.isArrayType()) {
                if (parameterDescriptor.isSimpleTypeArray()) {
                    SimpleTypeHandler simpleTypeHandler = new SimpleTypeHandler(service, string);
                    simpleTypeHandler.registerSimpleTypeArrayHandlers(parameterDescriptor);
                } else {
                    ComplexTypeHandler complexTypeHandler = new ComplexTypeHandler(service, string);
                    complexTypeHandler.registerComplexTypeHandler(parameterDescriptor, 2);
                }
            } else if (!parameterDescriptor.isSimpleType()) {
                ComplexTypeHandler complexTypeHandler = new ComplexTypeHandler(service, string);
                complexTypeHandler.registerComplexTypeHandler(parameterDescriptor, 1);
            } else {
                SimpleTypeHandler simpleTypeHandler = new SimpleTypeHandler(service, string);
                simpleTypeHandler.registerSimpleTypeHandlers(parameterDescriptor);
            }
        }
    }
}

