/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.https.JSSDebug;
import com.sun.portal.util.SystemProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class ApprovalCallback
implements SSLCertificateApprovalCallback {
    private String reqHost = null;
    private static ApprovalCallback theInstance = null;
    public static boolean trustAllServerCerts = false;
    protected static List srapGateway_trustedSSLDomainList = new ArrayList();

    private ApprovalCallback() {
    }

    public ApprovalCallback(String string) {
        if (string != null) {
            this.reqHost = string.toLowerCase();
        }
    }

    public static ApprovalCallback getInstance() {
        if (theInstance == null) {
            theInstance = new ApprovalCallback();
        }
        return theInstance;
    }

    public boolean approve(X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        JSSDebug.debug.message("ApprovalCallback: SubjectDN = " + x509Certificate.getSubjectDN().getName());
        Enumeration enumeration = validityStatus.getReasons();
        String string = ApprovalCallback.getCertHost(x509Certificate.getSubjectDN().getName());
        if (this.reqHost == null) {
            int n = 0;
            while (enumeration.hasMoreElements()) {
                SSLCertificateApprovalCallback.ValidityItem validityItem = (SSLCertificateApprovalCallback.ValidityItem)enumeration.nextElement();
                int n2 = validityItem.getReason();
                JSSDebug.debug.message("ApprovalCallback: reason " + n2);
                if (n2 == -8172 || n2 == -8171 || n2 == -8156 || n2 == -8179) {
                    if (trustAllServerCerts) continue;
                    ++n;
                    continue;
                }
                if (n2 == -12276) {
                    if (ApprovalCallback.isTrustedDomain(string)) continue;
                    ++n;
                    continue;
                }
                ++n;
            }
            return n == 0;
        }
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem validityItem = (SSLCertificateApprovalCallback.ValidityItem)enumeration.nextElement();
            int n = validityItem.getReason();
            JSSDebug.debug.message("ApprovalCallback: reason " + n);
            if (n == -8172 || n == -8171 || n == -8156 || n == -8179) {
                if (trustAllServerCerts) continue;
                bl = false;
                continue;
            }
            if (n != -12276) {
                bl = false;
                continue;
            }
            if (ApprovalCallback.isTrustedDomain(string) || string.equalsIgnoreCase(this.reqHost)) continue;
            bl = false;
        }
        return bl;
    }

    private static boolean isTrustedDomain(String string) {
        if (trustAllServerCerts) {
            return false;
        }
        string = string.toLowerCase();
        if (srapGateway_trustedSSLDomainList == null || srapGateway_trustedSSLDomainList.size() < 1) {
            return false;
        }
        if (srapGateway_trustedSSLDomainList.contains(string)) {
            return true;
        }
        Iterator iterator = srapGateway_trustedSSLDomainList.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString().trim();
            int n = string2.indexOf("*");
            if (n == -1 || !(n == 0 ? string.endsWith(string2.substring(1, string2.length())) : string.startsWith(string2.substring(0, n)) && string.endsWith(string2.substring(n + 1, string2.length())))) continue;
            return true;
        }
        return false;
    }

    private static String getCertHost(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim().toLowerCase();
            if (!string2.startsWith("cn=")) continue;
            return string2.substring(3);
        }
        return "";
    }

    static {
        String string = SystemProperties.get("gateway.trust_all_server_certs");
        trustAllServerCerts = string != null && string.equals("true");
        Iterator iterator = GatewayProfile.getStringList("TrustedSSLDomainList").iterator();
        while (iterator.hasNext()) {
            srapGateway_trustedSSLDomainList.add(iterator.next().toString().toLowerCase());
        }
    }
}

