/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.NetletGroupManager;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.util.GWDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class NetletGroup
implements SSOTokenListener {
    private List userNetlets = new ArrayList();
    private SSOToken ssoToken = null;
    private NetletGroupManager manager;
    private boolean netletRunUponLogout = false;
    private NetletProfile netletUserattrs = null;
    private Hashtable appletSrcPorts = null;
    private Vector srcPorts = null;
    private long userLoginTime;
    private long maxSessionTime;

    public NetletGroup(NetletGroupManager netletGroupManager, SSOToken sSOToken) throws SSOException {
        this.ssoToken = sSOToken;
        this.manager = netletGroupManager;
        this.appletSrcPorts = new Hashtable();
        this.srcPorts = new Vector();
        this.getNetletProfile();
        this.setSrcPorts();
        this.setNetletRunUponLogout();
        this.ssoToken.addSSOTokenListener((SSOTokenListener)this);
        this.userLoginTime = System.currentTimeMillis() - (this.ssoToken.getMaxSessionTime() * 60L - this.ssoToken.getTimeLeft()) * 1000L + 10000L;
        this.maxSessionTime = this.ssoToken.getMaxSessionTime() * 60000L;
    }

    public NetletGroup(NetletGroupManager netletGroupManager, SSOTokenID sSOTokenID) throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        this.ssoToken = sSOTokenManager.createSSOToken(sSOTokenID.toString());
        this.manager = netletGroupManager;
        this.appletSrcPorts = new Hashtable();
        this.srcPorts = new Vector();
        this.getNetletProfile();
        this.setSrcPorts();
        this.setNetletRunUponLogout();
        this.ssoToken.addSSOTokenListener((SSOTokenListener)this);
        this.userLoginTime = System.currentTimeMillis() - (this.ssoToken.getMaxSessionTime() * 60L - this.ssoToken.getTimeLeft()) * 1000L + 10000L;
        this.maxSessionTime = this.ssoToken.getMaxSessionTime() * 60000L;
    }

    public NetletGroup(NetletGroupManager netletGroupManager, String string) throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        this.ssoToken = sSOTokenManager.createSSOToken(string);
        this.manager = netletGroupManager;
        this.appletSrcPorts = new Hashtable();
        this.srcPorts = new Vector();
        this.getNetletProfile();
        this.setSrcPorts();
        this.setNetletRunUponLogout();
        this.ssoToken.addSSOTokenListener((SSOTokenListener)this);
        this.userLoginTime = System.currentTimeMillis() - (this.ssoToken.getMaxSessionTime() * 60L - this.ssoToken.getTimeLeft()) * 1000L + 10000L;
        this.maxSessionTime = this.ssoToken.getMaxSessionTime() * 60000L;
    }

    public void getNetletProfile() {
        try {
            this.netletUserattrs = new NetletProfile(this.ssoToken.getTokenID().toString());
        }
        catch (Exception exception) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("NetletGroup: unable to retrieve netlet user attributes from service schema");
            }
            this.netletUserattrs = null;
        }
    }

    public void setNetletRunUponLogout() {
        if (this.netletUserattrs != null) {
            try {
                this.netletRunUponLogout = !NetletProfile.getBoolean("TerminateAtLogout", true);
            }
            catch (Exception exception) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("NetletGroup: Cannot read TerminateAtLogout attribute from srapNetletService schema");
                }
                this.netletRunUponLogout = false;
            }
        } else {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("NetletGroup: Netlet user attributes unavailable");
            }
            this.netletRunUponLogout = false;
        }
    }

    public boolean getNetletRunUponLogout() {
        return this.netletRunUponLogout;
    }

    private void setSrcPorts() {
        if (this.netletUserattrs != null) {
            List list = NetletProfile.getStringList("Rules");
            int n = 0;
            while (n < list.size()) {
                String string = (String)list.get(n);
                boolean bl = string.endsWith("EXTEND");
                if (bl) {
                    string = string.substring(0, string.lastIndexOf("|"));
                    String string2 = "false";
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                    String string3 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    while (stringTokenizer.hasMoreElements()) {
                        string3 = stringTokenizer.nextToken();
                        int n2 = Integer.parseInt(string3);
                        this.srcPorts.add(new Integer(n2));
                        string3 = stringTokenizer.nextToken();
                        string3 = stringTokenizer.nextToken();
                    }
                }
                ++n;
            }
        } else if (GWDebug.debug.errorEnabled()) {
            GWDebug.debug.error("NetletGroup: Netlet user attributes unavailable");
        }
    }

    public void addAppletSrcPort(ReaderWriterLock readerWriterLock) {
        block2: {
            try {
                this.appletSrcPorts.put(readerWriterLock, new Integer(readerWriterLock.getAppletSrcPort()));
            }
            catch (NullPointerException nullPointerException) {
                if (!GWDebug.debug.errorEnabled()) break block2;
                GWDebug.debug.error("NetletGroup: Unable to add source port to NetletGroup -> " + nullPointerException);
            }
        }
    }

    public void removeAppletSrcPort(ReaderWriterLock readerWriterLock) {
        this.appletSrcPorts.remove(readerWriterLock);
    }

    public synchronized void add(ReaderWriterLock readerWriterLock) {
        this.userNetlets.add(readerWriterLock);
        this.addAppletSrcPort(readerWriterLock);
    }

    public synchronized void remove(ReaderWriter readerWriter) {
        this.userNetlets.remove(readerWriter);
    }

    public synchronized void remove(ReaderWriterLock readerWriterLock) {
        this.removeAppletSrcPort(readerWriterLock);
        this.userNetlets.remove(readerWriterLock);
    }

    public SSOToken getSSOToken() {
        return this.ssoToken;
    }

    public int activeGroupCount() {
        return this.userNetlets.size();
    }

    public synchronized void clean() {
        ReaderWriterLock readerWriterLock = null;
        int n = 0;
        while (n < this.userNetlets.size()) {
            readerWriterLock = (ReaderWriterLock)this.userNetlets.get(n);
            if (readerWriterLock != null) {
                readerWriterLock.stopAll();
            }
            ++n;
        }
    }

    public long getLastActivityTime() {
        long l = 0L;
        try {
            Object[] objectArray = null;
            l = System.currentTimeMillis() - (this.ssoToken.getMaxIdleTime() * 60000L + 10000L);
            long l2 = 0L;
            List list = this.userNetlets;
            synchronized (list) {
                objectArray = new Object[this.userNetlets.size()];
                objectArray = this.userNetlets.toArray();
            }
            int n = 0;
            while (n < objectArray.length) {
                block16: {
                    ReaderWriterLock readerWriterLock = (ReaderWriterLock)objectArray[n];
                    if (readerWriterLock != null) {
                        block14: {
                            try {
                                l2 = readerWriterLock.getLastActivityTime();
                                if (System.currentTimeMillis() - l2 >= this.ssoToken.getMaxIdleTime() * 60000L) {
                                    readerWriterLock.stopAll();
                                    this.remove(readerWriterLock);
                                }
                                break block14;
                            }
                            catch (NullPointerException nullPointerException) {
                                this.remove(readerWriterLock);
                            }
                            break block16;
                        }
                        if (l < l2) {
                            l = l2;
                        }
                    }
                }
                ++n;
            }
            return l;
        }
        catch (Throwable throwable) {
            block15: {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("NetletGroup: Unable to get the Netlet Groups last user activity -> " + throwable);
                }
                try {
                    l = System.currentTimeMillis() - (this.ssoToken.getMaxIdleTime() * 60000L + 1000L);
                }
                catch (SSOException sSOException) {
                    if (!GWDebug.debug.errorEnabled()) break block15;
                    GWDebug.debug.error("NetletGroup: Unable to get the Netlet Groups last user activity -> " + (Object)((Object)sSOException));
                }
            }
            return l;
        }
    }

    public void ssoTokenChanged(SSOTokenEvent sSOTokenEvent) {
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("NetletGroup: Gateway gets session notification");
        }
        SSOToken sSOToken = null;
        try {
            sSOToken = sSOTokenEvent.getToken();
            int n = sSOTokenEvent.getType();
        }
        catch (SSOException sSOException) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("NetletGroup: Unknown SSOToken event -> " + (Object)((Object)sSOException));
            }
            return;
        }
        String string = sSOToken.getTokenID().toString();
        String string2 = this.ssoToken.getTokenID().toString();
        if (string2.equals(string) && !this.getNetletRunUponLogout()) {
            NetletGroupManager.unregister(string2.toString());
        }
    }

    public boolean needToExtend() {
        boolean bl = false;
        Enumeration enumeration = this.appletSrcPorts.keys();
        Collection collection = this.appletSrcPorts.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            if (n == -1) {
                n = new Integer(30021);
            }
            if (!this.srcPorts.contains(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public long getUserLoginTime() {
        return this.userLoginTime;
    }

    public long getMaxSessionTime() {
        return this.maxSessionTime;
    }
}

