/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.Password;
import com.sun.portal.cli.cert.PasswordContext;
import com.sun.portal.cli.cert.SRADecoderException;

public class PasswordContextImpl
implements PasswordContext {
    public String generatePassphrase(JSSContext jSSContext) {
        String string = "";
        boolean bl = true;
        if (!jSSContext.isDBFileExist() || !jSSContext.isPassFileExist()) {
            while (bl) {
                CertAdminUtil.println(CertAdminHelpText.getPassphraseHelpText());
                string = CertAdminUtil.questionMasked(CertAdminLocale.getPFString("q20", "Enter passphrase ?"));
                while (string.trim().equals("")) {
                    CertAdminUtil.println(CertAdminLocale.getPFString("m40", "Passphrase cannot be blank!"));
                    string = CertAdminUtil.questionMasked(CertAdminLocale.getPFString("q20", "Enter passphrase ?"));
                }
                String string2 = CertAdminUtil.questionMasked(CertAdminLocale.getPFString("q21", "Verify (re-enter) passphrase ?"));
                CertAdminUtil.println(CertAdminConstants.newline);
                if (string.equals(string2)) {
                    CertAdminUtil.println(CertAdminLocale.getPFString("m41", "Passphrase accepted"));
                    boolean bl2 = false;
                    if (jSSContext.isPasswordEcrypted()) {
                        try {
                            bl2 = CertAdminUtil.writeLine(JSSUtil.encryptPassword(string), jSSContext.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
                        }
                        catch (SRADecoderException sRADecoderException) {
                            CertAdminUtil.println(CertAdminLocale.getPFString("m55", "Error!, Could not encode|decode the JSS engine password") + CertAdminConstants.newline + sRADecoderException);
                            return null;
                        }
                    } else {
                        bl2 = CertAdminUtil.writeLine(string, jSSContext.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
                    }
                    if (!bl2) {
                        CertAdminUtil.println(CertAdminLocale.getPFString("m42", "Could not store the password!"));
                    }
                    bl = false;
                    continue;
                }
                CertAdminUtil.println(CertAdminLocale.getPFString("m43", "Passwords don't match!"));
            }
        } else {
            string = CertAdminUtil.readLine(jSSContext.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
            if (jSSContext.isPasswordEcrypted()) {
                try {
                    Password password = JSSUtil.decryptPassword(string);
                    string = password.getPassword();
                }
                catch (SRADecoderException sRADecoderException) {
                    CertAdminUtil.println(CertAdminLocale.getPFString("m55", "Error!, Could not encode|decode the JSS engine password") + CertAdminConstants.newline + sRADecoderException);
                    return null;
                }
            }
        }
        return string;
    }
}

