/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityListener;
import com.sun.portal.util.SystemProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HostChooser
extends HostAvailabilityListener {
    private static final String SERVLET_URL = SystemProperties.get("gateway.dsame.agent");
    private String path;
    private List portalServers;
    private Iterator roundRobin;
    private static int orginalSize = 0;

    public HostChooser() {
        block2: {
            this.path = null;
            this.portalServers = null;
            this.roundRobin = null;
            try {
                this.path = new URL(SERVLET_URL).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                if (!GWDebug.debug.errorEnabled()) break block2;
                GWDebug.debug.error("Gateway Aborting: Invalid gateway.dsame.agent url ");
            }
        }
        this.addHostAvailabilityListener(this);
    }

    private synchronized void initialize() {
        Iterator iterator = GatewayProfile.getStringList("PortalServerList").iterator();
        this.portalServers = new ArrayList();
        while (iterator.hasNext()) {
            this.portalServers.add(iterator.next().toString().toLowerCase());
        }
        this.roundRobin = this.portalServers.iterator();
    }

    public synchronized String getHost() {
        if (this.portalServers == null) {
            try {
                this.initialize();
            }
            catch (NullPointerException nullPointerException) {
                return SERVLET_URL;
            }
            orginalSize = this.portalServers.size();
        }
        if (this.portalServers.size() == 0) {
            return null;
        }
        if (orginalSize < 2) {
            return SERVLET_URL;
        }
        if (this.roundRobin == null) {
            this.roundRobin = this.portalServers.iterator();
        }
        if (this.roundRobin.hasNext()) {
            return this.roundRobin.next().toString() + this.path;
        }
        this.roundRobin = this.portalServers.iterator();
        return this.roundRobin.next().toString() + this.path;
    }

    public synchronized boolean isAvailable(String string) {
        try {
            if (this.portalServers == null) {
                this.initialize();
            }
            URL uRL = new URL(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(uRL.getProtocol()).append("://").append(uRL.getHost()).append(":").append(uRL.getPort());
            String string2 = stringBuffer.toString().toLowerCase();
            return this.portalServers.contains(string2);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void hostAvailabilityChanged(HostAvailabilityEvent hostAvailabilityEvent) {
        if (this.portalServers == null) {
            this.initialize();
        }
        if (hostAvailabilityEvent.getEventType() == 1) {
            this.addHost(hostAvailabilityEvent.getHost());
        } else if (hostAvailabilityEvent.getEventType() == 2) {
            this.removeHost(hostAvailabilityEvent.getHost());
        }
    }

    private synchronized void removeHost(String string) {
        if (this.portalServers.contains(string)) {
            this.portalServers.remove(string);
            this.roundRobin = this.portalServers.iterator();
        }
    }

    private synchronized void addHost(String string) {
        if (!this.portalServers.contains(string)) {
            this.portalServers.add(string);
            this.roundRobin = this.portalServers.iterator();
        }
    }

    public static String getBootupPortalServer() {
        return SERVLET_URL;
    }
}

