/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.crypto;

import com.iplanet.services.util.Base64;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.crypto.RandomString;

public class CryptoHelper {
    public static final String PROPERTY_SECRET_KEY = "CRYPTO_SECRET_KEY";
    private static final String SECRET_KEY = ConfigManager.getProperty("CRYPTO_SECRET_KEY", "DefaultSecretKeyPassword");
    private static final String CRYPTO_BEGIN_SUFFIX = RandomString.create(SECRET_KEY);
    private static final String CRYPTO_END_SUFFIX = RandomString.create(CRYPTO_BEGIN_SUFFIX);

    public static String encode(String aString) {
        if (aString == null || aString.length() == 0 || aString.startsWith(CRYPTO_BEGIN_SUFFIX)) {
            return aString;
        }
        return CRYPTO_BEGIN_SUFFIX + Base64.encode((byte[])aString.getBytes()) + CRYPTO_END_SUFFIX;
    }

    public static String decode(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        StringBuffer sb = new StringBuffer(aString.length());
        int startIndex = 0;
        int endIndex = -1;
        while ((endIndex = aString.indexOf(CRYPTO_BEGIN_SUFFIX, startIndex)) != -1) {
            sb.append(aString.substring(startIndex, endIndex));
            startIndex = endIndex;
            endIndex = aString.indexOf(CRYPTO_END_SUFFIX, startIndex);
            if (endIndex != -1) {
                sb.append(new String(Base64.decode((String)aString.substring(startIndex + CRYPTO_BEGIN_SUFFIX.length(), endIndex))));
                startIndex = endIndex + CRYPTO_END_SUFFIX.length();
                continue;
            }
            sb.append(aString.substring(startIndex, startIndex + CRYPTO_BEGIN_SUFFIX.length()));
            startIndex += CRYPTO_BEGIN_SUFFIX.length();
        }
        sb.append(aString.substring(startIndex));
        return sb.toString();
    }
}

