/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.services.comm.client.PLLNotificationServlet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.netlet.eproxy.EProxy;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.PerfData;
import com.sun.portal.perf.rproxy.TimerData;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.rproxy.configservlet.client.UserProfile;
import com.sun.portal.rproxy.connectionhandler.Base64;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.DomainWebProxyConfig;
import com.sun.portal.rproxy.connectionhandler.ErrorResponse;
import com.sun.portal.rproxy.connectionhandler.FileNotFoundResponse;
import com.sun.portal.rproxy.connectionhandler.GatewayServletResponse;
import com.sun.portal.rproxy.connectionhandler.HTTPRequest;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.HTTPRetriever;
import com.sun.portal.rproxy.connectionhandler.HeaderResponse;
import com.sun.portal.rproxy.connectionhandler.RedirectResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.connectionhandler.RetrievalFactory;
import com.sun.portal.rproxy.connectionhandler.Retriever;
import com.sun.portal.rproxy.connectionhandler.RewriterProxyRouter;
import com.sun.portal.rproxy.connectionhandler.ServersList;
import com.sun.portal.rproxy.connectionhandler.StatisticsResponse;
import com.sun.portal.rproxy.rewriter.SRAPAdapter;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorHelper;
import com.sun.portal.util.Debug;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.SRAPSocket;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLSocket;

public abstract class Session {
    protected Socket _theSocket;
    protected boolean _moreElements = true;
    protected Integer _logId;
    protected static String _platformloginURL;
    protected static String _platformlogoutURL;
    protected static boolean _useHTTPProxy;
    protected static String _hpport;
    protected static String _hpprot;
    protected static String rphost;
    protected static List srapGateway_certificateEnabledList_lc;
    private static List virtualHost;
    private static List virtualHostActual;
    private static List nonAuthPathList;
    protected String _gwport;
    protected String _gwprotocol;
    protected int port;
    private static int _numRequests;
    public static int _numBytesRead;
    public static int _numBytesSent;
    private static final String UNKNOWN_HOST = "Unknown Host";
    private static Debug server_traffic;
    private static Debug browser_traffic;
    static final String defaultLocale;
    static final String exceptionErrorMessage = "ExceptionErrorMessage";
    static final String notificationErrorMessage = "NotificationErrorMessage";
    static final String invalidGatewayHostNameErrorMessage = "InvalidGatewayHostNameErrorMessage";
    static final String accessDeniedErrorMessage = "AccessDeniedErrorMessage";
    static final String webProxErrorMessage = "WebProxErrorMessage";
    static final String hostConnectErrorMessage = "HostConnectErrorMessage";
    private static final boolean isPerSessionLoggingEnabled;
    private static final boolean detailedRproxLog;
    private Socket actualClientSocket = null;
    private static final int DEFAULT_TIMEOUT = 60000;
    protected final int readTimeout = GatewayProfile.getInt("RProxyPortTimeout", 60000);
    protected int this_req = 0;
    public static final boolean processKeepAliveConnections;
    private static final int timeoutseconds;
    public static final int GRACE_PERIOD;
    public static final long maxTimeOutSetting;
    private int MAX_PER_SESS = GatewayProfile.getInt("EProxyKeepAliveMaxConnection", 10);
    public static final long THREAD_SLEEP_TIME = 50L;
    private long nullTimeout = maxTimeOutSetting;
    protected boolean thisreqKeepAlive = processKeepAliveConnections;
    public static boolean doingPDC;
    static final String defDomain;
    static final String sessionCookieName;
    static final int sessionCookieLen;
    protected static String defaultOrg;
    protected boolean pdcHeaderFound;
    protected boolean initiatePDC;
    protected boolean invalidateSSL;
    private static String gwDomain;
    private static final String PDC_COOKIE_HEADER = "DoPDC@";
    private static List serverList;
    private static final String notificationURL;
    private static final String REWRITER_PROXY = "__sra_rewriter_proxy__";
    private static HashMap virtualHostOrgMapping;
    public static final String PDC_CERT_INFO = "__sra_pdc_cert__";
    static List expandedSessionServersList;
    private static final String pdcHeaderKey = "PS-GW-PDC";
    private static final String netletHeaderKey = "PS-Netlet";
    private static String clientIPHeaderKey;
    private static String gatewayURLInfoHeaderKey;
    private static String gatewayRWURLInfoHeaderKey;
    private static String netletHeaderValue;
    protected static String faviconLocation;

    public Session(Socket socket) {
        this._theSocket = socket;
        this.getLoggingInfo();
    }

    public Session(Socket socket, String string) {
        this._theSocket = socket;
        this.getLoggingInfo();
    }

    private void getLoggingInfo() {
        Object v = GWLogManager.logIdMap.remove(new Integer(this._theSocket.getPort()));
        if (v != null) {
            LogInfoContainer logInfoContainer = (LogInfoContainer)v;
            this._logId = logInfoContainer.getLogID();
            this.actualClientSocket = logInfoContainer.getClientSocket();
        }
    }

    public boolean isStillActive() {
        return this._moreElements;
    }

    public void setStillActive(boolean bl) {
        this._moreElements = bl;
    }

    public void addNetletCustomHeader(Request request) {
        netletHeaderValue = "enabled=false";
        if (EProxy.isNetletEnabled) {
            netletHeaderValue = request.isGatewayProtocolSecure() ? "enabled=true; encryption=ssl" : "enabled=true; encryption=plain";
        }
        netletHeaderValue = "PS-Netlet: " + netletHeaderValue;
        request.setRequestHeader(netletHeaderKey, netletHeaderValue);
    }

    public void addClientIP(Request request) {
        StringBuffer stringBuffer = new StringBuffer().append(clientIPHeaderKey).append(": ").append(this.actualClientSocket.getInetAddress().getHostAddress());
        String string = stringBuffer.toString();
        request.setRequestHeader(clientIPHeaderKey, string);
    }

    public void addGatewayInfo(Request request) {
        StringBuffer stringBuffer = null;
        if (request instanceof HTTPRequest) {
            HTTPRequest hTTPRequest = (HTTPRequest)request;
            stringBuffer = new StringBuffer().append(gatewayURLInfoHeaderKey).append(": ").append(hTTPRequest.getUnEncodedGatewayURL());
            request.setRequestHeader(gatewayURLInfoHeaderKey, stringBuffer.toString());
            stringBuffer = hTTPRequest.isCookieSupported() ? new StringBuffer().append(gatewayRWURLInfoHeaderKey).append(": ").append(hTTPRequest.getGatewayURL()) : (hTTPRequest.isForwardCookieHost() ? new StringBuffer().append(gatewayRWURLInfoHeaderKey).append(": ").append(hTTPRequest.getGatewayURL()) : new StringBuffer().append(gatewayRWURLInfoHeaderKey).append(": ").append(hTTPRequest.getUnEncodedGatewayURL() + "$SessionID"));
            request.setRequestHeader(gatewayRWURLInfoHeaderKey, stringBuffer.toString());
        } else {
            stringBuffer = new StringBuffer().append(gatewayURLInfoHeaderKey).append(": ").append(request.getGatewayURL());
            request.setRequestHeader(gatewayURLInfoHeaderKey, stringBuffer.toString());
            stringBuffer = new StringBuffer().append(gatewayRWURLInfoHeaderKey).append(": ").append(request.getGatewayURL());
            request.setRequestHeader(gatewayRWURLInfoHeaderKey, stringBuffer.toString());
        }
    }

    public void addPDCInfo(Request request) {
        String string = pdcHeaderKey;
        string = doingPDC && request.isGatewayProtocolSecure() ? string + ": true" : string + ": false";
        request.setRequestHeader(pdcHeaderKey, string);
    }

    public void addCustomHeaders(Request request) {
        this.addNetletCustomHeader(request);
        this.addGatewayInfo(request);
        this.addPDCInfo(request);
    }

    private static int writeContent(OutputStream outputStream, Response response, Session session) throws IOException {
        int n;
        String string = response.getResponseHeader("Content-length");
        BufferedInputStream bufferedInputStream = response.getContentStream();
        byte[] byArray = new byte[2048];
        if (bufferedInputStream == null) {
            return 0;
        }
        if (string != null) {
            int n2 = Integer.parseInt(string.substring(string.indexOf(58) + 1).trim());
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n2 - n4;
                n3 = bufferedInputStream.read(byArray, 0, n5 < byArray.length ? n5 : byArray.length);
                if (n3 == -1) {
                    session.setStillActive(false);
                    break;
                }
                if (n3 <= 0) continue;
                n4 += n3;
                outputStream.write(byArray, 0, n3);
                outputStream.flush();
            }
            return n4;
        }
        int n6 = 0;
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            n6 += n;
            outputStream.write(byArray, 0, n);
            outputStream.flush();
        }
        return n6;
    }

    public abstract Request getRequest();

    /*
     * Loose catch block
     */
    public final void processNextRequest() {
        Response response;
        block99: {
            Object object;
            Object object2;
            String string;
            String string2;
            Object object3;
            Object object4;
            String string3;
            Object object5;
            Object object6;
            Object object7;
            long l = 0L;
            if (processKeepAliveConnections) {
                l = System.currentTimeMillis();
            }
            Request request = this.getRequest();
            response = null;
            boolean bl = true;
            boolean bl2 = false;
            ++_numRequests;
            String string4 = null;
            int n = 0;
            if (browser_traffic.messageEnabled() && request != null) {
                browser_traffic.message("Request sent from Browser:\n" + request);
            }
            if (request != null && (object7 = request.getGatewayHost()) != null) {
                object6 = this.getFQDN((String)object7);
                GWDebug.debug.message("FQDN -> " + (String)object6 + " , gwhost -> " + (String)object7 + " , rphost -> " + rphost);
                if (object6 != null && !((String)object7).equalsIgnoreCase(rphost)) {
                    object5 = new StringBuffer();
                    ((StringBuffer)object5).append(this._gwprotocol).append("://").append((String)object6);
                    if (this._gwprotocol.equalsIgnoreCase("http")) {
                        if (!this._gwport.equals("80")) {
                            ((StringBuffer)object5).append(':').append(this._gwport);
                        }
                    } else if (!this._gwport.equals("443")) {
                        ((StringBuffer)object5).append(':').append(this._gwport);
                    }
                    ((StringBuffer)object5).append('/');
                    string3 = ((StringBuffer)object5).toString();
                    GWDebug.debug.message("newGatewayURL -> " + string3);
                    request.setGatewayURL(string3);
                }
            }
            this.processKeepAlive(l, request);
            if (PerfContextObject.ENABLE_PERF) {
                object7 = PerfContextObject.getPerfContext();
                object6 = new TimerData("Session.java , after getting request object");
                object7.record((PerfData)object6);
            }
            this.initiatePDC = false;
            this.invalidateSSL = false;
            this.pdcHeaderFound = false;
            while (bl) {
                block98: {
                    this.initiatePDC = false;
                    this.invalidateSSL = false;
                    this.pdcHeaderFound = false;
                    object7 = null;
                    if (doingPDC && (object7 = request.getSessionID()) != null) {
                        if (EProxy.isNetletEnabled) {
                            try {
                                object6 = SSOTokenManager.getInstance();
                                string3 = SSOUtil.getSSOToken((String)object7);
                                object6.validateToken((SSOToken)string3);
                                object5 = string3.getProperty(PDC_CERT_INFO);
                                if (object5 == null) {
                                    object4 = this.getActualSocket().getStatus().getPeerCertificate();
                                    object3 = object4.getEncoded();
                                    string2 = JSSUtil.getDefaultDecoder().getEncodedStr((byte[])object3);
                                    string = JSSUtil.getDefaultDecoder().digest(string2);
                                    string3.setProperty(PDC_CERT_INFO, string);
                                }
                            }
                            catch (Exception exception) {
                                GWDebug.debug.error("Unable to encode the pdc cert info");
                            }
                        }
                        if (((String)object7).startsWith(PDC_COOKIE_HEADER)) {
                            this.removePDCCookie(request);
                            this.pdcHeaderFound = true;
                        }
                    }
                    if (request != null) {
                        block97: {
                            Object object8;
                            int n2;
                            if (GWDebug.debug.messageEnabled()) {
                                GWDebug.debug.message("Session: processNextRequest checking for " + request.getURI() + "\nobject: " + request.getObject());
                            }
                            if (GWLogManager.loggingEnabled) {
                                GWLogManager.write("RProxy", GWLocale.getPFString("session1", new Object[]{this._logId, new String(GWLogManager.getUserId(request.getSessionID())), request.getURI()}));
                            }
                            if ((n2 = ((String)(object6 = request.getObject())).indexOf("psScriptReferrer=")) != -1) {
                                request.changeURI();
                            }
                            if (ServiceIdentifier.isGateway()) {
                                this.addCustomHeaders(request);
                            }
                            if (request.getGatewayScheme().equals(notificationURL)) {
                                response = this.processNotificationRequest(request);
                                if (response == null) {
                                    this.setStillActive(false);
                                    return;
                                }
                            } else if (request.getGatewayScheme().equals("statistics")) {
                                response = this.processStatisticsRequest(request);
                            } else if (request.getObject().length() == 0 && request.getProtocol() != null) {
                                response = this.processMissingObjectRequest(request);
                            } else {
                                try {
                                    if (request.getProtocol() == null) {
                                        response = this.processMissingProtocolRequest(request);
                                    } else if (doingPDC && request.getObject().startsWith(_platformloginURL)) {
                                        if (this.pdcHeaderFound || object7 == null) {
                                            this.initiatePDC = true;
                                        }
                                        if (!this.hostFound(request.getURI())) {
                                            response = this.processProtocolRequest(request);
                                        } else if (this.initiatePDC) {
                                            response = this.processMissingProtocolRequest(request);
                                        } else if (doingPDC && this.pdcHeaderFound) {
                                            this.invalidateSSL = true;
                                            response = new RedirectResponse(this.loginURL(request, _platformloginURL));
                                        } else {
                                            response = this.processProtocolRequest(request);
                                        }
                                    } else {
                                        response = this.processProtocolRequest(request);
                                    }
                                }
                                catch (Exception exception) {
                                    if (GWDebug.debug.errorEnabled()) {
                                        GWDebug.debug.error("Cannot process protocol request", exception);
                                    }
                                    object4 = exception.toString();
                                    object3 = request.getRequestHeader("Accept-Language");
                                    if (exceptionErrorMessage != null && exceptionErrorMessage.length() > 0) {
                                        string2 = this.getUserLocale(request);
                                        object4 = GWLocale.getPFString(exceptionErrorMessage, new Object[]{object4}, string2);
                                    }
                                    response = new ErrorResponse((String)object4, null, (String)object3);
                                }
                                if (GWDebug.debug.messageEnabled()) {
                                    GWDebug.debug.message("Session: Request:\n" + request + "Response\n" + response);
                                }
                            }
                            if (GWLogManager.loggingEnabled) {
                                GWLogManager.write("RProxy", GWLocale.getPFString("session2", new Object[]{this._logId, new String(GWLogManager.getUserId(request.getSessionID())), new Integer(request.getSize())}));
                            }
                            if (server_traffic.messageEnabled()) {
                                server_traffic.message("--> Session: Request:\n" + request + "Response\n" + response);
                            }
                            response.setClientCaching();
                            boolean bl3 = true;
                            boolean bl4 = false;
                            object2 = null;
                            object = null;
                            if (response instanceof HTTPResponse) {
                                ((HTTPResponse)response).processSetCookieHeaders(request);
                            }
                            boolean bl5 = false;
                            string4 = response.getStatusCode();
                            if (ServiceIdentifier.isGateway() && string4 != null && !string4.startsWith("1") && !string4.startsWith("204") && !string4.startsWith("304")) {
                                bl5 = true;
                            }
                            if (request.isURIChanged()) {
                                request.restoreURI();
                            }
                            if (!bl5) {
                                if (GWDebug.debug.warningEnabled()) {
                                    GWDebug.debug.warning(" ************* No Translator available");
                                }
                                object8 = response.getResponseHeader("Content-length");
                                object = response.getContentStream();
                                if (object8 == null) {
                                    this.thisreqKeepAlive = false;
                                }
                            } else {
                                if (GWDebug.debug.messageEnabled()) {
                                    GWDebug.debug.message(" ************* Got Translator");
                                }
                                object = SRAPAdapter.rewrite(request, response);
                                if (GWDebug.debug.messageEnabled()) {
                                    GWDebug.debug.message(" ************* Translated !!! in = " + object);
                                }
                                if (object != null) {
                                    bl4 = true;
                                    response.setContentLength(((InputStream)object).available());
                                } else {
                                    object = response.getContentStream();
                                    object8 = response.getResponseHeader("Content-length");
                                    if (object8 == null) {
                                        this.thisreqKeepAlive = false;
                                    }
                                    if (GWDebug.debug.messageEnabled()) {
                                        GWDebug.debug.message("Not rewritten , so in = " + object);
                                    }
                                }
                            }
                            if (this.thisreqKeepAlive) {
                                response.setConnectionAlive(" timeout=" + timeoutseconds + ",max=" + (this.MAX_PER_SESS - this.this_req));
                            } else {
                                response.setConnectionClose();
                                this.setStillActive(false);
                            }
                            if (ServiceIdentifier.isGateway()) {
                                this.translateHeader(response, request);
                            }
                            if (browser_traffic.messageEnabled()) {
                                browser_traffic.message("Response sent back to Browser:\n" + response);
                            }
                            object2 = this._theSocket.getOutputStream();
                            object8 = response.getHeaderBytes();
                            _numBytesSent += ((Object)object8).length;
                            n += ((Object)object8).length;
                            ((OutputStream)object2).write((byte[])object8);
                            ((OutputStream)object2).flush();
                            if (string4 == null || string4.startsWith("1") || string4.startsWith("204") || string4.startsWith("304")) break block97;
                            int n3 = 0;
                            if (!bl4) {
                                n3 = Session.writeContent((OutputStream)object2, response, this);
                                if (GWDebug.debug.messageEnabled()) {
                                    GWDebug.debug.message("Not rewritten for " + request.getURL() + " Bytes of content written as response : " + n3);
                                }
                            } else {
                                int n4;
                                object4 = new byte[2048];
                                while ((n4 = ((InputStream)object).read((byte[])object4)) >= 0) {
                                    if (n4 <= 0) continue;
                                    n3 += n4;
                                    ((OutputStream)object2).write((byte[])object4, 0, n4);
                                    ((OutputStream)object2).flush();
                                }
                            }
                            _numBytesSent += n3;
                            if (GWDebug.debug.messageEnabled()) {
                                GWDebug.debug.message(n3 + " bytes of content written as response");
                            }
                            n += n3;
                        }
                        Object var23_32 = null;
                        try {
                            ((OutputStream)object2).flush();
                        }
                        catch (Exception exception) {}
                        break block98;
                        {
                            catch (IOException iOException) {
                                try {
                                    ((OutputStream)object2).flush();
                                    if (object instanceof CSBufferedInputStream) {
                                        ((CSBufferedInputStream)object).getSocket().close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (GWDebug.debug.warningEnabled()) {
                                    GWDebug.debug.warning("Session failed to respond to client", iOException);
                                }
                                this.setStillActive(false);
                                var23_32 = null;
                                try {
                                    ((OutputStream)object2).flush();
                                }
                                catch (Exception exception) {}
                                break block98;
                            }
                            catch (NullPointerException nullPointerException) {
                                this.setStillActive(false);
                                if (GWDebug.debug.warningEnabled()) {
                                    GWDebug.debug.warning("Session failed to respond to client", nullPointerException);
                                }
                                var23_32 = null;
                                try {
                                    ((OutputStream)object2).flush();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (Throwable throwable) {
                            var23_32 = null;
                            try {
                                ((OutputStream)object2).flush();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                bl = false;
            }
            if (isPerSessionLoggingEnabled) {
                object7 = this._theSocket instanceof SRAPSocket ? (((SRAPSocket)this._theSocket).isSSLSocket() ? "https" : "http") : (this._theSocket instanceof SSLSocket ? "https" : "http");
                object6 = this.actualClientSocket.getInetAddress().toString();
                string3 = request.getHost();
                if (detailedRproxLog && request instanceof HTTPRequest) {
                    object5 = (HTTPRequest)request;
                    object4 = ((HTTPRequest)object5).getMethod();
                    object3 = ((HTTPRequest)object5).getURL();
                    string2 = null;
                    string = ((HTTPRequest)object5).getSessionID();
                    if (string != null && (object2 = this.getUserSession(request, string)) != null) {
                        string2 = object2.getTokenID().toString();
                    }
                    object2 = null;
                    if (((String)object4).trim().toLowerCase().equals("post")) {
                        object = ((HTTPRequest)object5).getRequestHeader("Content-length");
                        object = ((String)object).substring(((String)object).indexOf(58) + 1);
                        try {
                            object2 = new Integer(Integer.parseInt((String)object));
                        }
                        catch (Exception exception) {}
                    } else {
                        object2 = new Integer(0);
                    }
                    GWLogManager.write("RProxy", GWLocale.getPFString("RproxyPerRequestDetailedLogFormat", new Object[]{this._logId, new String(GWLogManager.getUserId(((HTTPRequest)object5).getSessionID())), object6, object7, string3, object4, object3, object2, string4, new Integer(n)}));
                } else {
                    GWLogManager.write("RProxy", GWLocale.getPFString("RproxyPerRequestLogFormat", new Object[]{this._logId, new String(GWLogManager.getUserId(request.getSessionID())), object6, object7, string3}));
                }
            }
            if (doingPDC && this.invalidateSSL) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("SESSION:  INVALIDATE SSL");
                }
                try {
                    this.getActualSocket().invalidateSession();
                }
                catch (SocketException socketException) {
                    if (!GWDebug.debug.errorEnabled()) break block99;
                    GWDebug.debug.error("Unable to invalidate SSL Session");
                }
            }
        }
        if (response != null) {
            response.closeSocket();
        }
        if (!this.thisreqKeepAlive) {
            this.setStillActive(false);
        }
    }

    private void processKeepAlive(long l, Request request) {
        this.thisreqKeepAlive = processKeepAliveConnections;
        if (processKeepAliveConnections) {
            if (request != null) {
                ++this.this_req;
                this.nullTimeout = maxTimeOutSetting;
                if (request instanceof HTTPRequest) {
                    String string;
                    HTTPRequest hTTPRequest = (HTTPRequest)request;
                    this.thisreqKeepAlive = this.this_req >= this.MAX_PER_SESS ? false : ((string = hTTPRequest.getRequestHeader("Connection")) != null ? !(string = string.substring(string.indexOf(58) + 1).trim().toLowerCase()).equals("close") : hTTPRequest.getHTTPVersion().toUpperCase().compareTo("HTTP/1.1") >= 0);
                    hTTPRequest.setRequestHeader("Connection", "Connection: close\r\n");
                    this._moreElements = true;
                    if (!this.thisreqKeepAlive) {
                        if (this.this_req < this.MAX_PER_SESS && this.this_req > 1) {
                            this.thisreqKeepAlive = true;
                            this._moreElements = true;
                        } else {
                            this._moreElements = false;
                        }
                    }
                } else if (this.this_req < this.MAX_PER_SESS && this.this_req > 1) {
                    this.thisreqKeepAlive = true;
                    this._moreElements = true;
                } else {
                    this.thisreqKeepAlive = false;
                    this._moreElements = false;
                }
            } else {
                long l2 = System.currentTimeMillis() - l;
                if (l2 < this.nullTimeout && l2 >= (long)(this.readTimeout / 2)) {
                    this._moreElements = true;
                    this.nullTimeout -= l2;
                    boolean bl = false;
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.nullTimeout -= System.currentTimeMillis() - l2;
                    }
                    if (!bl) {
                        this.nullTimeout -= 50L;
                    }
                } else {
                    this.thisreqKeepAlive = false;
                    this._moreElements = false;
                }
            }
        } else if (request != null) {
            HTTPRequest hTTPRequest = (HTTPRequest)request;
            hTTPRequest.setRequestHeader("Connection", "Connection: close\r\n");
        }
        if (this.this_req > 1 && GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Reusing the socket for : " + this.this_req);
        }
    }

    private void translateHeader(Response response, Request request) {
        String string;
        boolean bl = request.getGatewayScheme().equals("external");
        if (response instanceof RedirectResponse && !((RedirectResponse)response).needTranslation()) {
            return;
        }
        String string2 = response.getResponseHeader("Location:");
        if (string2 != null) {
            string = SRAPTranslatorHelper.translateHeaderURL(string2, response, request, string2.toLowerCase().startsWith("location:"), bl);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Translated from [" + string2 + "] to [" + string + "]");
            }
            response.setLocation(string);
        }
        if (!(response instanceof HTTPResponse)) {
            return;
        }
        string = response.getResponseHeader("Content-Location:");
        if (string != null) {
            String string3 = SRAPTranslatorHelper.translateHeaderURL(string, response, request, string.toLowerCase().startsWith("content-location:"), bl);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Translated from [" + string + "] to [" + string3 + "]");
            }
            ((HTTPResponse)response).setContentLocation(string3);
        }
        if (response instanceof HTTPResponse) {
            this.translateWebDAVHeaders(request, (HTTPResponse)response, bl);
        }
    }

    protected void translateWebDAVHeaders(Request request, HTTPResponse hTTPResponse, boolean bl) {
        this.translateSpecificHeader("Destination", request, hTTPResponse, bl);
        this.translateSpecificHeader("Status-URI", request, hTTPResponse, bl);
    }

    protected void translateSpecificHeader(String string, Request request, HTTPResponse hTTPResponse, boolean bl) {
        List list = hTTPResponse.getHeaderAttributeList(string);
        Iterator iterator = list.iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        hTTPResponse.removeHeader(string);
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            String string3 = SRAPTranslatorHelper.translateHeaderURL(string2, hTTPResponse, request, true, bl);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message(string + " Translated from [" + string2 + "] to [" + string3 + "]");
            }
            linkedList.add(string3);
        }
        if (linkedList.size() != 0) {
            hTTPResponse.setHeader(string, linkedList);
        }
    }

    private Response processMissingObjectRequest(Request request) {
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Session: Redirecting-> " + request.getURL());
        }
        String string = request.getGatewayScheme();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this._gwprotocol).append("://");
        if (this._gwport.equals("443") && this._gwprotocol.equals("https") || this._gwport.equals("80") && this._gwprotocol.equals("http")) {
            stringBuffer.append(request.getGatewayHost()).append("/");
        } else {
            stringBuffer.append(request.getGatewayHost()).append(":").append(this._gwport).append("/");
        }
        if (string.length() > 0) {
            stringBuffer.append(string).append("/");
        }
        stringBuffer.append(request.getURL()).append("/");
        return new RedirectResponse(stringBuffer.toString(), false);
    }

    private Response processNotificationRequest(Request request) {
        Object var2_2;
        block3: {
            var2_2 = null;
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(this._theSocket.getOutputStream());
                GatewayServletResponse gatewayServletResponse = new GatewayServletResponse(dataOutputStream);
                PLLNotificationServlet pLLNotificationServlet = new PLLNotificationServlet();
                pLLNotificationServlet.doPost((HttpServletRequest)request, (HttpServletResponse)gatewayServletResponse);
                var2_2 = null;
            }
            catch (Exception exception) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Exception in processing notification request: " + exception);
                }
                String string = request.getRequestHeader("Accept-Language");
                String string2 = "Session: Unable to process notification";
                if (notificationErrorMessage == null || notificationErrorMessage.length() <= 0) break block3;
                String string3 = this.getUserLocale(request);
                string2 = GWLocale.getPFString(notificationErrorMessage, new Object[]{string2}, string3);
            }
        }
        return var2_2;
    }

    private Response processStatisticsRequest(Request request) {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (!this.isUserSessionValid(request)) {
            return new RedirectResponse(this.loginURL(request, _platformloginURL));
        }
        stringBuffer.append("<html>");
        String string = request.getURI();
        String string2 = string.startsWith("/statistics/") && string.length() > 12 ? string.substring(12) : "req&read&sent";
        if (string2.equals("reset")) {
            _numRequests = 0;
            _numBytesRead = 0;
            HTTPRetriever.numBytesRead = 0;
            _numBytesSent = 0;
            stringBuffer.append("<p>Reset is ok.</p></html>");
            return new StatisticsResponse(stringBuffer.toString());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("req")) {
                stringBuffer.append("<p>Number of Requests: ").append(_numRequests).append("</p>");
                continue;
            }
            if (string3.equals("read")) {
                stringBuffer.append("<p>Number of Bytes Read: ").append(_numBytesRead + HTTPRetriever.numBytesRead).append("</p>");
                continue;
            }
            if (!string3.equals("sent")) continue;
            stringBuffer.append("<p>Number of Bytes Sent: ").append(_numBytesSent).append("</p>");
        }
        stringBuffer.append("</html>");
        return new StatisticsResponse(stringBuffer.toString());
    }

    private Response processMissingProtocolRequest(Request request) {
        if (request.getGatewayScheme() != null && request.getGatewayScheme().equalsIgnoreCase("favicon.ico") && (request.getURL() == null || request.getURL().trim().length() == 0)) {
            HeaderResponse headerResponse;
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("favicon.ico match !");
            }
            if (faviconLocation != null) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Redirecting to : " + faviconLocation);
                }
                headerResponse = new RedirectResponse(faviconLocation, true);
            } else {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Returning Not Found message");
                }
                headerResponse = new FileNotFoundResponse();
            }
            return headerResponse;
        }
        String string = request.getGatewayHost();
        String string2 = this.getFQDN(string);
        if (string2 == null) {
            String string3 = string;
            String string4 = request.getRequestHeader("Accept-Language");
            if (invalidGatewayHostNameErrorMessage != null && invalidGatewayHostNameErrorMessage.length() > 0) {
                String string5 = this.getUserLocale(request);
                string3 = GWLocale.getPFString(invalidGatewayHostNameErrorMessage, new Object[]{string3}, string5);
            } else {
                string3 = string3 + " is not a valid gateway host name.";
            }
            return new ErrorResponse(string3, null, string4);
        }
        if (!string.equalsIgnoreCase(string2)) {
            if (this._gwport.equals("443") && this._gwprotocol.equals("https") || this._gwport.equals("80") && this._gwprotocol.equals("http")) {
                return new RedirectResponse(this._gwprotocol + "://" + string2 + request.getURI(), false);
            }
            return new RedirectResponse(this._gwprotocol + "://" + string2 + ":" + this._gwport + request.getURI(), false);
        }
        if (!doingPDC) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: not doing PDC");
            }
            return new RedirectResponse(this.loginURL(request, _platformloginURL));
        }
        boolean bl = false;
        String string6 = request.getURL();
        if (string6 != null && string6.trim().toLowerCase().indexOf("service=gatewaypdc") != -1) {
            bl = true;
        }
        if (this.pdcHeaderFound && !bl) {
            this.invalidateSSL = true;
            return new RedirectResponse(this.loginURL(request, _platformloginURL));
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Session: doing PDC");
        }
        if (this._gwport.equals("443") && this._gwprotocol.equals("https") || this._gwport.equals("80") && this._gwprotocol.equals("http")) {
            return this.doPDC(string, request);
        }
        return this.doPDC(string + ":" + this._gwport, request);
    }

    private Response processProtocolRequest(Request request) {
        Object object;
        Object object2;
        String string;
        String string2;
        SSOToken sSOToken = null;
        boolean bl = false;
        if (ServiceIdentifier.isGateway()) {
            if (this.isNonAuthenticatedURL(request)) {
                if (request.getURL().endsWith(_platformloginURL) && doingPDC && this.pdcHeaderFound) {
                    this.invalidateSSL = true;
                }
                if (doingPDC) {
                    bl = true;
                }
            } else {
                string2 = request.getSessionID();
                if (string2 == null) {
                    if (GWLogManager.loggingEnabled) {
                        GWLogManager.write("RProxy", GWLocale.getPFString("session4", new Object[]{this._logId}));
                    }
                    return new RedirectResponse(this.loginURL(request, _platformloginURL));
                }
                try {
                    string = SSOTokenManager.getInstance();
                    sSOToken = SSOUtil.getSSOToken(string2);
                    string.validateToken(sSOToken);
                }
                catch (SSOException sSOException) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("Error creating SSOToken ", sSOException);
                    }
                    if (doingPDC) {
                        return this.doPDC(request.getGatewayHost(), request);
                    }
                    return new RedirectResponse(this.loginURL(request, _platformloginURL));
                }
                catch (Exception exception) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("Error creating SSOToken ", exception);
                    }
                    if (doingPDC) {
                        return this.doPDC(request.getGatewayHost(), request);
                    }
                    return new RedirectResponse(this.loginURL(request, _platformloginURL));
                }
                string = sSOToken;
                if (doingPDC) {
                    bl = true;
                }
                try {
                    if (GWLogManager.loggingEnabled) {
                        GWLogManager.write("RProxy", GWLocale.getPFString("session3", new Object[]{this._logId, new String(GWLogManager.getUserId(request.getSessionID())), sSOToken.getIPAddress().toString()}));
                    }
                }
                catch (SSOException sSOException) {
                    // empty catch block
                }
                if (!this.isAccessControlAllowed(request, string2)) {
                    String string3 = "Access Denied";
                    String string4 = request.getRequestHeader("Accept-Language");
                    if (accessDeniedErrorMessage != null && accessDeniedErrorMessage.length() > 0) {
                        String string5 = this.getUserLocale(string2);
                        string3 = GWLocale.getPFString(accessDeniedErrorMessage, new Object[]{string3}, string5);
                    }
                    return new ErrorResponse(string3, sSOToken, string4);
                }
            }
        }
        string2 = request.getHost();
        string = request.getPort();
        String string6 = request.getProtocol();
        String string7 = request.getObject();
        Retriever retriever = null;
        if (_useHTTPProxy) {
            block46: {
                object2 = this.getProxyHost(request);
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("GW using Rewriter Proxy :" + (String)object2);
                }
                object = null;
                try {
                    object = new URL((String)object2);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!GWDebug.debug.errorEnabled()) break block46;
                    GWDebug.debug.error("Malformed Rewriter Proxy URL :" + (String)object2);
                }
            }
            request.setHost(((URL)object).getHost());
            if (((URL)object).getPort() != -1) {
                request.setPort(Integer.toString(((URL)object).getPort()));
            } else {
                request.setPort("10443");
            }
            request.setProtocol(((URL)object).getProtocol());
            request.setObject("/" + request.getURL());
            retriever = RetrievalFactory.getRetriever(_hpprot);
            if (request instanceof HTTPRequest) {
                ((HTTPRequest)request).populateWebProxyInfo();
            }
        } else {
            retriever = RetrievalFactory.getRetriever(request.getProtocol());
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: HTTP not in HTTPS mode");
            }
        }
        object2 = this.retrieveResponse(request, string2, retriever, sSOToken);
        if (_useHTTPProxy) {
            request.setHost(string2);
            request.setPort(string);
            request.setProtocol(string6);
            request.setObject(string7);
        }
        object = object2.getStatusCode();
        if (doingPDC && request.getObject().startsWith(_platformlogoutURL)) {
            this.addPDCCookie(request, (Response)object2);
            bl = false;
        } else if (doingPDC && bl && object2 instanceof HTTPResponse) {
            int n;
            String string8;
            String string9 = null;
            List list = ((HTTPResponse)object2).getHeaderAttributeList("Set-Cookie");
            if (list != null && list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SSOToken sSOToken2;
                    block47: {
                        String string10;
                        string9 = (String)iterator.next();
                        int n2 = string9.indexOf(sessionCookieName);
                        int n3 = string9.indexOf(61, n2);
                        if (n2 > 1 && !(string10 = string9.substring(n2 + sessionCookieLen, n3)).trim().equals("")) {
                            n2 = -1;
                        }
                        if (string9 == null || n2 == -1 || (string10 = request.getSessionID()) == null) continue;
                        sSOToken2 = null;
                        try {
                            sSOToken2 = SSOUtil.getSSOToken(string10);
                        }
                        catch (SSOException sSOException) {
                            if (GWDebug.debug.errorEnabled()) {
                                GWDebug.debug.error("**** ssoToken = null ****", sSOException);
                            }
                        }
                        catch (Exception exception) {
                            if (!GWDebug.debug.errorEnabled()) break block47;
                            GWDebug.debug.error("**** ssoToken = null ****", exception);
                        }
                    }
                    if (sSOToken2 != null) continue;
                    return this.doPDC(request.getGatewayHost(), request);
                }
            } else if (((String)object).startsWith("302") && (string8 = object2.getResponseHeader("Location")) != null && (n = string8.indexOf(":")) != -1) {
                if ((string8 = string8.substring(n + 1, string8.length()).trim()).toUpperCase().startsWith(_platformloginURL.toUpperCase())) {
                    if (this.hostFound(request.getURI())) {
                        this.addPDCCookie(request, (Response)object2);
                    }
                } else {
                    String string11;
                    int n4;
                    int n5 = string8.indexOf("://");
                    if (n5 != -1 && (n4 = string8.indexOf(47, n5 + 3)) != -1 && (string11 = string8.substring(0, n4)).toUpperCase().startsWith(_platformloginURL.toUpperCase()) && this.hostFound(request.getURI())) {
                        this.addPDCCookie(request, (Response)object2);
                    }
                }
            }
        }
        return object2;
    }

    private boolean isNonAuthenticatedURL(Request request) {
        if (request.getProtocol() == null || request.getHost() == null) {
            return false;
        }
        String string = request.getProtocol().toLowerCase() + "://" + request.getHost().toLowerCase() + ":" + request.getPort();
        String string2 = null;
        if (string == null) {
            return false;
        }
        String string3 = request.getObject();
        if (string3 == null || string3.trim().length() == 0) {
            string3 = "/";
        }
        string2 = !serverList.contains(string) ? string + string3 : string3;
        int n = nonAuthPathList.size();
        int n2 = 0;
        while (n2 < n) {
            String string4 = (String)nonAuthPathList.get(n2);
            if (string2.startsWith(string4)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private SSOToken getUserSession(Request request, String string) {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = SSOUtil.getSSOToken(string);
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Session: state is not VALID");
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("RProxy", GWLocale.getPFString("session5", new Object[]{this._logId, string}));
                }
                return null;
            }
        }
        catch (Exception exception) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Failed to get session", exception);
            }
            return null;
        }
        return sSOToken;
    }

    /*
     * Unable to fully structure code
     */
    private boolean wildcardMatch(String var1_1, String var2_2) {
        block10: {
            var3_3 = 0;
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = 0;
            var7_7 = var1_1.length();
            var8_8 = var2_2.length();
            var9_9 = null;
            if (var1_1 == null || var2_2 == null) {
                return false;
            }
            var6_6 = var2_2.indexOf(42, var5_5);
            if (var6_6 == -1) break block10;
            var9_9 = var2_2.substring(var5_5, var6_6);
            if (var6_6 > var5_5) {
                if ((var3_3 = var1_1.indexOf(var9_9, var3_3)) == -1) {
                    return false;
                }
                if (var3_3 != var5_5) {
                    return false;
                }
            }
            var3_3 += var6_6 - var5_5;
            if (var6_6 >= var8_8 - 1) {
                return true;
            }
            var5_5 = var6_6 + 1;
            if (true) ** GOTO lbl36
        }
        var3_3 = var1_1.indexOf(var2_2);
        if (var3_3 == -1) {
            return false;
        }
        return var3_3 == var5_5;
        do {
            var9_9 = var2_2.substring(var5_5, var6_6);
            if (var6_6 > var5_5 && (var3_3 = var1_1.indexOf(var9_9, var3_3)) == -1) {
                return false;
            }
            var3_3 += var6_6 - var5_5;
            if (var6_6 >= var8_8 - 1) {
                return true;
            }
            var5_5 = var6_6 + 1;
lbl36:
            // 2 sources

        } while ((var6_6 = var2_2.indexOf(42, var5_5)) != -1);
        var9_9 = var2_2.substring(var5_5, var8_8);
        var4_4 = var1_1.lastIndexOf(var9_9, var7_7 - 1);
        if (var4_4 == -1) {
            return false;
        }
        return var3_3 <= var4_4;
    }

    private boolean isAccessControlAllowed(Request request, String string) {
        boolean bl = false;
        try {
            UserProfile userProfile = new UserProfile(string);
            boolean bl2 = false;
            if (userProfile.getString("sunPortalGatewayAllowedAuthLevelResult", "true").equalsIgnoreCase("false")) {
                return false;
            }
            List list = userProfile.getStringList("sunportalgatewayaccessdenylist");
            Iterator iterator = list.iterator();
            String string2 = request.getURL();
            while (iterator.hasNext()) {
                String string3 = iterator.next().toString();
                if (string3.equals("*")) {
                    bl = false;
                    bl2 = true;
                    break;
                }
                if (!this.wildcardMatch(string2, string3)) continue;
                bl = false;
                bl2 = true;
                break;
            }
            if (!bl2) {
                list = userProfile.getStringList("sunportalgatewayaccessallowlist");
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string4 = iterator.next().toString();
                    if (string4.equals("*")) {
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    if (!this.wildcardMatch(string2, string4)) continue;
                    bl = true;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                bl = false;
            }
            if (!bl) {
                if (GWDebug.debug.warningEnabled()) {
                    GWDebug.debug.warning("Session: request is not allowed");
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("RProxy", GWLocale.getPFString("session8", new Object[]{this._logId, request.getURL(), new String(GWLogManager.getUserId(request.getSessionID()))}));
                }
            }
        }
        catch (Exception exception) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Session: failed to get URLPrivList", exception);
            }
            bl = false;
        }
        return bl;
    }

    Response retrieveResponse(Request request, String string, Retriever retriever, SSOToken sSOToken) {
        Response response;
        String string2;
        String string3 = request.getRequestHeader("Accept-Encoding");
        if (string3 != null) {
            request.setRequestHeader("Accept-Encoding", "");
        }
        if (request.getGatewayScheme().equals("redirect")) {
            string2 = request.getURL();
            if (!DomainWebProxyConfig.containHost(string)) {
                return new RedirectResponse(string2, false);
            }
        }
        if ((response = retriever.getResponse(request, string, this._logId)) == null) {
            if (GWDebug.debug.warningEnabled()) {
                GWDebug.debug.warning("Session: Unable to connect to host:  " + request.getHost());
            }
            if (request.getGatewayScheme().equals("redirect")) {
                if (request.getUseProxy()) {
                    String string4;
                    string2 = request.getProxyHost() + ":" + request.getProxyPort();
                    if (webProxErrorMessage != null && webProxErrorMessage.length() > 0) {
                        string4 = this.getUserLocale(sSOToken);
                        string2 = GWLocale.getPFString(webProxErrorMessage, new Object[]{string2}, string4);
                    } else {
                        string2 = "Session: Unable to connect to web prox host: " + string2 + ".";
                    }
                    string4 = request.getRequestHeader("Accept-Language");
                    response = new ErrorResponse(string2, sSOToken, string4);
                } else {
                    response = new RedirectResponse(request.getURL(), false);
                }
            } else if (ServiceIdentifier.isGateway()) {
                String string5;
                string2 = request.getHost();
                if (hostConnectErrorMessage != null && hostConnectErrorMessage.length() > 0) {
                    string5 = this.getUserLocale(sSOToken);
                    string2 = GWLocale.getPFString(hostConnectErrorMessage, new Object[]{string2}, string5);
                } else {
                    string2 = "Session: Unable to connect to host:  " + string2 + ".";
                }
                string5 = request.getRequestHeader("Accept-Language");
                response = new ErrorResponse(string2, sSOToken, string5);
            } else {
                String string6;
                string2 = "Session: Unable to connect to host:  " + request.getHost() + ".";
                if (hostConnectErrorMessage != null && hostConnectErrorMessage.length() > 0) {
                    string6 = this.getUserLocale(sSOToken);
                    string2 = GWLocale.getPFString(hostConnectErrorMessage, new Object[]{string2}, string6);
                }
                string6 = request.getRequestHeader("Accept-Language");
                response = new ErrorResponse(string2, UNKNOWN_HOST, sSOToken, string6);
            }
        } else if (ServiceIdentifier.isGateway() && (string2 = response.getStatusText()) != null && string2.equals(UNKNOWN_HOST)) {
            if (request.getGatewayScheme().equals("redirect")) {
                BufferedInputStream bufferedInputStream = null;
                bufferedInputStream = response.getContentStream();
                try {
                    if (bufferedInputStream instanceof CSBufferedInputStream) {
                        ((CSBufferedInputStream)bufferedInputStream).getSocket().close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                response = new RedirectResponse(request.getURL(), false);
            } else {
                response.setStatusText("Bad Gateway");
            }
        }
        return response;
    }

    private String getProxyHost(Request request) {
        String string = request.getSessionID();
        String string2 = null;
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = SSOUtil.getSSOToken(string);
            if (sSOTokenManager.isValidToken(sSOToken)) {
                string2 = sSOToken.getProperty(REWRITER_PROXY);
                if (string2 != null) {
                    if (RewriterProxyRouter.isRewriterProxyAlive(string2)) {
                        return string2;
                    }
                    string2 = RewriterProxyRouter.getRewriterProxyAlive();
                    if (string2 == null) {
                        return RewriterProxyRouter.getServer();
                    }
                    sSOToken.setProperty(REWRITER_PROXY, string2);
                    return string2;
                }
                string2 = RewriterProxyRouter.getRewriterProxyAlive();
                if (string2 == null) {
                    return RewriterProxyRouter.getServer();
                }
                sSOToken.setProperty(REWRITER_PROXY, string2);
                return string2;
            }
            string2 = RewriterProxyRouter.getRewriterProxyAlive();
            if (string2 == null) {
                return RewriterProxyRouter.getServer();
            }
            return string2;
        }
        catch (Exception exception) {
            string2 = RewriterProxyRouter.getRewriterProxyAlive();
            if (string2 == null) {
                return RewriterProxyRouter.getServer();
            }
            return string2;
        }
    }

    private String loginURL(Request request, String string) {
        String string2 = request.getSessionID();
        String string3 = ServersList.getServeraLive();
        String string4 = request.getGatewayHost();
        String string5 = request.getURI();
        String string6 = this.getDefaultOrg(request.getGatewayHost());
        String string7 = null;
        boolean bl = false;
        if (request.getProtocol() != null) {
            bl = true;
            string7 = request.getURL();
            if (string7 == null) {
                bl = false;
            }
        } else if (string5.length() > 1) {
            int n = string5.toLowerCase().indexOf("org=");
            if (n != -1) {
                int n2 = string5.indexOf(38, n += 4);
                if (n2 == -1) {
                    n2 = string5.length();
                }
                if ((string6 = string5.substring(n, n2)).equalsIgnoreCase("statistics")) {
                    string6 = defaultOrg;
                }
            } else if (request.getProtocol() == null && !string5.endsWith(_platformloginURL) && (string6 = string5.substring(1)).equalsIgnoreCase("statistics")) {
                string6 = defaultOrg;
            }
        }
        String string8 = null;
        if (bl && string7 != null && string7.indexOf("goto=") != -1) {
            String string9 = string7.trim().toLowerCase();
            Iterator iterator = expandedSessionServersList.iterator();
            while (iterator.hasNext()) {
                String string10 = (String)iterator.next();
                if (string10 == null) continue;
                if (!string9.startsWith(string10) || string9.indexOf(string.toLowerCase()) == -1) break;
                bl = false;
                break;
            }
        }
        try {
            if (string6.indexOf(61) != -1) {
                string6 = URLEncoder.encode(string6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            try {
                string7 = URLEncoder.encode(string7);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string8 = "gw=" + string4 + "&org=" + string6 + "&goto=" + string7;
        } else {
            string8 = "gw=" + string4 + "&org=" + string6;
        }
        if (doingPDC) {
            string8 = string8 + "&service=gatewaypdc";
        }
        return string3 + string + "?" + string8;
    }

    public void close() {
        try {
            this._theSocket.getOutputStream().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._theSocket != null) {
            try {
                this._theSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._theSocket = null;
        }
        if (processKeepAliveConnections && this.actualClientSocket != null) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.actualClientSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.actualClientSocket = null;
        }
    }

    private static void setVirtualHostname() {
        virtualHost.add(rphost);
        String string = SystemProperties.get("gateway.virtualhost", null);
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken().trim();
            virtualHost.add(string.toLowerCase());
            virtualHostActual.add(string);
        }
    }

    protected String getDefaultOrg(String string) {
        if (string == null || string.trim().length() == 0) {
            return defaultOrg;
        }
        String string2 = (String)virtualHostOrgMapping.get(string.toLowerCase());
        return string2 == null ? defaultOrg : string2;
    }

    private static void populateVirtualHostDefaultOrgMapping() {
        Iterator iterator = virtualHostActual.iterator();
        virtualHostOrgMapping = new HashMap();
        while (iterator.hasNext()) {
            String string = iterator.next().toString().trim();
            String string2 = SystemProperties.get(string + ".defaultOrg");
            if (string2 == null || string2.trim().length() <= 0) continue;
            virtualHostOrgMapping.put(string.toLowerCase(), string2.trim());
        }
    }

    private String getFQDN(String string) {
        int n = virtualHost.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)virtualHost.get(n2);
            if (string2.regionMatches(true, 0, string, 0, string.length())) {
                return string2;
            }
            ++n2;
        }
        return null;
    }

    private String getUserLocale(Request request) {
        if (request == null) {
            return defaultLocale;
        }
        return this.getUserLocale(request.getSessionID());
    }

    private String getUserLocale(SSOToken sSOToken) {
        if (sSOToken == null) {
            return defaultLocale;
        }
        return this.getUserLocale(sSOToken.getTokenID().toString());
    }

    private String getUserLocale(String string) {
        try {
            UserProfile userProfile = new UserProfile(string);
            return userProfile.getString("preferredlocale", "en_US");
        }
        catch (Exception exception) {
            return defaultLocale;
        }
    }

    private Response doPDC(String string, Request request) {
        Response response;
        block28: {
            response = null;
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: now doingPDC");
            }
            String string2 = "gw=";
            byte[] byArray = string2.getBytes();
            String string3 = URLEncoder.encode(string);
            byte[] byArray2 = string3.getBytes();
            String string4 = "&client=";
            byte[] byArray3 = string4.getBytes();
            String string5 = "127.0.0.1";
            byte[] byArray4 = string5.getBytes();
            String string6 = "&Login.Token0=";
            byte[] byArray5 = string6.getBytes();
            String string7 = "&testxyz=";
            byte[] byArray6 = string7.getBytes();
            String string8 = "justatest";
            String string9 = URLEncoder.encode(string8);
            byte[] byArray7 = string9.getBytes();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: ABOUT TO DO CERT LOGIN");
            }
            X509Certificate x509Certificate = null;
            Base64 base64 = new Base64();
            String string10 = null;
            byte[] byArray8 = null;
            SSLSocket sSLSocket = this.getActualSocket();
            try {
                int n;
                byte[] byArray9;
                block27: {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Session: prepare the cert to send over to the server.");
                    }
                    try {
                        x509Certificate = sSLSocket.getStatus().getPeerCertificate();
                    }
                    catch (SocketException socketException) {
                        if (GWDebug.debug.errorEnabled()) {
                            GWDebug.debug.error("Unable to get peer certificate");
                        }
                        return null;
                    }
                    byte[] byArray10 = x509Certificate.getEncoded();
                    byte[] byArray11 = Base64.encode(byArray10);
                    String string11 = new String(byArray11);
                    string10 = URLEncoder.encode(string11);
                    byArray9 = string10.getBytes();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream("/tmp/base64cert.certbyte");
                        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                        n = 0;
                        while (n < byArray11.length) {
                            dataOutputStream.writeByte(byArray11[n]);
                            ++n;
                        }
                        dataOutputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!GWDebug.debug.errorEnabled()) break block27;
                        GWDebug.debug.error("Session: see file /tmp/base64cert");
                    }
                }
                byArray8 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length + byArray6.length + byArray7.length + byArray9.length + 200];
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Session: certparam.length=" + byArray8.length);
                    GWDebug.debug.message("Session: b64Cert.length=" + string10.length());
                }
                int n2 = 0;
                int n3 = 0;
                while (n3 < byArray.length) {
                    byArray8[n3] = byArray[n3];
                    ++n3;
                }
                n2 = byArray.length;
                n = 0;
                while (n < byArray2.length) {
                    byArray8[n2] = byArray2[n];
                    ++n2;
                    ++n;
                }
                int n4 = 0;
                while (n4 < byArray3.length) {
                    byArray8[n2] = byArray3[n4];
                    ++n2;
                    ++n4;
                }
                int n5 = 0;
                while (n5 < byArray4.length) {
                    byArray8[n2] = byArray4[n5];
                    ++n2;
                    ++n5;
                }
                int n6 = 0;
                while (n6 < byArray5.length) {
                    byArray8[n2] = byArray5[n6];
                    ++n2;
                    ++n6;
                }
                int n7 = 0;
                while (n7 < byArray9.length) {
                    byArray8[n2] = byArray9[n7];
                    ++n2;
                    ++n7;
                }
                int n8 = 0;
                while (n8 < byArray6.length) {
                    byArray8[n2] = byArray6[n8];
                    ++n2;
                    ++n8;
                }
                int n9 = 0;
                while (n9 < byArray7.length) {
                    byArray8[n2] = byArray7[n9];
                    ++n2;
                    ++n9;
                }
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Session: certificate version: getSubjectDN " + x509Certificate.getSubjectDN());
                }
                Retriever retriever = null;
                HTTPRequest hTTPRequest = new HTTPRequest(this._gwprotocol, this.port);
                if (request.getObject().startsWith(_platformloginURL)) {
                    HTTPRequest hTTPRequest2 = null;
                    String string12 = request.getURL().trim();
                    int n10 = string12.toLowerCase().indexOf("org=");
                    if (n10 != -1) {
                        int n11 = string12.indexOf(38, n10 += 4);
                        if (n11 == -1) {
                            n11 = string12.length();
                        }
                        if ((string12 = string12.substring(n10, n11)).startsWith("/")) {
                            string12 = string12.substring(1);
                        }
                        hTTPRequest2 = new HTTPRequest(string12);
                    } else {
                        hTTPRequest2 = new HTTPRequest();
                    }
                    hTTPRequest2.setHost(request.getHost());
                    hTTPRequest2.setPort(request.getPort());
                    hTTPRequest2.setGatewayHost(request.getGatewayHost());
                    hTTPRequest.addHeaderLine("POST  /" + this.loginURL(hTTPRequest2, _platformloginURL) + " " + ((HTTPRequest)request).getHTTPVersion() + "\r\n");
                } else {
                    hTTPRequest.addHeaderLine("POST  /" + this.loginURL(request, _platformloginURL) + " " + ((HTTPRequest)request).getHTTPVersion() + "\r\n");
                }
                hTTPRequest.addHeaderLine("Content-Type: application/x-www-form-urlencoded\r\n");
                hTTPRequest.addHeaderLine("Content-Length: " + byArray8.length + "\r\n");
                retriever = RetrievalFactory.getRetriever(hTTPRequest.getProtocol());
                response = retriever.getResponse2(hTTPRequest, hTTPRequest.getHost(), this._logId, byArray8);
                request.setHost(hTTPRequest.getHost());
                request.setPort(hTTPRequest.getPort());
                request.setProtocol(hTTPRequest.getProtocol());
                request.setObject(hTTPRequest.getObject());
                request.setURL(hTTPRequest.getURL());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                if (!GWDebug.debug.errorEnabled()) break block28;
                GWDebug.debug.error("Session: CertificateEncodingException");
            }
        }
        return response;
    }

    private void removePDCCookie(Request request) {
        String string = request.getRequestHeader("Cookie");
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(sessionCookieName);
        n = string.indexOf(61, n) + 1;
        String string2 = string.substring(n).trim();
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string2.substring(6));
        request.setRequestHeader("Cookie", stringBuffer.toString());
    }

    private void addPDCCookie(Request request, Response response) {
        if (!(response instanceof HTTPResponse)) {
            return;
        }
        String string = null;
        List list = ((HTTPResponse)response).getHeaderAttributeList("Set-Cookie");
        if (list != null && list.size() > 0) {
            ((HTTPResponse)response).removeResponseHeader("Set-Cookie");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                StringBuffer stringBuffer = new StringBuffer();
                int n = string.indexOf(sessionCookieName);
                if (n != -1) {
                    String string2 = string.substring(string.indexOf(61, n) + 1).trim();
                    stringBuffer.append(string.substring(0, n));
                    stringBuffer.append(sessionCookieName);
                    stringBuffer.append("=");
                    stringBuffer.append(PDC_COOKIE_HEADER);
                    stringBuffer.append(string2);
                    ((HTTPResponse)response).appendResponseHeader("Set-Cookie", stringBuffer.toString());
                    continue;
                }
                ((HTTPResponse)response).appendResponseHeader("Set-Cookie", string);
            }
        } else {
            string = request.getRequestHeader("Cookie");
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = string.indexOf(sessionCookieName);
                if (n != -1) {
                    int n2 = string.indexOf(59, n);
                    n2 = n2 == -1 ? string.length() : n2;
                    String string3 = string.substring(string.indexOf(61, n) + 1, n2).trim();
                    stringBuffer.append("Set-Cookie: ");
                    stringBuffer.append(sessionCookieName);
                    stringBuffer.append("=");
                    stringBuffer.append(PDC_COOKIE_HEADER);
                    stringBuffer.append(string3);
                    stringBuffer.append(";path = /;");
                    if (gwDomain != null) {
                        stringBuffer.append(" domain =");
                        stringBuffer.append(gwDomain);
                        stringBuffer.append(";");
                    }
                    response.setResponseHeader("Set-Cookie", stringBuffer.toString());
                } else {
                    stringBuffer.append("Set-Cookie: ");
                    stringBuffer.append(sessionCookieName);
                    stringBuffer.append("=");
                    stringBuffer.append(PDC_COOKIE_HEADER);
                    stringBuffer.append(";path = /;");
                    if (gwDomain != null) {
                        stringBuffer.append(" domain =");
                        stringBuffer.append(gwDomain);
                        stringBuffer.append(";");
                    }
                    response.setResponseHeader("Set-Cookie", stringBuffer.toString());
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Set-Cookie: ");
                stringBuffer.append(sessionCookieName);
                stringBuffer.append("=");
                stringBuffer.append(PDC_COOKIE_HEADER);
                stringBuffer.append(";path = /;");
                if (gwDomain != null) {
                    stringBuffer.append(" domain =");
                    stringBuffer.append(gwDomain);
                    stringBuffer.append(";");
                }
                response.setResponseHeader("Set-Cookie", stringBuffer.toString());
            }
        }
    }

    private boolean hostFound(String string) {
        Iterator iterator = serverList.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString().toLowerCase();
            String string3 = null;
            int n = -1;
            if (string2.startsWith("http:")) {
                n = string2.lastIndexOf(58);
                string3 = 4 == n ? string2.substring(7) : string2.substring(7, n);
            } else if (string2.startsWith("https:")) {
                n = string2.lastIndexOf(58);
                string3 = 5 == n ? string2.substring(8) : string2.substring(8, n);
            } else if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Server list entry is not in the right format: " + string2);
            }
            String string4 = string.substring(string.indexOf(58) + 3).toLowerCase();
            if (string3 == null) {
                return false;
            }
            if (!string4.startsWith(string3)) continue;
            return true;
        }
        return false;
    }

    private boolean isUserSessionValid(Request request) {
        String string = request.getSessionID();
        if (string == null || string.equals("null") || string.trim().length() == 0) {
            return false;
        }
        return this.getUserSession(request, string) != null;
    }

    SSLSocket getActualSocket() {
        if (this._theSocket instanceof SRAPSocket) {
            SRAPSocket sRAPSocket = (SRAPSocket)this._theSocket;
            return (SSLSocket)sRAPSocket.getActualSocket();
        }
        return (SSLSocket)this._theSocket;
    }

    static {
        _hpprot = "https";
        srapGateway_certificateEnabledList_lc = GatewayProfile.getLowerCaseStringList("CertificateEnabledList");
        virtualHost = new ArrayList();
        virtualHostActual = new ArrayList();
        nonAuthPathList = GatewayProfile.getLowerCaseURLList("NonAuthenticatedURLPath");
        _numRequests = 0;
        _numBytesRead = 0;
        _numBytesSent = 0;
        processKeepAliveConnections = GatewayProfile.getBoolean("EProxyDoKeepAlive", true) && ServiceIdentifier.isGateway();
        timeoutseconds = GatewayProfile.getInt("EProxyKeepAliveConnectionTimeout", 50);
        GRACE_PERIOD = GatewayProfile.getInt("EProxyKeepAliveConnectionGraceTimeout", 20);
        maxTimeOutSetting = (long)(timeoutseconds + GRACE_PERIOD) * 1000L;
        defDomain = GatewayProfile.getString("DefaultDomainAndSubdomains", "");
        sessionCookieName = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        sessionCookieLen = sessionCookieName.length();
        defaultOrg = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.defaultOrg", (String)defDomain);
        gwDomain = null;
        serverList = GatewayProfile.getLowerCaseStringList("PortalServerList");
        notificationURL = System.getProperty("gateway.notification.url", "notification");
        isPerSessionLoggingEnabled = GatewayProfile.getBoolean("EProxyPerSessionLogging", false) && ServiceIdentifier.isGateway();
        detailedRproxLog = GatewayProfile.getBoolean("EProxyDetailedPerSessionLogging", false);
        defaultLocale = GatewayProfile.getString("locale", "en_US");
        server_traffic = GWDebug.createDebugLog("Gateway_to_from_server");
        server_traffic.setDebug();
        browser_traffic = GWDebug.createDebugLog("Gateway_to_from_browser");
        browser_traffic.setDebug();
        rphost = SystemProperties.get("gateway.host", null);
        Session.setVirtualHostname();
        Session.populateVirtualHostDefaultOrgMapping();
        _useHTTPProxy = GatewayProfile.getBoolean("UseHTTPProxy", false) && ServiceIdentifier.isGateway();
        _hpport = GatewayProfile.getString("HTTPProxyPort", "10443");
        _platformloginURL = PlatformProfile.getString("login-url", "");
        _platformlogoutURL = PlatformProfile.getString("logout-url", "");
        nonAuthPathList.add(_platformloginURL);
        nonAuthPathList.add(_platformlogoutURL);
        int n = rphost.indexOf(46);
        gwDomain = n != -1 ? rphost.substring(n) : null;
        expandedSessionServersList = null;
        expandedSessionServersList = new LinkedList();
        Set set = ServersList.getAllSessionServersSet();
        URL uRL = null;
        String string = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                string = iterator.next().toString();
                uRL = new URL(string);
                expandedSessionServersList.add(uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort());
                if ((!uRL.getProtocol().equalsIgnoreCase("http") || uRL.getPort() != 80) && (!uRL.getProtocol().equalsIgnoreCase("https") || uRL.getPort() != 443)) continue;
                expandedSessionServersList.add(uRL.getProtocol() + "://" + uRL.getHost());
            }
            catch (Exception exception) {
                if (!GWDebug.debug.messageEnabled()) continue;
                GWDebug.debug.message("Exception while parsing entry " + string, exception);
            }
        }
        clientIPHeaderKey = "PS-GW-ClientIP";
        gatewayURLInfoHeaderKey = "PS-GW-URL";
        gatewayRWURLInfoHeaderKey = "PS-GW-Rewriting-URL";
        faviconLocation = "";
        faviconLocation = SystemProperties.get("gateway.favicon", "");
        if (faviconLocation != null && faviconLocation.trim().length() == 0) {
            faviconLocation = null;
        }
    }
}

