/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterDecrypt;
import com.sun.portal.netlet.econnection.ReaderWriterEncrypt;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.SConn;
import com.sun.portal.netlet.eproxy.SessionAuthenticator;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.NetletLogMgr;
import java.net.Socket;

public class RWGroupCrypt
extends ReaderWriterLock {
    public boolean done;
    private int srcPort;
    private String destPort;
    private String destHost;
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterDecrypt src_to_dst;
    private ReaderWriterEncrypt dst_to_src;
    private SessionAuthenticator sessionAuth;
    private SessionRequest sessionReq;
    private Integer netletLogId;
    private long startTime;
    private boolean stopLogged;

    public RWGroupCrypt(Socket socket, int n, String string, String string2, SessionAuthenticator sessionAuthenticator, SessionRequest sessionRequest) {
        block12: {
            this.done = false;
            this.stopLogged = false;
            this.fromClient = socket;
            this.srcPort = n;
            this.destPort = new String(string);
            this.destHost = new String(string2);
            this.sessionAuth = sessionAuthenticator;
            this.sessionReq = sessionRequest;
            this.toServer = SConn.connect(this.destPort, this.destHost);
            if (this.toServer == null) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("RWGroupCrypt: unable to make server connection!");
                }
                this.cleanup();
                return;
            }
            if (NetletLogMgr.loggingEnabled) {
                try {
                    this.netletLogId = new Integer(NetletLogMgr.getLogId());
                    NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessionReq.getSessionID())), "START", this.fromClient.getInetAddress().toString(), new Integer(this.srcPort), this.toServer.getInetAddress().toString(), new Integer(this.toServer.getPort())}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.getNetletKeepAliveInterval(sessionRequest) > 0) {
                try {
                    this.fromClient.setSoTimeout(this.getNetletKeepAliveInterval(sessionRequest) * 60000);
                }
                catch (Exception exception) {
                    System.out.println("Unable to set socket time out.." + exception);
                }
            }
            try {
                this.src_to_dst = new ReaderWriterDecrypt(this, this.fromClient.getInputStream(), this.toServer.getOutputStream());
                this.dst_to_src = new ReaderWriterEncrypt(this, this.toServer.getInputStream(), this.fromClient.getOutputStream(), this.getNetletKeepAliveInterval(sessionRequest));
            }
            catch (Exception exception) {
                GWDebug.debug.error("RWGroupCrypt: Unable to create reader writers.", exception);
            }
            try {
                GWThreadPool.run(this.src_to_dst);
                GWThreadPool.run(this.dst_to_src);
            }
            catch (InterruptedException interruptedException) {
                if (!GWDebug.debug.errorEnabled()) break block12;
                GWDebug.debug.error("Could not start ReaderWriterClear tasks", interruptedException);
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void notifyFinished(ReaderWriter readerWriter) {
        if (!this.stopLogged && NetletLogMgr.loggingEnabled) {
            try {
                this.netletLogId = new Integer(NetletLogMgr.getLogId());
                NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessionReq.getSessionID())), new String("STOP"), this.fromClient.getInetAddress().toString(), new Integer(this.srcPort), this.toServer.getInetAddress().toString(), new Integer(this.toServer.getPort())}));
                this.stopLogged = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (readerWriter == this.src_to_dst) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
        } else if (readerWriter == this.dst_to_src && this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public synchronized void stopAll() {
        if (!this.done) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
            if (this.src_to_dst != null) {
                this.src_to_dst.stop();
            }
            this.cleanup();
        }
    }

    public void cleanup() {
        try {
            if (this.fromClient != null) {
                try {
                    block12: {
                        try {
                            this.fromClient.close();
                            if (!PerfContextObject.ENABLE_PERF) break block12;
                            SocketCount.decrementPlainSockets();
                        }
                        catch (Exception exception) {
                            Object var3_2 = null;
                            this.fromClient = null;
                        }
                    }
                    Object var3_1 = null;
                    this.fromClient = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.fromClient = null;
                    throw throwable;
                }
            }
            if (this.toServer != null) {
                try {
                    block14: {
                        try {
                            this.toServer.close();
                            if (!PerfContextObject.ENABLE_PERF) break block14;
                            SocketCount.decrementPlainSockets();
                        }
                        catch (Exception exception) {
                            Object var5_8 = null;
                            this.toServer = null;
                        }
                    }
                    Object var5_7 = null;
                    this.toServer = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    this.toServer = null;
                    throw throwable;
                }
            }
            Object var7_11 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
            throw throwable;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public long getLastActivityTime() {
        if (this.src_to_dst.getLastActivityTime() > this.dst_to_src.getLastActivityTime()) {
            return this.src_to_dst.getLastActivityTime();
        }
        return this.dst_to_src.getLastActivityTime();
    }

    private int getNetletKeepAliveInterval(SessionRequest sessionRequest) {
        try {
            String string = sessionRequest.getSessionID();
            NetletProfile netletProfile = new NetletProfile(string);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("RWGroupCrypt: Netlet keep alive interval -> " + NetletProfile.getInt("KeepAliveInterval", 0));
            }
            return NetletProfile.getInt("KeepAliveInterval", 0);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getAppletSrcPort() {
        return this.srcPort;
    }
}

