/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.xml;

import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.xml.Document;
import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public final class Node {
    private NamedNodeMap nodeMap = null;
    private String name = "";
    private String pcData = "";
    private org.w3c.dom.Node w3cNode;
    private Document source = null;

    public Node(org.w3c.dom.Node aNode) {
        if (aNode != null) {
            this.w3cNode = aNode;
            this.source = new Document(aNode.getOwnerDocument());
            this.name = aNode.getNodeName();
            this.nodeMap = aNode.getAttributes();
            org.w3c.dom.Node childNode = aNode.getFirstChild();
            if (childNode != null) {
                this.pcData = childNode.getNodeValue();
                if (this.pcData == null) {
                    this.pcData = "";
                }
            }
        }
    }

    public org.w3c.dom.Node getW3CNode() {
        return this.w3cNode;
    }

    public String getName() {
        return this.name;
    }

    public String getPCData() {
        return this.pcData;
    }

    public String getAttributeValue(String aAttName) {
        if (this.nodeMap != null) {
            try {
                return this.nodeMap.getNamedItem(aAttName).getNodeValue();
            }
            catch (Exception e) {
                Debug.warning("Error: NodeName: " + this.getW3CNode().getNodeName() + " Attribute Absent: " + aAttName, e);
            }
        }
        return "";
    }

    public Node selectNode(String aXPath) throws InvalidXMLException {
        Node[] list = this.selectNodes(aXPath);
        Node result = new Node(null);
        int nodeLength = list.length;
        switch (nodeLength) {
            case 0: {
                break;
            }
            case 1: {
                result = list[0];
                break;
            }
            default: {
                throw new InvalidXMLException("More than One Element of '" + aXPath + "' present : ", null, aXPath, 1003);
            }
        }
        return result;
    }

    public Document getDocument() {
        return this.source;
    }

    public Node[] selectNodes(String aXPath) {
        return Document.selectNodes(this.source, aXPath);
    }

    public Node[] getChildren(String aTagName) {
        return Node.getChildNodes(this, aTagName);
    }

    public static Node[] getChildNodes(Node aNode, String aTagName) {
        ArrayList<Node> v = new ArrayList<Node>();
        if (aNode.getW3CNode() != null) {
            NodeList list = aNode.getW3CNode().getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                org.w3c.dom.Node lNode = list.item(i);
                if (lNode.getNodeName().equals(aTagName)) {
                    v.add(new Node(lNode));
                }
                ++i;
            }
        }
        return v.toArray(Constants.EMPTY_NODE_ARRAY);
    }
}

