/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.am.util.SystemProperties;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityListener;
import com.sun.portal.util.ServersList;
import java.net.MalformedURLException;
import java.net.URL;

public class ApplicationLoginHostChooser
extends HostAvailabilityListener {
    private URL currentHostInUse = null;
    private boolean isInitialised = false;
    private static final String bootupISUrl;
    private static ApplicationLoginHostChooser instance;

    private ApplicationLoginHostChooser() {
        this.addHostAvailabilityListener(this);
    }

    private synchronized void setCurrentHostInUse(URL url) {
        this.currentHostInUse = url;
    }

    public static synchronized URL getAlivePlatFormServerURL() {
        String url = null;
        url = PlatformProfile.isInitialised() ? ServersList.getServeraLive() : bootupISUrl;
        URL retUrl = null;
        if (url != null) {
            try {
                retUrl = new URL(url);
                instance.setCurrentHostInUse(retUrl);
            }
            catch (MalformedURLException mfEx) {
                retUrl = null;
            }
        }
        return retUrl;
    }

    public void hostAvailabilityChanged(HostAvailabilityEvent hae) {
        boolean needRecreate = false;
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Host avaliability changed : " + hae.getHostStatus() + " for " + hae.getHost());
        }
        if (!this.isInitialised || this.currentHostInUse == null) {
            needRecreate = true;
        }
        if (hae.getHostType() == 1 && hae.getHostStatus() == 2) {
            try {
                URL tmpURL = new URL(hae.getHost());
                if (tmpURL.getHost().equalsIgnoreCase(this.currentHostInUse.getHost()) && tmpURL.getPort() == this.currentHostInUse.getPort()) {
                    needRecreate = true;
                }
            }
            catch (Exception ex) {
                needRecreate = true;
            }
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Host avaliability changed -> Host : " + hae.getHost() + " needRecreate app session : " + needRecreate);
        }
        if (needRecreate) {
            this.recreateLoginSession();
        }
    }

    private void recreateLoginSession() {
        GWLogManager.createNewAppSession();
    }

    static {
        String url;
        block4: {
            url = null;
            String protocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
            String host = SystemProperties.get((String)"com.iplanet.am.server.host");
            String port = SystemProperties.get((String)"com.iplanet.am.server.port");
            try {
                URL _url = new URL(protocol, host, Integer.parseInt(port), "/");
                url = _url.toString();
            }
            catch (MalformedURLException mfEx) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Unable to create IS server url from AMConfig.properties", mfEx);
                    GWDebug.debug.error("protocol : " + protocol + " host : " + host + " port : " + port);
                }
            }
            catch (NumberFormatException nfEx) {
                if (!GWDebug.debug.errorEnabled()) break block4;
                GWDebug.debug.error("Unable to create IS server url from AMConfig.properties", nfEx);
                GWDebug.debug.error("protocol : " + protocol + " host : " + host + " port : " + port);
            }
        }
        bootupISUrl = url;
        instance = new ApplicationLoginHostChooser();
    }
}

