/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.ESessionMsg;
import com.sun.portal.netlet.eproxy.EProxy;
import com.sun.portal.netlet.eproxy.ESession;
import com.sun.portal.netlet.eproxy.ProxyConnection;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.server.RequestProcessor;
import com.sun.portal.rproxy.server.ServerSocketFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class RProxyConnection
extends ProxyConnection {
    private boolean secureConnection;
    private int port = 0;
    private RequestProcessor requestProcessor;
    static boolean useAcceleratorSupport = false;
    private static final String TIMEOUT = "RProxyPortTimeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int timeout;

    public static void startHttps(final int port) {
        Runnable r = new Runnable(){

            public void run() {
                RProxyConnection rpconn = new RProxyConnection(true, port);
                rpconn.start();
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    public static void startHttps(final int exposedPort, final int port) {
        Runnable r = new Runnable(){

            public void run() {
                RProxyConnection rpconn = new RProxyConnection(true, exposedPort, port);
                rpconn.start();
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    public static void startHttp(final int port) {
        Runnable r = new Runnable(){

            public void run() {
                RProxyConnection rpconn = new RProxyConnection(false, port);
                rpconn.start();
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    private RProxyConnection(boolean secureConnection, int port) {
        super("RProxyHTTPSThread", "epc1");
        this.secureConnection = secureConnection;
        this.port = port;
        this.requestProcessor = this.secureConnection ? new RequestProcessor("https", port) : new RequestProcessor("http", port);
    }

    private RProxyConnection(boolean secureConnection, int exposedPort, int port) {
        super("RProxyHTTPSThread", "epc1");
        this.secureConnection = secureConnection;
        this.port = port;
        this.requestProcessor = this.secureConnection ? new RequestProcessor("https", exposedPort) : new RequestProcessor("http", exposedPort);
    }

    protected ServerSocket makeServerSocket() {
        if (this.secureConnection && useAcceleratorSupport && ServiceIdentifier.isGateway()) {
            return ServerSocketFactory.createSRAPServerSocket(this.port);
        }
        return this.secureConnection ? ServerSocketFactory.createSSLSocketServer(this.port) : ServerSocketFactory.createSRAPServerSocket(this.port);
    }

    private boolean isNetletTraffic(Socket inconnection) {
        ESessionMsg emsg;
        block15: {
            InputStream in = null;
            try {
                in = inconnection.getInputStream();
            }
            catch (IOException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("RProxyConnection cannot open input stream on " + inconnection, e);
                }
                try {
                    inconnection.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return false;
            }
            emsg = new ESessionMsg();
            try {
                in.mark(512);
            }
            catch (Exception e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot mark " + inconnection, e);
                }
                try {
                    inconnection.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                emsg = null;
                return false;
            }
            if (emsg.readMsg(new DataInputStream(in)) == 0) {
                emsg = null;
                return true;
            }
            try {
                in.reset();
            }
            catch (Exception e) {
                if (!GWDebug.debug.errorEnabled()) break block15;
                GWDebug.debug.error("Cannot reset " + inconnection, e);
            }
        }
        emsg = null;
        return false;
    }

    protected void process(Socket connection, Integer logId) {
        try {
            GWThreadPool.run(new RProxyThread(connection, logId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        String strUseAcceleratorSupport = SystemProperties.get("gateway.enable.accelerator", "false");
        if (strUseAcceleratorSupport != null) {
            useAcceleratorSupport = strUseAcceleratorSupport.trim().equalsIgnoreCase("true");
        }
        timeout = GatewayProfile.getInt(TIMEOUT, 60000);
    }

    class RProxyThread
    implements Runnable {
        private Socket connection;
        private Integer logId;

        public RProxyThread(Socket _connection, Integer _logId) {
            this.connection = _connection;
            this.logId = _logId;
        }

        public void run() {
            int initialTimeout;
            boolean checkNetlet;
            block20: {
                block19: {
                    checkNetlet = false;
                    if (ServiceIdentifier.isRewriterProxy() || ServiceIdentifier.isGateway() && EProxy.isNetletEnabled) {
                        GWLogManager.logIdMap.put(new Integer(this.connection.getPort()), new LogInfoContainer(this.logId, this.connection));
                    }
                    initialTimeout = 0;
                    try {
                        initialTimeout = this.connection.getSoTimeout();
                    }
                    catch (Exception ex) {
                        if (!GWDebug.debug.errorEnabled()) break block19;
                        GWDebug.debug.error("RProxy caught exception while setting getSoTimeout() : ", ex);
                    }
                }
                try {
                    this.connection.setSoTimeout(timeout);
                }
                catch (Exception ex) {
                    if (!GWDebug.debug.errorEnabled()) break block20;
                    GWDebug.debug.error("RProxy caught exception while setting setSoTimeout() : ", ex);
                }
            }
            if (ServiceIdentifier.isGateway()) {
                checkNetlet = EProxy.isNetletEnabled;
            } else if (ServiceIdentifier.isNetletProxy()) {
                checkNetlet = true;
            }
            if (checkNetlet && RProxyConnection.this.isNetletTraffic(this.connection)) {
                block21: {
                    GWDebug.debug.message("RPRoxy received netlet request. Starting netlet session...");
                    try {
                        this.connection.setSoTimeout(initialTimeout);
                    }
                    catch (Exception ex) {
                        if (!GWDebug.debug.errorEnabled()) break block21;
                        GWDebug.debug.error("isNetletTraffic caught exception while setting setSoTimeout() : ", ex);
                    }
                }
                ESession es = new ESession(this.connection, this.logId);
                try {
                    GWThreadPool.run(es);
                }
                catch (InterruptedException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Cannot run ESession", e);
                    }
                    try {
                        this.connection.close();
                        if (PerfContextObject.ENABLE_PERF) {
                            SocketCount.decrementPlainSockets();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (!ServiceIdentifier.isNetletProxy()) {
                RProxyConnection.this.requestProcessor.processRequestInGWTheadPool(this.connection, this.logId);
            } else {
                RProxyConnection.this.closeSocket(this.connection);
            }
        }
    }
}

