/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.econnection.CipherMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SessionCipherMsg
extends CipherMsg {
    protected byte[] sessId = null;

    public SessionCipherMsg() {
        super((byte)1, (short)1);
    }

    public SessionCipherMsg(byte[] sid, int sidlen) {
        super((byte)1, (short)1);
        this.msgLen = sidlen;
        this.sessId = new byte[sidlen];
        System.arraycopy(sid, 0, this.sessId, 0, sidlen);
    }

    public int readMsg(DataInputStream in) {
        int rc = 0;
        rc = this.readHeader(in);
        if (rc == 0) {
            if (this.msgLen > 0) {
                if (this.sessId != null) {
                    this.sessId = null;
                }
                byte[] tmpId = new byte[this.msgLen];
                try {
                    in.readFully(tmpId, 0, this.msgLen);
                    this.sessId = new byte[this.msgLen];
                    System.arraycopy(tmpId, 0, this.sessId, 0, this.msgLen);
                }
                catch (IOException e) {
                    System.out.println("SessionMsg: readMsg IOE: " + e);
                    rc = -1;
                }
                Object var3_3 = null;
            } else {
                rc = -1;
            }
        }
        return rc;
    }

    public int writeMsg(DataOutputStream out) {
        int rc = 0;
        try {
            byte[] tmpId = new byte[this.sessId.length];
            System.arraycopy(this.sessId, 0, tmpId, 0, this.msgLen);
            ByteArrayOutputStream b_out = new ByteArrayOutputStream(11 + this.sessId.length);
            DataOutputStream db_out = new DataOutputStream(b_out);
            int oldmsgLen = this.msgLen;
            this.writeHeaderToByteArray(b_out);
            b_out.write(tmpId, 0, this.msgLen);
            b_out.writeTo(out);
            out.flush();
            this.msgLen = oldmsgLen;
            tmpId = null;
        }
        catch (IOException e) {
            System.out.println("SessionMsg: writeMsg IOE: " + e);
            rc = -1;
        }
        return rc;
    }

    public byte[] getToDataStream() {
        ByteArrayOutputStream b_out = new ByteArrayOutputStream();
        b_out.write(this.sessId, 0, this.msgLen);
        return b_out.toByteArray();
    }

    public int setFromDataStream(byte[] buffer, int buffer_len) {
        int rc = 0;
        if (buffer_len > 0) {
            ByteArrayInputStream b_in = new ByteArrayInputStream(buffer);
            this.msgLen = buffer_len;
            b_in.read(this.sessId, 0, this.msgLen);
        } else {
            rc = -1;
        }
        return rc;
    }

    public byte[] getSessionId() {
        if (this.msgLen > 0) {
            byte[] id = new byte[this.msgLen];
            System.arraycopy(this.sessId, 0, id, 0, this.msgLen);
            return id;
        }
        return null;
    }

    public void setSessionId(byte[] id, int id_len) {
        this.msgLen = 0;
        if (this.sessId != null) {
            this.sessId = null;
        }
        this.sessId = new byte[id_len];
        System.arraycopy(id, 0, this.sessId, 0, id_len);
        this.msgLen = id_len;
    }
}

