/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.crypto.CryptoHelper;
import com.sun.portal.rewriter.util.uri.StandardURI;
import com.sun.portal.rewriter.util.uri.URIHelper;
import com.sun.portal.rewriter.util.uri.URIIntf;
import java.net.MalformedURLException;

public class DecoratedURI
implements URIIntf {
    public static final DecoratedURI EMPTY_DECORATED_URI = DecoratedURI.createEmptyDecoratedURI();
    private final StandardURI uriImpl;
    private String orgURI;
    private String portString = null;
    private String networkURI = null;
    private String baseHREF = null;
    private String pathQueryReference = null;
    private String protocol = null;
    private String userInfo = null;
    private String host = null;
    private String path = null;
    private String query = null;
    private String reference = null;
    private String fileURI = null;
    private String fullFileURI = null;
    private String pathAndQuery = null;
    private String externalForm = null;
    private String normalForm = null;

    private DecoratedURI(StandardURI aStandardURI, String aOrgURI) {
        this.uriImpl = aStandardURI;
        this.orgURI = aOrgURI;
    }

    public DecoratedURI(String aURIString) throws MalformedURLException {
        this.orgURI = CryptoHelper.decode(aURIString);
        try {
            this.uriImpl = new StandardURI(this.orgURI);
        }
        catch (MalformedURLException me) {
            Debug.recordURIWarning("Invalid URI:" + this.orgURI, me);
            throw me;
        }
    }

    public String getInputString() {
        if (this.orgURI == null) {
            return "";
        }
        return this.orgURI;
    }

    public boolean isAbsolute() {
        return this.uriImpl.isAbsolute();
    }

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.uriImpl.getProtocol();
        }
        return this.protocol;
    }

    public String getUserInfo() {
        if (this.userInfo == null) {
            String string = this.userInfo = this.uriImpl.getUserInfo().equals("") ? "" : this.uriImpl.getUserInfo() + "@";
            if (this.uriImpl.getHost().length() == 0 && this.userInfo.length() == 0 && this.uriImpl.getAuthority().length() != 0) {
                this.userInfo = this.uriImpl.getAuthority();
            }
        }
        return this.userInfo;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = this.uriImpl.getHost();
        }
        return this.host;
    }

    public int getPort() {
        int lPort = this.uriImpl.getPort();
        if (lPort == this.uriImpl.getDefaultPort()) {
            return -1;
        }
        return lPort;
    }

    public String getPortString() {
        if (this.portString == null) {
            int lPort = this.getPort();
            this.portString = lPort != -1 ? ":" + lPort : "";
        }
        return this.portString;
    }

    public int getDefaultPort() {
        return this.uriImpl.getDefaultPort();
    }

    public String getNetworkURI() {
        if (!this.isAbsolute()) {
            return "";
        }
        if (this.networkURI == null) {
            this.networkURI = this.getProtocol() + "://" + this.getUserInfo() + this.getHost() + this.getPortString();
        }
        return this.networkURI;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.uriImpl.getPath();
        }
        return this.path;
    }

    public String getPathQueryAndReference() {
        if (this.pathQueryReference == null) {
            this.pathQueryReference = this.getFileURI() + this.getQuery() + this.getReference();
        }
        return this.pathQueryReference;
    }

    public String getPathAndQuery() {
        if (this.pathAndQuery == null) {
            this.pathAndQuery = this.getFileURI() + this.getQuery();
        }
        return this.pathAndQuery;
    }

    public String getParameterValue(String aParamName) {
        return this.uriImpl.getParameterValue(aParamName);
    }

    public String getFileURI() {
        if (this.fileURI == null) {
            this.fileURI = this.uriImpl.getFileURI();
            if (URIHelper.needsToAppendDirectorySeperator(this.fileURI)) {
                this.fileURI = this.uriImpl.getFileURI() + "/";
            }
        }
        return this.fileURI;
    }

    public String getDirURI() {
        return this.uriImpl.getDirURI();
    }

    public String getFileName() {
        return this.uriImpl.getFileName();
    }

    public String getFileExtension() {
        return this.uriImpl.getFileExtension();
    }

    public String getQuery() {
        if (this.query == null) {
            this.query = this.hasQuery() ? "?" + this.uriImpl.getQuery() : "";
        }
        return this.query;
    }

    public String getReference() {
        if (this.reference == null) {
            this.reference = this.hasReference() ? "#" + this.uriImpl.getReference() : "";
        }
        return this.reference;
    }

    public boolean hasReference() {
        return this.uriImpl.hasReference();
    }

    public boolean hasQuery() {
        return this.uriImpl.hasQuery();
    }

    public String getBaseHREF() {
        if (this.baseHREF == null) {
            this.baseHREF = this.getNetworkURI() + this.uriImpl.getDirURI();
        }
        return this.baseHREF;
    }

    public String getFullFileURI() {
        if (this.fullFileURI == null) {
            this.fullFileURI = this.getNetworkURI() + this.getFileURI();
        }
        return this.fullFileURI;
    }

    public boolean isValid() {
        return this.uriImpl.isValid();
    }

    public DecoratedURI resolve(String aResolveURI) throws MalformedURLException {
        return new DecoratedURI(this.uriImpl.resolve(aResolveURI), aResolveURI);
    }

    public boolean isOnlyReference() {
        if (this.orgURI != null) {
            return this.orgURI.startsWith("#");
        }
        return false;
    }

    public URIIntf getDecoratee() {
        return this.uriImpl;
    }

    public final String toExternalForm() {
        if (this.externalForm == null) {
            if (!this.isValid()) {
                this.externalForm = this.uriImpl.toExternalForm();
            } else {
                StringBuffer sb = new StringBuffer(this.getInputString().length());
                sb.append(this.getProtocol());
                if (this.getProtocol().length() != 0) {
                    sb.append("://");
                }
                sb.append(this.getUserInfo()).append(this.getHost()).append(this.getPortString()).append(this.getPath()).append(this.getQuery()).append(this.getReference());
                this.externalForm = sb.toString();
            }
        }
        return this.externalForm;
    }

    public String toNormalForm() {
        if (this.normalForm == null) {
            if (!this.isValid()) {
                this.normalForm = this.toExternalForm();
            } else {
                StringBuffer sb = new StringBuffer(this.getInputString().length());
                sb.append(this.getProtocol());
                if (this.getProtocol().length() != 0) {
                    sb.append("://");
                }
                sb.append(this.getUserInfo()).append(this.getHost()).append(this.getPortString()).append(this.getFileURI()).append(this.getQuery()).append(this.getReference());
                this.normalForm = sb.toString();
            }
        }
        return this.normalForm;
    }

    public boolean isNetworkURIMatch(DecoratedURI aURIIntf) {
        return this.getProtocol().equalsIgnoreCase(aURIIntf.getProtocol()) && this.getHost().equalsIgnoreCase(aURIIntf.getHost()) && this.getPort() == aURIIntf.getPort();
    }

    public String toString() {
        return "Contents of PageSpec Object:\n\tOriginal: " + this.getInputString() + "\n\tExternal Form: " + this.toExternalForm() + "\n\tProtocol: " + this.getProtocol() + "\n\tHost: " + this.getHost() + "\n\tPort: " + this.getPortString() + "\n\tNetworkURI: " + this.getNetworkURI() + "\n\tFileURI: " + this.getFileURI() + "\n\tDirURI: " + this.getDirURI() + "\n\tFileName:" + this.getFileName() + "\n\tReference: " + this.getReference() + "\n\tQuery: " + this.getQuery() + "\n\tRelativeURI: " + this.getPathQueryAndReference() + "\n\tBaseHREF: " + this.getBaseHREF();
    }

    public String getImplID() {
        return "DecoratedURI";
    }

    private static DecoratedURI createEmptyDecoratedURI() {
        try {
            return new DecoratedURI("");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String[] location = new String[]{"https://zeus.nawab.inda.com:443/index.html", "https://rajanagendra.sun.com:443/home/rule.jsp#rajesh", "https://rajanagendra.sun.com:443/home/rule.jsp#rajesh?ab=12&&34=yu", "https://rajanagendra.sun.com:443/home/..", "http://rajanagendra.sun.com/Base/Raja/raja.html", "http://raja.com", "http://rajanagendra.sun.com/avc/abc.jsp", "http://rajanagendra.sun.com/", "http://rajanagendra.sun.com:80/home/rule.jsp?ab=12&&34=yu", "https://rajanagendra.sun.com:1443/home/rule.jsp#rajesh?ab=12&&34=yu"};
        for (int i = 0; i < location.length; ++i) {
            DecoratedURI uriDec = new DecoratedURI(location[i]);
            System.out.println(uriDec.getPort());
        }
    }
}

