/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.mozilla.jss.crypto.X509Certificate;

public class PrintCertificate
implements Command {
    public boolean execute(JSSContext cntx) {
        String nick = CertAdminUtil.question(CertAdminLocale.getPFString("q18", "Enter the name you like for this certificate ["));
        if (nick.trim().equals("")) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m30", "Certificate name entered is not valid!"));
            return false;
        }
        if (!JSSUtil.certExist(cntx, nick)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m31", "Specified certificate does not exist!"));
            return false;
        }
        try {
            X509Certificate certificate = JSSUtil.getCertByNickname(cntx, nick);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(certificate.getEncoded());
            Certificate cert = cf.generateCertificate(bais);
            CertAdminUtil.println(cert.toString());
            return true;
        }
        catch (Exception ex) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m39", "Could not print the certificate!") + " " + nick + " ");
            ex.printStackTrace();
            return false;
        }
    }
}

