/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminPasswordCallback;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11TokenCert;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class DeleteCertificate
implements Command {
    private JSSContext cntx;

    public boolean execute(JSSContext cntx) {
        this.cntx = cntx;
        String nick = CertAdminUtil.question(CertAdminLocale.getPFString("q17", "Enter the name of the certificate to be deleted ?"));
        if (nick.trim().equals("")) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m30", "Certificate name entered is not valid!"));
            return false;
        }
        if (!JSSUtil.certExist(cntx, nick)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m31", "Specified certificate does not exist!"));
            return false;
        }
        try {
            this.deleteCertificate(nick);
            CertAdminUtil.println(CertAdminLocale.getPFString("m26", "Certificate") + " " + nick + " " + CertAdminLocale.getPFString("m32", "deleted successfully"));
            return true;
        }
        catch (Exception ex) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m33", "Could not delete the certificate!") + " " + nick + " ");
            ex.printStackTrace();
            return false;
        }
    }

    private void deleteCertificate(String nick) throws Exception {
        X509Certificate cert = this.cntx.getCryptoManager().findCertByNickname(nick);
        this.deleteCertificate(cert);
    }

    private void deleteCertificate(X509Certificate cert) throws Exception {
        Object password;
        String passphrase = this.cntx.getPasswordContext().generatePassphrase(this.cntx);
        CryptoToken tok = null;
        if (cert instanceof PK11TokenCert) {
            tok = ((PK11TokenCert)cert).getOwningToken();
            password = new ConsolePasswordCallback();
            if (!tok.passwordIsInitialized()) {
                tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
            }
        } else {
            tok = this.cntx.getCryptoManager().getInternalKeyStorageToken();
            password = new CertAdminPasswordCallback(passphrase);
            if (!tok.passwordIsInitialized()) {
                tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
            }
        }
        tok.login((PasswordCallback)password);
        CryptoStore store = tok.getCryptoStore();
        store.deleteCert(cert);
    }
}

