/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminFactory;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.CertContext;
import com.sun.portal.cli.cert.CreateSelfSignedCertificate;
import com.sun.portal.cli.cert.InstallPasswordContextImpl;
import com.sun.portal.cli.cert.JSSContextImpl;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.cli.cert.VerifyCertificate;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CertUtil {
    public static final String DEFAULT = "default";
    public static final String CREATE_SELF_SIGN = "createselfsigncert";
    public static final String VERIFY_CERT = "verifycert";
    public static final String CREATE_LOG_USER_PASSWORD = "createloguserpassword";

    public static void main(String[] args) {
        String option = DEFAULT;
        int i = 0;
        if (args[0].toLowerCase().startsWith("-option=")) {
            option = args[0].substring(8, args[0].length());
            ++i;
        }
        if (option.equalsIgnoreCase(DEFAULT) || option.equalsIgnoreCase(CREATE_SELF_SIGN)) {
            String dir = args[i++];
            String password = args[i++];
            String locale = args[i++];
            String other_info = args[i++];
            String token = args[i++];
            String nickname = args[i++];
            int validity = 6;
            try {
                validity = Integer.parseInt(args[i++]);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String cn = "";
            String l = "";
            String st = "";
            String c = "";
            String o = "";
            String ou = "";
            cn = CertUtil.getDistinguishedNameComponent(other_info, "CN");
            l = CertUtil.getDistinguishedNameComponent(other_info, "L");
            st = CertUtil.getDistinguishedNameComponent(other_info, "ST");
            c = CertUtil.getDistinguishedNameComponent(other_info, "C");
            o = CertUtil.getDistinguishedNameComponent(other_info, "O");
            ou = CertUtil.getDistinguishedNameComponent(other_info, "OU");
            CertUtil.CreateSelfSignedCertificate(dir, password, locale, cn, o, ou, l, st, c, token, nickname, validity);
        } else if (option.equalsIgnoreCase(VERIFY_CERT)) {
            String dir = args[i++];
            String locale = args[i++];
            String nickname = args[i++];
            CertAdminUtil.println(CertUtil.VerifyCertificate(dir, locale, nickname));
        } else if (option.equalsIgnoreCase(CREATE_LOG_USER_PASSWORD)) {
            CertUtil.createLogUserPassword(args[i++], args[i++], args[i++]);
        }
    }

    public static String getDistinguishedNameComponent(String searchString, String toFind) {
        String match = "";
        Pattern p_quotes = Pattern.compile(toFind + "=\"", 2);
        Pattern p_noquotes = Pattern.compile(toFind + "=([^,]+),?", 2);
        Matcher m = p_quotes.matcher(searchString);
        if (m.find()) {
            Pattern p_find = Pattern.compile(toFind + "=\"([^\"]+)\"", 2);
            m = p_find.matcher(searchString);
            if (m.find() && m.groupCount() > 0) {
                match = m.group(1);
            }
        } else {
            m = p_noquotes.matcher(searchString);
            if (m.find() && m.groupCount() > 0) {
                match = m.group(1);
            }
        }
        return match;
    }

    public static void createLogUserPassword(String confFile, String certDir, String plainPassword) {
        try {
            JSSUtil.setDefaultDecoder(certDir);
            String password = JSSUtil.encryptPassword(plainPassword);
            Properties prop = new Properties();
            FileInputStream inpstrm = new FileInputStream(confFile);
            prop.load(inpstrm);
            ((InputStream)inpstrm).close();
            prop.put("gateway.logging.password", password);
            FileOutputStream outstrm = new FileOutputStream(confFile);
            prop.store(outstrm, null);
            ((OutputStream)outstrm).close();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        catch (SRADecoderException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean CreateSelfSignedCertificate(String certdir, String jsspass, String locale, String fqdn, String o, String ou, String l, String s, String c, String token, String nick, int val) {
        JSSContextImpl jsscntx = new JSSContextImpl(certdir, fqdn, locale);
        InstallPasswordContextImpl passwdcntx = new InstallPasswordContextImpl(jsspass);
        jsscntx.setPasswordContext(passwdcntx);
        if (!jsscntx.init()) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m1", "Error!, Initialization failed"));
            return false;
        }
        CertContext certcntx = CertAdminFactory.CreateCertificateContext(fqdn, o, ou, l, s, c, token, nick, val);
        CreateSelfSignedCertificate cmd = new CreateSelfSignedCertificate();
        return cmd.execute(jsscntx, certcntx);
    }

    public static String VerifyCertificate(String certdir, String locale, String nick) {
        JSSContextImpl jsscntx = new JSSContextImpl(certdir, locale);
        jsscntx.setPasswordContext(CertAdminFactory.CreatePasswordContext());
        if (!jsscntx.init()) {
            return CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + nick + " " + CertAdminLocale.getPFString("m1", "Error!, Initialization failed");
        }
        VerifyCertificate cmd = new VerifyCertificate();
        cmd.execute(jsscntx, nick);
        return cmd.getMessage();
    }
}

