/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriterproxy;

import com.sun.portal.netlet.eproxy.RProxyConnection;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.rproxy.server.GatewayContext;
import com.sun.portal.rproxy.server.GatewayContextFactory;
import com.sun.portal.util.GCThread;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWNSSInit;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;

public class HTTPProxy {
    public static ResourceBundle _resources;
    public static final String DEFAULT_PORT = "10443";
    static final String watchdogInfoFileBase = "/var/opt/SUNWps/.rp.";

    public static void main(String[] argv) {
        block4: {
            GCThread gc = new GCThread();
            gc.start();
            GatewayContext gatewayContext = GatewayContextFactory.getGatewayContext();
            int httpProxyPort = Integer.valueOf(SystemProperties.get((String)"rewriterproxy.port", (String)DEFAULT_PORT));
            HTTPProxy.writePortInfoForWatchdog(httpProxyPort);
            try {
                RProxyConnection.startHttps((int)httpProxyPort);
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("RewriterProxy: exception " + ex);
                }
            }
            catch (Error er) {
                if (!GWDebug.debug.errorEnabled()) break block4;
                GWDebug.debug.message("RewriterProxy: error " + er);
            }
        }
    }

    public static void exit(int status) {
        System.exit(status);
    }

    private static void writePortInfoForWatchdog(int httpsPort) {
        block3: {
            File watchdogInfoFile = new File(watchdogInfoFileBase + System.getProperty("conf.suffix"));
            if (watchdogInfoFile.exists()) {
                watchdogInfoFile.delete();
            }
            try {
                FileWriter fw = new FileWriter(watchdogInfoFile);
                fw.write(httpsPort + "\n");
                fw.flush();
                fw.close();
            }
            catch (IOException ex) {
                if (!GWDebug.debug.errorEnabled()) break block3;
                GWDebug.debug.error("Unable to enter information for watchdog information");
            }
        }
    }

    static {
        GWDebug.createDefault((String)"srapRewriterProxy");
        if (!GWNSSInit.initialize()) {
            System.exit(1);
        }
        try {
            String profileName = System.getProperty("gateway.profilename", "default");
            GatewayProfile.init((String)"this-should-be-sid", (String)profileName);
            PlatformProfile.init((String)"this-should-be-sid");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to initialize GatewayProfile/PlatformProfile");
            System.exit(1);
        }
        ServiceIdentifier.createDefault((String)"srapRewriterProxy");
        GWLocale.createDefault();
        GWThreadPool.init();
        GatewayContextFactory.init((int)1);
    }
}

