package TO::HOST;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::Server';
use strict;

sub leaf { 1 }

sub type { "host"}

sub new {
  my($class, $Topo, $hostname, $info) = @_;
  my($size);
  my($name)  = "host:$hostname";
  my($hosts) = $Topo->[0];
  my $syns   = $Topo->[4];
  my $renv = System->get_renv();
  my $mgmtLevel = "D";

  if (!defined($hosts->{$name}) ) {
     my($obj) = {};
     $obj->{info}       = $info;
     $obj->{info}{type} = "Sun";
     $obj->{info}{class} = "host";
     $obj->{info}{hostid}= System->hostid();
     $obj->{info}{ipno}  = Util->name2ip($hostname);
     $obj->{info}{bitMode} = System->bitMode();
     $obj->{info}{model}   = $info->{model} || System->model();
     $obj->{info}{release} = System->os_release();
     $obj->{info}{mgmtLevel} = $mgmtLevel;
     $obj->{info}{name} = $name;
     $obj->{portInfo}   = [];
     $obj->{port}       = [];
     bless($obj, 'TO::HOST');
     $hosts->{$name} = $obj;
     $syns->{$hostname} = $name;
  }
  return $hosts->{$name};
}

sub statusFunc {
  my($class, $name, $State) = @_;

  my $Comp = $State->components($name);
  my $i   = $Comp->value("e");
  my ($enc, $encInfo);
  my ($other, $disk, $diskInfo, $otherInfo, $port, $portInfo);
  my ($lunS, $lunI, $otherS, $otherI);

  my (@P, $x);
  foreach my $c (keys %$Comp) {
     my $el = $Comp->value($c);
     next if ($el->[0] <= 0);
     if (substr($c,0,4) eq "hba.") {
        my $po = substr($c,4) + 0;
        $P[$po] = $Comp->value($c);

     } elsif (substr($c,0,5) eq "port.") {
        my $po = substr($c,5) + 0;
        $P[$po] = $Comp->value($c);
     }
     $Comp->summ($c, \$other, \$otherInfo);
  }

  for ($x=0; $x <= $#P; $x++) {
     if ($P[$x]) {
       $port .= $P[$x][0] . ",";
       my $pi = $P[$x][1];
       $pi =~ s/\/devices//;
       $portInfo .= "$pi,";
     } else {
       $port .= ",";
       $portInfo .= ",";
     }
  }
  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}

sub iconLayout {
  my($ho) = @_;
  my $gif = $ho->getGif();
  return "E0E0E0/$gif,_," ; 
}


sub getGif {
  my($h) = @_;
  my $info = $h->{info};
  my $model = $info->{model};
  if ($model =~ /Fire-280R/) {
    return "280r.gif";
  } elsif ($model =~ /UltraAX-i2/ || $model =~ /Netra/) {
    return "netraX1.gif";
  } elsif ($model =~ /Enterprise.*10000/) {
    return "e10k.gif";
  } elsif ($model =~ /Enterprise/) {
    return "e45.gif";
  } elsif ($model =~ /Ultra/) {
    return "ultra.gif";
  }
  return "host2.gif";
}


1;

