package Service::Util;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use Net::Telnet;
use Labels;
use Html::Screen;
use Logic::Ethers;
use strict;
use Html;
use PPRO;
use Inventory;
use Events;
use vars qw ($DETECT $DB  $FILE $PROXY_HOST $PROXY_PORT $CDTARGET $CACHETARGET $PATCH_SERVER
   $PATCH_PASSWORD );

$DETECT    = "patchpro.detectors.source.url";
$DB        = "patchpro.database.source.url";
$CDTARGET   = "/var/sadm/spool";
$CACHETARGET= "/var/opt/SUNWppro/lib/cache";

$FILE        = "/etc/opt/SUNWppro/etc/patchpro.conf";
$PROXY_HOST  = "patchpro.proxyserver.host";
$PROXY_PORT  = "patchpro.proxyserver.port";
$PATCH_SERVER= "patchpro.sun.com";
$PATCH_PASSWORD = "/opt/SUNWppro/lib/.proxypw";


use vars qw(%CONN);

#  $Id: Util.pm,v 1.34 2003/12/19 02:58:04 edunning Exp $

sub ether {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("Service::Util")->section("ether");

  print Html->body();
  $info = "";
  my($warn2, $warn3, $cat, $last_win);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  my $info;
  if ($q->{ACTION_submit} ) {
     my ($error, $new);
     my %E = &readEther();
     foreach my $el (sort %$q) {
        next if (substr($el,0,3) ne "et_");
	my $name = substr($el, 3);
        my $et = $q->{$el};
	$et = uc(Util->trim($et));
	if (!$et){
	   delete $E{$name};
	   next;
	}
	if (!Logic::Ethers->valid($et)) {
           $error .= $L->expand(invalid => $name, $et) . "<br>";
	} else {
           $new .= "$et\t$name\n";
           delete $E{$name};
	}
     }
     if (!$error) {
       foreach my $el (keys %E) {
         $new .= "$E{$el}\t$el\n";
       }
       open(O, ">/etc/ethers");
       print O $new;
       close(O);
       $info = Html->info($L->{update});
     } else {
       $info = Html->error($error);
     }
  }

  print Html->header2("service.service.ether_upd");

  my $o =<<EOF;
$info
<form method=post>
 <input type=hidden name=GO value=Service::Util::ether>
 <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=$Style::WIDTH>
  <tr><td colspan=3 bgcolor=$Style::DARK><font color=white><b>$L->{title}</td>
  <tr bgcolor=$Style::LIGHT>
      <th>$L->{name}</th>
      <th>$L->{ip}</th>
      <th>$L->{mac}</th>
EOF

  my ($l);
  my $H = Logic::Ethers->readHosts("192.168");
  
  my @L;
  open(O, "/etc/hosts");
  foreach my $ip (sort keys %$H) {
     my $el = $H->{$ip};

     my $val = "<input type=text size=20 name=et_$el->[0] value=\"$el->[1]\">";
     $o .= "<tr><td>&nbsp;$el->[0]&nbsp;</td>
                <td>&nbsp;$ip&nbsp;</td>
		<td>$val</td>
		";
  }
  close(O);
  $o .= "</table><b>".
        Html::Screen->submitButton("ACTION_submit", $L->{submit});

  print $o;
}

# 00:C0:DD:00:B2:01	sw1b

sub readEther {
  my (%E,$l);
  open(O, "/etc/ethers");
  while ($l = <O>) {
     my($et, $name) = split(/\s+/, $l);
     $E{$name} = $et;
  }
  close(O);
  return %E;
}


sub setup {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("Service::Util")->section("setup");
  my $PPROSETUP = "/opt/SUNWppro/bin/pprosetup";
  my $RUNNING;

  print Html->body();
  if ($q->{ACTION_update} || $q->{AGAIN} < 5) {
    my $ag = $q->{AGAIN} + 1;
    print "<meta http-equiv=Refresh content=\"60;URL=$Http::WEBPROC?GO=Service::Util::setup&AGAIN=$ag\">";
  }
  
  print Html->header2("service.service.rev_setup");
  my $setup = PPRO->setup_path();

  $info = "";
  my($warn2, $warn3, $cat, $last_win);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  if ($q->{ACTION_test}) {
    my $url = "https://" . $renv->{"ppro.patch_server"} ;
    my $args;
    if ($renv->{'ppro.proxy'}) {
      $ENV{http_proxy} = $renv->{'ppro.proxy'};
    } else {
      $args .= " --proxy=off";
    }
    $args .= " --proxy-user=$renv->{'ppro.proxy_user'}" if ($renv->{'ppro.proxy_user'});
    $args .= " --proxy-passwd=$renv->{'ppro.proxy_password'}" if ($renv->{'ppro.proxy_password'});
    my $com = System->get_home() . "/bin/wget -O /dev/null $args $url";
    open(O, "$com 2>&1|");
    my @result = <O>; close(O);
    if ("@result" =~ /200 OK/) {
      print Html->info("<b>$L->{test_ok}:</b><br>$com<br>@result");
    } else {
      print Html->error("<b>$L->{test_bad}:</b><br>$com<br>@result");
    }
  }

  if ($q->{ACTION_update} || $q->{ACTION_defaults} ) {
     if ($q->{source} eq "Server") { 
         $q->{patch_server} = "";
     }
     if ($q->{source} eq "Other" && $q->{patch_server}) {
         $q->{user} = $q->{password} = $q->{proxy_host}= "";
     }
     if ($q->{source} eq "CD") {
         $q->{patch_server} = $q->{user} = $q->{password} = $q->{proxy_host}= "";
     }
         
     if ($q->{ACTION_defaults}) {
         $q->{source}    = "Server";
         $q->{timeout}   = 60;
         $q->{patch_server} = "";
         $q->{source}    = "";
         $q->{user}      = "";
         $q->{password}  = "";
         $q->{proxy_host}= "";
         $q->{update_freq}= "";
         $q->{auto_update}= "";
     }
   while (1) {
     my $err;
     $renv->{'ppro.timeout'}       = $q->{timeout} + 0;
     if ($q->{source} eq "Server") {
       $renv->{'ppro.patch_server'}  = $PATCH_SERVER;
     } elsif ($q->{source} eq "Other") {
       $renv->{'ppro.patch_server'}  = $q->{patch_server};
     }
     $renv->{'ppro.source'}        = $q->{source};
     my $warn1;
     if ($q->{source} eq "Other" && $q->{patch_server} && $q->{patch_server} !~ /\:\d\d\d+/) {
        $warn1 .= $L->{err_local} ." ";
     }
     if ($q->{proxy_host} && $q->{proxy_host} !~ /\:\d\d\d+/) {
        $warn1 .= $L->{err_proxy};
     }
     if ($warn1) {
       print Html->error($warn1);
       last;
     }
     my $run;
     # Patchserver patchpro.sun.com
     if ( $q->{source} eq "Server" &&  $renv->{'ppro.patch_server'}) {
        $run .= "-P https://$renv->{'ppro.patch_server'}/servlet/com.sun.patchpro.server.PatchProServerServlet/";
     }
     # Local patch (Relay) Server
     if ( $q->{source} eq "Other" &&  $renv->{'ppro.patch_server'}) {
        $run .= "-P http://$renv->{'ppro.patch_server'}/psvr/servlet/PatchServer/";
     }
     $renv->{'ppro.auto_update'}   = $q->{auto_update} ? "Y" : "N";
     $renv->{'ppro.update_freq'}   = $q->{update_freq};
     my($proxyh, $proxyp) = split(/\:/, $q->{proxy_host});
     my($localh, $localp) = split(/\:/, $q->{patch_server});

     my $fw_config_port;
     if ($q->{source} eq "Other") {
       $fw_config_port = $localp || "443";
     } elsif ($q->{source} eq "Server") {
       $fw_config_port = $proxyp || "443";
     }
     if ($fw_config_port && $renv->{save_fw_config_port} ne $fw_config_port) {
       $renv->{save_fw_config_port} = $fw_config_port;
       &system2("/usr/local/bin/FW_config --set_port_val patchpro=$fw_config_port >/dev/null 2>&1&");
       $info .= $L->{update_firewall} . " ";
     }

     $renv->{'ppro.proxy'}  = $q->{proxy_host};

     $run .= " -x \"$renv->{'ppro.proxy'}\"";
     
     $renv->{'ppro.proxy_user'} = $q->{user};
     $run .= " -U \"$renv->{'ppro.proxy_user'}\"";

     if ($run) {
        &system2("$PPROSETUP $run> /dev/null");
     }
     $q->{password} = Util->trim($q->{password});
     if (open(O2, ">$PATCH_PASSWORD")) {
        $renv->{'ppro.proxy_password'} = $q->{password};
        print O2 $q->{password};
        close(O2);
     } else {
        print Html->error($PATCH_PASSWORD . " $!");
        last;
     }
     PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
     $info .= $L->{ppro_updated};
     print Html->info($info) ;
     last;
   }
  }
  if (Util->findProcessByName("FW_config") ) {
    print Html->warning($L->{fw_running});
    $RUNNING = 1;
  }

  my(%LAST, %CURR);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  my $proxy_host     = $renv->{'ppro.proxy'}; # include port
  my $patch_server   = $renv->{'ppro.patch_server'} || $PATCH_SERVER;
  my $user           = $renv->{'ppro.proxy_user'};
  my $ck_auto        = "checked" if ($renv->{"ppro.auto_update"} eq "Y");
  my $sel_updates = Html->makeSelect("update_freq", 
        "=$L->{never}|D=$L->{daily}", $renv->{"ppro.update_freq"});

  open(O, $PATCH_PASSWORD); my $pass = <O>; close(O);

  my $sel = Html->makeSelect("source", 
              "Server=PatchPro Server|Other=$L->{other}|CD=CD", $renv->{'ppro.source'});

  my $scr = Html::Screen->new();
  $scr->add(" <form method=post> <input type=hidden name=GO value=Service::Util::setup>");

  $scr->table( { title => $L->{options}, labelWidth => "40%" },
    [
    [ f => $L->{source},  $sel ],
    [ f => $L->{server}, "<input type=text size=40 name=patch_server value=\"$patch_server\">"],
    [ f => $L->{timeout},  
            "<input type=text size=4 name=timeout value=\"$renv->{'ppro.timeout'}\"> ($L->{mins})"],
    [ l => $L->{scheduler} ],
    [ f => $L->{updates}, $sel_updates ],
    [ f => $L->{auto_update}, "<input type=checkbox name=auto_update $ck_auto>"],

    [ l => $L->{proxy_info} ],
    [ f => $L->{proxy},"<input type=text size=30 name=proxy_host value=\"$proxy_host\">&nbsp;" 
          . $L->{info}],
    [ f => $L->{user}, "<input type=text size=20 name=user value=\"$user\">" ],
    [ f => $L->{pass}, "<input type=password size=20 name=password value=\"$pass\">" ],
    ]);

   if (!$RUNNING) {
    $scr->button2( [
    [ l => 'ACTION_update',   $L->{submit_upd} ],
    [ l => 'ACTION_defaults', $L->{submit_def} ],
    [ l => 'ACTION_test',     $L->{submit_test} ],
    ]);
   }
   $scr->add("</form>");
   print $scr->out();
}

sub system2 {
  my($com) = @_;
  print "<table border=0 width=100% cellspacing=0><tr><td>Command: $com</table>";
  system($com);
}


sub patchpro_read {
  my($LAST, $CURR) = @_;
  my($l, $content);

  open(O, $FILE);
  while ($l = <O>) {
     chop($l);
     my($name, $val) = split(/\=/, $l);
     if ($l =~ /^#LAST (.*)=(.*)/) {
        $LAST->{$1} = $2;

     } elsif ($name eq $DETECT || $name eq $DB ) {
        $CURR->{$name} = $val;
     } elsif ($name eq $PROXY_HOST || $name eq $PROXY_PORT) {
        $CURR->{$name} = $val;

     } else {
        $content .= "$l\n";
     }
  }
  close(O);
  return $content;
}

sub fix_patchpro_conf {
  my($source, $proxy_host, $proxy_port, $patch_value) = @_;

  my ($content, %LASTCD, %LASTServer, $l, %CURR, %LAST);

  #$proxy_port = "" if (!$proxy_port);

  $LASTCD{$DETECT} = "file:///var/opt/SUNWppro/lib/cache/ppromas3det.jar";
  $LASTCD{$DB}     = "file:///var/opt/SUNWppro/lib/cache/ppromas3db.zip";

  $LASTServer{$DETECT} = "https://patchpro.sun.com/database/ppromas3det.jar";
  $LASTServer{$DB}     = "https://patchpro.sun.com/database/ppromas3db.zip";

  $content = &patchpro_read( \%LAST, \%CURR);

  my ($err, $rc);
  if (!open(W, ">$FILE")) {
       return ("Cannot open $FILE: $!");
  }
  my $change;
  print W $content;
  if ($source eq "CD") {
     print W "$DETECT=$LASTCD{$DETECT}\n";
     print W "$DB=$LASTCD{$DB}\n";
     $change = 1 if ($LASTCD{$DETECT} ne $CURR{$DETECT});

  } else {
     print W "$DETECT=$LASTServer{$DETECT}\n";
     print W "$DB=$LASTServer{$DB}\n";
     $change = 1 if ($LASTServer{$DETECT} ne $CURR{$DETECT});
  }
  print W "$PROXY_HOST=$proxy_host\n";
  print W "$PROXY_PORT=$proxy_port\n";

  close(W);
  return (undef, "patchpro.conf updated");
}

sub cim_password {
  my($q) = @_;

  print Html->body();
  print Html->header2("manage.configure.se2_util");
  if ($q->{ACTION_save}) {
     if ($q->{password}) {
       System->setPassword("cim_guest", $q->{password});
       print Html->info("Password updated!");
     } else {
       print Html->error("Enter a password!");
     }
  }
  print "
   <form><input type=hidden name=GO value=Service::Util::cim_password>
   <table border=1 cellspacing=0 width=90% bgcolor=white>
   <tr bgcolor=$Style::DARK>
      <td colspan=2><font color=white>Enter New Password</td>
   <tr><td align=right bgcolor=$Style::LIGHT>Password:</td>
       <td><input type=password name=password size=20>
  </table>".
  Html::Screen->submitButton("ACTION_save", "Change Password");
}

sub configure {
  my($q, $post) = @_;
  my($c1, $c2);
  my($err1, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("Service::Util")->section("configure");

  print Html->body();
  my($warn2, $warn3, $cat, $last_win);
  my($renv, $devs, $host,$notifs, $Config) = PDM::ConfigFile->read();

  if ($q->{ACTION_conf_sel} || $q->{ACTION_unconf_sel}) {
     my $command = $q->{ACTION_conf_sel} ? "configure" : "unconfigure";
     foreach my $x (keys %$q) {
        if (substr($x,0,6) eq "array_") {
           my $ip = substr($x, 6);
           my $dev = $Config->deviceByIP($ip);
           Events->saveEvent("CFG", ucfirst($command), 
                             "$dev->{name}/$ip on Sun Solution $renv->{solution_name}");
           my ($err, $rc, $trace) = Inventory->run_vmcfg0($ip, $command);
           $trace =~ s/exit code/<br><b>exit code<\/b>/;
           if ($err) {
             print Html->error("'$command': $err");
           } elsif ("@$rc" =~ /usage:/) {
             print Html->warning("'$command': @$rc<br> Invalid argument(s), if the storage array password was not saved, use 'sysbin/saveArrayPassword' to save it.");
           } else {
             print Html->info("'$command' command executed on device $ip:@$rc");
           }
           if ($trace) {
            $trace =~ s/\n/<br>/g;
            print "<table border=1 width=$Style::WIDTH cellpadding=0>
              <tr><td>/var/adm/messages:<br>$trace
              </table>";
           }
        }
     }
  }

  if ( $q->{ACTION_conf} || $q->{ACTION_unconf} ) {
     my $command = $q->{ACTION_conf} ? "configure" : "unconfigure";
     my $info;
     foreach my $d (@$devs) {
        next if ($d->{type} !~ /6[01]20/);
        my ($err, $rc) = Inventory->run_vmcfg0($d->{ipno}, $command);
        if ($err) {
          print "Error on '$command': $err <br>";
        } else {
          $info .= "'$command' command executed on device $d->{ipno}:@$rc<br>";
        }
     }
     print Html->info($info) if ($info);
  }

  print Html->header2("service.service.conf");

  if ($q->{ACTION_update} ) {
       $renv->{'ppro.timeout'}       = $q->{timeout};
       $renv->{'ppro.proxy'}         = $q->{proxy};
       $renv->{'ppro.patch_server'}  = $q->{patch};
       $renv->{'ppro.source'}        = $q->{source};
         print Html->info(
           " -x $q->{proxy}, -P $q->{patch}, -m $q->{source} <br>done.\n");
       if (!PDM::ConfigFile->write( $renv, $devs, $host,$notifs)) {
          print "Cannot write ConfigFile <br>";
       }
  }
  my $sel = Html->makeSelect("source", "Server=PatchPro Server|CD=CD", $renv->{'ppro.source'});

  my $o =<<EOF;

<form method=post>
 <input type=hidden name=GO value=Service::Util::configure>
<center>
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td colspan=3 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{title}</td>
<tr bgcolor=$Style::LIGHT>
    <th>$L->{sel}
    <th>$L->{name}
    <th>$L->{ip}
EOF

    foreach my $d (@$devs) {
       next if ($d->{type} !~ /6[01]20/);
       $o .= "<tr><td><center><input type=checkbox name=array_$d->{ipno}></td>
                  <td>$d->{name}</td>
                  <td>$d->{ipno}</td>";
    }
    $o .=
"</table> 
  <table border=0 cellspacing=0 cellpadding=0 width=90%>
  <tr><td><b>".
          Html::Screen->submitButton("ACTION_conf", $L->{conf_sel})
  ."<br>".
          Html::Screen->submitButton("ACTION_unconf_sel", $L->{unc_sel})
      ."</td>

      <td align=right><b>".
          Html::Screen->submitButton("ACTION_conf", $L->{conf_all})
  ."<br>".
          Html::Screen->submitButton("ACTION_unconf", $L->{unc_all})
  ."</table>
  </form>";

  print $o;
}

sub ejectCD {
  my($q) = @_;
 
  my $LB = Labels->read("Service::Util")->section("ejectcd");

  print Html->body();
  print Html->header2("service.util.ejectcd");
  if ($q->{ACTION_eject}) {
     my $com = "/usr/bin/eject";
     my $rc = `$com 2>&1`;

     print Html->info("Command $com executed:<br> $rc");
  }


  print "<form><b>
         <input type=hidden name=GO value=Service::Util::ejectCD>".
         Html::Screen->submitButton("ACTION_eject", $LB->{eject})
         ."</form>";

}


sub changePasswords {
  my($q) = @_;

  print Html->body();
  print Html->header2("service.util.chpwd");
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
  my $LB = Labels->read("Service::Util")->section("password");

  if ($q->{ACTION_change}) {
     if ($q->{confirm} ne $q->{new}) {
       print Html->error($LB->{err1});
     } else {
       my($o1, $n1);
       if ($q->{s_old} eq "M") {
         $q->{old} = "BLANK" if (!$q->{old});
         $o1 = "-o $q->{old}" ;
       }
       if ($q->{s_new} eq "M") {
         $q->{new} = "BLANK" if (!$q->{new});
         $n1 = "-n $q->{new}" ;
       }
       my $com = System->get_home() . "/sysbin/changeArrayPasswords $o1 $n1";
       print "Command : sysbin/changeArrayPasswords <pre></center>";
       my($err, $o) = Util->run_command($com, "test", 120);
       print "$err" . join("\n",  @$o) . "<br>";
       print "</pre><center>";
       print Html->info($LB->{go_to_config});
     }
  }

  my $sel1 = Util->makeSelect("s_old", "S=$LB->{save}|M=$LB->{manual}");
  my $sel2 = Util->makeSelect("s_new", "M=$LB->{manual}|S=$LB->{save}");
  my $submit_change=Html::Screen->submitButton("ACTION_change", $LB->{submit});
  print <<EOF;
<form>
   <input type=hidden name=GO value=Service::Util::changePasswords>
   <table border=1 cellspacing=0 cellpadding=0 width=90% bgcolor=white>
   <tr><td colspan=3 bgcolor=$Style::DARK>
        <font color=white><b>$LB->{enter_password}</td>
   <tr><td align=right bgcolor=$Style::LIGHT>
         $LB->{old_password}:</td>
       <td width=10%>&nbsp;$sel1</td>
       <td>&nbsp;<input type=password name=old size=20>

   <tr><td align=right bgcolor=$Style::LIGHT>
         $LB->{new_password}:</td>
       <td width=10%>&nbsp;$sel2</td>
       <td>&nbsp;<input type=password name=new size=20>
   <tr><td align=right bgcolor=$Style::LIGHT>
         $LB->{confirm_new_password}:</td>
       <td width=10%>&nbsp;</td>
       <td>&nbsp;<input type=password name=confirm size=20>
   </table><b>
   $submit_change 
          onclick="return confirm('$LB->{sure}')" >
   </form>
EOF

}

sub toggle_ssh {
  my($q) = @_;

  print Html->body();
  system("/usr/local/bin/FW_config --toggle_port_state ssh >/dev/null 2>&1&");
  print "Toggle SSH<br>";
}


1;
