package Service::Array;

use Net::FTP;
use Net::Telnet;
use Net::Ping;
use System;
use strict;

use vars qw($host_file $syslog_conf $target_syslog $array_user $array_name  $array_prompt $array_password $SP_ADDRESS $log_file $tnet $log_path);


  $host_file      = "/etc/hosts";
  $syslog_conf    = "/opt/sp_conf/etc/syslog.conf";
  $target_syslog  = "/etc/syslog.conf";
  $log_path       = "/var/opt/SUNWstade/log/"; 

  $array_prompt   = '/\S*:\/:<\d+>/'; #[ARRAYNAME]:/:<command#>
  $array_user     = "root";

  $SP_ADDRESS = "192.168.0.2";  # may be good idea to get from /etc/hosts file


sub add {
  my($class, $ip) = @_;

  $array_name     = $ip;

  $array_password = System->getPassword("array");
  $array_name     = &getArrayName($ip);

  if (!&pingArray() ) {
     return "Error: ping $ip failed, Can not find the array";
  }

  if (!&tryPassword($array_password) ) { # bail on no-error assume everything is set properly
    return undef;
  }

  if(&openArrayConnetcion($array_name)){
    return "Error: Cannot Login to array. If this a new array, a blank password is needed";
  }

  if (&configureArray($array_name) ) {
    return "Error: Failed to modify the array configurations";
  }

  if (&changePassword() ) {
    return "Error: Cannot change password. If this a new array, a blank password is needed";
  }

  &closeArrayConnection;

  if (&syslogTransfer() ) {
    return "Error: Failed to open ftp connection with the array";
  }

  if (&updateArrayPatch) {
    return "Error: Failed to modify the array configurations";
  }

  return undef;
}

sub getArrayName {
  my($ip) = @_;
  my($l, $found);

  open(O, "/etc/hosts");
  while ($l = <O>) {
     my($ip0, $name, $rest) = split(/\s+/, $l);
     if ($ip0 eq $ip) {
       $found = $name; last;
     }
  }
  close(O);
  return $found;
}


#return 1 on success , 0 Fail
sub pingArray
{
  my $ping;
  my $status;
  
  $ping = Net::Ping->new("icmp");
  $status = $ping->ping($array_name);
  $ping->close;

  return($status);
}

# Open ftp section to transfer /opt/sp_conf/etc/syslog.conf
# Return 0 if OK and 1 Fail

sub syslogTransfer
{
  my $ftp;

  if(-e "$syslog_conf")  {
  
      unless ($ftp = Net::FTP->new($array_name)) {
         return 1;
      }
  
      unless ($ftp->login($array_user, $array_password)) {
         return 1;
      }
  
      unless ($ftp->put($syslog_conf, $target_syslog)) {
         return 1;
      }
      $ftp->quit;
  } else {
    return 1;
  }

  return 0;
}


# return 0 on sucess , 1 on Fail
sub tryPassword {
  my($pass) = @_;

  $tnet = new Net::Telnet (
             errmode => "return",
             Timeout   => 10,
             Prompt    => $array_prompt,
             );

  $tnet->open(Host => $array_name);
  if ($tnet->errmsg()) {
     return 1;
  } 

  $tnet->login($array_user, $pass);
  if ($tnet->errmsg()) {
     return 1;
  } 
  $tnet->close; 
  return 0;
}


#
# Open telnet section to change password
# Return 1 if OK or 0 is not
#

sub changePassword
{

  my @l  = $tnet->cmd(String => "passwd", Prompt => '/\:/');
  my @l2 = $tnet->cmd(String => "",     Prompt => '/\:/');
  my @l3 = $tnet->cmd(String => $array_password,     Prompt => '/\:/');
  my @l4 = $tnet->cmd(String => $array_password,     Prompt => $array_prompt);

  return 1 if ("@l4" =~ /sorry/);
  return 0;

}
  
#
# Configure the array
# Return 0 if OK and 1 if not
#
sub configureArray {
  my($array_name) = @_;

  my @l = $tnet->cmd(String => "ntp server $SP_ADDRESS", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "ntp poll unicast", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "ntp interval 60", Prompt => $array_prompt);

#######   setting setup parameters
 
  my @l = $tnet->cmd(String => "set bootmode auto", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "set netmask 255.255.255.0", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "set gateway $SP_ADDRESS", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "set tftphost $SP_ADDRESS", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "set tftpfile  /var/crash/$array_name", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "set hostname $array_name", Prompt => $array_prompt);

###### setting system parametsers

  my @l = $tnet->cmd(String => "sys mp_support mpxio", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "sys disk_scrubber on", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "sys ondg befit", Prompt => $array_prompt);
  my @l = $tnet->cmd(String => "sys fc_topology auto", Prompt => $array_prompt);

  return 1 if (&cleanFileSystem);
  return 0;
}


# return 0 if successfull 
sub cleanFileSystem {

  my @l = $tnet->cmd(String => "ls -1", Prompt => $array_prompt);

  foreach my $file (@l) {
       if ($file =~ /[t4|lpc]\S+.bin/i) {
           my @l = $tnet->cmd(String => "rm $file", Prompt => $array_prompt);
       }
  } 
  return 0;
}

# return 0 if successful 
sub updateArrayPatch {

my $patchlocation = "/var/sadm/swimages";
my $result;
my $T4_patch = `ls $patchlocation|grep 115179`; 

if($T4_patch =~/115179-\d+/) {
    $patchlocation = "$patchlocation/$T4_patch";
    chomp($patchlocation);

#### here document for adding path to T4

$result = `$patchlocation/6120.sh <<EOF
$array_name
$patchlocation

root
$array_password
`;
} else {
       return 1;
}
return 0;
}

#Returns 0 if successful 
sub openArrayConnetcion {
  my($array_name) = @_;

  $tnet = new Net::Telnet (
             errmode   => "return",
             Timeout   => 20,
             Prompt    => $array_prompt,
             );

  $tnet->open(Host => $array_name);
  if ($tnet->errmsg()) {
     return 1;
  }

  $tnet->login($array_user, "");
  if ($tnet->errmsg()) {
     return 1;
  }

  return 0; 
}

sub closeArrayConnection {

  $tnet->close;

}

sub openLogFile {

my $LOGFILE = "$log_path/add_array.$array_name";

my $result = open(LOG,">>$LOGFILE");
        if(!(defined($result))) {
           return 1;
        }

return 0;
}

sub printLog {

my ($msg) = @_;

   print LOG "$msg \n";

}

1;
