package Revision::A5K;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"Sun StorEdge A5000 array Patches and Disk Firmware"}
sub class {"host.driver"}
sub type {"a5k"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;

  my @a5k_box_list;
  my @rec_list;
  my $box_wwn;
  my @re;
  my $timeout_info = "Please increase the system timeout for luxadm command (click Admin->System Utilities->System TimeOuts), then re-run the revision check. If you still run into problem, please contact your SUN representative";
 
  my $cmd = "/usr/sbin/luxadm";

  # get the default timeout for luxadm
  my($renv) = System->get_renv(); 
  my $temp = $renv->{'timeout.luxadm'};
#  print "info:".$temp."\n";
  my($TO) = $renv->{'timeout.luxadm'} || 600;


  # first create a a5k box list
  my ($error, $di) = Util->run_command("$cmd probe","a5k_report1.txt",$TO); 
  if ($error) {
      push(@re, ["A5K", undef,'ERR',undef, undef, undef,undef,$timeout_info]); 
      return [@re];
  }

  foreach my $line (@$di) {
     next if ($line !~ /SENA\s+Name/);
#     print $line;
     my $l = Util->ltrim($line);
     if ($l =~ / Name:(.+)\s+Node WWN:([^\s]+)\s+Log(.+)/) {
         $box_wwn  = Util->trim($2);
     } elsif ($l =~ / Name:(.+)\s+Node WWN:([^\s]+)/) {
         $box_wwn  = Util->trim($2);
     }
     push(@a5k_box_list, $box_wwn);
  }  
  my ($l, @Li);
  my %box_ib =();

  foreach my $box (@a5k_box_list){
       my $done = 0;
       my $line_num =0;
       my ($err, $info);
       ($err, $info) = Util->run_command("$cmd display $box","a5k_report.txt",$TO);
       # $err = "This is test info";
       if (!$err) {
           foreach my $l (@$info) {  
              if (!$done) {
                  $line_num++;
                  next if  (($line_num<=4)|| ($line_num >20) || ($l =~ /Not/) || ($l =~ /Login failed/) );
                  chop($l);
                  my ($first,$rest)= split(/\s+/,$l);
                  if ($first =~ /\d/){
                       my ($index,$status,$front_wwn,$status_2,$rear_wwn) = split(/\s{3,}/,$l);
                       my $outline;
		       
                       my ($err1, $info1) = Util->run_command("$cmd display $front_wwn","a5k_report1.txt",$TO);
                       if (!$err1) { 
                           foreach $outline (@$info1){ 
                               next if ($outline !~  /\/dev\/rdsk/);
                               my $where1 = index($outline,"c");
                               my $where2 = index($outline,"t");
                               my $num= substr($outline,$where1, $where2-$where1);
                               push (@Li, $num);
                               # print $num;
                           }    
                           $done =1;
                       } else {
                           my @L;
                           push(@L, ["A5K", $box,'ERR',undef, undef, undef,undef,$timeout_info]);
                           return[@L];
                       }
                 } 
            }
          }
       } else{
         my @L;
         push(@L, ["A5K", $box,'ERR',undef, undef, undef,undef,$timeout_info]);
         return[@L];
       } 
   }

   my $Liptr = \@Li;
   my $box_ptr = \@a5k_box_list;
   my $rc1 = $class->checkA5kIB($Matrix, $InstalledPatches, $box_ptr, $TO);
   my $rc2 = $class->checkDiskFirmware($Matrix,   $InstalledPatches,$Liptr );
   
   return [@$rc1, @$rc2];
}

sub checkA5kIB {
   my($class, $Matrix, $InstalledP, $yu_box_list, $time_out) = @_;
   my @L;
   my $category="IB_FIRMWARE";
   my $key;
   my $timeout_info= "Please increase the system timeout for luxadm command (click Admin->System Utilities->System TimeOuts),then re-run the revision check. If you still run into problem, please contact your SUN representative";

   foreach my $box (@$yu_box_list){
       my $line_num =0;
       my $cmd = "/usr/sbin/luxadm display";
       my ($err, $info) = Util->run_command("$cmd $box","a5k_ib.txt",$time_out);
       if ($err) {
          push(@L, ["A5K", $box,'ERR',undef, undef, undef,undef,$timeout_info]);    
          return \@L;
       } else { 
           foreach my $l (@$info) {
              $line_num++;
              next if  (($line_num<=4)|| ($line_num >20) || ($l =~ /Not{2}/));
              chop($l);
              my ($first,$rest)= split(/\s+/,$l);
              if ($first =~ /FW/ ) {
                  my ($var1, $var2, $var3, $var4, $var5) = split(/\s+/, $l);
                  #  var2 has contents like:  Revision:1.09
                  my ($rn, $curr_fw) = split(/:/,$var2);

                  if ( $curr_fw =~ /\d/){
                       if ($line_num > 16) {
                         $key = 5200;
                       }
                       if ($line_num < 16) {
                         $key = 5000;
                       }
                       my $ib_fw = $Matrix->{IB_FIRMWARE};
                       if ($ib_fw->{$key}){
                             my $d =$ib_fw->{$key};
                             my $req_fw = $d->[0];
                             my $comp = $class->compareFwLevels($curr_fw, $req_fw);
                             if ( $comp==0) {
                              push(@L, [$category, $box,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
                             }
                             elsif ($comp>0) {
                               push(@L, [$category, $box,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
                             }
                             elsif ($comp<0){
                               push(@L, [$category, $box,'DOWNREV',$curr_fw, $req_fw, undef,undef,undef]);
                             }
                      }else{
                            push(@L, [$category, $box, 'ERR', undef, undef,undef,undef, "No Key in Matrix/A5K"]);
                      }

                 }
           }
        }
     }
   }
   return \@L;
}

1;


