package RasScheduler;
use Html::Screen;
use System;
use strict 'vars';
use Style;
use Util;
use vars qw ($DB);
use Mail;

$DB = "RasScheduler";


sub read {
  my($class) = @_;

  my $db = Util->deserialize($DB) || {};

  bless($db, "RasScheduler");
  return $db;
}

sub clear {
  my($class) = @_;
  unlink System->get_home() . "/DATA/$DB";
}

sub delete {
  my($db, $key) = @_;
  delete $db->{$key};
}


sub add {
  my($db, $command, $args, $freq, $time, $dow, $email, $desc) = @_;

  my $em = $email;
  $em =~ s/\W//g;
  $args .= Util->encode("&EM=$em");
  $db->{$args} = { command => $command,
                      desc => $desc, 
                       dow => $dow, 
                      freq => $freq,   # not used
                      email=> $email, 
                      time => $time, 
                  last_run => 0
                 };
}

sub write {
  my($db) = @_;

  Util->serialize($DB, $db);
}

use Http;
# run from rasagent
#
sub run {
 my($class) = @_;
 my $renv = System->get_renv();
 Style->init($renv);
 my $db = $class->read();

 my $start = Util->get_today();
 my $hour  = substr($start, 11,2) + 0;
  my ($today, $year, $month, $day) = Util->get_today_array();
 my ($jd, $dow, $wk) = Util->julian($year, $month, $day);

 foreach my $e (keys %$db) {
    my $el = $db->{$e};
    if ($hour < $el->{time}){
       if (!$el->{last_run}){
         # Set last run time to zero so report will be sent today
         $el->{last_run} = 0;
       }
       next;
    }

    next if ($el->{dow} ne "99" && ($el->{dow} ne $dow) );

    if (!$el->{last_run}){
      my($sec, $min, $hour, $monthday, $month, $year, $weekday, 
        $yearday, $isdaylight) = gmtime;
      # Find number of seconds up to this day from 1970 since this is what the
      #   time function returns. The gmtime returns years since 1900.
      #
      #           #Years * #secs/year   +  #days * #seconds/day
      my $tsec = ($year - 70) * 31536000 + $yearday * 86400;

      # Now add in the number seconds for when report is suppose to run
      $tsec += ($el->{time}*3600);

      $el->{last_run} = $tsec;
    }
    
    next if ((time - $el->{last_run}) /60/60 < 23);

    Debug->print2("RasScheduler: running $el->{command} / $el->{desc}");
    my $comm = $el->{command};  
    my $email = $el->{email};
    my $args = Util->decode($e);
    my $q = {};
    Http::parse($args, $q, 1);
    $q->{email} = 1;
    Http::loadPackage("", $comm);
    my $ix = rindex($comm, "::");
    my $run = substr($comm,0,$ix) . "::RUN";

    open(OLDOUT, ">&STDOUT");   open(OLDERR, ">&STDERR");
    open(STDOUT, '>/dev/null'); open(STDERR, '>/dev/null');
    select(STDOUT);
    &$run($q);
    my $report = &$comm($q);
    $report =~ s/<img /<ximg /g;
    close(STDOUT);              close(STDERR);
    open(STDOUT, ">&OLDOUT");   open(STDERR, ">&OLDERR");

    my $data = Util->email_html("Storage_ADE", "Scheduled Report $el->{desc}", $email, 
                                "Scheduled report from Storage_ADE\n\n Description: $el->{desc}\n    Command : $el->{command}\n      Date : $start \n", 
                                "scheduler.html", $report, "html"
                               );
    Mail->mailData($email, $data);
    Debug->info(TEXT => "ran scheduled report $comm $el->{desc}");
    $el->{last_run} = time;
 }
 $db->write();
}

1;
