package RasDB;
use System;

use GDBM_File;
use MLDBM::Sync;
use Storable qw(retrieve dclone store);
use MLDBM qw(GDBM_File Storable);
use strict;
use vars qw(%DBS $DBC);

sub close {
  my($class) = @_;
}

sub cache {
  my($class) = @_;
  my $DBC = $class->new("CACHE") if (!$DBC);
  return $DBC->{hash};
}


sub reset {
  my($class, $file) = @_;
  delete $DBS{$file};
}

#  $db = RasDB->new("state/state");

sub new {
  my($class, $file, $no_cache) = @_;

  if (!$no_cache) {
    return $DBS{$file} if (exists $DBS{$file});
  }

  my(%ST2);
  my $NEW = System->get_home() . "/DATA/$file.db";

  my $ST2_db =  tie %ST2,  'MLDBM::Sync', $NEW , GDBM_WRCREAT,GDBM_READER, 0666;

  my $obj = {handle => $ST2_db, hash => \%ST2};
  bless($obj, $class);

  if (!-f $NEW) {
    delete $ST2{""};
    chmod 0666, $NEW;
    chmod 0666, "$NEW.lock";
    chown 0,1, $NEW, "$NEW.lock";
  }
  $DBS{$file} = $obj;

  return $obj;
}

# REORGANIZE THE DATABASE, 
# $obj->Lock();
# $obj->reorganize();
#
sub reorganize {
  my($obj) = @_;
  if (exists $obj->{handle}{dbm}{DB}) {
      my $gdbm = $obj->{handle}{dbm}{DB};
      $gdbm->reorganize();
  }
}

#
# REORGANIZE THE USUAL SUSPECTS ABOVE 5 Meg
#
sub REORG {
  my($class) = @_;
  require EventDB;

  foreach my $f ('SEQUENCER','EDOCS') {
     my $name = System->get_home() . "/DATA/$f.db";
     my $size = Util->fileSize($name);
     if ($size > 5000 * 1000) {
        my $DB = $class->new($f);
        $DB->Lock();
        $DB->reorganize();
        $DB->UnLock();
     }
  }
  EventDB->clean(10); # keep 10 days;
}



sub clear {
  my($obj,  $file) = @_;

  my $handle = $obj->{handle};
  my $hash   = $obj->{hash};
  $handle->Lock();
  foreach my $k (keys %$hash) {
     delete $hash->{$k};
  }
  $handle->UnLock();
}


sub ReadLock {
  my($obj) = @_;
  my $handle = $obj->{handle};
  $handle->ReadLock();
}

sub Lock {
  my($obj) = @_;
  my $handle = $obj->{handle};
  $handle->Lock();
}

sub UnLock {
  my($obj) = @_;
  my $handle = $obj->{handle};
  $handle->UnLock();
}

sub dump {
  my($obj) = @_;
  require Data::Dumper;

  my $handle = $obj->{handle};
  my $hash   = $obj->{hash};
  $obj->ReadLock();
  foreach my $k (keys %$hash) {
     my $v = $hash->{$k};
     print "$k: " . Data::Dumper::Dumper($v) . "\n";
  }
  $obj->UnLock();
}

sub hash {
  my($class) = @_;
  return $class->{hash};
}

1;
