package Policies::ARRAY;
use DevDB;
use strict;

#
# pol : policy hash
# line: logline
# key : type:key:topic
# comp: part of topic
# sev : current sev
#
# return:
# ($new_sev, $extra txt)
#  new_sev = -1: no event at all
#

sub battery_not_ok_NU {
  my($class,  $pol, $line, $key, $comp, $sev ) = @_;

  my($type, $k, $topic) = split(/\:/, $key);

  my $el = DevDB->read($k);
  if (time - $el->{"$topic.refresh_time"} <= 6*60*60) {
     return (0,'(in refreshing cycle)');
  }
  return ($sev);
}

sub refreshing_battery {
  my($class, $pol, $line, $key, $sev ) = @_;

  my($type, $k, $topic) = split(/\:/, $key);
  DevDB->Lock();
  my $el = DevDB->read($k);
  $el->{"$topic.refresh_time"} = time;

  DevDB->write($k, $el);
  DevDB->UnLock();
  
  return ($sev);
}

#
#  'u1d1 Missing' found in logfile
#
sub disk_missing {
  my($class, $pol, $line, $key, $sev ) = @_;

  $DB::single = 1;
  my($type, $k, $topic) = split(/\:/, $key);
  DevDB->Lock();
  $topic =~ s/d0/d/;
  my $el = DevDB->read($k);
  $el->{"$topic.missing_time"} = time;
  DevDB->write($k, $el);
  DevDB->UnLock();
  
  return ($sev);
}


1;

