package Navigation;
use strict qw(vars);
use Style;

use vars qw (%NAV);

sub base { return 'Navigation'}

sub exclude {
   return ",url,role,skip,Xhelp,target,rack,";
}

# mark with stars when writing in lan-specific file
sub mark {
   return ",desc,name,title,";
}

sub read {
  my($class, $nocache, $filename) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $base = $class->base();

  my $lang = $ruser->{language} || $renv->{language};
  $lang = "$lang/" if ($lang);

  if (!$nocache) {
    return $NAV{$base}{$lang} if (exists $NAV{$base}{$lang});
  }
  my $menus = $filename || $renv->{navigation_menus} || "menus";
  my $lfile = "${lang}$menus";
  my $file  = $menus;

  my ($V1, $V2, $V3);
  if (-r System->get_home() . "/Lang/System/$base/$lfile") {
     $V1 = $class->read_($lfile);
  } else {
     $V1 = $class->read_($file);
  }
  $NAV{$base}{$lang} = $V1 if (!$nocache);
  return $V1;
}

sub node {
  my($class, $node) = @_;
  my($section, $n) = split(/\./, $node);
  if (exists  $class->{$section}{items}{$n}) {
    return $class->{$section}{items}{$n};
  } else {
    return undef;
  }
}


sub read_ {
  my($class, $file) = @_;
  my %V;
  my $LANG = "/Lang" if (index($file, "/") > 0);
  my $DIR =  System->get_home() . "$LANG/System/" . $class->base();

  if (!open(O, "$DIR/$file")) {
     print "Cannot read $DIR/$file!\n";
     return {};
  }
  my ($l);
  my ($section, $item, $last, $ix);
  my $section_no = -1;
  while ($l = <O>) {
     chop($l);
     next if (substr($l,0,1)  eq "#");
     if (substr($l,0,1) eq "'") {
        $V{$section}{items}{$item}{$last} .= " " . substr($l,1) if ($item);
     } elsif (substr($l,0,1) eq "[") {
        $l = Util->rtrim($l);
        $section = substr($l,1,-1);
        $section_no++;
        $V{$section}{info}{_order} = $section_no;
        $item = $last = "";
     } else {
        next if (index($l, "=") < 0);
        my($n, $v) = split(/\s*\=\s*/, $l, 2);
        if (substr($n,0,1) eq ".") {
          $V{$section}{info}{substr($n,1)} = $v;

        } else {
          my $ix = index($n,".");
          $item = substr($n,0,$ix);

          if (substr($n,-4) eq ".url") {
            $V{$section}{order} .= "$item,";
            $V{$section}{items}{$item}{url} = $v;
          } else {
            my $n0 = substr($n, $ix+1);
            $V{$section}{items}{$item}{$n0} = $v;
            $last = $n0;
          }
        }
     }
  }
  close(O);
  my $vv = \%V;
  bless($vv, "Navigation");
  return $vv;
}


sub write {
  my($class,  $v1, $file, $arg) = @_;
  my (@OR);
  my $langOnly = $arg->{langOnly}; # only write fields that should be translated
  my $base = $class->base();

  my $EXCL = $class->exclude();
  my $LANG = "/Lang" if (index($file, "/") > 0);

  open(O, ">" . System->get_home(). "$LANG/System/$base/" . $file);
  foreach  my $el (sort keys %$v1) {
      $OR[$v1->{$el}{info}{_order}] = $el;
  }
  foreach my $el (@OR) {
      print O "\n[$el]\n";
      my $info = $v1->{$el}{info};
      foreach my $k (sort keys %$info) {
         next if ($k eq "_order");
         next if ($langOnly && index($EXCL, ",$k,") >= 0);
         print O sprintf(".%-20s = %s\n", $k, $info->{$k});
      }
      my @L = split(/,/, $v1->{$el}{order});
      foreach my $el2 (@L) {
          print O "\n";
          my $item = $v1->{$el}{items}{$el2};
          print O sprintf("%-21s = %s\n", "$el2.url", $item->{url});
          foreach my $k (sort keys %$item) {
              next if ($k eq "url");
              next if ($langOnly && index($EXCL, ",$k,") >= 0);
              print O sprintf("%-21s = %s\n", "$el2.$k", $item->{$k});
          }
      }
  }
  close(O);
}

# v1 is local
# replace in v1 language-specific tags from v2, return v1
# mark the missing fields with '$mark'

sub sync {
   my($class, $v1, $v2, $mark) = @_;

  my $EXCL = $class->exclude();
  my $MARK = $class->mark();

   foreach  my $el (keys %$v1) {
      if (exists $v2->{$el}) {
         my $X =  $v1->{$el}{info};
         foreach my $e (keys %$X) {
           next if (index($EXCL, ",$e,") >= 0);
           if (exists $v1->{$el}{info}{$e}) {
             next if (substr( $v1->{$el}{info}{$e},0,5) eq "FILE ");
             if (exists $v2->{$el}{info}{$e}) {
                $v1->{$el}{info}{$e} = $v2->{$el}{info}{$e} ;
             } elsif (index($MARK, ",$e,") >= 0) {
                $v1->{$el}{info}{$e} .= $mark;
             }
           }
         }
         my $items = $v1->{$el}{items};
         foreach my $line (keys %$items) {
            my $X =  $v1->{$el}{items}{$line};
            foreach my $e (keys %$X) {
               next if (index($EXCL, ",$e,") >= 0);
               if (exists $v1->{$el}{items}{$line}{$e}) {
                  next if (substr( $v1->{$el}{items}{$line}{$e},0,5) eq "FILE ");
                  if (exists $v2->{$el}{items}{$line}{$e}) {
                    $v1->{$el}{items}{$line}{$e} = $v2->{$el}{items}{$line}{$e};

                  } elsif (index($MARK, ",$e,") >= 0) {
                    $v1->{$el}{items}{$line}{$e} .= $mark;
                  }
               }
            }
         }
      }
   }
   return $v1;
}

# create titles and save in htdocs/Help/titles.txt or Lang/..
# $v1 is the language specific menus

sub help_titles {
   my($class, $v1, $lang) = @_;
   my (%H, $x, $l);
   my $DIR = $lang ne "en" ? System->get_home() . "Lang/htdocs/Help/$lang" :
                             System->get_home() . "/htdocs/Help";
   foreach  my $el (keys %$v1) {
         my $items = $v1->{$el}{items};
         foreach my $line (keys %$items) {
            my $X =  $v1->{$el}{items}{$line};
            my @helps = split(/\s*,\s*/, $X->{help});
            if ($#helps >= 0) {
                $H{$helps[0]} = $X->{title};
            }
            for ($x=1; $x <= $#helps; $x++) {
               my $file0 = $helps[$x];         
               my $file = "$DIR/$file0.html";
               if (open(O, $file)) {
                  while ($l = <O>) {
                     if ($l =~ /<TITLE>(.*)<\/TITLE>/i) {
                        $H{$file0} = $1;
                        last;
                     }
                  }
               } else {
                  $H{$file0} = uc($file0);
               }
            }
         }
   }
   my $OF = "$DIR/titles.txt";
   open(W, ">$OF");
   foreach my $el (sort keys %H) {
      print W "$el\t$H{$el}\n";
   }
   close(W);
}


#  0 : invisible
#  1 : inactive
#  2 : active

sub active {
  my($item, $ruser, $renv, $q) = @_;
  my $window  = $ruser->{window} || $renv->{window};

  if (exists $item->{dir} && !-d System->get_home() . "/$item->{dir}") {
     return 0;
  }
  return 0 if ($item->{window} && $item->{window} ne $window);

  if (exists($item->{edition})) {
     my $ed = $renv->{edition} || "dev";
     return 0 if (index("|$item->{edition}|", "|$ed|") < 0);
  }

  if ($item->{solaris}) {
    my $v = System->os_version();
    return 1 if ($v && $v lt $item->{solaris});
  }
  #return 2;

  if (exists($item->{rack})) {
    my $R = lc($item->{rack});
    my $sol = lc($renv->{solution});    # can be n,se,se2 so far
    $sol = "se" if ($sol eq "n" && $renv->{se_slave}); 
    if ( index("|$R|", "|$sol|") < 0) {
      return $R eq $item->{rack}? 1: 0;
    }
  }
  if (exists($item->{model})) {
    my $model_list = lc($item->{model});
    my $sol = lc($renv->{solution_model});    # can be 6920 etc..
    if ( index("|$model_list|", "|$sol|") < 0) {
      return 0;
    }
  }

  return 2 if ($ruser->{userid} eq "ROOT");
  if ($item->{cookie} && $q) {
    my $ck = $item->{cookie};
    return 1 if (!$q->{"COOKIE_$ck"});
  }

  return 2 if ($ruser->{isCustomer} && index("|$item->{role}|", "|c|") >= 0);
  return 2 if (!$ruser->{isCustomer} && index("|$item->{role}|", "|s|") >= 0);

  my @s = split(/\|/, $item->{role});
  foreach my $el (@s) {
     return 2 if (index("|$ruser->{roles}|", "|$el|") >= 0) ;
  }
  return 1;
}


sub links {
    my($class, $nav1, $ruser, $renv, $css) = @_;
    my @O = split(/,/, $nav1->{order});
    my(@LNK, $html);

    foreach my $el (@O) {
        my $item = $nav1->{items}{$el};
        next if ($item->{skip} && index($item->{skip}, "w") >= 0);
        my $act = &active($item, $ruser, $renv);
        my($url, $out0, $targ) = $class->read_url($item);
        $html .= $out0;

        if ($act == 2) {
           $targ = "target=$item->{target}" if ($item->{target} && !$targ);
           push(@LNK, [2, $item, "<a href=\"$url\" $targ $css>$item->{title}</a>" ] );
        } elsif ($act == 1) {
           push(@LNK, [1, $item, $item->{title}]);
        }
    }
    return (\@LNK, $html);
}

sub read_url {
  my($class, $item) = @_;
  my ($url, $out);
  my $nav_url = $ENV{HTTPS} ? ($item->{secure_url} || $item->{url})  : $item->{url};
  my $target;
  if (substr($nav_url,0,7) eq "WINDOW ") {
     #$target = "target=newwin";
     if ($nav_url =~ / https*\:\//) {
       $url = $class->trans(substr($nav_url,7));
     } else {
       $url = $class->clean_url(substr($nav_url,7));
       $out .= "<script>\nfunction win2(a) {\n" .
           "  var b = '$url'; \n"   .
           "  var O = window.open(b,'procW','$item->{window_info}');\n" .
           "  O.focus(); \n}</script>\n";
       $url = "javascript:win2()";
     }
   } else {
     if ($nav_url =~ /^https*\:\//) {
       $url    = $class->trans($nav_url);
       $target = "target=_top";
     } else {
       $url = $class->clean_url($nav_url);
     }
   }
   return ($url, $out, $target);
}

sub trans {
  my($class, $url) = @_;
  my $h = $Http::httphost;
  if (index($url, '$host$') >= 0) {
    $url =~ s/\$host\$/$h/;
  }
  if (index($url, '$se2_port$') >= 0) {
    # 9080 | 9443
    my $port = $ENV{HTTPS} ? 9443 : 9080;
    $url =~ s/\$se2_port\$/$port/;
  }
  return $url;
}

sub clean_url {
  my($class, $url) = @_;
  my $new;
  if (substr($url,0,1) eq "/") {
     $new = $url;
  } elsif (substr($url,0,1) eq ">") {
     $new = "$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=" . substr($url,1);
  } else {
     $new = "$Http::WEBPROC?GO=$url";
  }
  return $new;
}




#   leftmargin=0 topmargin=0 marginwidth=0 marginheight=0>

use TopFrame;

sub get_vars {
  my($info, $window, $renv, $q) = @_;
  my ($url1, $url2);

  if ($window eq "N") {
      $url1 = "$Http::WEBPROC?GO=GUI::Navigation::index";
      $url2 = "$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=help_sys";
  } else {
      $url1 = "$Http::WEBPROC?GO=GUI::Welcome::welcome target=bottom";
      $url2 = "$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=help_sys target=bottom";
  }
  my ($model, $out);
  if ($renv->{solution} ne "N") {
      $model = "&nbsp;(StorEdge $renv->{solution_model})";
  }
  if ( Http->isNarrow()) {
    $out  = TopFrame::palm_hci2($info, $window, $q, $renv,$url1, $url2, $model);

  } elsif (substr($renv->{color_scheme},0,4) eq "hci2") {
    $out = TopFrame::hci2($info, $window, $q, $renv,$url1, $url2, $model);

  } else {
    $out = TopFrame::tabs($info, $window, $q,$renv,$url1, $url2, $model);
  }
  return $out;
   
}

sub default_page {
  my($window, $item, $renv) = @_;

  if ($window eq "N") {
     if ($item->{defaultPage} && $renv->{solution} ne "N") {
       return $item->{defaultPage};
     } elsif ($item->{defaultPageA}) {
       return $item->{defaultPageA};
     }
  } else {
     return  $item->{defaultPageA};
  }
  return undef;
}




# TOP OF PAGE, NO JS, uses $q->{TAB}

sub nf_top {
  my($q) = @_;
  # $q->{TAB} = 1,2
  my ($tab, $tab2);

  if (!defined $q->{TAB}) {
    $tab = -2 ;
  } else {
    ($tab, $tab2) = split(/,/, $q->{TAB});
  }
  my $high = $Style::TAB_BG;
  my $NARROW = Http->isNarrow();

  my $frame   = $q->{FRAME};
  my  $renv   = System->get_renv();

  my $version = $renv->{version};
  my $ruser   = System->get_ruser();
  my $nav     = Navigation->read();
  my $nav1    = $nav->{ROOT};
  my $window  = $ruser->{window} || $renv->{window};
  my $G       = Labels->read();
  my ($sep2, $cols, $lcorner, $rcorner, $active_tab);
  $active_tab = "&nbsp;";
  $sep2 = $NARROW ? "<img src=/gif/dot_clear.gif width=2 height=13>" :
                    "<img src=/gif/dot_clear.gif width=5 height=17>";

  if (substr($renv->{color_scheme},0,4) eq "hci2") {
    $cols = 8;
    $rcorner = $lcorner= "&nbsp;";
  } else {
    $cols = 3;
    $lcorner= "<img src=/gif/lcorner.gif border=0>";
    $rcorner= "<img src=/gif/rcorner.gif border=0>";
  }
  my $out = &get_vars($nav1->{info}, $window, $renv, $q) . "\n";

  my @O = split(/,/, $nav1->{order});
  my ($tab_list, $sub_tab);
  my $cnt = 0;
  my ($i, $sub);
  my @MENU2 = split(/\./, $q->{MENU});

  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];
    my $item = $nav1->{items}{$el};
    next if ($item->{skip} && index($item->{skip}, "t") >= 0);
    my $act = &active($item, $ruser, $renv, $q);
    $act = 1 if ($q->{OFF});
    $act = 1 if (index(",admin,monitor,", ",$el,") < 0 && $act == 2 && -f System->get_home() . "/DATA/ALTACTIVE");
    next if ($act == 0);
    $tab = $i if ($MENU2[0] eq $el);
    my $ll;
    my $fc = ($i == $tab) ? "<font color=$Style::TAB_FG>" : 
                         "<font color=$Style::TABOFF_FG>";
    if ($act == 2) {
#use Data::Dumper;
#print "<pre>" . Dumper($item) . "</pre>";
       my $dp = &default_page($window, $item, $renv);
       if ($dp) {
         if (substr($dp,0,1) eq ">") {
           $ll .= "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=" . 
                       substr($dp,1) . "\" class=t10>";
         } elsif ($window eq "N") {
           $ll .= "<a href=\"$Http::WEBPROC?GO=$dp\" class=t10>";
         } else {
           $ll .= "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::index&MENU=>$el\"
                      onclick=javascript:startDef('$dp') class=t10>";
         }
       } else {
         $ll .= "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::index&MENU=>$el\"
                      onclick=javascript:start1('$el') class=t10>";
       }

       #$ll .= "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$el&TOPDONE=1\" 
       #target=bottom onclick=javascript:start2('$el') class=t10>";

       $ll .= ($i == $tab)? "$fc<b>$item->{title}</b></font></a>" :
                            "$fc<xx>$item->{title}</b></font></a>" ;
       $cnt++;
    } else {
       $ll .= ($i == $tab)? "$fc<b>$item->{title}</b></font>" :
                            "<font color=#404040 class=l10>$item->{title}</font>" ;
    }
    $ll =  $NARROW ? "&nbsp;$ll&nbsp;" : "&nbsp;$ll&nbsp;&nbsp;";
    if ($i == $tab) {
       $sub = $el;
       $out .= "<td bgcolor=$high>$active_tab$ll</td>\n";
    } else {
       if ($Style::HIGH_TAB) {
         $out .= "<td bgcolor=$Style::TABOFF_BG>
                  <table border=0 cellspacing=0 cellpadding=0>
                  <tr><td bgcolor=$Style::TOPBGCOLOR><img src=/gif/dot_clear.gif height=2></td>
                  <tr><td>$sep2$ll</table></td>\n";
       } else {
         $out .= "<td bgcolor=$Style::TABOFF_BG valign=top>$sep2$ll</td>\n";
       }
    }
    $out .= "<td><img src=/gif/dot_clear.gif width=3></td>";
  }
  $out .= "</table></td>";


  if (substr($renv->{color_scheme},0,4) ne "hci2") {
     my $machine = System->get_machine_name();
     $machine = "$machine | " if ($machine);
     $out .= "<td align=right nowrap><ximg src=/gif/user_16.gif alt=\"User Name\" border=0>
              <font color=white>$machine $ruser->{userid} | v$version&nbsp;</td>";
  }
  my $gr = "silver";
  #
  # DISPLAY SECOND LEVEL OF MENU
  #
  my ($second, $second_menu);
  if ($tab >= 0) {
     my @order = split(/,/, $nav->{$sub}{order});
     my ($out2, $y);
     $out .= "<tr bgcolor=$high><td valign=top xbgcolor=$Style::TOPBGCOLOR>$lcorner</td><td colspan=$cols valign=top>";

     my ($OUT, $T1, $T2, $inarow);
   
     for ($y = 0; $y <= $#order; $y++) {
        my $e = $order[$y];
        my $el1 = $nav->{$sub}{items}{$e};
        next if ($el1->{skip} && index($el1->{skip}, "t") >= 0);
        my $act = &active($el1, $ruser, $renv);
        next if ($act == 0);

        if ( ">$MENU2[0].$MENU2[1]" eq $el1->{url} || "$MENU2[0].$MENU2[1]" eq "$sub.$e" ) {
            my $lnk = &set_link($act, $frame, $el1, $tab, $y, $window, 1, 2);
            $T1 .= "<td colspan=3 bgcolor=$gr ><img src=/gif/dot_clear.gif></td>";
            $OUT .= "<td bgcolor=$gr ><img src=/gif/dot_clear.gif></td><td><table border=0><tr><td nowrap><b>$lnk</b></table></td><td bgcolor=$gr><img src=/gif/dot_clear.gif></td>";
            $T2 .=  "<td colspan=3></td>";
            $inarow=0;
            if (substr($el1->{url},0,1) eq ">") {
              $second = substr($el1->{url},1);
              $second_menu = $e;
            }
        } else {
            my $lnk = &set_link($act, $frame, $el1, $tab, $y, $window, 0, 2);
            if ($inarow) {
              $T1 .=  "<td></td>";
              $OUT .= "<td><font color=$Style::DELIMITER>|&nbsp;</td>";
              $T2 .=  "<td bgcolor=$gr><img src=/gif/dot_clear.gif></td>";
            }
            $T1 .=  "<td></td>";
            $OUT .= "<td><table border=0><tr><td nowrap>$lnk</table></td>";
            $T2 .=  "<td bgcolor=$gr><img src=/gif/dot_clear.gif></td>";
            $inarow=1;
        }
     }
     $T1 .=  "<td width=100%></td>";
     $OUT .= "<td><table border=0 width=100%><tr><td>&nbsp;</table></td>";
     $T2 .=  "<td bgcolor=$gr width=100%><img src=/gif/dot_clear.gif></td>";

     if ($window eq "N") {
       $out .= "<table border=0><tr><td></table>
                <table border=0 cellspacing=0 width=100% cellpadding=0>
                    <tr>$T1<tr>$OUT<tr>$T2</table></td>";
     } else {
       #$out .= " <table border=0 cellspacing=0 cellpadding=0><tr>$T1<tr>$OUT<tr>$T2</table></td>";
       $out .= " <table border=0 cellspacing=0 cellpadding=0><tr>$T1<tr>$OUT</table></td>";
     }
      
  } else {
    my $i1 = $G->expand(select_function => $cnt) if (!$q->{OFF});
    #$out .= "<tr><td colspan=4 bgcolor=$Style::DARK>&nbsp;</td>\n";
    $out .= "<tr bgcolor=$high><td valign=top>$lcorner</td>";
    $out .= "<td colspan=$cols valign=top>" . 
     "<table border=0 cellspacing=2 cellpadding=0><tr><td><font color=$Style::DELIMITER>&nbsp;$i1" .
     "</table></td><td align=right valign=top>$rcorner</td>";
  }
  my $c1 = $cols + 2;
  $out .= "<tr bgcolor=$Style::TAB_BG><td colspan=$c1>&nbsp;</td>" if ($frame);
  #
  # DISPLAY THIRD LEVEL OF MENU
  #
  if ($window eq "N") {
     my @order = split(/,/, $nav->{$second}{order});
     my ($out2, $y, $cnt3);
     my ($OUT, $inarow);
   
     for ($y = 0; $y <= $#order; $y++) {
        my $e = $order[$y];
        my $el1 = $nav->{$second}{items}{$e};
        next if ($el1->{skip} && index($el1->{skip}, "t") >= 0);
        next if ($el1->{skip} && index($el1->{skip}, "w") >= 0);
        my $act = &active($el1, $ruser, $renv);
        next if ($act == 0);

	#$OUT .= "<tr><td nowrap>" if ($cnt3 % 7 == 0);
        if ( ">$MENU2[0].$MENU2[1].$MENU2[2]" eq $el1->{url} || "$MENU2[0].$MENU2[1].$MENU2[2]" eq "$sub.$second_menu.$e" ) {
            my $lnk = &set_link($act, $frame, $el1, $tab, $y, $window, 1, 3);
            $OUT .= "<b>$lnk</b> <font color=$Style::TAB2OFF_FG>|&nbsp";
        } else {
            my $lnk = &set_link($act, $frame, $el1, $tab, $y, $window, 0, 3);
            $OUT .= "$lnk<font color=$Style::TAB2OFF_FG> |&nbsp;";
        }
	$cnt3++;
     }

     if ($OUT) {
       my $cols2 = $cols; #-1;
       $out .= "<tr bgcolor=$high><td valign=top xbgcolor=$Style::TOPBGCOLOR>$lcorner</td><td colspan=$cols2 valign=top>";
       $out .= "<table border=0 cellspacing=0><tr><td></table>
              <table border=0 cellspacing=0 cellpadding=1>$OUT</table></td>";
     }
  }
  $out .= "</table>";
  return $out;

}

sub set_link {
  my($act, $frame, $el1, $tab, $y, $window, $sel, $level) = @_;
  my $lnk;
  my $renv = System->get_renv();
  if ($act == 2) {
     if ($frame) {
        if (substr($el1->{url},0,1) eq ">") {
          $lnk  = "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=" .  substr($el1->{url},1) . "\" target=bottom class=t10>";
        } elsif (substr($el1->{url},0,1) eq "/") {
          my $tt = $el1->{target} || "bottom";
          $lnk  = "<a href=\"$el1->{url}\" target=$tt class=t10>";
        } else {
          $lnk  = "<a href=\"$Http::WEBPROC?GO=$el1->{url}\" target=bottom class=t10>";
        }
     } else {
        my $dp = &default_page($window, $el1, $renv);
        if ($dp) {
          if (substr($dp,0,1) eq ">") {
            $lnk = "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=" . 
                       substr($dp,1) . "\" class=t10>";
          } else {
            $lnk = "<a href=\"$Http::WEBPROC?GO=$dp\" class=t10>";
          }
        } else {
           $lnk  = "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::index&TAB=$tab,$y&MENU=$el1->{url}\" class=t10>";
        }
     }
     my $c = $sel  ? "color=$Style::TAB2_FG>" : "color=$Style::TAB2OFF_FG>";
     my $t1 = $el1->{title}; $t1 =~ s/ /&nbsp;/g;
     $lnk .= "<font $c$t1</font></a>";
   } else {
     $lnk =  "<font color=gray xclass=t10>$el1->{title}</font>";
   }
   return $lnk;
}


# 'monitor.log' => {
#   'items' => {
#            'errors' => {
#                          'url' => 'GUI::Errlog::list',
#                          'title' => 'Agent Errors',
#                          'desc' => 'Agent Errors',
#                          'role' => 's|c'
#                        },
#            'events' => {
#                          'url' => 'GUI::EventLog::list ',
#                          'title' => 'Event Log',
#                          'desc' => 'Event Log',
#                          'role' => 's|c'
#                        },
#            'alerts' => {
#                          'url' => 'GUI::EventLog::alerts',
#                          'title' => 'Alert Log',
#                          'desc' => 'Alert Log',
#                          'role' => 's|c'
#                        },
#            'messages' => {
#                            'url' => 'GUI::MessageLog::list',
#                            'title' => 'Messages',
#                            'desc' => 'Messages',
#                            'role' => 's|c'
#                          }
#          },
#  order' => 'messages,events,alerts,errors,',
#  info' => {
#           'tab' => 'monitor',
#           'title' => 'Monitor Log',
#           'desc' => 'Monitor Log',
#           'name' => 'Monitor Log'
#         }
#}
#

1;
