package NWS::Switch2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Switch2.pm,v 1.6 2004/02/04 18:10:08 ccadieux Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.6 $'}
#
#  RUNS ON SWITCH2 and INRANGE SO FAR
#

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j, $k, $k1, $v);
  my($PORTS);
  my($wwn) = $rep->get('id.wwn');
  my $firm = $rep->get('info.version.Active_Firmware_image');
  my $type = $rep->get('id.device_type');
  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		=> $wwn               ],
                    [SystemName         => $rep->get('id.name')],
                    [OtherIdentifyingInfo  => "wwn=$wwn"      ],
                    [WWN                => $wwn      ],
                    [IP 		=> $rep->get('id.ip')],
                    [FruCount 		=> $rep->get('port.count')+1],
                    [SysRevision        => $firm ],
                    [BootInfo           => $rep->get('info.UpTime')] ,
                    [Caption            => ucfirst($type)],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 			=> $rep->get("id.wwn")],
                  [Name			=> $rep->get("id.wwn")],
                  [Manufacturer		=> "SUN" ],
                  [Model 		=> "Qlogic_". $rep->get('port.count')],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element		=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  $PORTS =  $rep->get('port.count');


  for ($i = 0; $i < $PORTS; $i++) {
    $dd = $class->newPort($rep,"port.$i" , $i);
    $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "port$i"],
                   ]);
    push (@pil, @$dd);
    push (@pil, $a);
  }
  
  return Ilist->new(\@pil);
}


sub newPort {
  my($class, $rep, $cd, $no) = @_;
  my(@il, $p1, $c1, $a1);
  
  my $type       = $rep->get('id.device_type');
  my $state_info = $rep->get("${cd}.state");
  my $status     = $rep->get("${cd}.status");

  my $serial_no = $rep->get("id.wwn") .  "." . $cd;

  my $map   = PDM->getDeviceStateMap("$type.availability");
  my $state = $map->get("state.$state_info");

  $p1 = CIM::Instance->new('NWS_SwitchPort',  [
             [Admin        => $rep->get("$cd.state")],
             [Mode         => $rep->get("$cd.status")],
             [SystemName   => ucfirst($type) . "-" . $rep->get("port.count") ],
             [DeviceID     => $serial_no ],
             [Name         => $serial_no ],
             [RemoteWWN    => $rep->get("$cd.link_wwn") ],
             [StatusInfo   => "$state_info, $status"    ],
             [Status       => $state     ],
             [Speed        => $rep->get("$cd.speed") ],
             [PortType     => $rep->get("$cd.type") ],
                    ]);

  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
                [Removable 	=> "No"],
                [Replaceable 	=> "No"],
                [Tag 		=> $serial_no],
                [Name  		=> $serial_no],
                [SerialNumber 	=> $serial_no],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent => $c1],
                [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}

1;
