package Logic::Subnet;

use strict;
use Logic;
use Agent::T3;
use Logic::SWITCH;
use Agent::MCDATA;
use Logic::SE;
use Agent::9900;

# host => 'hosttosearch',  SUB1..6 => 'subnet', prefixT => 'use hostname as prefix', 
# prefix => 'custom prefix', monitor_on => 'turn-on monitoring'
# timeout => 6

sub addToConfig {
  my($class, $q) = @_;
  my(@nodes,$err, $err_text, $x);
  my $host       = $q->{host};
  my $monitor_on = $q->{monitor_on};
  my $datahost   = $q->{datahost};
  $q->{prefix} =~ s/\./_/g;
   if ($q->{SUB1} =~ /\d+\.\d+\.\d+\D/) {
      $err= Error->error('subnet.101');
      return ($err, []);
   }
   if ($q->{SUB1} !~ /\d+\.\d+\.\d+/) {
       $err= Error->error('subnet.101');
       return ($err, []);
   } else {
       my($data, %F, $adding, $found, %C);
       my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
       my $new_dev = $#$devs ;

       my $cnt=1;
       foreach my $d (@$devs) {
          $F{$d->{key}} = $cnt;
	  $C{$d->{key}} = $d->{ip};
          $cnt++;
       }
       if (!$host) {
           $data = &get_snmpdata($q);

       } else {
          my $sub;
          for ($x=1; $x <= 6; $x++) {
             $sub .= "&SUB$x=" . $q->{"SUB$x"};
          }
	  print "Running on Host: $q->{host}. This could take up to 5 minutes. There will be no screen output during this time.<br>";
          my $rc = Util::Http->getCommand($host, "Logic::Subnet::snmpdata&REM=1$sub&timeout=$q->{timeout}", 500);
          if (substr($rc,0,2) ne "OK") {
	      if($rc) {
                 my $err = Error->error(2, $rc);
	      } else {
	         my $err = Error->error(3) ;
	      }
              return($err, []);
          } else {
              my @A = split(/\n/, substr($rc,2));
              $data = \@A;
          }
       }
       my $short = Util->shortHostname($host || $renv->{hostname});

       foreach my $line (@$data) {
          my($class, $type, $ip, $wwn, $key, $wwn2, $ctrl, $devname, $label) = split(/\|/, $line) ;
          my($ip0, $port) = split(/\:/, $ip);
          if ($class eq "ERR") {
             $err_text .= "ERR: $type, \n";
             next;
          }
          if (!$F{$key}) {
             $F{$key} = 1;
             $adding = 1;
             $found++;
             $new_dev++;
             my($ip1,$ip2,$ip3, $ip4) = split(/\./, $ip0);
             $devs->[$new_dev]{_name}    = "device" . $new_dev;
             $devs->[$new_dev]{type}     = $type;
             $devs->[$new_dev]{class}    = $class;
             my $n1 = $devname || "$ip3-$ip4";
             if ($q->{prefixT}) {
               $devs->[$new_dev]{name}     = $short ."-" . 
                    ($devname || sprintf("%3.3d", $ip4)) ;
             } elsif ($q->{prefix}) {
               $devs->[$new_dev]{name}     = $q->{prefix} . "-$n1";
	     } elsif ($devname){
	       $devs->[$new_dev]{name}     = $devname;
             } else {
               $devs->[$new_dev]{name} = "$type-$n1";
             }
             $devs->[$new_dev]{ctrl_model}= $ctrl if ($ctrl);
             $devs->[$new_dev]{userLabel} = $label if ($label);
             $devs->[$new_dev]{ip}       = $ip;
             $devs->[$new_dev]{ipno}     = $ip;
             $devs->[$new_dev]{wwn}      = $wwn;
             $devs->[$new_dev]{wwn2}     = $wwn2;
             $devs->[$new_dev]{key}      = $key;

             $devs->[$new_dev]{host}     = $q->{host};
             $devs->[$new_dev]{active}   = ($monitor_on ? "Y":"N");
             #$dev->[$new_dev]{datahost} = $datahost;

             $devs->[$new_dev]{mgmtLevel} = "D";
	     if($type =~ /^se\d*/){
	        # This is a solution rack
	        $devs->[$new_dev]{model} = $label;
	        $devs->[$new_dev]{ipName} = $ip;
	     }
             push(@nodes, $devs->[$new_dev]);
             print " $type:$ip added. \n";

         } else {
	    if($ip eq $C{$key}){
	       print " $ip already exists in configuration\n";
	    }else{
               print " The unique identifier ($key) for $type:$ip conflicts with device at $C{$key}\n";
	    }
         }
      }
      if ($adding) {
         foreach my $h (@$hosts) {
             $h->{last_push} = undef;
         }
         PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
      }
   }
   
   return ($err, \@nodes, $err_text);
}

sub get_snmpdata {
  my($q, $post, $util) = @_;
  my(%T, @a, $loc, $ip, $out);
  my(%F, $d, $adding, $found, $l );
  my(@NEW);
  my($xx, $sub, $remote, $x);

  $remote   = $q->{REM};

  my(@L);
  for ($x=1; $x <= 6; $x++) {
     $sub = $q->{"SUB$x"};
     next if ($sub !~ /^\d+\./);
     foreach my $x (0,20,40,60,80,100,120,140,160,180,200,220,240) {

        my $first = $x;
        my $last  = $x+19;
        $first = 1   if ($x == 0);
        $last  = 254 if ($x == 240);
        
        print "Probing ports $sub: $first..$last \n" if (!$remote);
        $out = Logic::Subnet->snmpget($sub, "public 1.1.0", $first, $last, $q->{timeout});

        foreach my $node (@$out) {
           push(@L, $node);
        }
     }
  }
  if ($remote) {
     print "OK" . join("\n", @L);
  } else {
     return \@L;
  }
}


sub snmpget {
  my($func , $ip, $f, $start, $end, $sleep_time) = @_;
  my($err, @out, $l, $x, $ipno, $comm, $cnt, $ret);
  if (!-d "/tmp") {
     mkdir "/tmp" , 0777;
  }

  $sleep_time = 5 if (!$sleep_time);
  $sleep_time = 2 if ($sleep_time == 1);

  my($prog) = System->get_home() . "/snmp/bin/snmpget";
  for ($x = $start; $x <= $end; $x++) {
     unlink("/tmp/snmp_$x");
  }
  for ($x = $start; $x <= $end; $x++) {
     last if ($x > 254);
     $ipno = "$ip." . $x;
     $comm = "$prog -t " . ($sleep_time-1) ." -r 0 $ipno $f > /tmp/snmp_$x 2>&1";
     system("$comm&");
  }
  sleep($sleep_time+1);
  $cnt= 0;
  for ($x = $start; $x <= $end; $x++) {
     last if ($x > 254);
     open(O, "/tmp/snmp_$x");
     $ret = <O>; close(O);
     unlink("/tmp/snmp_$x");

     chop($ret);
     $ipno = "$ip." . $x;
     Logic::Subnet->snmp_device($ipno, $ret, \@out);
  }
  return \@out;
}


sub snmpget1 {
  my($func , $ipno, $f, $sleep_time) = @_;

  $f = "public 1.1.0" if (!$f);
  $sleep_time= 5 if (!$sleep_time);

  my($prog) = System->get_home() . "/snmp/bin/snmpget";

  my $comm = "$prog -t $sleep_time -r 0 $ipno $f";
  my($err, $out) = Util->run_command($comm, "test", $sleep_time+2);
   
  my $out2 = join("", @$out);
  my @VAL;
  $func->snmp_device($ipno, $out2, \@VAL);
  return \@VAL;
}


sub snmp_device {
  my($class, $ipno, $ret, $out) = @_;
     if ($ret !~ /No Response/) {
        my(@b) = split(/\s*=\s*/, $ret);


        if (lc($b[1]) =~ /brocade/) {
           my $wwn = Util->snmpWWN($ipno);
	   my $mymodel = Agent::BROCADE->getModel($ipno); 

           push(@$out, "switch.brocade|brocade|$ipno|$wwn|$wwn|$wwn|||$mymodel");
	} elsif (lc($b[1]) =~ /pirus storage/) {
	  # For now do nothing
	} elsif (lc($b[1]) =~ /sun storedge solution/) {
	   my($solution, $wwn, $model, $hostname, $port) = Logic::SE->find_solution($ipno);
           $ipno .= ":$port" if ($port);
	   push(@$out, "storage.$solution|$solution|$ipno|$wwn|$wwn|$wwn|||$model");

	} elsif (lc($b[1]) =~ /mcdata/) {
	   if($ret =~ /Connectivity Manager/){
	      # This is the Management pc, skip it
	      next;
	   }
	   my $mymodel = Agent::MCDATA->getModel($ipno);
	   my $wwn = Util->snmpWWN($ipno);
           push(@$out, "switch.mcdata|mcdata|$ipno|$wwn|$wwn|$wwn|||$mymodel");

        } elsif (lc($b[1]) =~ /switch/ || lc($b[1]) =~ /sanbox/) {
           my($wwn, $type, $label) = Logic::SWITCH->find_wwn($ipno);
	   my($dname) = Logic::SWITCH->find_name($ipno);

           push(@$out, "switch.$type|$type|$ipno|$wwn|$wwn|$wwn||$dname|$label") if ($type);

	} elsif (lc($b[1]) =~ /inrange technologies/) {
	   my($wwn, $type, $label) = Logic::SWITCH->find_wwn($ipno);
           push(@$out, "switch.inrange|inrange|$ipno|$wwn|$wwn|$wwn|||$label");

	} elsif (lc($b[1]) =~ /sun t3/ || lc($b[1]) =~ /sun storedge 6[01]20/) {
           my $hh =  Agent::T3->getWWN($ipno);
	   my $class = "storage.$hh->{type}";
           my $model = "$hh->{ctrl_model}\t$hh->{units}";
           if (!$hh->{key}) {
              push(@$out, "ERR|Invalid Key for Array $ipno, cannot add, check for web directory on array and for a valid backplane WWN");
           } else {
              push(@$out, "$class|$hh->{type}|$ipno|$hh->{wwn}|$hh->{key}|$hh->{wwn2}|$model|$hh->{name}|$hh->{userLabel}");
           }

	} elsif ((lc($b[1]) =~ /raid400/)||
	         (lc($b[1]) =~ /raid401/)||
		 (lc($b[1]) =~ /raid450/)) {
	   # HDS 9900
	   my $rc = Agent::9900->getWWN($ipno);
           push(@$out, "storage.9900|9900|$ipno|$rc->{wwn}|$rc->{key}|$rc->{wwn}|||$rc->{userLabel}");


        }
     }
}


1;



