package Linktest::SE2;

use strict;
use Linktest::Node;
use base 'Linktest::Node';


sub portTest {0}

sub class {'storage.se2'}

sub type2 {"ST"}


sub add_port_info{
  my($node, $port) = @_;
  my $to_node = $node->topo();
  if ($to_node) {
     my $ports = $to_node->portInfo();
     if($ports){
        if($ports->[$port]){
	  my $tinfo = $ports->[$port];
	  if($tinfo->{"PortId"}){
	    if( $tinfo->{"PortId"} =~ /m(.+)p(.+)/) {
	      return " (Module $1 Port $2)";
	    }
	  }
      	}
     }
  }
  return undef;
}
sub prompt_info {
  my($node) = @_;
  return ($node->{logical}, $node->{port});
}

sub node_isolation {
  my ( $node_a, $node_b, $failed_node, $mode ) = @_;

  Linktest->debug_header( $node_a, $node_b, "SE2_node_isolation" );
  my $linkEnv = System->get_linkEnv();

  my $diagnostic_node;
  my $answer;
  my $status;
  my $out;

  $diagnostic_node = $node_b;
  # try the GBIC/SFP first

  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('replace_device_gbic' );
  $node_a->prompt('restore_device_cable' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    # utilize the port diagnostic
    $out = $node_b->start_diagnostic( "E");
  } else {
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_gbic' );
    $node_a->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new GBIC. The GBIC is the suspect.
    $node_a->prompt('suspect_device_gbic' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }
  # Check cable
  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('restore_device_gbic' );
  $node_a->prompt('replace_device_cable' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    # utilize the port diagnostic
    $out = $node_b->start_diagnostic( "E");
  } else {
    $node_b->prompt('remove_device_cable' );
    $node_b->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new cable. The cable is the suspect.
    $node_a->prompt('suspect_device_cable' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }
  # wasn't the cable
  $node_a->prompt('restore_device_cable' );

  # it wasn't the GBIC or the CABLE.
  #$node_a->prompt('multiple_suspects' );
  $node_a->prompt('suspect_SE2_device');
  $node_a->prompt('ra_run_SE2_diagnostics');

    
  if ($linkEnv->{option_pattern_type} ne "all") {
    $node_a->prompt('ra_all_patterns' );
  }

  return $Linktest::PROBLEM_UNDETECTED;

}

sub start_diagnostic {
  my($node, $mode) = @_;
  my($test, $options, $sparcv9, $estimated_time);

  my($verbose, $wb_patterns, $option_user_pattern, $option_pattern_type) = 
                 $node->diag_defaults();

  $test = "disktest";

  $options = "$verbose -q -i1 -f -o " . '"' . "dev=$node->{logical}|partition=2|selftest=Enable|wrdevbuf=Enable|selectpattern=$wb_patterns|rawsub=Enable|method=SyncIO+AsyncIO|rawcover=1|rawiosize=0x32768" . $option_user_pattern . '"';

  if ($option_pattern_type eq "user") {
    $estimated_time = 2;
  } elsif ($option_pattern_type eq "critical") {
    $estimated_time = 3;
  } else {
    $estimated_time = 4;
  }

  return $node->run_diagnostic($test, $sparcv9, $options, $estimated_time);
}



1;

