package Lease;

use System;
use strict;
use RasDB;

# Lease->get('name', $time, [wait_secs] );
# if ($lease = Lease->get("read_log_file")) {
#    do stuff
#    $lease->release();
#  lease_id :  type:
#              type:key
#              type:key:page


use vars qw ($LEASES $CURRENT_LEASE);

sub get {
  my($class, $lease_id, $time, $wait_time) = @_;

  $time = 60 if (!$time);
  $CURRENT_LEASE = undef;

  $LEASES = RasDB->new("LEASES");
  my $l;
  if (!$wait_time) {
     return &get0($LEASES, $lease_id, $time);

  } else {
     $l = &get0($LEASES, $lease_id, $time);
     while ($wait_time > 0 && !$l) {
       sleep(2);
       $l = &get0($LEASES, $lease_id, $time);
     }
  }
  return $l;
}


sub age {
  my($lease) = @_;
  return time - $lease->{start};
}

sub refresh {
  my($lease) = @_;
  $LEASES = RasDB->new("LEASES");
  my $hash = $LEASES->{hash};

  if (exists $hash->{$lease->{lease_id}}) {
     my $l = $hash->{$lease->{lease_id}};
     foreach my $e ('start','pid','time', 'cacheHandle') {
       $lease->{$e} = $l->{$e} if (exists $l->{$e});
     }
     return $lease;
  } else {
     return undef;
  }
}

sub found {
  my($hash, $id) = @_;
  foreach my $el (keys %$hash) {
     if ($el eq $id || substr($el, 0, length($id)+1) eq "$id:") {
        return 1;
     }
  }
  return 0;
}


sub get0 {
  my ($LEASES, $lease_id, $time) = @_;
  my($x, $l);
  my $hash = $LEASES->{hash};
  $LEASES->Lock();

  # TRY TO FIND OUT IF THERE IS A LEASE IN THE WAY (shorter or longer)
  my $take_lease = 1;
  foreach my $el (keys %$hash) {
    my $l = $hash->{$el};
    next if (time - $l->{start} > $l->{time});
    next if ( ($el eq $lease_id) && ($l->{pid} eq $$) );
    if ($el eq $lease_id || "$el:" eq substr($lease_id, 0, length($el)+1) ||
                      "$lease_id:" eq substr($el, 0, length($lease_id)+1) ) {
       if (-d "/proc/$l->{pid}") {
         $CURRENT_LEASE = $l if ($el eq $lease_id);
         $take_lease = 0; last;
       }
    }
  }
  if ($take_lease) {
    $l= $hash->{$lease_id} = &entry($lease_id, $time);
  }
  $LEASES->UnLock();
  return $l;
}

sub currentLeaseInfo {
  my($class, $info) = @_;
  return undef if (!$CURRENT_LEASE);
  if ($info) {
     return $CURRENT_LEASE->{$info};
  } else {
     return $CURRENT_LEASE;
  }
}

sub entry {
   my($lease_id, $time) = @_;
   my $en = {
         pid => $$, 
       start => time,  
        time => $time,
    lease_id => $lease_id,
            };

   bless($en, 'Lease');
   return $en; 
}

       

sub release {
  my($lease) = @_;

  $LEASES = RasDB->new("LEASES");

  my $hash = $LEASES->{hash};
  delete $hash->{$lease->{lease_id}} if ($lease->{lease_id});
}



1;
