package Launch;

use System;

sub copyDefaults {
  my($class) = @_;
  $DEF = Util->deserialize("System/UrlLaunch.txt", undef, 1) || {};
  $U   = Util->deserialize("UrlLaunch.txt") || {};
  foreach my $el (keys %$DEF) {
     $U->{$el} = $DEF->{$el};
  }
  Util->serialize("UrlLaunch.txt", $U);
}

sub clear {
  $URLS = undef;
}


sub read {
  my($class) = @_;

  return $URLS if ($URLS);

  $URLS = Util->deserialize("UrlLaunch.txt") || {};
  bless($URLS, 'Launch');
  return $URLS;
}

# long to display the name with the gif
sub link {
  my($urls, $type, $dev, $long, $target) = @_;

  $target= "apps" if (!$target);

  my $u_name  = $urls->{$type}[0];
  my $u_value = $urls->{$type}[1];
  my $u_name2 = $urls->{$type}[2];
  my $u_value2 = $urls->{$type}[3];
  return undef if (!$dev && index($u_value, "\$ip") >= 0);

  my $ip = $dev->{ipno};
  my $lid = $dev->{LID};
  $u_value =~ s/\:\d+//          if ($ip =~ /\:\d+/);
  $u_value2 =~ s/\:\d+//         if ($ip =~ /\:\d+/);
  $u_value =~ s/http\:/https:/   if ($ip =~ /\:\d443/ || $ip =~ /\:6789/);
  $u_value2 =~ s/http\:/https:/  if ($ip =~ /\:\d443/ || $ip =~ /\:6789/);

  $u_value =~ s/\$ip/$ip/;
  $u_value2 =~ s/\$ip/$ip/;

  $u_value =~ s/\$lid/$lid/;
  $u_value2 =~ s/\$lid/$lid/;
  
  $u_value = Util->encode($u_value);
  $u_value2 = Util->encode($u_value2);

  $launch = "&nbsp;<a href=\"$Http::WEBPROC?GO=Launch::launch&url=$u_value\" target=$target><img src=/gif/urllink.gif alt=\"Launch $u_name\" border=0>" .
     ($long ? $u_name : "") . "</a>";

  if ($u_name2) {
    $launch .= "&nbsp;<a href=\"$Http::WEBPROC?GO=Launch::launch&url=$u_value2\" target=$target><img src=/gif/urllink.gif alt=\"Launch $u_name2\" border=0>" . 
     ($long ? $u_name2 : "") . "</a>";
  }
  return $launch;
}

use Net::Ping;

sub launch {
  my($q) = @_;

  my $url = $q->{url};
  my @l = split(/[\:\/\@]+/, $url);
  my $ip = index($url, "\@") > 0 ? $l[3]: $l[1];
  my $p = Net::Ping->new("icmp");

  print Html->body();
  if (Util->ping($ip, 5) || $p->ping($ip,5)) {

    print "<meta http-equiv=Refresh content=\"0;URL=$url\">";
  } else {
    print "&nbsp;<p><table border=1 cellpadding=5 bgcolor=white><tr><td><font color=red><h1>Cannot access device at $ip !</table>";
  }
}

1;




