package Html::List;
use strict;
use Html;
use base 'Html';
use Labels;

#  $list = Html::List->makeList($q,
#     [ [r1c1, r1c2, r1c3 ...],
#       [r2c1, r2c2, r2c3 ...],
#     ],
#     ['Col1','Col2','Col3','Col4'],
#     ['l',   'r',   'c',   'c'   ],
#     ['+sn',   '-'                 ],
#     { pageSize    => 20,  
#       interactive => 0, 
#       colDisplay  => [undef,undef, \&func1] ,
#       colHide     => [0,1,2]  # 0=normal, 1=inactive,2=removed
#       line2 => "7,2" # display col7 on a second line and skip 2 col.
#     }
#  +s : means put a space when the sort value changes
#  +_n : don't repeat the column
#  l =left, r=right, c=center, ln=left/nowrap, h=html

      

sub makeList {
  my($class, $q, $array, $headers,$justify, $sorts, $opts) = @_;
  my($x, $c, $sign,  $lang, @L, $values, $line2_col, $line2_skip);

  my $interactive = $opts->{interactive};
  my $G = Labels->read();
  my $renv = System->get_renv();
  $opts->{hci2} = 1 if (substr($renv->{color_scheme},0,3) eq "hci");

  my $list_size = $opts->{reportSize} ? 100 : $renv->{'screen.list_size'};
  my $pageSize  = $list_size || $opts->{pageSize} ||  20;

  $pageSize = 100000 if ($q->{ONEPAGE} || 
                        (exists $opts->{interactive} && !$opts->{interactive}));

  my $page = $q->{PAGE} || 1;

  my $url = "$Http::WEBPROC?GO=$q->{GO}";
  my $c1  = $opts->{break} ; # break contains color and content 
  if ($opts->{line2}) {
     ($line2_col, $line2_skip) = split(/,/, $opts->{line2});
  }
  my $colorRow = $opts->{colorRow};
  $line2_skip = 1 if (!defined($line2_skip));

  my $fpnl = $opts->{fpnl} || "<img src=/gif/pfirst.gif width=23 height=20 border=0 alt=\"$G->{firstp}\">|<img src=/gif/pbefore.gif width=23 height=20 border=0 alt=\"$G->{prevp}\">|<img src=/gif/pafter.gif width=23 height=20 border=0 alt=\"$G->{nextp}\">|<img src=/gif/plast.gif width=23 height=20 border=0 alt=\"$G->{lastp}\">";
  my @FPNL = split(/\|/, $fpnl);
  my $fpnl2 =  $opts->{fpnl2} || "<img src=/gif/pfirst2.gif width=23 height=20 border=0 alt=First>|<img src=/gif/pbefore2.gif width=23 height=20 border=0 alt=Previous>|<img src=/gif/pafter2.gif width=23 height=20 border=0 alt=Next>|<img src=/gif/plast2.gif width=23 height=20 border=0 alt=Last>";
  my @FPNL2 = split(/\|/, $fpnl2);

  my $colDisplay = $opts->{colDisplay};
  my $colHide    = $opts->{colHide};

  foreach my $k (keys %$q) {
     next if ($k eq "SORT" || $k eq "SIGN" || $k eq "PAGE" || $k eq "GO" || $k eq "ONEPAGE" || substr($k,0,7) eq "COOKIE_");
     my $v = $q->{$k}; $v =~ s/ /+/g;
     $url .= "&$k=$v";
  }
  my $sort = $q->{SORT};
  $q->{SIGN} = 1 if (!$q->{SIGN} && $sort);

  my $out = ($renv->{window} eq "N" && $renv->{color_scheme} eq "hci2") ? "<tr>" : "<tr bgcolor=$Style::LIGHT>";

  for ($x=0; $x <= $#$headers; $x++) {
     my $si = substr($sorts->[$x],0,1);
     my $v  = $headers->[$x];
     my $al = $justify->[$x] || 'l';
     my $hide = $colHide->[$x];

     next if ($al eq 'x');
     if ($hide == 2) {
       $out .= "<td></td>";
     } elsif ($hide == 1) {
       $out .= ($al eq "r") ? 
                 "<td align=right><table border=0><tr><td>$v&nbsp;</table></td>" : 
                 "<td>&nbsp;$v</td>";

     } elsif ($si eq "+" || $si eq "-" ) {
         my ($prefix, $gif, $gif2, $col1);
         
         if ($sort == $x+1) {
            $col1 = "bgcolor=$Style::LIGHT";
            $sign = - $q->{SIGN};
            if ($q->{SIGN} == 1) {
               $prefix = "+&nbsp;";
               $gif = "<img src=/gif/asc1.gif width=12 height=10 alt=\"Current Ascending Sort\" border=0>";
            } else {
               $prefix = "-&nbsp;";
               $gif = "<img src=/gif/desc1.gif width=12 height=10 alt=\"Current Descending Sort\" border=0>";
            }
         } else {
            if ($si eq "+") {
              $sign = 1;
              $gif = "<img src=/gif/asc.gif width=12 height=10 alt=\"Ascending Sort\" border=0>";
            } else {
              $sign = -1;
              $gif = "<img src=/gif/desc.gif width=12 height=10 alt=\"Descending Sort\" border=0>";
            }
         }
         if ($opts->{hci2}) {
           $gif2 = $gif;
           $prefix = "";
         }
         my $href = $interactive ? 
              "<a class=TblHdrLnk href=\"$url&SORT=" . ($x+1) . "&SIGN=$sign\">$v</a>" : $v;
         if ($al eq "r") {
           $out .= "<td align=right $col1><table border=0><tr>
             <td><b>$prefix$href</td><td>$gif2</td></table></td>";
         } else {
           $out .= "<td $col1><table class=Tclear border=0><tr><td class=TclearTd><b>$prefix$href</td><td class=TclearTd>$gif2</td></table></td>";
         }
     } else {
         $out .= ($al eq "r") ? "<td align=right><table border=0><tr><td><b>$v</table></td>":  "<td><b>$v&nbsp;</td>";
     }
  }
  $out .= "\n";
  my $S = $array;
  my(@NS, @NS2, $r);
  if ($sort) {
     for ($x=0; $x <= $#$array; $x++) {
         $r = $array->[$x];
         push(@NS2, $r->[$sort-1] . "\t" . sprintf("%3.3d", $x));
     }
     if ($q->{SIGN} == -1) {
        foreach my $v (reverse sort @NS2) {
          my($s, $no) = split(/\t/, $v);
          push(@NS, $array->[$no]);
        }
     } else {
        foreach my $v (sort @NS2) {
          my($s, $no) = split(/\t/, $v);
          push(@NS, $array->[$no]);
        }
     }
     $S = \@NS;
  }
     
  my $first = ($page-1) * $pageSize;
  my $last =  $page * $pageSize - 1;
  my $p1   = $#$array+1;
  my $tot_pages  = int($p1 / $pageSize);
  $tot_pages++ if ($tot_pages * $pageSize < $p1);

  $last = $#$array if ($last > $#$array);
  my($y);
  my $lastv ="++++";
  my $norepeat = (index($sorts->[$sort-1], 'n') >= 0); # substr($sorts->[$sort-1],2,1);
  my $breakspace= (index($sorts->[$sort-1], 's') >= 0); 
  my $new = 0;
  my $cnt;

  for ($x=$first; $x <= $last; $x++) {
      my $row = $S->[$x];
      $new =0;
      if ($sort && ($breakspace||$norepeat)  && $lastv ne $row->[$sort-1]) {
          if ($lastv ne "++++") {
              if ($c1) {
                $out .= "<tr><td></td><tr><td bgcolor=$c1 colspan=" . ($#$headers+1) . "><b>&nbsp;" . 
                         $headers->[$sort-1] . ": " . $row->[$sort-1] . "</td>";
              } elsif ($breakspace) {
                $out .= "<tr><td></td><tr><td></td>";
              }
          }
          $lastv = $row->[$sort-1]; $new = 1;
      }
      if ($colorRow && $row->[$colorRow-1]) {
        $out .= "<tr bgcolor=$row->[$colorRow-1]>";
      } else {
        $out .= "<tr>";
      }
      my $cols = ($#$headers >= 0) ? $#$headers : $#$row;
      for ($y=0; $y <= $cols; $y++) {
         my $al   = $justify->[$y] || 'l';
         next if ($al eq 'x');
         my $hide = $colHide->[$y];
         my $bold;
         my $col1 = ($sort eq $y+1) ? "bgcolor=$Style::LISTCOL" : "";
         if ($sort-1 == $y && $norepeat) {
           if ( $new ) {
             $bold = "<b>";
           }  else {
             $out .= "<td></td>";
             next;
           }
         }
         if ($hide == 2) { # hide
           $out .= "<td></td>";

         } elsif ($hide == 1) {
           $out .= "<td>&nbsp;</td>";

         } elsif ($colDisplay->[$y]) {
            my $f = $colDisplay->[$y];
            $out .= &$f($row->[$y]);
         } elsif ($al eq "l") {
            $out .= "<td $col1>$bold&nbsp;$row->[$y]</td>";
         } elsif ($al eq "ln") {
            $out .= "<td $col1 nowrap>$bold&nbsp;$row->[$y]</td>";
         } elsif ($al eq "r") {
            $out .= "<td $col1 align=right>$bold$row->[$y]&nbsp;</td>";
         } elsif ($al eq "x") {
            $out .= "<td $col1>$row->[$y]</td>";
         } elsif ($al eq "h") {  # html included
            $out .= "<td $col1 $row->[$y]</td>";
         } elsif ($al eq "c") {
            $out .= "<td $col1><center>$bold$row->[$y]&nbsp;</td>";
         }
      }
      $cnt++;
      if ($line2_col && $row->[$line2_col] ) {
         my $w = $#$headers - $line2_skip + 1;
         $out .= "<tr><td colspan=$line2_skip><td colspan=$w>$row->[$line2_col]</td>" ;
      }
      #$out .= "<tr><td bgcolor=gray colspan=" . ($cols+1) . "><img src=/gif/dot_clear.gif height=0></td>";
      $out .= "\n";
  }
  my $page_info = $G->expand(page => "<b>$page</b>", $tot_pages) ;
  my $ss = "&SORT=$q->{SORT}&SIGN=$q->{SIGN}";
  my ($pre_info, $next_info, $many_info);

  if ($interactive) {
    if ($tot_pages  > 0) {
      if ($page > 1) {
         $pre_info .= "<a href=\"$url&PAGE=1$ss\">$FPNL[0]</a>";
      } else {
         $pre_info .= "$FPNL2[0]";
      }
      if ($page > 1) {
         my $pp = $page - 1;
         $pre_info .= "<a href=\"$url&PAGE=$pp$ss\">$FPNL[1]</a>";
      } else {
         $pre_info .= "$FPNL2[1]";
      }
      if ($page < $tot_pages) {
         my $np = $page + 1;
         $next_info .= "<a href=\"$url&PAGE=$np$ss\">$FPNL[2]</a>";
      } else {
         $next_info .= "$FPNL2[2]";
      }
      if ($page < $tot_pages) {
        $next_info .= "<a href=\"$url&PAGE=$tot_pages$ss\">$FPNL[3]</a>";
      } else {
        $next_info .= "$FPNL2[3]";
      }
    }
    if ($q->{ONEPAGE}) {
        $many_info .= "<a href=\"$url&PAGE=1$ss\">".
                "<img src=/gif/manypage.gif height=20 border=0 alt=\"$G->{manyp}\"></a>";
    } elsif ($tot_pages > 1) {
        $many_info .= "<a href=\"$url&ONEPAGE=1$ss\">".
                  "<img src=/gif/onepage.gif height=20 border=0 alt=\"$G->{onep}\"></a>";
    } elsif ($tot_pages == 1) {
        $many_info .= "<img src=/gif/onepageI.gif height=20 border=0>";
    }
  }
  return ("$pre_info $page_info $next_info", $out, $tot_pages, $last-$first+1,
            $many_info, $page_info);
}


1;
