package Html;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#use System;
use Navigation;
use Error;
use Util;
use Labels;
use strict;

use vars qw (%MAP $SCR1 $SCR2 @SCR1 @SCR2 $HEADER_DONE $SAVE_HEADER $HEADER2_DONE %LANG);


$SCR1 = "1234567890qwertyuiopasdfghjklzxcvbnm ZXCVBNMLKJHGFDSAQWERTYUIOP".
        "!\@#\$%^&*()-_=+[]{}\\|;':\",.<>/?";
$SCR2 = "mnbvcxzasdfghjklpPLOKMNJIUHBYGVTFCRDXESZWAQoiuytrewq1234567890 ".
        "<>?,./:\";'{}|[]\\+_)(*&^%\$#\@!-=";

sub init_scramble {
  my($class) = @_;
  my ($x, $c2);
  for ($x=0; $x < length($SCR1); $x++) {
    my $c1 = substr($SCR1,$x,1); 
    my $o1 = ord($c1);

    my $c2 = substr($SCR2,$x,1);
    my $o2 = ord($c2);
    if ($c2 =~ /\W/) {
      $SCR1[$o1] = sprintf("%%%X",$o2);
    } else {
      $SCR1[$o1] = $c2;
    }
    $SCR2[$o2] = $c1;
  }
}

#  $arg->{select} =1 means that you want a [Select] first option
#  makeSelect("sel1", "2=opt2|4=opt3", "2");
#  $arg->{head} = "onchange=form.submit()";

sub makeSelect {
  my($class, $name, $l, $val, $arg) = @_;
  my($o, $ck);
  my $head = $arg->{head};
  my $G = Labels->read();

  my $m = "multiple size=$arg->{multiple}" if ($arg->{multiple});

  my @a = split(/\|/, $l);
  $o = "<select name=$name $head $m>";
  $o .= "<option value=\"\">[$G->{select}]</option>" if ($arg->{select});

  foreach my $x (@a) {
    my @b = split(/=/, $x);
    $b[1] = $b[0] if (!$b[1]);
    if ($arg->{multiple} ) {
      $ck = "";
      $ck = "selected" if (index("\t$val\t", "\t$b[0]\t") >=0) ;
    } else {
      $ck = ($b[0] eq $val)? "selected":"";
    }
    $o .= "<option $ck value=\"$b[0]\">$b[1]</option>";
  }
  $o .= "</select>";
  return $o;
}

# OLD, no <select> section

sub select {
  my($class, $values, $val, $m) = @_;
  my($sel, $x, $val0, $key, @a, $i);
  $sel = "";

  @a = split(/ *\| */, $values);
  foreach $x (@a) {
    $key = $val0 = "";
    $i = index($x,"=");
    if ($i >= 0) {
      $key = substr($x,0,$i);
      $val0 = substr($x,$i+1);
      my $selected;
      if ($m) {
        $selected = (index($val, $key) >=0) ? "selected":"";
      } else {
        $selected = ($key eq $val) ? "selected":"";
      }
      $sel .= "<option value=\"$key\" $selected>$val0</option>";
    } else {
      my $selected;
      if ($m) {
        $selected = (index($val, $x) >= 0) ? "selected":"";
      } else {
        $selected = ($x eq $val) ? "selected":"";
      }
      $sel .= "<option value=\"$x\" $selected>$x</option>";
    }
  }
  $sel .= "</select>";

}

sub linkToggle {
 my($class, $link, $tag_name, $vals, $no) = @_;

 my $help;
 my $cnt = 1;
 foreach my $v (@$vals) {
    if ($cnt == $no) {
       $help .= "<b>$v</b>";
    } else {
       $help .= "<a href=$Http::WEBPROC?GO=$link&$tag_name=$cnt>$v</a>";
    }
    $help .= " | ";
    $cnt++;
 }
 chop($help);
 chop($help);
 return $help;
}


sub href {
 my($class, $hname, $url, $name, $target) = @_;
 
 $url = $class->scramble($hname, $url);
 return "<A href=$url $target>$name</a>";
}
  
# Html->scramble("", "GO=GUI::Hosts::upd&no=0");

sub scramble {
 my($class, $hname, $url) = @_;
 my $renv = System->get_renv();
 return "/$hname?$url" if ($renv->{scramble} ne "Y");

 $class->init_scramble() if ($#SCR1 < 0);

 if (substr($url,0,3) eq "GO=") {
     my $url1 = substr($url,3);
     $url1 =~ s/(.)/$SCR1[ord($1)]/eg;
     return "/$hname?SGO=" . $url1;
 }
 return "/$hname?$url";

}

sub unscramble {
 my($class, $url) = @_;

 if (substr($url,0,4) eq "SGO=") {
     $class->init_scramble() if ($#SCR1 < 0);
     my $url1 = substr($url,4);
     $url1 = Util->decode($url1);
     $url1 =~ s/(.)/$SCR2[ord($1)]/eg;
     return "GO=" . $url1;
 }
 return $url;
}

#  print Html->errorByCode('t3.101', 1, "arg1", "arg2" ..);


#  DISPLAY ERROR STRINGS
#

sub line {
  my($class, $line) = @_;
  return "<table border=0 bgcolor=white width=100% cellspacing=0>
    <tr><td><b>- $line</table>
  <table border=0><tr><td></table>";
}

# $arg = { left => 1}
sub info {
  my($class, $m, $sev, $arg) = @_;
  return $class->error_($m, $sev, $arg);

}

sub makeArgs {
  my($class, $q, $skip) = @_;
  my $args;
  foreach my $el (keys %$q) {
    next if (substr($el,0,6) eq "COOKIE" || $el eq "GO");
    if (index(",$skip,", ",$el,") < 0) {
       $args .= "&$el=$q->{$el}";
    }
  }
  return $args;
}

sub makeHidden {
  my($class, $q, $skip) = @_;
  my $h;
  foreach my $el (keys %$q) {
    next if (substr($el,0,6) eq "COOKIE" || $el eq "GO");
    if (index(",$skip,",",$el,") < 0) {
       $h .= "<input type=hidden name=$el value=\"$q->{$el}\">\n";
    }
  }
  return $h;
}

sub warning {
  my($class, $m, $sev, $arg) = @_;
  return $class->error_($m, $sev|| 1, $arg);
}

sub error {
  my($class, $m, $sev, $arg) = @_;
  return $class->error_($m, $sev || 2, $arg);
}

sub docFile {
  my($class, $file, $arg) = @_;

  my $doc = $class->readHtdocs($file);
  return $class->doc($doc);
}

sub doc {
  my($class, $text, $arg) = @_;

  my $width = $arg->{width} || $Style::WIDTH;
  return "<table border=0 width=$width cellspacing=1 cellpadding=1 bgcolor=#F0F0F0>
   <tr><td>$text</table>
   <table border=0><tr><td></table>\n";
}

sub step {
  my($class, $m,  $arg) = @_;
  
  my $width = $arg->{width} || $Style::WIDTH;
  my $gif = "step.gif";
  return "<table border=0 width=$width cellspacing=1 cellpadding=1>
   <tr><td><b>-</td><td><b>&nbsp;$m &nbsp;</table>
   <table border=0><tr><td></table>\n";
}



# present a string as an html error box
sub error_ {
  my($class, $m, $sev, $arg) = @_;
  my $width = $arg->{width} || $Style::WIDTH;
  my $G = Labels->read();
  my ($col, $gif, $v);
  my $bg = "#F0F0F0";
  if ($sev == 0) {
    $gif = "info_large.gif alt=\"$G->{notice}\""; # "al_ok.gif";
  } elsif ($sev ==1) {
    $gif = "warning_large.gif alt=\"$G->{warning0}\"";
    $bg  = "#FFFFD0";
  } else {
    $gif = "error_large.gif alt=\"$G->{error0}\""; # al_crit.gif";
    $bg  = "#FFE8E8";
  }
  my $ce; #  = "<center>" if (!$arg->{left});
  return "<center><table border=0 width=$width cellspacing=1 cellpadding=1 bgcolor=$bg>
   <tr><td width=6%><center><img src=/gif/$gif></td><td>&nbsp;$m &nbsp;</table></center><table border=0><tr><td></table>
   ";
}

sub select_frequency {
  my($class, $renv, $select) = @_;
  my($frequency, $x);

  $select = "Select" if (!$select);
  $frequency = "<select name=frequency><option value=\"\">[$select]</option>";
  my $G = Labels->read();
  foreach $x (5,10,15,20,30,40,50,60,90,120,180,240) {
    my $sel = ($renv->{frequency} == $x) ? "selected":"";
    my $ss = ($x == 1) ? "":"s";
    $frequency .= "<option $sel value=$x>$x $G->{minutes}</option>";
  }
  $frequency .= "</select>";
  return $frequency;
}

sub save_header {
  my($class, $string) = @_;

  $SAVE_HEADER .= $string;
}

#
# extra_header and SAVE_HEADER must end with a \n if they are not blank
#
sub text_header {
  my($class, $rc, $extra_header) = @_;
  $rc = "200 OK" if (!$rc);
  my $o;
  if (!$HEADER_DONE) {
    $HEADER_DONE = 1;
    $o = "HTTP/1.0 $rc\n" if (!$ENV{FCGI});
    if (index($extra_header, "Content-type") >= 0) {
      $o .= "$extra_header$SAVE_HEADER\n";
    } else {
      $o .= "Content-type: text/html\n$extra_header$SAVE_HEADER\n";
    }
    $SAVE_HEADER = undef;
  }
  return $o;
}

#  body({ head     => "  ",
#         color    => "#C0C0C0",
#         margin   => "leftmargin=2...",
#         nocenter => 1 
#       });

sub body {
  my($class, $nav_section, $args) = @_;
  my $o;
  if (!$HEADER_DONE) {
    $o = "HTTP/1.0 200 OK\n" if (!$ENV{FCGI});
    $o .= "Content-type: text/html\n$SAVE_HEADER\n";
    $SAVE_HEADER = undef;
    $HEADER_DONE = 1;
  }
  my $color  = $args->{color} || $Style::BGCOLOR;
  my $margin = $args->{margin};
  my $extra  = $args->{extra};
  my $body   = $args->{body};
  my $nav    = Navigation->read();
  my $head   = $nav->{ROOT}{info}{style};
  my $ruser  = System->get_ruser();
  my $renv   = System->get_renv();
  my $window = $ruser->{window} || $renv->{window};
  $head     .= "\n" if ($head);
  $head     .= $args->{head};
  my $link;
  if (Http::css_button()) {
    $link = "<link rel=stylesheet type=\"text/css\" href=\"/css/buttons.css\"/>";
  }

  my $short = Util->shortHostname($renv->{hostname});
  my $tit   = "<title>" . ($args->{title}||$short) . " - $renv->{GSV_NAME} </title>"; 

  if ($head) {
      $o .= "<head>$link$head</head>\n";
  } else {
      $o .= "<head>$link$tit</head>\n";
  }

  if ($window ne "N" || $body) {
    $o .= "<body bgcolor=$color $margin $extra>\n";
  }
  $o .= "<center>" if (!$args->{nocenter});
  $o .= "<a name=top>";
  return $o;
}

sub find_file {
  my($class, $f, $dir) = @_;

  $dir = "htdocs" if (!$dir);
  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();
  my $lang  =  $ruser->{language} || $renv->{language};
  my $lang0 = "$lang/" if ($lang);

  $f = "/$f" if (index($f,"/") < 0);
  my $ix = rindex($f, "/");
  my $lf = substr($f,0,$ix+1) . $lang0 . substr($f,$ix+1);
     
  my $F  = System->get_home() . "/$dir/$f";
  my $LF = System->get_home() . "/Lang/$dir/$lf";
  $F     = $LF if (-f $LF);
  if (wantarray) {
    return ($F, $lang);
  } else {
    return $F;
  }
}

sub readHtdocs {
  my($class, $f, $notrace, $print)  = @_;

  my $renv  = System->get_renv();
  my $trace = $renv->{html_trace} && !$notrace;

  my ($F, $lang) = $class->find_file("$f.html");

  my (@l, $i1, $l);
  if (open(RH,$F) ) {
    if ($print) {
       while ($l = <RH>) {
           print $l;
       }
       close(RH);
    } else {
       @l = <RH>; close(RH);
    }
    $i1 = "</b><small>($lang $f)</small>" if ($trace);
    print $i1 if ($print);
  }
  return "@l $i1" if (!$print);
}



sub readMap {
  my($class, $mapname)  = @_;

  my($l, $section);
  return $MAP{$mapname} if ($MAP{$mapname});

  $MAP{$mapname} = {};
  my $D = System->get_home() . "/System/$mapname";
  if (open(O, $D)) {
     while ($l = <O>) {
        chop($l);
        next if (substr($l,0,1) eq "#");
        if (substr($l,0,1) eq "[") {
           my $ix = index($l, "]");
           $section = substr($l,1,$ix-1);
        } else {
           my($lang,$val) = split(/ *= */, $l, 2);
           next if (!$val);
           $MAP{$mapname}{$section}{$lang} = $val;
        }
     }
  }
  close(O);
  return $MAP{$mapname};
}

#  works with the Navigation file
#  Html->header2("admin.gen_maint.site_info", "95%");
#  right : more stuff on the right by the 'help'

sub header2 {
  my($class, $nav_section,  $width, $extra_label , $doc_file, $arg) = @_;
  my $helpSection = $arg->{helpSection};
  my $nocrumb = $arg->{noCrumb};
  return if ($HEADER2_DONE);
  $HEADER2_DONE = 1;
  my $right   = $arg->{right};
  my $notitle = $arg->{noTitle};
  my $middle  = $arg->{middle};
  my $cnl     = $arg->{CNL};  # Crumbs have No Links
  my $nohelp  = $arg->{nohelp} || $arg->{noHelp};
  my $popup   = $arg->{popup};
  if ($popup) {
     my $G = Labels->read();
     $right = "<a href=\"javascript:close()\">$G->{close}</a>" ;
  }
  my $noTabs  = $arg->{noTabs} || $popup;
  my $noDoc   = $arg->{noDoc};
  my $ruser  = System->get_ruser();
  my $renv   = System->get_renv();
  my $window = $ruser->{window} || $renv->{window};
  my $NARROW = Http->isNarrow();

  my $nav = Navigation->read();
#print "nav=$nav_section, $extra_label<br>";
  my($s1, $s2,$s3);
  my $ix = rindex($nav_section, ".");

  if ($ix > 0) {
    $s1 = substr($nav_section, 0, $ix);  # BASE MENU
    $s2 = substr($nav_section, $ix+1);   # SECTION IN MENU
    $ix    = rindex($s1, ".");
    $s3 = substr($s1, 0, $ix) if ($ix > 0);
  } else {
    $s1 = $nav_section;
  }
  $width = $Style::WIDTH if (!$width);

  my ($section, $item, $title, $out);
  $section = $nav->{$s1};
  $item    = $nav->{$s1}{items}{$s2};
  $title   = $item->{title};
  if ($popup) {
     $out .= "
     <table border=0 bgcolor=$Style::TOPBGCOLOR width=100% cellspacing=0><tr><td>
     <table border=0 bgcolor=$Style::TOPBGCOLOR width=100% cellspacing=6 cellpadding=2>
        <tr><td bgcolor=white>
               <font color=$Style::TOP_FG><img src=/gif/storade-popup.gif></td>
            <td bgcolor=$Style::SUNBLUE><img src=/gif/small_logo2.gif></td>
     </table></table>
     <table border=0><tr><td></table>
     ";
  }
 
  if ($window eq "N" && !$noTabs) {
    $out .= Navigation::nf_top({MENU => $nav_section, OMENU => $s1, 
                         ITEM => $item, TAB => $Http::HTTPQ->{TAB}});
    $out .= "<table border=0><tr><td></table>" if (!$NARROW);
  } else {
    if ($noTabs) {
      $out .= "<body bgcolor=$Style::BGCOLOR>";
    }
    if (!$noDoc) {
      $out .= "<table border=0><tr><td></table>\n";
    }
  }

  if (!exists $nav->{$s1}{items}{$s2}) {
    #return "Cannot find $s1.$s2 in navigation file!";
    $nohelp = 1;
  }

  # CRUMBS LEVEL 1 and 2
  my $crumb;
  if ($window eq 'ZZZ' && !$nocrumb) {
     #$crumb = "<a$cnl href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$s1>$section->{info}{title}</a> >";
     $crumb = "$section->{info}{title} >";
     if ($s3) {
        my $section3 = $nav->{$s3};
        #$crumb = "<a$cnl href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$s3>$section3->{info}{title}</a> > $crumb";
        $crumb = "$section3->{info}{title} > $crumb";
     }
  }

  $title  = "" if ($notitle);

  my ($script, $user);
  if (!$nohelp && ($renv->{window} ne "N" || !$renv->{sun_help}) ) {
    ($script, $user)  = $class->help2("$s1.$s2", $item);
  }
  my $extra;
  if (substr($extra_label,0,1) eq "#") {
     $extra = ": " .  $item->{"title" . substr($extra_label,1)};
  } elsif ($extra_label) {
     $extra = (substr($extra_label,0,1) eq ">"? "": ": ") . $extra_label;
  }
  my $mid = "<td nowrap>$middle</td>" if ($middle);
  if ($right) {
    $script = $script ? "$right | $script" : $right;
  }
  if ($item->{right}) {
     if (substr($item->{right},0,1) eq ">") {
       my $right = substr($item->{right},1);
       my($base, $section) = split(/\./, $right, 2);
       if (exists $nav->{$base}{items}{$section}) {
          my $right_item = $nav->{$base}{items}{$section};
          $script .= " | <a href=$Http::WEBPROC?GO=$right_item->{url}>$right_item->{title}</a>";

       } else {
          my $right_item = $nav->{$base};
          $script .= " | <a href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$base>$right_item->{info}{title}</a>";
       }
     }
  }
  $script = "[ $script ]" if (!$arg->{noBrackets} && $script);
  $out .= "
  <table border=0 cellspacing=0 cellpadding=1 width=$width>\n 
    <tr><td></td>
    <tr>
    <td nowrap valign=middle><font color=#808080><b>$title $extra\n</td>
      $mid<td align=right nowrap width=2%>$script</td>
  </table>\n" if (!$arg->{noHeader});

  my $desc2 = $item->{desc2};
  my $desc1 = $item->{desc};
  my $out_desc;
  my $line_img = $arg->{noLine} ? "" : "<img src=/gif/dot_clear.gif height=2>";
        
  if ($renv->{window} eq "N" && ($renv->{color_scheme} eq "hci2")  && !$NARROW ) {
    $out .= "<table border=0 cellspacing=0 cellpadding=0 width=$Style::WIDTH>
              <tr><td></td><tr><td></td>
              <tr><td></td>
              <tr><td bgcolor=gray>$line_img</td>
              <tr><td></td>
              <tr><td></td>
              <tr><td></td></table>" ;
  }
  if (!$noDoc) {
    if ($doc_file) {
      $out_desc .= $class->readHtdocs($doc_file);
    } elsif (substr($desc2,0,5) eq "FILE ") {
      $out_desc .= $class->readHtdocs(substr($desc2,5));
    } elsif (exists $item->{desc2}) {
      $out_desc .= $desc2;
    } elsif ($desc1) {
      $out_desc .= $desc1;
    }
    if (length($out_desc) > 1) {
      $out .= "<table border=0 cellpadding=3 width=$width bgcolor=$Style::HELP_BG><tr><td>$out_desc</table>";
    } else {
      $out .= "<table border=0><tr><td></table>";
    }
  }
  return $out;

}

#  ->header("Maintenance", "95%", $mach, "Maintenance#Cust", "maint_help");

sub header {
  my($class, $title0, $w, $opt, $helpSection, $doc, $arg) = @_;
  my($caller, $tag);
  my $nohelp = $arg->{nohelp};
  if ($arg->{caller}) {
     $caller = $arg->{caller};
     $tag    = $arg->{tag};
  } else {
    my @X = caller(1);
    my $ix = rindex($X[3], "::");
    if ($ix > 0) {
       $caller = substr($X[3],0, $ix);
       $tag    = substr($X[3],$ix+2) . ".";
    } else {
       $caller = $X[3];
    }
  }
  my $labels =  Labels->read();
  my $title  =  $labels->{"${tag}title"} || $title0;
  $w = "90%" if (!$w);

  if ($opt) {
    $opt = "<td><form></td><td align=right nowrap>$opt</td><td width=1%></form></td>";
  }
  my ($script, $user);
  if (!$nohelp) {
    ($script, $user)  = $class->help($helpSection) ;
    $script = " $script |";
  }

  my $out = "<table border=0 cellspacing=0 cellpadding=2 width=$w> <tr> <td><font size=+1 color=navy><b>$title</td>$opt<td align=right nowrap width=2%>$script $user</td></table>";

  if ($doc) {
     $out .= "<table border=0 cellpadding=3 width=$w bgcolor=white><tr><td>". $class->readHtdocs($doc) . "</table>";
  }
  return $out;
}

# Here is the mapping for where to look
# /htdocs/Help/english/index.htm    	(en)
# /htdocs/Help/french/index.htm     	(fr)
# /htdocs/Help/japanese/index.htm	(ja)
# /htdocs/Help/simplified_chinese/index.htm   (zh)

%LANG = ( 
         'fr' => 'french', 
         'zh' => 'simplified_chinese',
         'ja' => 'japanese',
         'en' => 'english',
       );


sub sunhelp {
  my($class, $item, $renv, $ruser) = @_;

  my $lang = $ruser->{language} || $renv->{language} || "en";
  my $L = $LANG{$lang} || "english";
  $item->{sunhelp} = "storade.home" if (!$item->{sunhelp});

  my $sh = $item->{sunhelp};

  #return "/Help/$L/frame.htm?context=$renv->{sun_help}&topic=$item->{sunhelp}";
  return "/rashttp?GO=Html::sunhelp_frame&context=$renv->{sun_help}&topic=$sh&lang=$L";
}

sub sunhelp_frame {
  my($q) = @_;
  print Html->text_header();

  print <<EOF;
<frameset border=0 rows=80,*>
  <frame src="/htdocs/help_top.html" scrolling=off  marginheight=0 marginwidth=0 leftmargin=0 topmargin=0>
 <frame src="/htdocs/Help/$q->{lang}/index.htm?context=$q->{context}&topic=$q->{topic}" scrolling=auto  marginheight=0 marginwidth=0 leftmargin=0 topmargin=0>
</frameset>
EOF
}


sub help2 {
  my($class, $node, $item) = @_;

  my $user;
  my $sysLb =  Labels->read();
  my $file  = $item->{help};
  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();

  my $u;

  if ($renv->{sun_help}) {
    $u = $class->sunhelp($item, $renv, $ruser);
  } else {
    $file = $item->{help};
    $u = "/rashttp?GO=GUI::Navigation::help2&ROOT=$node&file=$file&WIN=1";
  }

  my $dd = "<script> function o_win(x){ var w=window.open('$u','help_W','menubar=no,scrollbars,resizable,width=850,height=700'); w.focus(); } </script> <a href=javascript:o_win()>$sysLb->{help}</a>";

  if (wantarray) {
    return ($dd, $user);
  } else {
    return $dd;
  }
}

sub help {
  my($class, $move) = @_;

  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $lang = $ruser->{language} || $renv->{language};
  my $INDEX = "indexWin";

  $lang = "$lang/" if ($lang);

  my $user = System->get_ruser();
  $user = $user->{userid};

  my $ix = index( $move, "#");
  my $sysLb =  Labels->read();
  my ($dd, $off);
  if ($ix > 0) {
     $off =  "#" . substr($move,$ix+1);
     $move =  substr($move,0,$ix) . ".html";
  } elsif ($move) {
     $move = "$move.html";
  } else {
     $move = "$INDEX.html";
  }
  my $D = System->get_home() . "/htdocs";
  if ($lang && -f "$D/$lang/Help/$move") {
    $dd = "/$lang/Help/$move";
  }
  if (!$dd && -f "$D/Help/$move") {
    $dd = "/Help/$move";
  }
  if (!$dd) {
    $dd = "/Help/$INDEX.html";
  }


  $dd = "<script> function o_win(x){ var w=window.open('$dd$off','help_W','menubar=yes,scrollbars,resizable,width=800,height=700'); w.focus(); } </script> <a href=javascript:o_win()>$sysLb->{help}</a>";

  if (wantarray) {
    return ($dd, $user);
  } else {
    return $dd;
  }
}


1;
