package Health::Host;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Host.pm,v 1.17 2003/12/18 17:59:24 ccadieux Exp $

 
use Health;
use PDM;
use Carp;
use Data::Dumper;
use Report;
use strict;
use CIM::Instance;
use Message;
use Debug;
use TO;
use Health::Server;
use base 'Health::Server';

sub revision {'$Revision: 1.17 $'}
 

# runs every time
#
sub run_host {
  my($hm, $report) = @_;
  my($run, $orep, $ompxio, $x);
  my($renv)    = System->get_renv();
  my $Config   = PDM::ConfigFile->read();

  CIM->version("1.1");
  $DB::single = 1;

  my $rep     = $report->content();
  my $mpxio   = $rep->{mpxio};
  my $oreport = PDM->getOldReport($report->fileKey);
  my $orep    = $oreport->content()  if ($oreport);
  my $to      = $report->id("class") eq "host.datahost" ? $rep->{topo} : TO->readExistingTopo();
  my $id      = $report->deviceName();

  return if (!$to);   # cannot do ports or mpxio without a topo

# FC COUNTERS
  $hm->fcEvent($rep->{FC_COUNTERS}, $orep->{FC_COUNTERS});

# PORTS
#
  if ($oreport) {
    my $hosts  = $to->hostList();
    my $host1  = $hosts->[0];
    my $hbas   = $host1->portInfo();

    my $wwn = $id;
    foreach my $p (keys %$rep) {
       next if (substr($p,0,6) ne "ports.") ;
       my $new = $rep->{$p} || "[undefined]";
       my $old = $orep->{$p} || "[undefined]";
       if ($old ne $new) {
         my $sev;
         if ($new =~ /NOT/) {
            $sev = ($orep->{$p}) ? Message::SEVERITY_ERROR : Message::SEVERITY_WARNING;
         } else {
            $sev = Message::SEVERITY_GREEN;
         }
         my $sign = ($new =~ /NOT/)? "M": "P";
         my $p2 = $p;
         if ($p2 =~ /socal.*:(\d)$/) {
            $p2 = substr($p2,0,-2) . "/sf\@$1";
         }
         my $found;
         for ($x=0; $x <= $#$hbas; $x++ ) {
             my $to_p = Util->ltrim($hbas->[$x]{path});
             if (substr("ports.$to_p",0,length($p2)) eq $p2) {
                $found = $x; last;
             }
             
         }
         my $comp  = defined($found) ? "port.$found" : "ports";
         my $desc0 = "status of hba " . substr($p,6) . " on $wwn changed from $old to $new";
         Grid->setCode("host.AlarmEvent.hba");
         Grid->setSign($sign);
         my $ev = $hm->alarmEvent($comp, "", $report, $wwn, $desc0, $sev, "$sign.hba.$found", {noState => 1});
         if (defined($found)) {
            State->saveState("host", $wwn, "hba.$found", $wwn, $sev, $desc0, 1, $ev);
         }
       }
    }
  }

 
 
# ONLINE OFFLINE STANDBY

  if ($oreport) {
    $orep    = $oreport->content() ;

    foreach my $k (keys %$orep) {
      next if (substr($k,0,6) ne "mpxio.");
      if (!exists $rep->{$k}) {
        my($t, $wwn) = split(/\./, $k);
        my ($dev, $port) = $Config->deviceByWWN($wwn);
        if ($dev) {
           my $o_type = $report->id('category',   $dev->{type});
           my $o_dev  = $report->id('deviceName', $dev->{key});
           Grid->setCode("$dev->{type}.AlarmEvent.device_path");
           $hm->alarmEvent("port.$port.device_path", "", $report, $dev->{key}, 
             "Path $wwn to $dev->{type} $dev->{name}/$dev->{ipno} dissapeared from the host", 2, 
             "port.$port.device_path");
           $report->id('category',   $o_type);
           $report->id('deviceName', $o_dev);
        }
      }
    }
  }

  foreach my $k (keys %$rep) {
     next if (substr($k,0,6) ne "mpxio.");
     my($state, $desc) = split(/\t/, $rep->{$k});
     my $v = "MPXIO: $state on $desc";

     my($ostate, $odesc) = split(/\t/, $orep->{$k});
     if (!$oreport && ($state eq "OFFLINE")) {
       &saveMpx($to,"t3",$k, Message::SEVERITY_ERROR, $v);

     } elsif ($oreport && ($state ne $ostate)) {
        if ($state eq "OFFLINE") {
           &saveMpx($to,"t3",$k, Message::SEVERITY_ERROR, $v);
        } elsif ($state eq "ONLINE") {
           &saveMpx($to,"t3",$k, Message::SEVERITY_GREEN, $v);
        }
     }
  }
#
#  LUNS
# lun.VE.dev-rdsk-c7t2B00006022004188d7s2.statusA' => 'O.K.'
# lun.VE.dev-rdsk-c7t2B00006022004188d7s2.wwn' => 2900006022004188
# lun.T300.dev-rdsk-c14t50020F2300003EE5d0s2.statusA' => 'No UNIX Label'
# lun.T300.dev-rdsk-c14t50020F2300003EE5d0s2.wwn' => '50020f2000003ee5'


  if ($oreport) {
     $orep    = $oreport->content() ;
     # removed
     my $cimkey = $id;
     my $cnt;
     # deleted
     foreach my $key (keys %$orep) {
         if (substr($key,0,4) eq "lun." && substr($key, -3) eq "wwn" ) {
           my($a1, $type, $dev0, $a2) = split(/\./, $key);
           my $wwn    = $orep->{$key};
           if (!exists($rep->{$key}) ) {
              my $dev = $Config->deviceByWWN($wwn, 4); # check only last 4 digits of wwn
              my $info =  "target=$dev->{type}:$dev->{name}/$dev->{ipno}" if ($dev);
              my $name = $id;
              Grid->setCode("host.AlarmEvent.lun.$type");
              $hm->alarm($report, $orep, "host", "lun.$type.$dev0", "statusA", $name, $name , $cimkey, "lun.status", {use_map_id => 1, info => $info }
                  );
              #State->saveState($dev->{type}, $dev->{key}, "e", $dev->{key}, 2, "inband comm lost", 0);
              last if ($cnt++ > 10);
           }
         }
     }
     # changed
     $cnt = 0;
     foreach my $key (keys %$rep) {
         if ( substr($key,0,4) eq "lun." && substr($key, -3) eq "wwn" ) {
           my($a1, $type, $dev0, $a2) = split(/\./, $key);
           my $wwn    = $rep->{$key};

           foreach my $A ('A', 'B') {
             if ( exists( $rep->{"$a1.$type.$dev0.status$A"}) &&
                  exists($orep->{"$a1.$type.$dev0.status$A"}) ) {
                 my $dev = $Config->deviceByWWN($wwn, 4); # check only last 4 digits of wwn
                 my $name = $id;
                 my $info =  "target=$dev->{type}:$dev->{name}/$dev->{ipno}" if ($dev);
                 Grid->setCode("host.AlarmEvent.lun.$type");
                 $hm->alarm($report, $orep, "host", "lun.$type.$dev0", "status$A", $name, $name , $cimkey, "lun.status", {use_map_id => 1, info => $info}
                     );
                 last if ($cnt++ > 10);
             }
           }
         }
     }
  }
  $hm->free_space($report, $orep);
}


# k = mpxio.wwn

sub saveMpx {
  my($to, $cat, $k, $sev, $desc) = @_;
  my($x,$y);
  my $L = $to->storageList();
  my $done = 0;
  for ($x=0; $x <= $#$L; $x++) {
     my $st = $L->[$x];
     next if ($st->{info}{type} ne $cat);
     my $k1 = $st->{info}{name};
     my $pi = $st->{portInfo};
     my $po = $st->{port};
     next if (!$pi);
     for ($y=0; $y <= $#$pi; $y++) {
       my $pw = $pi->[$y]{PortWWN};
       if ($k =~ /$pw/) {
          my($t2, $k2) = split(/\:/, $po->[$y]);
          State->saveState($cat, $k1, "port.$y.fc_link", 
                             $st->{info}{BoxName} || $k1, $sev, "mpxio to $po->[$y]");
          $done = 1 ;last;
       }
     }
     last if ($done);
  }
        
  State->saveState($cat,  $k, "mpxio", undef, $sev, $desc, 0);
}



sub run_backup {
  my($hm, $report ) = @_;

  my $renv = System->get_renv();
  CIM->version("1.1");
  $DB::single = 1;
  my $mgmtLevel = $report->value('id.mgmtLevel') || 'D';
  my($rep)     = $report->content();

  my($oreport) = PDM->getOldReport($report->fileKey);

  my($orep, $desc, $data, $run, $disco, $obackup, $x);

  if (!$oreport) {
     $run = 1;
  } else {
     $orep  = $oreport->content();
     if ($orep->{backup_config} ne $rep->{backup_config}) {
        $run = 1;
     }
  }
#####################
#   CONFIG BACKUP
#####################
  if ($run) {
       Grid->setCode("host.backup");
       my $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => "host.backup"  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ MgmtLevel   => $mgmtLevel ],
                  [ Description => "Agent backup"],
                  [ Component   => "backup_config"],
                  [ Target      => $report->fileKey ],
                  [ Data        => $rep->{backup_config}]
                         ]);

       my $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
 
       my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $sd->[3]]
                    ]);

       my $ed = Message->new( {  id   => $report->id(),
                            instances => [$ev, @$sd , $pertains],
                            severity  => Message::SEVERITY_NORMAL });

       PDM->saveMessage($ed);
  }

######################
#   TOPOLOGY BACKUP
######################

  my $MASTER = System->get_home() . "/DATA/topo/MERGE-MASTER";
  my ($topo, $l);
  my $file   = $MASTER;
  my $age    = Util->getFileAge($MASTER); 

  if ($file && (!$orep || $orep->{"backup.master_topo.age"} ne $age)) {
    open(O, $file);
    while ($l = <O>) {
       $topo .= " " . $l;
    }
    close(O);
    Grid->setCode("host.backup.topo");
    my $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => "host.topoBackup"  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ MgmtLevel   => $mgmtLevel         ],
                  [ Description => "Topology backup"  ],
                  [ Component   => "backup_topo"      ],
                  [ Target      => $report->fileKey() ],
                  [ Data        => $topo              ]
                         ]);

    my $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});

    my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $sd->[3]]
                    ]);

    my $ed = Message->new( {  id   => $report->id(),
                            instances => [$ev, @$sd , $pertains],
                            severity  => Message::SEVERITY_NORMAL });

    PDM->saveMessage($ed);
  }


######################
#     PACKAGES
######################
  $run = 0;
  if (!$oreport || Timer->isXdays('sendPatchInfo', 10) ) {
     $desc  = "New Patch and Package Information generated";
     $disco = "D";
     foreach my $k (sort keys %$rep) {
       next if (substr($k,0,15) ne "showrev.package" &&
                 substr($k,0,14) ne "showrev.patch." );
       $data .= "ADD=$k|" . substr($rep->{$k},8) . "\n";
     }
     $run = 1; 
  } else {
     $desc  = "Patch and/or Package Information has changed:";
     $orep  = $oreport->content();
     $disco = "A";
     foreach my $k (keys %$rep) {
        next if (substr($k,0,15) ne "showrev.package" &&
                 substr($k,0,14) ne "showrev.patch." );
        if (!$orep->{$k}) {
           $data .= "ADD=$k|" . substr($rep->{$k},8) . "\n";
           $run = 1;
        } elsif ($rep->{$k} ne $orep->{$k}) {
           $data .= "UPDATE=$k|" . substr($rep->{$k},8) . "\n";
           $run = 1;
        }
     }
     foreach my $k (keys %$orep) {
        next if (substr($k,0,15) ne "showrev.package" &&
                 substr($k,0,14) ne "showrev.patch." );
        if (!$rep->{$k}) {
           $data .= "DELETE=$k|" . substr($orep->{$k},8) . "\n";
           $run = 1;
        }
     }
   }
   if ($run) {
       Grid->setCode("host.PatchInfo");
       my $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => "host.PatchInfo"  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Description => $desc],
                  [ Target      => $report->fileKey ],
                  [ Component   => "showrev"],
                  [ MgmtLevel   => $mgmtLevel ],
                  [ Data        => $data]
                         ]);

       my $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
 
       my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $sd->[3]],
                  [ DiscoveryType => $disco],
                    ]);

       my $ed = Message->new( {  id        => $report->id,
                            instances => [$ev, @$sd , $pertains],
                            severity  => Message::SEVERITY_NORMAL });

       PDM->saveMessage($ed);
   }
}

sub heartbeat {
  my($class, $desc) = @_;

  Grid->setCode("agent.HeartbeatEvent");
  my $ev = CIM::Instance->new('NWS_HeartbeatEvent', [
           [ EventType   => 'agent.HeartbeatEvent' ],
           [ EventId     => PDM->getEventSequence  ],
           [ Description => "Heartbeat $desc"   ],
           [ MgmtLevel   => "" ],
           [ Interval    => 24 * 60],
                         ]);
  my $sd = Events->sourceDetector({ event => $ev });
  my $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
            [ Event       => $ev  ],
            [ Element     => $sd->[0] ],
              ]);
  my $ed = Message->new( { id   => {},
                      instances => [$ev, @$sd, $pertains ],
                      severity  => Message::SEVERITY_NORMAL });
  return $ed;
}

sub all_logic {
  my($hm ) = @_;
  my($ev, $ed, $x, $pertains , $sd);
  my($HB) = 'heartbeat';
  CIM->version("1.1");
  my $renv = System->get_renv();
  $DB::single = 1;

#
# RUNS after all health ran.
#
 if (PDM->getEventCount > 0) {
     Timer->resetTimer($HB);
 } else {
     my($hb_delay) = $renv->{heartbeat} || 24; # hours
     $hb_delay *= 60;
     if (Timer->getTimer($HB) > $hb_delay) { #it's been a day with no transmission.
        Timer->resetTimer($HB);

        $ed = $hm->heartbeat();

        PDM->saveMessage($ed);
     }
 }

# GET ALL SYSTEM ERRORS AND SEND AS EN EVENT.
  my @errs = Debug->get_system_errors();
  my $sev;
  for ($sev=1; $sev <= 2; $sev++) {
     my $len = length($errs[$sev]);
     if ($len > 2000) {
       $errs[$sev] = substr($errs[$sev],0,2000) . "\ntotal-size=$len";
     }
  
     if ($errs[$sev]) {
      my $topic = $sev == 1 ? "warnings" : "errors";
      Grid->setCode("agent.AlarmEvent.system_$topic");
      my $desc = substr($errs[$sev],0,200);

      $ev = CIM::Instance->new('NWS_Event', [
                [ EventType   => 'agent.AlarmEvent' ],
                [ EventId     => PDM->getEventSequence  ],
                [ Severity    => $sev        ],
                [ MgmtLevel   => ""          ],
                [ Caption     => $topic      ],
                [ Component   => $topic      ],
                [ Data        => $errs[$sev] ],
                [ Target      => "host:$renv->{hostname}" ],
                [ Description => "$desc:"    ] ,
                       ]);
      $sd = Events->sourceDetector({ event => $ev });
  
      $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                [ Event           => $ev  ],
                [ Element         => $sd->[0] ],
                  ]);
  
      $ed = Message->new( { id   => { deviceName => System->serverName() },
                          instances => [$ev, @$sd, $pertains ],
                          severity  => $sev});
      PDM->saveMessage($ed);
    }
  }
} 

1;
