package GUIAdmin::IP;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>



use PDM;
use Util;
use Agent;
use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use GUI::Discover;
use base 'GUIAdmin';
use MIME::Base64;

sub isDevice    {0}
sub ipRequired  {1}

sub description { carp "abstact" }
sub logic       { carp "abstact" }
sub package     { carp "abstact" }

sub login       { 0 }

sub config_elements {}




sub updDevice {
  my($class, $q) = @_;

  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $devs, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);
  my $G = Labels->read();
  my $L = Labels->read('GUIAdmin')->section('add');


  my $deny = Roles->verifyRole($q, "admin");
  my $desc2 = $class->description();

  print Html->body();
  require "GUI/Devices.pm";

  if ($q->{ACTION_back}) {
   my($hostname) = System->hostname();
   GUI::Devices::list($q);
   return;

  } elsif ($q->{ACTION_update}) {
    ($renv, $devs, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $devs->[$x];

    $devs->[$x]{host} = $q->{host};
    $devs->[$x]{name} = $q->{name};
    $devs->[$x]{path} =  $q->{path} if (exists $q->{path});
    my ($login0, $pass0 , $base64)= split(",", $class->login());
    if ($login0) {
       if ($base64) {
         my $l1 = $q->{$login0};
         my $p1 =  $q->{$pass0};
         $devs->[$x]{$login0} = $l1;
         $devs->[$x]{$pass0}  = $p1;
         my $lid = MIME::Base64::encode("$l1:$p1");
         chop($lid);
         $devs->[$x]{LID} = $lid;
       } else {
         $devs->[$x]{$login0} = $q->{$login0};
         $devs->[$x]{$pass0}  = Util->encodeAll($q->{$pass0});
       }
    }
    $class->config_elements($devs, $q);

    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $devs, $host,$notifs);
    $err = Html->info($G->expand('device_updated', $name));

  } elsif ($q->{ACTION_delete}) {
    ($renv, $devs, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $devs->[$x]{type};
    $key =  $devs->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $devs->[$x]{_name} = "";
    $name = $devs->[$x]{name} . "/ " . $devs->[$x]{ip};
    PDM::ConfigFile->write( $renv, $devs, $host,$notifs);
    &main::log_change($G->expand('device_deleted',$name));

    $q->{ERR} = Html->error($G->expand('device_deleted',$name));
    GUI::Devices::list($q);
    return;
  }
out:

 print Html->header2("admin.gen_maint.maint_device", undef, $desc2," ");

  ($renv, $devs, $host,$notifs) = PDM::ConfigFile->read;
  $h = $devs->[$q->{no}];

  $sel = ($h->{host})? "":"selected";

  $ho = "<select name=host><option value=\"\" $sel>$G->{local}</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $ty = $h->{userLabel} || $h->{type};

  my $pkg = $class->package() . "->updDevice";
  
  my (@login_html);
  my ($login0, $pass0, $base64) = split(",", $class->login());
  if ($login0) {
    my($login_val, $pass_val);
    if ($base64) {
      $login_val = $h->{$login0};
      $pass_val  = $h->{$pass0};
    } else {
      $login_val = $h->{$login0};
      $pass_val  = Util->decode($h->{$pass0});
    }
    push(@login_html,  
           [ f => "Enter Login",    "<input type=text size=20 name=$login0 value=$login_val>"], 
           [ f => "Enter Password", "<input type=password size=20 name=$pass0 value=\"$pass_val\">" ],
           );
  }

  my $scr = Html::Screen->new();
  $scr->add(" <form  autocomplete=off method=get> <input type=hidden name=GO value=\"$pkg\"> 
   
           <input type=hidden name=no value=$q->{no}> <center> $err");
  my $wwns;
  my $wwn_label;
  if($class =~ /9900/){
     $wwns = "$h->{wwn}";
     $wwn_label = $L->{serial_no}
  }else{
     my $wwn1 = $h->{wwn};
     $wwn1 = "" if (index($h->{wwns}, $wwn1) >= 0);
     $wwns = "$wwn1 $h->{wwn2} $h->{wwn3} $h->{wwn4} $h->{wwns}";
     $wwns =~ s/,/, /g;

     $wwn_label =  $G->{port_wwns};
  }
  if($h->{path}){
     $scr->table({ title => $G->{enter_device_info} },
     [
      [ f => $G->{device_type}, $ty ],
      [ f => $G->{monitoring}, $active ],
      [ f => $G->{device_name}, "<input type=text name=name size=20 maxlength=40 value=\"$h->{name}\">"],
      [ f => $G->{device_path}, $h->{path} ],
      [ f => $wwn_label,        $wwns      ],
      [ f => "IP",              $h->{ipno} ],
      @login_html,
      [ f => $G->{primary_host}, $ho ],
     ]);
  }else{
     $scr->table({ title => $G->{enter_device_info} },
     [
      [ f => $G->{device_type}, $ty ],
      [ f => $G->{monitoring}, $active ],
      [ f => $G->{device_name}, "<input type=text name=name size=20 maxlength=40 value=\"$h->{name}\">"],
      [ f => $wwn_label,        $wwns      ],
      [ f => "IP",              $h->{ipno} ],
      @login_html,
      [ f => $G->{primary_host}, $ho ],
     ]);
  }

   
  my(@buttons);
  if (!$deny) {
     push(@buttons, 
       Html::Screen->submitButton("ACTION_update", $G->{submit_update}),
       Html::Screen->submitButton("ACTION_delete", $G->{submit_delete}));
  }
  push(@buttons, Html::Screen->submitButton("ACTION_back", $G->{submit_back}));
  $scr->button(undef, \@buttons);
  $scr->add("</form>");
  print $scr->out();
}



sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel, $warn);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::default")->section("add");
  my $desc2 = $class->description();

  require "GUI/Devices.pm";
  print Html->body();
  print Html->header2("admin.gen_maint.add_device", undef, $desc2," ", {nocrumb => 1});
  my $logic = $class->logic();

  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my($err, $dev) = $logic->addToConfig($q);

    if ($err) {
       $info = $err->toHtml();
    } elsif ($dev) {
       print Html->info($G->{device_added});
       GUI::Devices::list($q);
       return;
    }
  }

  print GUI::Devices::add0($q);

  ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";


  my($phost) = "<select name=host><option value=\"\">[Select]</option>".
              "<option value=\"\" $sel>Local</option>";
  foreach $x (@$host) {
    next if($x->{dh} eq "Y");
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  my($phostD) = "<select name=datahost>".  "<option value=\"\" $sel>Same Host</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $x (@$host, $l1) {
    next if($x->{dh} eq "Y");

    $sel = ($q->{datahost} eq $x->{ip})? "selected":"";
    $phostD .= "<option value=\"" . $x->{ip} . "\" $sel>" . $x->{hostname} ."</option>";
  }
  $phostD .= "<option value=\"*None\">*None</option></select>";
  my $package = $class->package() . "->addDevice";

  my (@login_html);
  my ($login0, $pass0) = split(",", $class->login());
  if ($login0) {
    push(@login_html, 
     [ f => "Enter Login",   "<input type=text size=20 name=$login0>"],
     [ f => "Enter Pasword", "<input type=password size=20 name=$pass0>" ],
     );
  }

  my $scr = Html::Screen->new();
  $scr->add(" <form  autocomplete=off method=get> <input type=hidden name=GO value=\"$package\">
              <input type=hidden name=ADD value=Device>  $info");
  $scr->table( { title => $L->{enter} },
    [
    [ f => $L->{dev_name}, "<input type=text name=name size=15 maxlength=35 value=\"$q->{name}\">" ],
    [ f => $L->{primary},  $phost ],
    [ f => $L->{ip},  "<input type=text name=ip size=40 maxlength=40 value=\"$q->{ip}\">"] ,
    @login_html,
    ]);

  my @buttons;
  if (!$deny) {
     push(@buttons, Html::Screen->submitButton("ACTION_add", $L->{submit_add}));
  }
  push(@buttons, Html::Screen->submitButton("ACTION_back", $L->{submit_back}));
  $scr->button(undef, \@buttons);
  $scr->add("</form>");
  print $scr->out();


}

1;
