package GUI::VolVerify;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use strict;
use Process;
use Html;
use Html::Tabs;
use PDM;

#  $Id: VolVerify.pm,v 1.27 2004/01/09 19:40:11 ccadieux Exp $

sub meta {
  my($q) = @_;
  my $o = "&option=$q->{option}";
  return 
  "<meta http-equiv=Refresh content=\"20;URL=$Http::WEBPROC?GO=GUI::VolVerify::run$o\">"; 
}

sub run {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUI::VolVerify");
  print Html->body();
  if ( Util->findMaster()) {
    print "<h1><center>$G->{e_101}";
    return;
  }
  $q->{option} =1 if (!$q->{option});

  my $table = Html::Tabs->create(list  =>  
            ["1=$L->{title1}", "2=$L->{title2}", "3=$L->{title3}" ],
                       url  => "$Http::WEBPROC?GO=GUI::VolVerify::run",
                     width  => $Style::WIDTH,
             selectedColor  => $Style::DARK,
         selectedTextColor  => "white",
           backgroundColor  => $Style::LIGHT,
        backgroundTextColor => 'black',
                  selection => $q->{option}
         );


  my $info;
  my($warn2, $warn3, $cat, $last_win, $cpid, $running);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  if ($q->{ACTION_kill}) {
      foreach my $h (@$host) {
         Util::Http->runit($h->{ipno}, "/sbin/volverify -k -b");
      }
      system(System->get_home() . "/sbin/volverify -k -b");
      $running = 1;
      print &meta($q);
      print Html->info($L->{started});
  }
  if ($q->{ACTION_submit} ) {
       System->setPassword("array", $q->{telnet});
       $renv->{volVerify}         = $q->{volVerify} ? "Y": "N";
       $renv->{'volVerify.fix'}   = $q->{fix}       ? "Y": "N";
       $renv->{'volVerify.rate'}  = $q->{rate};
       $renv->{'volVerify.frequency'}  = $q->{freq};
       my $x;
       for ($x=0; $x <= 6; $x++) {
         $renv->{"volVerify.time$x"}  = $q->{"time$x"};
       }
       $renv->{'volVerify.once_a_month'}  = $q->{once_a_month} ? "Y" : "N";
       
  
       if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print Html->error("Cannot write config file!");
       } else {
          System->set_renv($renv);
          print Html->info($L->{upd});
       }
  }
  my $st = Process->status(undef, "volverify");

  if ($st =~ /Running/) {
    print &meta($q);
  }


  if ($q->{option} == 1) {
    print Html->header2("manage.util.volverify", undef, $L->{start});
    print "<table border=0><tr><td></table>$table";
    &verify($q, $renv);

  } elsif ($q->{option} == 2) {
    print Html->header2("manage.util.volverify", undef, $L->{kill0});
    print "<table border=0><tr><td></table>$table";
    &kill($q, $renv, $running);

  } elsif ($q->{option} == 3) {
    print Html->header2("manage.util.volverify", undef, $L->{report});
    print "<table border=0><tr><td></table>$table<table border=0><tr><td></table>";
    &report($q, $renv ,$dev, $host);
  }
}

sub verify {
  my($q, $renv) = @_;

  my $G = Labels->read();
  my $L = Labels->read("GUI::VolVerify");
  my $volVerify = "checked" if ($renv->{volVerify} eq "Y");
  my $fix       = "checked" if ($renv->{'volVerify.fix'} eq "Y");

  require MIME::Base64;
  my $telnet    = System->getPassword('array');
  my $rate      = Html->makeSelect("rate", 
                     "1=1:$L->{slow}|4=4:$L->{mid}|8=8:$L->{high}", 
                     $renv->{'volVerify.rate'});

#  0=always, 1:midnight to 1am, ...  24:11pm to midnight.
  my($x, $tt, $tt2, $x0, $next);
  for ($x0=1; $x0 <= 23; $x0++) {
     my $s;
     if ($x0 == 12) {
        $x = $x0;
        $next = 1;
        $s = "$L->{pm}";
     } elsif ($x0 > 12) {
        $x = $x0 - 12;
        $next = $x+1;
        $s = "$L->{pm}";
     } else {
        $s = "$L->{am}";
        $x = $x0;
        $next = $x+1;
     }
     $tt .= ($x0+1) ."=${x}$s-$next$s|";
  }
  chop($tt2);
  my ($meta, $submit2, @time_html);

  for ($x=0; $x <= 6; $x++) {
     my $t = Html->makeSelect("time$x", "99=$L->{always}|1=$L->{midnight}-1$L->{am}|$tt", 
                             $renv->{"volVerify.time$x"}, {multiple => 3});
     my $d1 = $G->{"day$x"};
     my $tt = $L->{warn1} if ($x==0);
     push(@time_html, [ f => "<b>$d1</b> :<br> $L->{time}" , "<table border=0 cellspacing=0><tr><td>$t</td><td>$tt</table>" ]);
  }
  my $mm = "1|7|10|15|20|25|28|30|35|40|50|60|90|0=$L->{continue}";
  my $monthOnly = Util->makeSelect("freq", $mm, $renv->{'volVerify.frequency'});

  my $scr = Html::Screen->new();
  $scr->add(" <form method=post> <input type=hidden name=GO value=GUI::VolVerify::run>
              <input type=hidden name=option value=$q->{option}> $L->{warning}");

  $scr->table( { title => $L->{maint} } , 
    [
    [ f =>  $L->{volVerify} , "<input type=checkbox name=volVerify $volVerify>" ],
    [ f =>  $L->{fix}, "<input type=checkbox name=fix $fix>" ],
    [ f =>  $L->{monthly}, $monthOnly ],
    @time_html ,
    [ f => $L->{rate}, $rate ],
    [ f => $L->{telnet}, "<input type=password size=20 name=telnet value=\"$telnet\">" ],
    ]);

  $scr->button2( [
   [ l => "ACTION_submit", $L->{submit} ],
   ]);
  $scr->add("</form>");
  print $scr->out();
}

sub kill {
  my($q, $renv, $running) = @_;
  my ($submit2);
  my $G = Labels->read();
  my $L = Labels->read("GUI::VolVerify");
  my $st = Process->status(undef, "volverify");
  $st = "Running" if ($running);

  $submit2 = 1 if ($st !~ /Running/);

  my $scr = Html::Screen->new();
  $scr->script("
    function log(a) {
      var O = window.open('$Http::WEBPROC?GO=GUI::VolVerify::log', 'killkog',
                'menubar=no,resizable=yes,scrollbars=yes,width=500,height=500');
      O.focus();
    } ");
  my $stat;

  if($st =~ /Running/){
     $stat = $G->{running};
  }elsif($st =~ /Done/){
    $stat = $G->{done};
  }elsif($st =~ /Not/){
    $stat = $G->{not_running};
  }else{
    $stat = $st;
  }
  $scr->add(" <form method=post> <input type=hidden name=GO value=GUI::VolVerify::run>
          <input type=hidden name=option value=$q->{option}>");
  $scr->table( { title => $L->{kill2}, labelWidth => "35%" },
   [ 
   [ f => $L->{status} , $stat ],
   [ f => $L->{log}   , "[ <a href=javascript:log(1)>$L->{disp}</a> ]" ],
   ]);
  $scr->button2( [
    [ l => 'ACTION_kill', $L->{kill}, !$submit2 ],
    ]);
  $scr->add("</form>");
  print $scr->out();
}

sub process {
  my($out, $db) = @_;
  my $VAR1;
  if ($out) {
     eval $out;
     foreach my $el (keys %$VAR1) {
         $db->{$el} = $VAR1->{$el} if (!exists($db->{$el}));
     }
  }
}


sub report {
  my($q, $renv, $devs, $hosts) = @_;

  my $L  = Labels->read("GUI::VolVerify");
  my $G  = Labels->read();
  my $db = Util->deserializeDir("VolVerify");  # keyed by ipno

  my(@array, %D, $x, %H);

  for ($x=0; $x <= $#$devs; $x++) {
     my $d = $devs->[$x];
     next if (index(",t3,6020,6120,", ",$d->{type},") < 0);
     $H{$d->{host}} = 1;
     my $host = $d->{host} || $renv->{hostname};
     $d->{no} = $x;
     $D{"$host.$d->{key}"} = $d;
  }
  
  foreach my $h (@$hosts) {
     next if (!$H{$h->{hostname}});
     my $data = Util::Http->readFile($h->{ipno}, "VolVerify/");
     my @lines = split(/\n/, $data);
     my ($var, $VAR1);
     foreach my $l (@lines) {
       if ($l =~ /\$VAR1/) {
          &process($var, $db);
          $var = $l;
       } else {
          $var .= $l;
       }
     }
     &process($var, $db);
  }
  

  my $last;
  foreach my $name (sort keys %D) {
     my $d = $D{$name};
     my $scrubbing="off";
     (my $readerr, my $rep1) = 
                         Report->readReport($d->{type}.":".$d->{key}, "*");
     if ($rep1) {
       my $v = $rep1->value(); 
       $scrubbing="on" if($v->{"system.sysDiskScrubber"} eq "on");
     }
     my $el = $db->{$d->{ipno}};
     my $host = $d->{host} || $renv->{hostname};

       my $ver = $d->{volVerify} || $renv->{volVerify};
       my $progress = $el->{progress};
       $progress .= "%" if ($progress =~ /^\d+/);
       my $type2 = uc($d->{type});
       my $url = "<sort $d->{name}><a href=javascript:win1('$type2','$d->{no}')>$d->{name} / $d->{ipno}</a>";
       my $host1 = Util->shortHostname($host);
       my $end;

       if ($el->{end}) {
         $progress = "DONE";
         $end   = substr($el->{end},5);
       } elsif ($el->{start}) {
         $end   = $G->{running};
       }
     if($scrubbing eq "on"){
      $ver = $L->{scrubber};
      push(@array, [ $host1, $url, $ver,]); 
     }else{
       push(@array, [ $host1, $url, $ver, "$el->{volume_name} $el->{volume}", 
                    substr($el->{start},5), $end, "", "", $progress ]);
     }

     my $vols = $el->{VOL};
     foreach my $v (keys %$vols) {
        my $el2 = $vols->{$v};
        next if (!$el2->{end});
        my $dur_h = int($el2->{duration} / 60/60);
        my $dur_m = int($el2->{duration}/60) - $dur_h * 60;
        my $dur_display;
        if ($el2->{start}) {
           $dur_display = "$dur_h:$dur_m:00";
        } else {
           $dur_display = "";
        }
        my $err;
        foreach my $en ('soft','firm','hard') {
          $err = ucfirst($en) . ":$el2->{$en}," if ($el2->{$en});
        }
        chop($err) if ($err);
        $err = $G->{none} if (!$err);

        push(@array, [ $host1, $url, $ver, "$el2->{volume_name} $el2->{volume}", 
                    substr($el2->{start},5), 
                    substr($el2->{end},5), $dur_display,
                    $err, "DONE"]);
     }
  }

  my $scr = Html::Screen->new({ });
  $scr->script("
  function win1(t,n) {
    var b = '$Http::WEBPROC?WIN=1&GO=GUIAdmin::' + t + '->updDevice&no=' + n;0
    var O = window.open(b,'vol','menubar=no,resizable=yes,scrollbars=yes,width=600,height=500');
    O.focus();
  }
  ");
  $q->{SORT} = 1 if (!$q->{SORT});

  $scr->list($q, { title => $L->{title}, interactive => 1 },
   [
   [ l => $L->{host}, '+sn' ],
   [ l => $L->{dev}, '+'  ],
   [ c => $L->{ver}  ],
   [ c => $L->{vol}  ],
   [ l => $L->{start}, '+' ],
   [ l => $L->{end}    ],
   [ l => $L->{duration}  ],
   [ l => $L->{errors}  ],
   [ l => $L->{status} ],
   ],
   \@array);
   print $scr->out();  
   print "&nbsp;<p><table border=0 width=70% bgcolor=white><tr><td>$L->{explain}</table>&nbsp;<p>";
}

sub log {
  my($q) = @_;

  print Html->body();
  my $L = Labels->read("GUI::VolVerify");
  open(O, System->get_home() . "/DATA/tmp/volverify.out");
  my($l, $out, $done);
  while ($l = <O>) {
     $out .= $l;
     $done = 1 if ($l =~ /^EXIT/);
  }
  close(O);
  my $meta = "<meta http-equiv=Refresh content=\"20;URL=$Http::WEBPROC?GO=GUI::VolVerify::log\">" if (!$done);

  print "
    $meta
    <table border=0 cellspacing=0 cellpadding=3 bgcolor=$Style::DARK width=100%>
    <tr><td><font color=white><b>$L->{logkill}
    </td><td align=right><font color=white>[ <a href=javascript:window.close()><font color=white>$L->{close}</font></a> ]
    </table>
    </center><pre>$out";
}
 

1;
 
