package GUI::State;
use Html;
use System;
use strict;
use State;



sub clear {
  my($q) = @_;

   my $G = Labels->read();
   my $L = Labels->read('GUI::State');
   my $ruser = System->get_ruser();
   my $Config = PDM::ConfigFile->read();
   my (%LINK, %ERR);
   print Html->body();
   print  Html->header2("alarms.errors");
   if ($q->{ACTION_del_sel}) {
       print $L->{clear_1} . "<br>";
       foreach my $e (keys %$q) {
         if (substr($e,0,4) eq "del_") {
           my $v = substr($e, 4);
           State->clearComponent($v);
         } elsif (substr($e,0,5) eq "del2_") {
           my $v = substr($e, 5);
           State->clearComponent($v);
         }
       }
 
   } elsif ($q->{ACTION_del_green}) {
       print $L->{clear_4} . "...<br>";
       State->clearAllComponents(0);

   } elsif ($q->{ACTION_del_yellow}) {
       print $L->{clear_5} . "...<br>";
       State->clearAllComponents(1);

   } elsif ($q->{ACTION_del_err}) {
       print $L->{clear_3} . "...<br>";
       State->clearAllComponents();
  
   }
   my @Map = ('al_ok','al_alert','al_crit','al_down');
   
   my $State  = State->read();
   my $comps  = $State->hash();
   $State->ReadLock();

   foreach my $e (keys %$comps) {
     my $comp = $comps->{$e};
     foreach my $topic (keys %$comp) {
        my $v = $comp->{$topic};
        my($type, $k) = split(/\:/, $e);
        my $dev = $Config->deviceByKey($k);
        my $sev = int($v->[0]+0.5);
        next if ($sev < 0);
        my $desc   = $v->[1];
        my $target = $v->[2];
        my $name   = $dev->{name} || $k;
        my $topic0 = $topic eq "e" ? "Enclosure" : $topic;
        my $er = { name => $name, sev => $sev, comp => $topic, comp0 => $topic0, desc => $v->[1], type => $type, key => $e , dev => $dev , k => $k, agg => $v->[5]};
        push(@{$ERR{$name}}, $er);
      }
   }
   $State->UnLock();

   my ($out, $last, $lastn, $cnt, @report);
   my $sev_gifs = State->sev_gifs();
   my $sev_text = State->sev_labels();

   foreach my $e (sort keys %ERR) {
      my $errs = $ERR{$e};      
      foreach my $err (@$errs) {
        my $sev = "<img src=/gif/$sev_gifs->[$err->{sev}]>&nbsp;$sev_text->[$err->{sev}]&nbsp;";
        if ($last ne $err->{k}) {
           $last = $err->{k};
        }
        my $nn = $err->{name};
        $nn =~ s/\./. /;
        my $del = "&nbsp;";
        if ($lastn ne $nn) {
            $lastn = $nn;
            $nn = "<b>$nn";
            my $d = $err->{type} . ":" . $err->{k};
            $del = "<input type=checkbox name=del_$d>";
            $out .= "<tr><td></td>";
        } 
        my $del2 = "<input type=checkbox name=del2_$err->{type}:$err->{k}:$err->{comp}>";
        $cnt++;
	my $sub_event = ($err->{agg} < 0) ? $G->{yes} : "&nbsp;";
        my $lb = Util->abb("$err->{type}.short") || $err->{type};
        push(@report, [$del, $lb, $nn, $del2, $err->{comp0}, $sev, $sub_event, $err->{desc}]);
      }
   }

   my $scr = Html::Screen->new({ });
   $scr->add("<form><input type=hidden name=GO value=GUI::State::clear>");

   $scr->list($q, { title => $L->{title}, empty => $L->{no_error},
                   interactive => 1, pageSize => 100 },
   [
   [ c => $L->{delete}   ],
   [ l => $L->{cat}   ],
   [ l => $L->{device}   ],
   [ c => $L->{delete1}  ],
   [ l => $L->{comp}     ],
   [ l => $L->{sev}      ],
   [ c => $L->{sub}      ],
   [ l => $L->{desc}     ],
   ],
   \@report,
   [
    [ l => "ACTION_del_sel",    $L->{del_sel} ],
    [ l => "ACTION_del_green",  $L->{del_green} ],
    [ l => "ACTION_del_yellow", $L->{del_yellow} ],
    [ l => "ACTION_del_err",    $L->{del_errs} ],
   ]
   );
  $scr->add("</form>");
  print $scr->out();


}

sub show_links {
  my($last, $LINK, $Map, $Config) = @_;
  my $out;
  if ($last && exists($LINK->{$last}) ) {
     my $links = $LINK->{$last};
     foreach my $link (@$links) {
        next if ($link->{sev} < 0);
        my $sev = "<img src=/gif/$Map->[$link->{sev}].gif>";
        my($v1, $v2) = split(/\|/, $link->{key});
        my($t1,$k1, $p1) = split(/\:/, $v1);
        my($t2,$k2, $p2) = split(/\:/, $v2);
        my $dev = $Config->deviceByKey($k2);
        my $name2 = $dev->{name} || $k2;
        my $txt = "port$p1 -> $name2 port$p2";
        $out .= "<tr>
         <td>&nbsp;
         <td>&nbsp;
         <td><font color=navy>LinkAlert $txt
         <td><center>$sev
         <td><small>$link->{desc}
               ";
     }
  }
  return $out;
}


1;


