package GUI::Review;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
use System;
use Util;
use TO;
use Agent::HOST;

#  $Id: Review.pm,v 1.6 2003/12/17 19:28:39 ccadieux Exp $


sub run {
  my($q, $post) = @_;

  my $G = Labels->read();
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  print Html->header2("admin.gen_maint.review");

  print "<form><input type=hidden name=GO value=GUI::Review::_run>
       <input type=hidden name=no_start value=$q->{no_start}>
       <b>" .
    Html::Screen->submitButton("ACTION_run", $G->{submit_run}) . "</form>";
}

sub _run {
  my($q) = @_;

  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
  my($acronym) = $renv->{GSV_ACRONYM};
  my $G = Labels->read();

  print Html->body();
  print Html->header2('admin.gen_maint.review');
  $info = "";

  print "<table border=1 cellspacing=0 cellpadding=3 width=90% bgcolor=white><tr bgcolor=$Style::LIGHT>
   <th>$G->{number}</td><td><b>$G->{details}</td>
  ";

  my $L = &run_($q);
  my $cnt=1;
  foreach my $el (@$L) {
    print "<tr><td>$cnt</td><td>$el</td>";
    $cnt++;
  }
  if ($#$L < 0) {
    print "<tr><td colspan=2><b>$G->{no_error}</td>";
  }
  print "</table>";
}

sub run_ {
  my($q) = @_;

  my $SUPPORTED_PERL_VERSION = 5.005;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Review')->section('review');

  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
  my($acronym) = $renv->{GSV_ACRONYM};
  my @L;
  $cnt= 0;
  if (!$renv->{customer} || ($renv->{customer} =~ /Enter /) ||
      !$renv->{site_name} || !$renv->{site_city} || !$renv->{site_zip} ||
      !$renv->{site_country} ) {
     push(@L, $L->expand('err_1', "<a href=$Http::WEBPROC?GO=GUI::Config::upd>"));
  }

  if (!$renv->{categories} || $renv->{categories} eq "message") {
     push(@L, $L->expand('err_2', "<a href=$Http::WEBPROC?GO=GUI::Config::upd>"));
  }

  $local_active = (-f System->get_home() . "/DATA/start")? "Y":"N";

  if ($local_active eq "N" && !$q->{no_start}) {
     my $l1 = $L->expand(not_active => 
                   "<a href=$Http::WEBPROC?GO=GUI::Start::Agents>");
     push(@L, $l1);
  }

#
# check if topologies are present
#
  my $TOPO = System->get_home() . "/DATA/topo";
  if (!-f "$TOPO/$renv->{hostname}") {
     push(@L, $L->expand('no_topo',$renv->{hostname}));
  }
  for ($x0 = 0; $x0 <= $#$hosts; $x0++) {
    $h = $hosts->[$x0];
    next if ($h->{dh} eq "Y");
    if (!-f "$TOPO/$h->{hostname}") {
       push(@L, $L->expand('no_topo',$h->{hostname}));
    }
  }
          

#
# CHECK IF SLAVES CONFIG WERE PUSHED
#
  $CAT{H} = $renv->{categories} . "|se|";
  $CAT{H. $renv->{hostname}} = $renv->{categories} . "|se|";

  for ($x0 = 0; $x0 <= $#$hosts; $x0++) {
    $h = $hosts->[$x0];
    next if ($h->{dh} eq "Y");
    $CAT{"H" . $h->{hostname}} = $h->{categories} . "|se|";

    if (!$h->{categories} || ($h->{categories} eq "message") ) {
      push(@L, $L->expand(no_storage => $h->{hostname}, 
                "<a href=$Http::WEBPROC?GO=GUI::Hosts::upd&no=$x0>" ) );
    }

    if ($h->{active} eq "N" && !$q->{no_start}) {
      push(@L, $L->expand('slave_1', $h->{hostname}, "<a href=$Http::WEBPROC?GO=GUI::Start::Agents>") );
    }

    $rc = Util::Http->getCommand($h->{ipno} || $h->{hostname}, "Util::checkRasCrons",  20);
    if ($rc =~ /ERROR/) {
      $rc =~ s/\<font color=green\>.*\<\/font\>//;
      push(@L, "$h->{hostname}:</b> $rc");
    }
 
  }

  # Check package versions.
  my ($last_v);
  $last_v = $renv->{version};
  my %HOSTS;
  $HOSTS{'LOCAL'} = 1;
  for ($x0 = 0; $x0 <= $#$hosts; $x0++) {
    $h = $hosts->[$x0];
    next if ($h->{dh} eq "Y");
    $HOSTS{$h->{hostname}} = 1;
    $rc = Util::Http->getCommand($h->{ipno} || $h->{hostname}, "INFO1",  10);
    my($hostid, $v, $master1, $perl_version) = split(/\s*\|\s*/, $rc);
    $v = Util->trim(substr($v,8)) if (length($v) > 8);
    
    if ($perl_version && $perl_version < $SUPPORTED_PERL_VERSION) {
         push(@L, $L->expand('perl',$h->{hostname}, $perl_version));
    }
    $HOSTS{$h->{hostname}{version}} = $v;
    if ($last_v) {
       if ($last_v ne $v) {
         push(@L, $L->expand('diff',$h->{hostname}, $v, $last_v));
       }
    } else {
      $last_v = $v;
    }
  }

  #Check Patch levels on master and slaves
  my (%R, %R2);

  ##################################
  # GET LOCAL and REMOTE PATCHES
  ##################################

  #get Local patches
  Agent::HOST->agent_patches(\%R2);
  $R{"Master"} = $R2{'id.patches.local'};

  # get all SUNWstade patches on slaves 
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my @HD ;

  foreach my $host0 (@$hosts) {
     next if ($host0->{dh} eq "Y");
     # Get info from remote host 
     my $rc = Util::Http->runss($host0->{ipno} || $host0->{hostname}, "installed_patches");

     my @A = split(/\n/, $rc);
     my $list;
     my $com_okay = 0;
     for (my $x=0; $x <= $#A; $x++) {
	if($A[$x] =~ /Getting patches/){
	  $com_okay = 1;
	}else{
           my(@a) = split(/\./, $A[$x]);
	   $list .= "$a[1]|";
	   
	}
     }
     if( $HOSTS{$host0->{hostname}{version}} !~ /2.1.05.003/) {
       #Only do this check if on 2.2 or later code
       if($com_okay != 1)
       {
          #failed to get information(if 2.2 or later code)
	  push(@L, $L->expand('err_11',  $host0->{hostname}));

       }
     }
     $R{$host0->{hostname}} = $list;
  }

  # have all the patch data, now compare
  my ($match, $x, $y);
  my ($key1, $key2, $name1, $name2);
  foreach $key1 (keys %R) {
     my @A = split(/\|/, $R{$key1});
     #index through all the patches from this host index key
     for ($x=0; $x <= $#A; $x++) {
	#Compare this patch with patches from other hosts
        foreach $key2 (keys %R) {
           next if ($key1 eq $key2);

	   if (index($R{$key2}, $A[$x]) < 0) {
              $name1 = $key1 eq "local" ? "Master" : $key1;
              $name2 = $key2 eq "local" ? "Master" : $key2;
	      push(@L, $L->expand('err_10',  $A[$x], $name1, $name2));
	   }
        }
     }
  }

  ####### END PATCHES check  #####  

  $active = 0; $found = 0;
  my (%NOCHECK, %IPS);
  for ($x0 = 0; $x0 <= $#$dev; $x0++) {
     $h = $dev->[$x0];
     next if (!$HOSTS{$h->{host} || 'LOCAL' });

     if (!$h->{host} && !defined($CAT{"H" . $h->{host}})) {
        push(@L, $L->expand('err_3',  $h->{host}, 
          "<a href=$Http::WEBPROC?GO=GUIAdmin::A5K::updDevice&no=$x0>" , $h->{name}));
     }
     next if ($h->{type} =~ /^se\d*/); # skip racks devices
     if (index($CAT{"H" . $h->{host}}, $h->{type}) < 0) {
        $hh = $h->{host} || System->hostname();
        $NOCHECK{$hh} .= "$h->{type}:$h->{name}, ";
     }
     $IPS{$h->{ipno}}++ if ($h->{ipno});
     $found++;
     if ($h->{active} eq "Y") {
        $active++;
     }
  }
  foreach my $ip (keys %IPS) {
     if ($IPS{$ip} > 1) {
        push(@L, $L->expand(found_devices => $IPS{$ip}, $ip ));
     }
  }

  foreach $x0 (keys %NOCHECK) {
     push(@L, $L->expand('err_4', $x0,  $NOCHECK{$x0}, "<a href=$Http::WEBPROC?GO=GUI::Hosts::list>" )); 
  }
     
  if (!$active) {
     push(@L, $L->expand('err_5', "<a href=$Http::WEBPROC?GO=GUI::Start::Devices>" ));
  }

  if ($found != $active) {
     push(@L, $L->expand('err_6', "<a href=$Http::WEBPROC?GO=GUI::Start::Devices>")); 
  }
 
  $active = 0;
  opendir(O, System->get_home() . "/lib/Provider");
  @list = readdir(O); closedir(O);

  foreach $x (@list) {
    next if ($x !~ /.pm$/);
    $name = substr(lc($x), 0, -3);
    $active = 1 if ($renv->{"pro.$name.active"} eq "Y");
  }

  if (!$active) {
     push(@L, $L->expand('err_7', "<a href=$Http::WEBPROC?GO=GUI::Providers::display>" ));
  }

  if ($#$notifs < 0) {
     push(@L, $L->expand('err_8', "<a href=$Http::WEBPROC?GO=GUI::Notifs::list>"));
  }


  # check for MPxIO failed over paths
  # Read in Topology
  my $To  = TO->readExistingTopo("MERGE-MASTER") || TO->readExistingTopo();
  if ($To) {
     my($storage) = $To->storageList();
     $co = 0;
     foreach my $st ( @$storage) {
        my($port_infos) = $st->portInfo();
	my($p);
	for ($p=0; $p <= $#$port_infos; $p++) {
           if ($port_infos->[$p]->{ProductID}  && 
	       $port_infos->[$p]->{ProductID} =~ /T300/ && 
	       $port_infos->[$p]->{PortMode} =~ /Primary/ &&
	       $port_infos->[$p]->{"Path State"} !~ /ONLINE/ ) {
		      push(@L, $L->expand( primary => $port_infos->[$p]->{dataHost}, 
		         $port_infos->[$p]->{LogicalPath},
		         $port_infos->[$p]->{dataHost},
		         $port_infos->[$p]->{LogicalPath},
		         $port_infos->[$p]->{dataHost},
		         $port_infos->[$p]->{LogicalPath}));
	   }
	}
     }
  }
  #end find mpxio path errors
  


  $out = Util->checkRasCrons();

  if ($out =~ /ERROR:/) {
     $out =~ s/\<font color=green\>.*\<\/font\>//;
     push(@L, "On Master: $out \n");
  }

  my $netc = `/usr/bin/pkginfo -q SUNWncon`;
  $netc = $?;
  # With -q option, if package is installed, return value will 0
  # If the package isn't stalled, a value greater than 0 will be returned.
  if ((!$netc)  && $renv->{'pro.netconnect.active'} ne "Y") {
     push(@L, $L->expand('err_9', "<a href=$Http::WEBPROC?GO=GUI::Providers::display>"));
  }

  
  return \@L;
}

sub frame {
  my($q) = @_;

  my $frame = $q->{frame} || "maintF";
  my $page = $q->{page};

  open(O, System->get_home() . "/htdocs/${frame}.html");
  my $out;
  while ($l = <O>) {
     if ($l =~ /src=.*Welcome/) {
        $out .= "src=$Http::WEBPROC?GO=$page\n";
     } else {
        $out .= $l;
     }
  }
  close(O);
  print $out;
}

sub logout {
  my $renv = System->get_renv();

  print "Http/1.0 401 Authorization Required\n";
  print "WWW-Authenticate: Basic realm=\"User\"\n\n";

  print "<body bgcolor=white><meta http-equiv=Refresh content=\"0;URL=/\">";
}



1;
 
