package GUI::Process;
#
# used to track reports coming from Revision Checking, FCCheck and other programs that run in
# the background. need ID and NAME as argument to find the right directories.

use Process;
use System;
use PDM::ConfigFile;
use strict;

# ID = Revision | FCCheck

sub list {
  my($q) = @_;
  my $ID = $q->{ID};
  my $NAME = $q->{NAME};
  my $deny = Roles->verifyRole($q, "admin");
  print Html->body();
  my $L = Labels->read("GUI::Process");
  my ($run, $l);
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  if ($q->{ACTION_save}) {
    my $save_cnt = 0;
    foreach my $x (keys %$q) {
      if (substr($x,0,4) eq "sel_") {
         $save_cnt++ ;
         my $name = substr($x,4);
         print "$name <br>\n";
         if ($name eq "local") {
            my $F = System->get_home() . "/DATA/tmp/$ID";
            my $date1 = Util->get_file_created($F);
            $date1 =~ s/ /_/g;
            open(R, $F);
            my $w = $renv->{hostname} . ".$date1";
            print "copying $w <br>\n";
            open(W, ">" . System->get_home() . "/DATA/${ID}_history/$w");
            while ($l = <R>) {
                print W $l;
            }
            close(R); close(W);
         } else {
            my $rc = Util::Http->readFile($name, "tmp/$ID");
            my $date1 = Util->get_today();
            $date1 =~ s/ /_/g;
            my $w = "$name.$date1";
            print "copying $w <br>\n";
            open(W1, ">" . System->get_home() . "/DATA/${ID}_history/$w");
            if ($rc) {
              print W1 $rc;
            }
            close(W1);
         }
      }
    }
    if (! $save_cnt ) {
        print"<font color=red><b>$L->{nothing}</b></font>";
    }
  }
  print  Html->header2(($q->{ID} eq "FCCheck") ? 
                        "diagnose.tools.fc_report": "diagnose.revision.report");


  my $st = Process->status("", $ID);
  my ($url, $sel, @array);
  $sel = "&nbsp;";
  if ($st =~ /Done/) {
     $url = "<a href=$Http::WEBPROC?GO=GUI::${ID}::readLastReport&host=>$L->{display}</a>";
     $sel = "<input type=checkbox name=sel_local>";
  } else {
     $url = $L->{noreport};
  }
  $run =1 if ($st =~ /Running/);
  push(@array, [$sel,  $L->{local}, $url, &display($L, $st) ]);

  foreach my $h (@$hosts) {
     my $st=  Process->status($h->{ipno} || $h->{hostname}, $ID);
     my $sel = "&nbsp;";
     if ($st =~ /Done/) {
        my $ip = $h->{ipno} || $h->{hostname};
        $url = "<a href=$Http::WEBPROC?GO=GUI::${ID}::readLastReport&host=$ip&hostname=$h->{hostname}>Display Report</a>";
        $sel = "<input type=checkbox name=sel_$h->{hostname}>";
     } else {
        $url = $L->{noreport};
     }
     $run =1 if ($st =~ /Running/);
     push(@array, [$sel,  $h->{hostname}, $url, &display($L, $st) ]);
  }

  my $scr = Html::Screen->new();
  $scr->add("<meta http-equiv=Refresh content=\"30;URL=$Http::WEBPROC?GO=GUI::Process::list&ID=$ID&NAME=$NAME\">") 
            if ($run);
  $scr->add(" <form> <input type=hidden name=GO value=GUI::Process::list>
       <input type=hidden name=ID value=$ID>
       <input type=hidden name=NAME value=\"$NAME\">
      ");
  $scr->list($q, { title => $L->{$ID}, interactive => 1 },
    [
    [ c => $L->{select} ],
    [ l => $L->{host}, '+' ],
    [ l => $L->{last} ],
    [ l => $L->{status} ],
    ],
    \@array, 
    [
    [ l => 'ACTION_save', $L->{save} , $deny ],
    ]);
  $scr->add("</form>");
  print $scr->out();

}

sub display {
  my($L, $v) = @_;
  my $v0 = $v;
  if (index($v0, "Done") >= 0) {
    return $L->{st_Done} . substr($v0,4);
  }
  $v =~ s/ //g;
  return $L->{"st_$v"} || $v0;
}

sub history {
  my($q) = @_;
  my $ID = $q->{ID};
  my $NAME = $q->{NAME};
  my $L = Labels->read("GUI::Process");
  my $deny = Roles->verifyRole($q, "admin");

  print Html->body();
  print "<center>&nbsp;";
  my $dirz = System->get_home() . "/DATA/${ID}_history/";
  if (!-d $dirz) { 
     print "Cannot find dir $dirz!<br>";
     return;
  }

  if ($q->{ACTION_del}) {
     my $del_cnt;
    foreach my $x (keys %$q) {
         if (substr ($x,0,4) eq "del_") {
            $del_cnt++;
            unlink "$dirz" . substr($x,4);
        }
    }
    if (!$del_cnt){
       print "<font color=red><b>$L->{nothing2}</b></font>";
    }
  }

  if ($q->{delete}) {
    unlink System->get_home() . "/DATA/${ID}_history/$q->{delete}";
    print " $q->{delete} deleted.<br>\n";
  }
  if($q->{ID} =~ /FCCheck/){
     print Html->header2("diagnose.tools.fc_history");

  } elsif ($q->{ID} =~ /Revision/) {
     print Html->header2("diagnose.revision.history", undef, $q->{ID});

  } else { 
     print Html->header2("service.service.rev_hist", undef, $q->{ID});
  }
  print "<table border=0><tr><td></table>";


  my $D = System->get_home() . "/DATA/${ID}_history";
  opendir(O, $D);
  my @L = readdir(O); closedir(O);

  my ($last, @array, $cnt, $sta);

  foreach my $h (sort @L) {
    next if (substr($h,0,1) eq ".");
    my $ix = rindex($h, ".");
    my $host = substr($h,0,$ix);
    my $date = substr($h,$ix+1);
    my $sel = "&nbsp;";
    my $del = "&nbsp;";
     my $lnk = "<a href=$Http::WEBPROC?GO=GUI::${ID}::readLastReport&hist=$h&hostname=$host>$date</a> ";
     $del = "<input type=checkbox name=del_$h value=$date>";
     push(@array, [ $del, $host, $lnk ]);
     $cnt++;
  }
  if (!$cnt) {
     push(@array, ["", $L->{nohistory} ]);
  }

  my $scr = Html::Screen->new({ });
  $scr->add(" <form> <input type=hidden name=GO value=GUI::Process::history>
      <input type=hidden name=ID value=$ID>
      <input type=hidden name=NAME value=\"$NAME\">
     ");

  $scr->list($q, { title => $L->{history_list}, interactive => 1 } ,
    [
    [ c => $L->{select} ],
    [ l => $L->{host},   '+' ],
    [ l => $L->{report}, '+' ],
    ],
    \@array,
    [
    [ l => 'DATA' , Html::Screen->submitButton("ACTION_del", $L->{delete}, undef,
              { confirm => $L->{sure} })  , $deny ],
    ]);

  $scr->add("</form>");
  print $scr->out();


}




1;

