package GUI::Perf;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use Roles;
use Util;
use strict 'vars';
use GUI::SAN;
use System;
use Data::Dumper;
use Perf;
use Html;


sub array {
  my($q) = @_;
  my(%D, $applet, $x, $summ, @X, $xvalues, $reset, $created, $x0);
  my($title, $x, $report_list, %DEV_MAP);
  my $VALID_DEVS = ",6020,6120,dsp,";

  print Html->body();
  print Html->header2("report.system.parray", undef,undef, undef, {});
  my $G = Labels->read();
  my $LB = Labels->read("GUI::Perf");
  my $today = Util->get_today();

  my $hostname = System->shortHostname();

  my $Config  = PDM::ConfigFile->read();
  my $devices = $Config->devices();
  my(%DEV);
  foreach my $d (@$devices) {
     next if (index($VALID_DEVS, ",$d->{type},") < 0);
     $DEV{$d->{name}} = $d;
  }
  &display_header($q, \%DEV);
  if (!$q->{dev}) {
     print Html->info("Select a device");
  }

  my $file = $q->{mode} eq "C" ? "stat1" : "stat3" ; # Current=1, Hourly=3
  my $T    = Perf->read($file);

  foreach my $n (sort keys %DEV) {
     my $d = $DEV{$n};
     if ($q->{dev} eq "ALL" || $q->{dev} eq $n) {
       my $footer = $d->{type} eq 'dsp' ? "Module/Port" : "Unit/Volume";
       &display_totals($q, $d, $T, $footer, $q->{mode} eq "C" ? "Current":"");
     }
  }
  print "</form>";
}

sub display_header {
  my($q, $devs) = @_;
  my $options;
  foreach my $d (sort keys %$devs) {
     my $ck = "selected" if ($d eq $q->{dev});
     $options .= "<option $ck>$d</option>";
  }
  my $ck = "selected" if ($q->{dev} eq "ALL");
  $options .= "<option $ck>ALL</option>";
  my $sels = "<select name=dev><option value=\"\">[Select Device]</option>$options</select>";

  my $gr_sel = Html->makeSelect("graph", "Y=Yes|N=No", $q->{graph});
  my $mode_sel = Html->makeSelect("mode", "C=Current Value|H=Hourly Average", $q->{mode});
    
  print "<table border=0><tr><td><form><input type=hidden name=GO value=GUI::Perf::array></table>";
  print "<table border=0 width=$Style::WIDTH bgcolor=#F0F0F0><tr>
   <td>&nbsp;
     Select Device: $sels &nbsp;
     Graphics: $gr_sel &nbsp;
     Report: $mode_sel &nbsp;".
     Html::Screen->submitButton("ACTION", "GO")
   ."</td><td>
     <img src=/gif/blue_dot.gif width=10>: MB/sec read<br>
     <img src=/gif/red_dot.gif width=10>: MB/sec written
   &nbsp;</table>";
}

#
# DSP  : 0= BytesRead, 1=BytesWritten, 
# Array: 0=BlocksRead, 1=BlocksWritten,  =512bytes, / 2048 = megs
# stat1 (total) is the io of the last probe.
#
sub display_totals {
  my($q, $dev, $T, $footer, $header) = @_;
  my $renv = System->get_renv();
  my (%EL, %G, $cols, $maxr);
  my ($col1, $col2);
  my $BLOCKSIZE = 65536;

  if ($q->{graph} eq "Y") {
     $col2 = "0 cellspacing=2 cellpadding=1"; $col1 = "1";
  } else {
     $col2 = "1 cellspacing=0 cellpadding=1"; $col1 = "0";
  }
  foreach my $k (sort keys %$T) {
     my($mode, $name, $el) = split(/\./, $k);
     next if ($name ne $dev->{name});
     my $secs  =  $T->{$k}[0];
     my $meg_r = $secs ? $T->{$k}[1] / $secs : 0; # megs / sec read
     my $meg_w = $secs ? $T->{$k}[2] / $secs : 0; # megs / sec written
     if ($dev->{type} eq "dsp") {
         $meg_r /= (1000 * 1024);
         $meg_w /= (1000 * 1024);
     } else {
         $meg_r = $meg_r * $BLOCKSIZE / 1024 / 1024;
         $meg_w = $meg_w * $BLOCKSIZE / 1024 / 1024;
     }
     $EL{$el} = 1;
     $G{$mode}{$el} = [$meg_r, $meg_w];
     $cols++;
     $maxr = $meg_r if ($meg_r > $maxr);
     $maxr = $meg_w if ($meg_w > $maxr);
  }
  my $c1  = $cols*2 +1;
  my $t1 = $dev->{type} eq "dsp" ? "DSP" : "Array";
  print "\n
   <table border=0 cellpadding=2><tr><td></table>
   <table border=$col1 cellspacing=0 cellpadding=1 width=$Style::WIDTH>
   <tr><td bgcolor=$Style::DARK><font color=white><b>&nbsp;$t1 $dev->{name}</td>
   <tr><td>
       <table border=$col2 width=100%>
   ";
  $maxr = 1 if (!$maxr);
  if ($q->{graph} eq "N") {
    print "<tr><td>&nbsp;</td>";
    foreach my $e (sort keys %EL) {
      print "<th>r</th><th>w</th>";
    }
  }
  foreach my $m (sort keys %G) {
   my $V = $G{$m};
   my $head = $q->{mode} eq "C" ? $header : &hour($m);
   print "<tr><td width=10% bgcolor=#F0F0F0 valign=bottom align=right><b>$head&nbsp;</td>";
   foreach my $e (sort keys %EL) {
     my $v0 = $G{$m}{$e}[0];
     my $v1 = $G{$m}{$e}[1];
     my $h_r =  int($v0/$maxr * 100) || 1;
     my $h_w =  int($v1/$maxr * 100) || 1;
     my $r_v = sprintf("%.1f", $v0);
     my $w_v = sprintf("%.1f", $v1);
     my ($img_r, $img_w);
     if ($q->{graph} eq "Y") {
       $img_r = "<br><img src=/gif/blue_dot.gif width=10 height=$h_r>";
       $img_w = "<br><img src=/gif/red_dot.gif width=10 height=$h_w>";
     }

     print "<td valign=bottom ><center>
                 <font color=blue>$r_v</font>$img_r</td>
            <td valign=bottom><center>$w_v$img_w</td>
            ";
    }
    &printFooter($footer,\%EL) if ($q->{graph} eq "Y");
  }

  &printFooter($footer,\%EL) if ($q->{graph} eq "N");
  print "</table></table>";
}

sub printFooter {
  my($footer,$EL) = @_;
  print "<tr><td bgcolor=#F0F0F0 align=right><b>$footer&nbsp;</td>";
  foreach my $e (sort keys %$EL) {
      print "<td colspan=2 bgcolor=#F0F0F0><center><b>$e</td>";
  }
}



sub hour {
  my($v) = @_;
  my $v0 = substr($v,0,5);
  my $v1 = substr($v,6,2);
  my $v2;
  if ($v1 > 12) {
    $v2 = ($v1-12) . "pm";
  } else {
    $v2 = $v1 . "am";
  }
  return "$v0 $v2";
}
             
   
1;
