package GUI::Notifs;

#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
#  $Id: Notifs.pm,v 1.24 2003/12/16 07:13:37 ggibson Exp $

use Labels;
use Agent;
use  Html::Tabs;
use  Html::Screen;
use strict;
use MaxEvents;

sub get_PRIO {
  my $G = Labels->read();
  return (
           9 => "$G->{sev1S}+$G->{sev2S}+$G->{sev3S}", 
           0 => $G->{sev0}, 
           1 => $G->{sev1S}, 
           2 => $G->{sev2S}, 
           3 => $G->{sev3S},
           91 => "$G->{sev2S}+$G->{sev3S}",
          '*' => $G->{all}
          );
}


sub list {
  my($q) = @_;
  my($ho, $o);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs')->section("email");
  my $Lang = Util->languageList(1);
  my $renv = System->get_renv();
  my($info);

  print Html->body();
  if ( Util->findMaster()) {
    print "\n<h1><center>$G->{e_101}";
    return;
  }

  if ($q->{ACTION_del}) {
     my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
     my $cnt;
     foreach my $el (keys %$q) {
        if ($el =~ /^del_(\d+)/) {
          my $no = $1;
          $notifs->[$no] = undef; $cnt++;
        }
     }
     PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);
     $info = Html->info($L->expand( deleted => $cnt)) ; 
     
  } elsif ($q->{ACTION_add}) {
     &add($q);
     return;
  } elsif ($q->{ACTION_max}) {
     MaxEvents->delete();
     print Html->info($L->{'email.reset_done'});
  } 
  print Html->header2("admin.not_maint.email", undef, undef, {noHelp => 1});
  print $q->{WARN} if ($q->{WARN});
  print $info;
#  if ($renv->{solution} eq "se2" && !$renv->{sendmail_server}) {
#    print Html->warning($L->{set_sendmail});
#  }
  &emaillist($q);
}



sub emaillist {
  my($q) = @_;
  my ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
  my %PRIO = &get_PRIO();
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs');
  my($x, $h, $lnk, $type, $device, $prio, $ho);
  my @array;
  for ($x=0; $x <= $#$notifs; $x++) {
    $h    = $notifs->[$x];
    my $val = $h->{email} || $h->{script};
    $lnk  = "[ <a href=$Http::WEBPROC?GO=GUI::Notifs::upd&no=$x><b>$L->{'email.update'}</b></a> ] $val";
    $type = $h->{type};
    $device = ($h->{device}   eq "*") ? $G->{all}: $h->{device};
    $prio   = ($h->{priority} eq "*") ? $G->{all}: $PRIO{$h->{priority}};
    my @a      = split(/\|/,  $h->{event});

    my $grp = $h->{groups} || $G->{all};
    my $del = "<input type=checkbox name=\"del_$x\">";
    my $act = $h->{active} eq "N" ? $G->{no} : $G->{yes};
    push(@array, [$del, $type, $lnk, $act, $device, $prio, $grp, ]);
  }
  if ($#$notifs < 0) {
     push(@array, ["<b>$L->{'email.err_1'}"]);
  }
  my $scr = Html::Screen->new();
  $scr->add("<form  method=get> <input type=hidden name=GO value=GUI::Notifs::list>$q->{ERR}");

  $scr->list($q, {title => $L->{'email.l2'}, interactive => 1 },
     [
     [ c => $L->{'email.del'}    ],
     [ c => $L->{'email.l3'}     ],
     [ l => $L->{'email.l4'}     ],
     [ l => $L->{'email.active'} ],
     [ c => $L->{'email.l5'}     ],
     [ l => $L->{'email.l7'}     ],
     [ l => $L->{'email.groups'} ],
     ],
     \@array, 
     [
     [ l => 'ACTION_del' , $L->{'email.delete'},    $deny ],
     [ l => 'ACTION_add' , $L->{'email.submit1'},   $deny ],
     [ l => 'ACTION_max',  $L->{'email.reset_max'}, $deny ],
     ]);

  $scr->add("</form>");
  print $scr->out();
}

sub selectAgents {
  my($select);
  my($cat) = Agent->findSelectableAgents();
  my ($c0);
  foreach $c0 (@$cat) {
     my ($c, $c2) = split(/\=/, $c0);
     my $n1 = Util->abb(lc($c) . ".medium") || $c;
     $select .= lc($c)  ."=$n1|";
  }
  chop($select) if ($select);
  return $select;
}

sub upd {
  my($q) = @_;
  my($ho, $o);
  my($name,$renv, $dev, $hosts, $notifs);

  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs');
  my $deny = Roles->verifyRole($q, "admin");
  my($err, $renv, $dev, $host, $notifs, $x, $h);

  if ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;
  } elsif ($q->{ACTION_update}) {
    print Html->body();
    my @SCR = split(/\s+/, $q->{script});
    if ($q->{script}) {
      if (!-x $SCR[0]) {
         print Html->warning($L->expand('email.err_2', $q->{script}));
      }
    } elsif (!$q->{email}) {
        $err = Html->error($L->{'email.err_3'});
        goto out;
    }
    ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;

    my $x = $q->{no};
    $notifs->[$x]{email}  = $q->{email};
    $notifs->[$x]{device} = $q->{device};
    $q->{group}  = "" if (index($q->{group} , "_ALL_") >= 0);
    $q->{group} =~ s/\t/\|/g;
    $notifs->[$x]{groups}   = $q->{group};
    $notifs->[$x]{active} = $q->{active};
    $notifs->[$x]{type}   = $q->{type};
    $notifs->[$x]{skip_agg} = $q->{skip_agg} ? 1:0;
    #$notifs->[$x]{include_graph} = $q->{graph} ? 1:0;
  
    $notifs->[$x]{language} = ""; # $q->{language};
    $notifs->[$x]{script}   = $q->{script};
    $notifs->[$x]{no_grid}  = $q->{no_grid} ? "Y" : "N";
    $notifs->[$x]{priority} = $q->{priority};
    $notifs->[$x]{device} = "*" if (!$q->{device});
    $notifs->[$x]{apply_filters}  = $q->{filters} ? "Y" : "N";
    $notifs->[$x]{event}     = "*" ;

    PDM::ConfigFile->write($renv, $dev, $host, $notifs);
    $err = Html->info($L->{'email.info_1'});

  } elsif ($q->{ACTION_delete}) {
    print Html->body();
    ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $notifs->[$x]{_name} = "";
    $name = $notifs->[$x]{email};
    PDM::ConfigFile->write( $renv, $dev, $host, $notifs);
    $q->{ERR} = Html->warning($L->expand('email.info_2', $name));
    &list($q);
    return;

  }
out:
  print Html->body();
  print Html->header2("admin.not_maint.email", undef, "#2");

  ($renv, $dev, $hosts, $notifs) = PDM::ConfigFile->read();
  $h = $notifs->[$q->{no}];
  my %PRIO = &get_PRIO();

  my $device = ($h->{device} eq "*")? $G->{all}: $h->{device};
  my $prio   = ($h->{priority} eq "*")? $G->{all}: "$h->{priority}: $PRIO{$h->{priority}}";

  my $sel = &priorities();
  my $priority = "<select name=priority >" . Html->select($sel, $h->{priority});

  my @a      = split(/\|/,  $h->{event});
  my $events = "";
  my %w = ();
  foreach $x (@a) {
    $w{'event_'.$x} = 1;
  }

  my $select = &selectAgents();

  $device   = Html->makeSelect("device", "*=$L->{'email.l9'}|$select", $h->{device},
                  {multiple => 4} );
  #$events = "<select name=event size=8 multiple>".
  #            Html->select("*=$L->{'email.l1'}|" . &find_events , $h->{event}, 1);

  my $lang = Html->makeSelect("language", Util->languageList(), $h->{language});

  my $email_type = Html->makeSelect("email_type",
           "S=$L->{'email.type_s'}|C=$L->{'email.type_c'}" , $h->{email_type},
              {multiple => 2} );
  my $agg = "checked" if ($h->{skip_agg});
  #my $graph = "checked" if ($h->{include_graph});
  my ($t1, $val_label, $val);
  if ($h->{type} eq "Script") {
     $t1 = $L->{'email.script'};
     $val_label = $L->{'email.l12'};
     $val = "<input type=text name=script value=\"$h->{script}\" size=50>
             [ <a href=javascript:win2()>$G->{help}</a> ]";
  } else {
     $t1 = $h->{type} eq "Email" ? $L->{'email.l22'} : $L->{'email.l23'};
     $val_label = $L->{'email.l11'};
     $val = "<input type=text name=email value=\"$h->{email}\" size=40>";
  }
  my $no_grid = "checked" if ($h->{no_grid} eq "Y");
  my $filters = "<input type=checkbox name=filters " . ($h->{apply_filters} eq "Y"? "checked":"") . ">";
  my $groups = &groups($h->{groups});
  my $scr = Html::Screen->new();
  $scr->script("
    function win2(t) {
      var b = 'email_script.html';
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=600,height=500');
      O.focus();
    }
    ");
  my $act = Html->makeSelect("active", "Y=$G->{yes}|N=$G->{no}", $h->{active});
  $scr->add("<form  method=get>
 <input type=hidden name=GO value=GUI::Notifs::upd>
 <input type=hidden name=no value=$q->{no}>
    ");
  $scr->table( {title => $L->{'email.l10'}, error => $err , labelWidth => "35%"},
     [
     [ f => $L->{'email.l3'}, "<input type=hidden name=type value=$h->{type}>&nbsp;$t1"],
     [ f => $val_label, $val ],
     [ f => $L->expand('email.isactive', $t1) , $act ],
     [ f => $L->{'email.l5'}, $device ],
     [ f => $L->{'email.l7'}, $priority],
     [ f => $L->{'email.groups'}, $groups],
     [ f => $L->{'email.filters'}, $filters],
     [ f => $L->{'email.skip_agg_parts'}, "<input type=checkbox name=skip_agg $agg>" ],
     [ f => $L->{'email.no_grid'}, "<input type=checkbox name=no_grid $no_grid>" ],
     ]);

  $scr->button2( [
     [ l => 'ACTION_update',  $G->{submit_update}, $deny ],
     [ l => 'ACTION_delete',  $G->{submit_delete}, $deny ],
     [ r => 'ACTION_back',    $G->{submit_back}],
      ]);
  $scr->add("</form>");
  print $scr->out();
}

sub priorities {
  my $sel;
  my  %PRIO = &get_PRIO();
  
  foreach my $k (9,91,1,2,3,'*',0) {
    my $xx = "$k=$PRIO{$k}";
    $sel .= $xx;
    $sel .= " ($k)" if ($k >= 0 && $k < 9 && $k ne '*');
    $sel .= "|";
  }
  chop($sel);
  return $sel;
}
sub groups { 
  my($val) = @_;

  my $G = Labels->read();
  my $Group = Util->deserialize("admin_groups");
  my $groups = "<select name=group multiple size=2><option value=_ALL_>$G->{all}</option>";
  foreach my $e (keys %$Group, 'SYSTEM') {
    my $sel = "selected" if (index("|$val|", "|$e|") >= 0);
    my $v;
    if ($e eq "SYSTEM") {
        $v = "System/Agent Events";
    } else {
        $v = $Group->{$e};
    }
    $groups .= "<option $sel value=\"$e\">$e - $v</option>";
  }
  $groups .= "</select>";
  return $groups;
}

sub add {
  my($q) = @_;
  my($ho, $o, $err);

  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs')->section('email');
  my($renv, $dev, $host, $notifs, $info);

  if ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;

  } elsif ($q->{ACTION_add1}) {
    print Html->body();
    while (1) {
     my @SCR = split(/\s+/, $q->{script});
     if ($q->{script} && $q->{email}) {
        $err = Html->error($L->{both});
        last;
     }
     if ($q->{type} eq "Script") {
        if (!$q->{script}) {
          $err = Html->error($L->{script_err});
          last;
        } elsif (!-x $SCR[0]) {
          $q->{WARN} .= Html->warning($L->expand('err_2', $q->{script}));
        }
     }
     if ($q->{type} ne "Script" && $q->{email} !~ /^.+\@.+/) {
        $err = Html->error($L->{err_4});
        last;
     } else {
        ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
        my $x = $#$notifs + 1;
        $notifs->[$x]{_name}    = "notification" . ($x+1);
        $notifs->[$x]{email}    = $q->{email};
        $notifs->[$x]{device}   = $q->{device};
        $q->{group}  = "" if (index($q->{group} , "_ALL_") >= 0);
        $q->{group} =~ s/\t/\|/g;
        $notifs->[$x]{groups}   = $q->{group};
        $notifs->[$x]{language} = "";
        #$notifs->[$x]{include_graph} = $q->{graph} ? 1:0;
        $notifs->[$x]{script}   = $q->{script};
        $notifs->[$x]{apply_filters}  = $q->{filters} ? "Y" : "N";
        $notifs->[$x]{skip_agg} = $q->{skip_agg} ? 1:0;
        $notifs->[$x]{no_grid}  = $q->{no_grid} ? "Y" : "N";
        $notifs->[$x]{type}     = $q->{type};
        $notifs->[$x]{priority} = $q->{priority};
        $notifs->[$x]{device} = "*" if (!$q->{device});

        $notifs->[$x]{event}     = "*" ;

        if (!PDM::ConfigFile->write($renv, $dev, $host, $notifs)) {
           $q->{WARN} .= "$G->{'e_100'} <br>";
        } else {
           $q->{WARN} .= Html->info($L->{info_3});
        }
        $q->{option} = "";
        &list($q);
        return;
     }
     last;
    }
  }
out:
  print Html->body();
  print Html->header2("admin.not_maint.email", undef, "#3");
  my $scr = Html::Screen->new();
  $scr->script("
    function win2(t) {
      var b = 'email_script.html';
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=600,height=500');
      O.focus();
    }
    ");
  my $select = &selectAgents();

  my $device = "<select name=device size=4 multiple><option value=*>$L->{all_cat}</option>" .
              Html->select($select, $q->{device});
  
  my $sel = &priorities() ;
  my $priority = "<select name=priority>" . Html->select($sel, $q->{priority});
  my $ev = "";
  $ev = &display_event_list($q, '-h');
  my $evH = &display_event_list($q, 'h');

  my $events = "<select name=event size=5 multiple><option value=*>$L->{l1}</option>" .
              Html->select(&find_events);
  my $lang = Html->makeSelect("language", Util->languageList());
  my $email_type = Html->makeSelect("email_type", "S=$L->{type_s}|C=$L->{type_c}",
            "C", {multiple => 2});
  my $groups = &groups();
  my ($radio, $script);
  my $sel = $q->{type} || 'Email';
  my @LIST = ('Email|l22','Pager|l23');
  $renv = System->get_renv();

  if ($renv->{solution} eq "N") {
     push(@LIST, "Script|script") ;
     $script = [ f => "$L->{or} $L->{l12}", "<input type=text name=script  size=50>
                     [ <a href=javascript:win2()>$G->{help}</a> ] "];
  }

  foreach my $e (@LIST) {
    my($r, $lb) = split(/\|/, $e);
    my $ck = $r eq $sel ? "checked" : "";
    $radio .= "<input type=radio name=type value=$r $ck>:$L->{$lb}&nbsp;&nbsp;";
  }

  my $filters = "<input type=checkbox name=filters>";
  $scr->add(" <form  method=get> <input type=hidden name=GO value=GUI::Notifs::add> $err");

  $scr->table( {title => $L->{l20}, },
    [
     [ f => $L->{l21}, $radio ],
     [ f => $L->{l24}, "<input type=text name=email size=40 maxlength=60 value=\"$q->{email}\">"],
     $script,
     [ f => $L->{l7},   $priority   ],
     [ f => $L->{l5},   $device     ],
     [ f => $L->{groups},   $groups ],
     [ f => $L->{filters},  $filters],
     [ f => $L->{skip_agg_parts},  "<input type=checkbox name=skip_agg checked>"],
     [ f => $L->{no_grid},         "<input type=checkbox name=no_grid>" ],
     ]);

   $scr->button2( [
       [ l => 'ACTION_add1',  $G->{submit_add} ],
       [ l => 'ACTION_back',  $G->{submit_back} ],
       ]);
   $scr->add(" </form>");
   print $scr->out();

}

sub display_event_list {
  my($q, $filter) = @_;
  my($x, $ck, $out);

  foreach $x (sort keys %{Event->get_types} ) {
     if (substr($filter,0,1) eq "-") {
        next if (Event->get_category($x) eq substr($filter,1));
        $ck = ($q->{"event_$x"})? "checked":"";
        $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";

     } else {
       if (Event->get_category($x) eq $filter) {
         $ck = ($q->{"event_$x"})? "checked":"";
         $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";
       }
     }
  }
  return $out;
}


sub find_events {
  my $ruser = System->get_ruser();
  my $renv = System->get_renv();
  my($l);
  my $lang = $ruser->{language} || $renv->{language};

  my $F = System->get_home() ."/Lang/System/Labels/$lang/Events.lb";
  if (-f $F) {
    open(O, $F);
  } else {
    open(O, System->get_home() . "/System/Labels/Events.lb");
  }
  my($out); 
  while ($l = <O>) {
    chop($l);
    $l =~ s/\s*=\s*/=/;
    $out .= "$l|";
  }
  close(O);
  chop($out);
  return $out;
}


1;
