package GUI::MessageLog;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: MessageLog.pm,v 1.6 2004/01/13 00:06:25 ccadieux Exp $

use System;
use Util::Http;

sub process {
  my($array, $renv, $l, $label, $code) = @_;
  my ($name, $host, $type);
  if (exists $renv->{GSV_NAME}) {
    $type = "Master";
    $host = "local";
  } else {
    $type = "Slave";
    $host = $renv->{hostname};
  }
  $name = $renv->{hostname};
  my $ex;
  if ($type eq "Master") {
    $ex = -f $l;
  } else {
    my $ip = $renv->{ipno};
    $ex = Util::Http->getCommand($ip, "FILES&file=../../../../$l");
    $ex = 0 if ($ex =~ /Size=0/);
  }
  if ($ex) {
    my $l2 = $l; $l2 =~ s/\/var\/adm\///;
    my $url = "<a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=$host&file=$code>$l2</a>";
    my $ip = $renv->{ipno} ||Util->name2ip();
    push(@$array, [ "$name / $ip", $label, $url ]);
  }
}


sub makeList {
  my($array, $renv, $hosts, $file ) = @_;
  my($x);
  foreach my $log ($renv, @$hosts) {
    return $log->{logfile} if ($file eq "log");
    $o .= &process($array, $log, $log->{logfile}, "MessageLog", "log");
    for ($x=1; $x <= 2; $x++) {
      return $log->{logfile}.".$x" if ($file eq "log$x");
      &process($array, $log, "$log->{logfile}.$x", "MessageLog", "log$x");
    } 
    return "/var/adm/trap_messages" if ($file eq "trap");
    &process($array, $log, "/var/adm/trap_messages", "TrapLog", "trap") if (exists $log->{GSV_NAME});

    my @L = split(/\s+/, $log->{t300logfile});
    my($x);
    for ($x=0; $x <= $#L; $x++) {
      return $L[$x] if ($file eq "array$x");
      &process($array, $log, $L[$x], "ArrayLog", "array$x");
    }
    return "/var/adm/messages.3310" if ($file eq "3310");
    &process($array, $log, "/var/adm/messages.3310", "3510_MessageLog", "3310");

    return "/var/adm/messages.dsp" if ($file eq "dsp");
    &process($array, $log, "/var/adm/messages.dsp", "DSP_MessageLog", "dsp")
  }
}
  
sub list {
  my($q) = @_;

  $hname = System->hostname;
  $hid = System->hostid;
  $ip  = System->local_ip;
  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
  my $L = Labels->read('GUI::MessageLog')->section('list');
  my $G = Labels->read();
  print Html->body();
  print Html->header2("monitor.log.messages");

  my(@array);
  $LAST = "";
  $ERR = "";
  &makeList(\@array, $renv, $hosts);

  my $scr = Html::Screen->new();
  $scr->add(" <form  method=get><input type=hidden name=GO value=start>");

  $q->{SORT} = 1 if (!$q->{SORT});
  $scr->list($q, { title => $L->{label}, interactive => 1 },
   [
   [ l => $L->{hostname}, '+sn' ],
   [ l => $L->{log_type}, '+' ],
   [ l => $L->{log} , '+' ],
   ],
   \@array,
   );
   print $scr->out();
}

sub list2 {
  my($q) = @_;
  my(@a, $cnt, $name, $more, $more4, $more8); 

  my $LB = Labels->read('GUI::MessageLog')->section('list');
  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
  my(@array);
  print Html->body();
  print '</center>';
  $menu = "<td align=right><b>[ <a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&file=$q->{file}&host=$q->{host}>$LB->{refresh}</a> | <a href=$Http::WEBPROC?GO=GUI::MessageLog::list>$LB->{list}</a> ]
   </td>
   ";

  $q->{size} = 40 if (!$q->{size});
  $q->{size} = 80 if ($q->{size} > 80);

  my $FILE = &makeList(\@array, $renv, $hosts, $q->{file});

  if ($q->{host} eq "local") {
     $hname = System->hostname;
     my($size) = int ((stat($FILE))[7] / 1000);
     $more4 = 
      "<a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=local&file=$q->{file}&size=40>$LB->{k40}</a>";
     $more4 = "<b>$more4</b>" if ($q->{size} eq 40);
     if ($size > 40) {
       $more8 = " | <a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=local&file=$q->{file}&size=80>$LB->{k80}</a>";
       $more8 = "<b>$more8</b>" if ($q->{size} eq 80);
  
     }

     print "<table border=0 cellspacing=0 cellpadding=3 width=100% bgcolor=#D0D0D0>
          <tr><td><b>$q->{file} $LB->{local} /$hname&nbsp; ($LB->{size}: ${size}K) <br>
            </b> [ $more4  $more8 ]</td>
              $menu
            </table><small>";
     if (open(O, $FILE)) {
        my $size0 = (stat($FILE))[7];
        my($s1) = $q->{size} * 1000;
        if ($s1 < $size0) {
          seek(O,- $s1, 2);
          $l = <O>;
        }
        while ($l = <O>) {
           if (substr($l,0,1) eq "\t") {
             $a[$#a] .= $l;
           } else {
             push(@a, $l);
           }
        }
        close(O);
        for ($x=$#a; $x >= 0; $x--) {
          print "$a[$x]<br>";
        }
     } else {
        print "Cannot read $q->{file}: $!<br>";
     }
     print "&nbsp;<p>";

#
# SLAVE
#
  } else {
     ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
     foreach $h (@$host) {
       if ($h->{ipno} eq $q->{host}) {
         $name = $h->{hostname};
         last;
       }
     }
     print "$LB->{calling} $q->{host}...<br>\n";

     $page = Util::Http->getCommand($q->{host}, 
                    "GUI::MessageLog::read&file=$FILE&size=$q->{size}", 
                    $main::TO) || "Error";

     $ix = index($page, "\t");
     $size = substr($page,0,$ix) if ($ix > 0);

     $more4 = 
      "<a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=$q->{host}&file=$q->{file}&size=40>Display 40K</a>";
     $more4 = "<b>$more4</b>" if ($q->{size} eq 40);

     if ($size > 40) {
       $more8  = 
      " | <a href=$Http::WEBPROC?GO=GUI::MessageLog::list2&host=$q->{host}&file=$q->{file}&size=80>Display 80K</a>";
       $more8 = "<b>$more8</b>" if ($q->{size} eq 80);
     }

     print "<table border=0 cellspacing=0 cellpadding=3 width=100% bgcolor=#D0D0D0>
          <tr><td><b>$FILE $name on $q->{host}&nbsp; ($LB->{size}: $q->{size}K) <br>
            </b> [ $more4  $more8 ]</td>
              $menu
            </table><small>";

     print $header;
     print substr($page,$ix);
  }
}


sub get_read {
  my($q) = @_;
  my(@a);
  print "\n";
  $q->{size} = 40 if (!$q->{size});
  $q->{size} = 80 if ($q->{size} > 80);

  my $LB = Labels->read('GUI::MessageLog')->section('list');

  my($s1) = $q->{size} * 1000;

  if (open(O, $q->{file})) {
     my $size0 = (stat($q->{file}))[7];
     my $size  = int($size0/1000);
     print "$size\t";
     if ($s1 < $size0) {
        seek(O,- $s1, 2);
        $l = <O>;
     }
     while ($l = <O>) {
        push(@a, $l);
     }
     close(O);
     for ($x=$#a; $x >= 0; $x--) {
       print "$a[$x]<br>";
     }
  } else {
     print "\n$LB->{cannot_read} $q->{file}: $!<br>";
  }
}



1;

