package GUI::Instr;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Instr.pm,v 1.57 2003/12/18 07:30:31 ccadieux Exp $

use Util;
use Grid;
use Labels;
use Launch;
use Html;
use System;
use AdminGroup;
#use Agent;
use Modules;
use Report;
use State;
use strict;
#
#  dates are in ISO8601 (e.g. "1972-09-24 20:05") 
use vars qw($FRAME2);
$FRAME2 = "BS";

use vars qw (@Map);

sub frame {
  my($q) = @_;
  my($renv) = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};

  if (index($FRAME2, $window) < 0 || $q->{DOC}) {
     GUI::Instr::explore($q);
  } else {
     print Html->text_header();
     print <<EOF;
<frameset cols=50%,* border=1>
  <frame src=$Http::WEBPROC?GO=GUI::Instr::explore name=top  scrolling=auto>
  <frame src=$Http::WEBPROC?GO=GUI::Navigation::help2&ROOT=monitor.devices&file=monitordevice&NOHREF=9 name=tree scrolling=auto>
</frameset>

EOF
  }
}

sub header {
  my($q,  $url0, $title, $url, $window) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $window= $ruser->{window} || $renv->{window};

  my $Config = PDM::ConfigFile->read();
  my $d = $Config->deviceByKey($q->{file});
  my $n = "[" . ($d->{name} || $q->{file}) . "]";
  $n =~ s/host:// if ($renv->{solution} ne "N");

  my $u = " $title $n"; # if (index($FRAME2, $window) < 0);
  my $sec = $q->{LINKH} ? "diagnose.test.topo_test" : ($q->{topo} ? "monitor.topo" : "monitor.devices");
  print Html->header2($sec, undef, $u, undef, {lastLink => 1, noDoc => 1} );

  #} else {
  #  print "</center><b>$title</b><center>";
  #}
  print "<table border=0><tr><td></table>";
  print "<table border=0 width=$Style::WIDTH cellspacing=0><tr><td nowrap>$url</table>";
  print "<table border=0><tr><td></table>";
}

sub rStart {
  my($q) = @_;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart') ;
  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();
  my $window= $ruser->{window} || $renv->{window};

  my $summ  = $window eq "B" ? $L->{summary2}: $L->{summary};

  my $select ="<table border=0 cellspacing=0 cellpadding=0><tr><td>
      <form>
      <input type=hidden name=GO value=GUI::Instr::rStart>
      <input type=hidden name=host value=\"$q->{host}\">
      <input type=hidden name=file value=\"$q->{file}\">
      <input type=hidden name=topo value=\"$q->{topo}\">
      <input type=hidden name=_name value=\"$q->{_name}\">";

  $select .= "<input type=hidden name=LINKH value=1>" if ($q->{LINKH});
  $select .= "</td><td>$L->{select_page}: <select name=Roption onchange=form.submit() >";
  
  my ($maxd, $tst,$default);
  if ($q->{topo}) {
     $default = $q->{LINKH} ? 6: 1;
  } else {
     $default = 1;
  }
  my $current = $q->{Roption} || $default;
  
  my $syslog = "7=$L->{logSys}" if ($q->{file} =~ /^se\d*:/);
  foreach my $e ( "1=$summ", "2=$L->{alerts}", 
                 "3=$L->{log}", $syslog,
                 "4=$L->{report}",
                 "5=$L->{graph}","6=$L->{test}") {
     my($no, $label) = split(/=/, $e);
     next if (!$no);
     my $def = "selected" if ($no eq $current);
     $select .= "<option value=$no $def>$label</option>";
  }
  $select .= "</select></td><td></td><td>" .
     Html::Screen->submitButton("ACTION", $G->{go})  . 
          "</td><td> </form></table>";
     
  $maxd    = 6;

  $q->{Roption} = $default if (!$q->{Roption});

  print Html->body();
  print "<a name=top>";
  my $url = $select;

  if ($q->{Roption} == 2) {       # ALARMS
     &header($q, undef, $L->{alerts}, $url, $window);
     &state($q);

  } elsif ($q->{Roption} == 6) {  # TEST
     &header($q, undef, $L->{diag}, $url, $window);
     $q->{enc} = "$q->{file}:e";
     delete($q->{file});
     $q->{TAB} = 1;
     require GUI::Test;
     GUI::Test::get_test($q, 1); 

  } elsif ($q->{Roption} == 7) {  # LOG
     require GUI::EventLog;
     &header($q, undef, $L->{log}, $url, $window);
     $q->{NOBACK} = 1;
     $q->{SYSTEM} = 1;
     GUI::EventLog::display($q);

  } elsif ($q->{Roption} == 3) {  # LOG
     require GUI::EventLog;
     &header($q, undef, $L->{log}, $url, $window);
     $q->{NOBACK} = 1;
     GUI::EventLog::display($q);

  } elsif ($q->{Roption} == 4) {  # REPORT
     &header($q, undef,  $L->{report}, $url, $window);
     &explore1($q); 

  } elsif ($q->{Roption} == 5) {  # GRAPH
     &header($q, undef, $L->{graph}, $url, $window);
     &state($q, 1); 
  } else {                        # SUMMARY
     &header($q , undef, $summ, $url, $window);
     &report($q);  
  }
}


sub reverse {
  my($d) = @_;
  return (3000 - substr($d,0,4)) .   # year
         (20 - substr($d,5,2))   .   # month
         (40-substr($d,8,2))     .   # day
         (999999- (substr($d,11,2).substr($d,14,2).substr($d,17,2)));
}

sub short {
  my($e) = @_;
  my $ix = index($e,".");
  if (ord(substr($e,0,1)) > 57 && $ix > 0) {
    return substr($e,0,$ix);
  } else {
    return $e;
  }
}

sub explore {
  my($q, $post, $util) = @_;
  my(%D, $data, $head);
  print Html->body();
  ($q->{host})   = split(/\t/, $q->{host});
  ($q->{GROUP})  = split(/\t/, $q->{GROUP});
  ($q->{PREFIX}) = split(/\t/, $q->{PREFIX});

  my($renv, $dev, $hosts, $notifs, $Config) = PDM::ConfigFile->read;
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  my(%MAP);
  my($local) = System->hostname();

  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('explore') ;
  my (%LABEL, %MGMT);
  if ($q->{ACTION_CLEAR}) {
       State->clearAllComponents();
  }
  if ($renv->{solution} ne "N") {
     $MGMT{"host:$renv->{hostname}"} = "C";
  }
  my $x;
  for ($x=0; $x <= $#$hosts; $x++) {
     $MAP{$hosts->[$x]{hostname}} = $hosts->[$x];
  }
  my $sel     = ($q->{host} eq "ALL")? "selected":"";
  my $sel1    = ($q->{host} eq "local")? "selected":"";
  my $sel2    = ($q->{host} eq "HIDE")? "selected":"";
  my($hostsD) = "<select name=host><option value=ALL $sel>[$L->{all_hosts}]</option>".
                "<option value=HIDE $sel2>[$L->{hide}]</option>" .
                "<option value=local $sel1>" . &short($local) . "</option>";
  foreach my $hname (sort keys %MAP) {
     my $h = $MAP{$hname};
     if ($h->{solution} ne "N") {
        $MGMT{"host:$h->{hostname}"} = "C";
     }
     my $sel  = ($h->{hostname} eq $q->{host})? "selected":"";
     $hostsD .= "<option value=\"$h->{hostname}\" $sel>" . &short($h->{hostname})  ."</option>";
  }

  $hostsD    .= "</select>";
  my $groups = AdminGroup->new();

  $q->{GROUP} = $ruser->{adm_group} if (!exists $q->{GROUP} && $ruser->{adm_group});

  my $groupsD = $groups->select("GROUP", $q->{GROUP}, $L->{all_groups});

  my $val = $q->{PREFIX} || $G->{search};
  my $tstamp = Util->get_today();
  print Html->header2("monitor.devices");
  my $prefix = $q->{PREFIX} eq $G->{search} ? "" : $q->{PREFIX};

  my $HIDEHOST;
  if ($q->{host} eq "HIDE") {
    $HIDEHOST = 1;
    $q->{host} = "";
  }
  my $shost  = $q->{host} || "ALL";
  my $sort   = $q->{sort} || "HOST";

  print $head;

  my(%CONF) = ();
  my($types, %NAMES, %IP);
  $types = "host,";
  foreach my $d1 (@$dev) {
     $LABEL{"$d1->{type}:$d1->{key}"} = $renv->{solution} eq $d1->{type} ? 
                       $G->{summary} : ($d1->{userLabel} || $d1->{model});
                        
     $MGMT{$d1->{type} . ":" . $d1->{key}} = $d1->{mgmtLevel};
     $IP{$d1->{type} . ":" . $d1->{key}} = $d1;
     $types .= "$d1->{type},";
  }
  my $DB = State->getComponentState(1); # worst severity for each comp.

  my $GIF = State->sev_gifs();
  
# REPORT-LIST
  my $RL = Report->reportList();
  my($out, $found, @LIST);
  my $target = (index($FRAME2, $window) < 0) ? "" : "target=tree";
  my $agroups = $Config->adminGroups();
  my (@array);
  my $urls = Launch->read();

  foreach my $r0 (keys %$RL) { #host, type, date, XX, name
    my $r    = $RL->{$r0};
    my $file = $r0;
    my $type = $r->[1];
    next if ($HIDEHOST && $type eq "host");
    my $host = $r->[0];
    my $label = $LABEL{$r0} || $type;
    next if ($ruser->{isCustomer} && $MGMT{$r0} eq "C");
    next if (index($Report::EXCLUDE, ",$type,") >= 0);
    next if ($prefix and index($r->[4], $prefix) < 0);
    #next if (index($types, $type) < 0); # only display types that are in confg
    next if ($q->{GROUP} && ($agroups->{$file} ne $q->{GROUP}));
    my ($ok, $h1);
    if ($renv->{hostname} eq $r->[0]) { # local
       if ($shost eq "local" || $shost eq "ALL") {
         $ok = 1;
       }
    } else {
       $out .= "<tr><td colspan=7></td>";
       if ($shost eq $host || $shost eq "ALL") {
          $ok = 1;
          $h1 = $MAP{$host}{hostname} || $host;
       }
    }
    if ($ok) {
       my $name = $r->[4];
       my $date = $r->[2];
       $name =~ s/\.([a-zA-Z])/. $1/;
       $found++;
       my $url = "<a href=\"$Http::WEBPROC?GO=GUI::Instr::rStart&file=$file&type=$type&host=$h1&_name=$name\" $target>$name</a>";
       my $report = "<a href=$Http::WEBPROC?GO=GUI::Instr::explore1&file=$file&type=$type&host=$h1 $target>Report</a> ";
       
       my $state = $DB->{$file};

       my $sev = int($state->[0]+0.5);
       my $gif = "&nbsp;";
       if ($sev > 0) {
          my $g = $GIF->[$sev];
          $gif = "<a href=\"$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=2&file=$file&host=$host\" $target>".
                 "<img src=/gif/$g $L->{click} border=0 ></a>";
       }
       my $short = Util->shortHostname($host);
       my ($l1);
       if ($urls->{$type}[1] && $MGMT{$r0} ne "DS") {
          my $launch = $urls->link($type, $IP{$file});
          $l1 = "><name $name><table border=0 cellspacing=0 cellpadding=0 width=100%><tr><td>$url</td><td align=right>$launch</table>";
       } else {
          $l1 = "><name $name>$url";
       }
       push(@array, [ $short, $label, $l1, $gif, substr($date,5), "host_local" ]);
    }
  }

  my $g1 = "&GROUP=$q->{GROUP}" if (exists $q->{GROUP});
  my $scr = Html::Screen->new({ });
  $q->{SORT} = 3 if (!$q->{SORT});

  my $select = $scr->goForm(['GO=GUI::Instr::explore'], 
                "$hostsD $groupsD <input type=text size=8 name=PREFIX value=$val ".
                "onfocus=\"if(this.value==this.defaultValue) this.value='';\">");

  $scr->list( $q, { title => $L->{title}, interactive => 1, 
                    pageSize => 100, nextLine => ($window ne "N") }, 
    [
    [ l => $L->{host},         '+'],
    [ l => $L->{type},         '+'],
    [ h => $L->{name},         '+'],
    [ c => $L->{sev},          '-'],
    [ ln => $L->{last_report},  '+'],
    ],
    \@array, 
     [
     [ l => 'FILTER',  $select, $renv->{solution} ne "N" ], 
     ] );

  $scr->add(" <form><input type=hidden name=GO value=GUI::Instr::explore>".
      Html::Screen->submitButton("ACTION_CLEAR", $L->{clear}, undef,
                { extra => "onclick=\"return confirm('$L->{confirm_del}')\"" }) .
         "</form>" );
  print $scr->out();

  #print Html->readHtdocs('explore_trailer');
}

sub explore1F {
  my($q, $port, $util) = @_;
  my($url) = "host=$q->{host}&file=$q->{file}";
  print "<frameset rows=50%,* border=0>
     <frame src=$Http::WEBPROC?GO=GUI::Instr::explore1&$url name=left0 scrolling=auto>
     <frame src=javascript:return() name=main2 scrolling=auto>
 </frameset>
  ";
}

@Map = ('al_ok','al_alert','al_crit','al_down');
#@Map = ('bgcolor=#90F090><b>&nbsp;- ' , 'bgcolor=yellow><b>&nbsp;/ ', 'bgcolor=red>&nbsp;<b>I&nbsp;'   , 'bgcolor=red><center><img src=/gif/al_down3.gif>',);


sub addAlert {
  my($k, $file, $Comp, $desc, $typekey) = @_;
  return "" if ($Comp->[0] < 0);
  my $G = Labels->read();
  my ($n, $grid, $ac);
  $n = $k;
  $n = "Enclosure" if (index(",ei,eo,e,", ",$n,") >= 0);
  my $ev = State->eventHash($Comp->[4]);
  $ac = $ev->{Actionable} eq "TRUE" ? "Act." : "";
  my $grid_no = Grid->getNo($ev->{GridCode});
  $desc =~ s/'//g;
  $desc =~ s/ /\+/g;
  
  $grid = "$grid_no [ <a href=\"javascript:info2('$typekey:$k')\">$G->{advisor}" . 
	      "</a> ]" if ($grid_no);
  $n .= "</b> $ev->{OrigTargetName}" if (exists($ev->{OrigTargetName}));

  my $gif = "<img src=\"/gif/" . $Map[int($Comp->[0]+0.5)]. ".gif\">";
  #my $gif = $Map[int($Comp->[0]+0.5)];
  return 
    "<tr><td><center>$gif</td>
         <td><b>$n</b>&nbsp;$grid</td>
     <tr><td></td><td><small> $Comp->[1]</td>
    ";
}

sub san_graph {
  my($q, $to, $parms, $to_dev) = @_;
  return if (!$to_dev);
  $q->{FILTER} = $q->{file};
  my ($t, $F) = System->newPngName();
  $q->{zoom} = 1 if (!defined($q->{zoom}));
  my $url = "$Http::WEBPROC?GO=GUI::Instr::rStart&host=$q->{host}&".
            "LINKH=$q->{LINKH}&topo=$q->{topo}&Roption=5&file=";

  my ($map, $Coords) = TO::Graph->display($parms, $F, {zoom => $q->{zoom}, 
                 width => "MAX", height => "MAX",
                 circle => $q->{file},
                 text   => "Click to select",
                 url    => $url,
                });
  print <<EOF;
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=95%><tr><td>
  <img src=/Web/$t ismap usemap=#map1 border=0>
  </table>
  <map name=map1> $map </map>

EOF
}

sub san_connections {
  my($q, $to, $to_dev) = @_;
  my $file = $q->{file};
  return if (!$to_dev);
  my $renv = System->get_renv();
  my $Config = PDM::ConfigFile->read();
require TO;
  my $s;
  if($renv->{solution} eq "se2"){
     $s =  $to->toC_dev($to_dev, 2, "", "");
  }else{
     $s =  $to->toC_dev($to_dev, 2, 
    "[ <a href=$Http::WEBPROC?GO=GUI::Test::get_testlink&topo=MERGE-MASTER&LINKH=0", 
    "LinkTest</a> ]") ;
  }

  $s =~ s/\n\s+/\n&nbsp;/g;
  $s =~ s/\n/<br>/g;
  return ("<a href=#san_con>Connection Details</a>&nbsp;", 
         "<table border=1 width=95% cellspacing=0 cellpadding=1 bgcolor=white>$s</table>");

}


# HEALTH or GRAPH

sub state {
  my($q, $diagram) = @_;
  my($title);
  my $file = $q->{file};
  my $renv = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  my $deny = Roles->verifyRole($q, "admin|c_admin");
require TO;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart') ;

  if ($q->{name}) {
    $title = "$q->{cat}:$q->{name}";
  } else {
    $title = $q->{file};
  }
  my($type, $key) = split(/\:/, $title);
  my $dev = $Config->deviceByKey($title);

  if ($q->{ACTION_delete}) {
     if ($q->{key}) {
       State->clearComponent($q->{key});
     }
  }
  $q->{FILTER} = $q->{file};

  my ($State, $Comp);
  if ($q->{host} && $q->{host} ne $renv->{hostname} && 
      index(",host,se,se2,", ",$type,") < 0 && !$Config->deviceByKey($file) ) {
    my $i  = Util->rasInfo($q->{host});
    print "</b>Calling $q->{host}...<br>\n";
    $State = State->readFromDevice($q->{host}, $i->{hostname});
  } else {
    $Comp  = State->components($title);
  }
  my $t1     = $diagram ? $L->{graph} : $L->{alerts};
  my $title2 = $dev ? ($dev->{userLabel} || $dev->{type}) . " $dev->{name} $dev->{ipno}" : $title ;

  print "<script>
   function info2(a) {
      var b = '$Http::WEBPROC?GO=GUI::EventLog::info&event=' + a ;
      var O = window.open(b,'linfo','menubar=yes,resizable=yes,scrollbars=yes,width=600,height=700');
      O.focus();
   }
   </script>
   <table border=0 cellspacing=1 cellpadding=2 width=$Style::WIDTH bgcolor=$Style::DARK>
      <tr><td><b><font color=white>&nbsp;$t1 of $title2</td> </table> ";

  my ($san_con, $san_con_link, $t3_diag, $t3_diag_link);

  if ($diagram) {
    $q->{topo}   = "MERGE-MASTER" if (!$q->{topo});
    my ($parms, $to) = TO::Applet->genAppletData($q) ;
    if ($to) {
      my $to_dev = $to->nodeByName($q->{file});
      &san_graph($q, $to, $parms, $to_dev);
      # GRAPH
      ($san_con_link, $san_con) = &san_connections($q, $to, $to_dev);
      if ($type eq "t3") {
        my $diag =TO::T3->diagramApplet($title, $Comp, $to);
        $t3_diag_link = "<a href=#diag>T3 Graph</a>";
        $t3_diag = "<a name=diag>&nbsp;
          <table border=0 width=95% cellpadding=2 cellspacing=0>
           <tr><td><b>T3 Graph</td>
               <td align=right>[ <a href=#top>$L->{top}</a> ]</td></table>
        <table border=0 cellspacing=1 cellpadding=0 width=90% bgcolor=black>
           <tr><td><center>$diag</table>";
      }
      my $ll = $san_con_link;
      $ll .= " | " if ($t3_diag_link && $san_con_link);
      $ll .= $t3_diag_link;
      print "<table border=0 cellspacing=2 width=95%><tr>
           <td align=right>[ $ll ]&nbsp;</table>";
    } else {
      print "<table border=1 cellspacing=0 cellpadding=2 width=95% bgcolor=white><tr>
           <td>$L->{noTopo}</table>";
    }
  }
  print " <table border=1 cellpadding=2 cellspacing=0 width=$Style::WIDTH bgcolor=white>\n";

  # COMPONENT HEALTH
  $q->{details} = 2 if (!$q->{details});
  my ($cnt, $out, @LL);
  foreach my $k (keys %$Comp) {
     next if ($q->{details} == 2 && $Comp->{$k}[5] < 0);
     my $dd = $Comp->{$k}[1];
     next if (!$Comp->{$k}[0]  && !$q->{SHOWALL});
     push(@LL, "$dd\t$k\t$file\t");
  }

  # SORT AND MERGE
  foreach my $ll (reverse sort @LL) {
     my($dd, $k, $file, $el) = split(/\t/, $ll);
     my $new;
     $new = &addAlert($k,$file, $Comp->{$k}, $dd, $title);
     $out .= $new;
     $cnt++ if ($new);
  }

  print $out;
  if (!$cnt) {
    print "<tr><td colspan=3><b>$L->{no_alerts}</td>";
  } 
  print "</table>&nbsp;";
  if ($san_con) {
    print "<p><a name=san_con>&nbsp;";
    print "<table border=0 width=95% cellpadding=2 cellspacing=0>
           <tr><td><b>$L->{conn_details}</td>
               <td align=right>[ <a href=#top>$L->{top}</a> ]</td>
         </table>
          $san_con &nbsp<p> $t3_diag &nbsp;<p>";
  }
  if (!$diagram) {
    my ($links, $del);
    if ($cnt && !$deny) {
      $del = "[ <a href=\"$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=2&file=$file&ACTION_delete=1&key=$title\">$L->{submit_del}</a> ] ";
    }
    $links = Html->linkToggle("GUI::Instr::rStart&Roption=2&file=$file&key=$title", "details", [$L->{details}, $L->{summ}], $q->{details}) ;

    print "<table border=0 width=98%>
            <tr><td>[ $links ]</td>
            <tr><td align=right>$del</td>
          </table>";
    print "</form>";
  }
}


sub explore1 {
  my($q, $port, $util) = @_;
  my($data, @a);
  print Html->text_header();

  my($WIN) = "WIN=$q->{WIN}" if ($q->{WIN});
  
  print "\n<body bgcolor=$Style::BGCOLOR leftmargin=2 topmargin=2 marginwidth=2 marginheight=2>";
  my($P) = System->get_home() . "/DATA/OLD_REPORTS";
  my($ip);
  my($renv) = System->get_renv();
  $q->{host} = "" if ($q->{host} eq $renv->{hostname});
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart') ;

  if ($q->{file} && $q->{host} eq "*") {  # find host if missing
    my $rm = Report->reportList();
    my $dev = $rm->{$q->{file}};
    $q->{host} = $dev->[0] if ($dev);
  }


  if ($q->{host}) {
    print "$G->{calling} $q->{host}...<br>\n";
    my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
    foreach my $h (@$hosts) {
      if ($h->{hostname} eq $q->{host} || $q->{host} eq $h->{ip}) {
        $ip = $h->{ip};
        last;
      }
    }
    $ip = $q->{host} if (!$ip);
  }

  my ($err, $VAR1) = Report->readSpecial({ host  => $ip,
                                  timeout  => 10,
                                  file     => $q->{file},
                                  wwn      => $q->{wwn},
                                  name     => $q->{name} });
     
  if ($err) {
    print Html->warning($G->{no_report});
    print "&nbsp;<p><small>$err<br>";
    return;
  }
  require Report;

  my($id) = $VAR1->id();
  my $lost;
  if ($VAR1->status() eq "CC") {
    $lost = "<font color=red><b>$G->{cannot_comm}</b></font>" ;
  }
  $q->{file} = "$id->{category}:$id->{deviceName}";

 # $pl = "<font color=white>[ <a href=$Http::WEBPROC?GO=GUI::Instr::explore1&host=$q->{host}&file=$q->{file}&level=0><font color=white>$G->{close}</font></a> ] ";
  print "
 $lost
<table border=1 cellpadding=2 cellspacing=0 width=100% bgcolor=white>
  <tr><td bgcolor=$Style::DARK colspan=2>
   <table border=0 cellspacing=0 cellpadding=0 width=100%>
      <tr><td colspan=2><b><font color=white>" . uc($id->{category}) . ":$id->{name}</td>
      <tr><td colspan=2><b><font color=white>$G->{last_probe}: $VAR1->{_created}</td>
   </table>
<tr><td colspan=2><font face=arial,helvetica>
  <table border=0><tr><td></table>
 ";

  my $h = $VAR1->value();

  if (index("t3,6020,6120,", $id->{category}) >= 0)  { 
     foreach my $el ('loop','volume','fc_stats', 'volume_disk') {
        $h->{"$el.header"} = $el;
     }
  }
  require Html::Tree;
  my $tree =  Html::Tree->new({
                     this => "$Http::WEBPROC?GO=GUI::Instr::rStart&file=$q->{file}&host=$q->{host}&Roption=4",
                           q => $q,
                      sysgif => '/gif',
                     linkall => 1,
                        name => "ROOT"});
  my %X = ();
  foreach my $k (sort keys %$h) {
    next if (substr($k,0,1) eq "_");
    my $ix = rindex($k, ".");
    my $k1 = $k;
    if ($ix > 0) {
      $k1 = substr($k, 0, $ix);
    }
    $X{$k1} = 1;
  }
  my(@X) = ();
  print " <img src=/gif/menu_root.gif border=0 align=top>&nbsp;<a href=$Http::WEBPROC?GO=GUI::Instr::explore1&file=$q->{file}&host=$q->{host} >$id->{category}:$id->{deviceName}</a><br>";

  foreach my $k (sort keys %X) {
    my $k2 = $k; $k2 =~ s/\./\//g;
    push(@X, [ $k2, "$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=4&file=$q->{file}&section=$k2&host=$q->{host}" ]);
  }
  print $tree->read(\@X);
  print "<br>&nbsp;</table></table>";
  if ($q->{section}) {
     print "<table border=0><tr><td></table>";
     &explore2($q);
  }
}


sub explore2 {
  my($q, $port, $util) = @_;
  my($local);
  require Report;
  my($data);
  my($P) = System->get_home() . "/DATA/OLD_REPORTS";

  my @a = split(/:/, $q->{file});
  my $i = rindex($a[0],"/");
  $a[0] = substr($a[0],$i+1) if ($i) ;
  my $title = "$a[0]:$a[1] $q->{section}";
  
  if ($q->{host}) { # remote file
     my($D2) = System->get_home() . "/DATA/remote";
     $data = Util->readf("$D2/$q->{file}");

#     $url = Util->makeUrl($q->{host}, "?GET=run_file&file=$q->{file}");
#     print "Retrieving data from $url...<br>";
#     $data = Util::Http->get($url, 30);
     $local =0;
  } else {          # local file
     $data = Util->readf("$P/$q->{file}");
     $local =1;
  }
  if (substr($data,0,3) =~ /ER/) {
     print "$data<br>";
     return;
  }
  my($VAR1);
  eval $data;
  my $h = $VAR1->value();
  my($id) = $VAR1->id();
  my $section = $q->{section};

  my $l = length($section);
  $section =~ s/\//./g;
  print "
<table border=1 cellpadding=1 cellspacing=0 width=100% bgcolor=white>
  <tr><td colspan=2 bgcolor=$Style::DARK>&nbsp;<font color=white><b>$title</td>
<tr><td><pre>";
  my $last = undef;
  my ($val, $k0, $v, $ix, $cnt);
  foreach my $k (sort keys %$h) {
    next if (substr($k,0,1) eq "_");
    next if ($l && substr($k,0,$l) ne $section);
    next if ($l && length($k) > $l && substr($k,0,$l+1) ne "$section.");
    $k0 = $k;
    $k0 = substr($k, $l+1) if ($l);
    $ix = index($k0,".");
    if ($ix > 0) {
      $v = substr($k0,0,$ix);
      if ($v ne $last) {
        print "<tr><td colspan=2>&nbsp;</td>" if (defined($last));
        $last = $v;
      }
    }
    my $co = ($cnt++ % 2 == 0) ? "bgcolor=#F0F0F0" : "";
    
    print "<tr $co><td>&nbsp;";
    print "$k0</td><td>";
    $val= $h->{$k};
    require Data::Dumper;
    $Data::Dumper::Indent = 1;
    if (ref($val)) {
      print "<pre>" . substr(Data::Dumper::Dumper($val),7) . "</td>";
    } else {
      print " $val</td>";
    }
  }
  print "</table></table><center>";
  print "&nbsp;";


}

# NU
sub update {

  my($q, $port, $util) = @_;
  require Report;
  print "\n<body bgcolor=$Style::BGCOLOR>";
  my @a = split(/:/, $q->{file});
  my $i = rindex($a[0],"/");
  $a[0] = substr($a[0],$i+1) if ($i) ;
  my $title = "$a[0]:$a[1] $q->{section}";
  my $G = Labels->read();

  my($l);
  if ($q->{ACTION} eq "Update") {
     open(O, System->get_home() ."/$q->{file}");
     open(W, ">" . System->get_home() . "/$q->{file}.new");  
     while ($l = <O> ) {
         chop($l);
         @a = split(/ *\= */, $l);
         if ($a[0] eq "$q->{section}.$q->{value}") {
            print W "$a[0]  = $q->{new}\n";
         } else {
            print W $l . "\n";
         }
     }
     close(O); close(W);
  }
  my($data);
  if ($q->{host}) { # remote file
     print "$G->{ret_data} $q->{host}...<br>";
     require Util::Http;
     $data = Util::Http->getCommand($q->{host}, "run_file&file=$q->{file}", $main::TO);

  } else {          # local file
     $data = Util->readf(System->get_home() ."/$q->{file}");
  }
  if (substr($data,0,3) =~ /ER/) {
    print "$data<br>";
    return;
  }
  my $r = eval substr($data, 7);
  my $h = $r->value();
  my $id = $r->id();
  my $section = $q->{section};

  $l = length($section);
  $section =~ s/\//./g;
  print "
<table border=0 cellpadding=2 cellspacing=0 width=100% bgcolor=white><tr><td bgcolor=black>
<table border=0 cellpadding=0 cellspacing=0 width=100% bgcolor=white>
 <form  method=get>
 <input type=hidden name=GO value=update>
 <input type=hidden name=section value=$q->{section}>
 <input type=hidden name=value value=$q->{value}>
  <tr><td colspan=2 bgcolor=$Style::DARK>&nbsp;<font color=white><b>$title</td>
<tr><td><pre>";
  my $last = undef;
  my($k0);
  foreach my $k (sort keys %$h) {
    next if ($l && substr($k,0,$l) ne $section || substr($k,0,1) eq "_");
    $k0 = $k;
    next if (substr($k0, 0 - length($q->{value})) ne $q->{value});
    $k0 = substr($k, $l+1) if ($l);
    my $ix = index($k0,".");

    print "<tr><td align=right><b>$k0: </td>
               <td><input type=text name=new value=\"$h->{$k}\"></td>";
  }
  print "</table></table><center>" . Html::Screen->submitButton("ACTION", "Update"); 
  print "</form>&nbsp;";
  
}


sub mon {
  my($type, $name) = @_;
  my(%D);
  if (defined($D{$type}{$name})) {
    return ($D{$type}{$name}[0] eq "Y")? "<font color=green><b>On":"<font color=red><b>Off"
  } else {
    return "<font color=red><b>No";
  }
}


sub report {
  my($q) = @_;
  require TO;
  my($type, $wwn) = split(/:/, $q->{file});
  my $host1 = substr($q->{file}, 5) if ($type eq "host");

  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('rStart');

  my($renv) = System->get_renv();
  my $Config = PDM::ConfigFile->read();

  $q->{host} = "" if ($q->{host} eq $renv->{hostname});

  my($err, $VAR1, $host) = Report->readReport($q->{file}, $q->{host}, 10);
  $q->{host} = $host;

  if ($q->{host}) {
    print "Calling $q->{host}...<br>\n";
  }
  if (!$VAR1) {
     $err =~ s/</&lt;/g;
     print Html->warning($L->{err_no_report} . "<br><small>$err");
     return ;
  }

  if ($err) {
   $VAR1 = undef;
   if ($type ne "host") {
     print Html->warning($L->{err_no_report});

     return ;
   }
  }
  my $t1 = $VAR1->category();
  my $ip1 = $VAR1->value("id.ipno");

  if ($renv->{solution} eq "N") { # launch option
    my $urls = Launch->read();
    my $dev = $Config->deviceByKey($q->{file});
    if ($urls->{$t1}[1] && $dev) {
       my $u_out = $urls->link($t1, $dev, 1);
       print "<table border=0 cellspacing=0 width=90% cellpadding=0><tr><td align=right>Launch: $u_out</table>";
    }
  }
  my $Comments = Util->deserialize("Comments.txt");
  if ((my $com = $Comments->{$wwn})) {
    print "<table border=0 cellspacing=1 width=95% bgcolor=white><tr><td>$com</table>";
  }
  print "\n<body bgcolor=$Style::BGCOLOR topmargin=2 marginheight=2><center>";

  my $module = uc($type);
  eval "require \"Agent/$module.pm\"";
  $module = "Agent::$module";

  if (!$@) {
    print $module->REPORT($q->{host} || $renv->{hostname}, $VAR1, {host => $host1, q => $q});
  }
}


sub readR {
  my($file) = @_;
  my(@a, $v);
  open(O, System->get_home() . "/DATA/OLD_REPORTS/$file");

  @a = <O>; close(O);

  my $l = '$v = ' . substr("@a",7);
  eval $l;
  return $v;
}


1;
 
