package GUI::Hosts;

#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Id: Hosts.pm,v 1.21 2004/01/14 14:31:47 ccadieux Exp $

use Labels;
use AdminGroup;
use Util::Http;
use Agent;
use System;
use GUI::Config;
use GUIAdmin;
use Events;
use GUI;
use Logic::Slave;

# new one is pushSlaves, old is push_slaves

sub pushSlaves {
  my($q) = @_;
  my ($x);
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts');
  print Html->body();

  if (my $deny = Roles->verifyRole($q, "admin")) {
     print $deny;
     return;
  }
  my ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;

  if ($q->{ACTION_u} || $q->{ACTION_a} ) {
     my $list = ",";
     foreach my $x (keys %$q) {
        if (substr($x,0,4) eq "sel_") {
          $list .= substr($x,4) . ",";
        }
     }
     %T = (M => $L->expand('push.p_m'), 
           B => $L->expand('push.p_b'), 
           C => $L->expand('push.p_c') );
     my $cntS = 0;
     foreach my $h (@$hosts) {
        next if ($h->{dh} eq "Y");
        if ($q->{ACTION_a} || index($list, ",$h->{hostname},") >= 0) {
           print "'$T{$q->{action}}' :  $h->{hostname} /$h->{ip} ... <br>";
           $cntS++;
           if ($q->{action} eq "C" || $q->{action} eq "B") {
             my $rc = Logic::Slave->push($h) ;
             print substr($rc,3) if ($rc);
           }
           if ($q->{action} eq "M" || $q->{action} eq "B") {
              if ($q->{master}) {
                Util::Http->saveFile($h->{ipno} || $h->{hostname}, "MASTER", $q->{master});
                print $L->expand('push.err_1', $q->{master}, $h->{hostname});
              } else {
                print $L->expand('push.err_2', $h->{hostname});
              }
           }
        }
     }
     if ($cntS) {
       PDM::ConfigFile->write($renv, $dev, $hosts, $notifs);
     } else {
       print " <b><font color=red>--> $G->{nothing_sel}</font></b><br>\n";
     }
  }
  print Html->header2("admin.gen_maint.push" );

  if ($#$hosts < 0) {
    print "<center><h2><font color=red>$G->{no_slave}";
    return;
  }

  my $m = System->ifconfigs();
  my $master_list = "<select name=master><option value=\"\">[$G->{no_change}]";
  foreach my $x (@$m) {
     next if ($x->[1] eq "127.0.0.1");
     $master_list .= "<option value=\"$x->[1]\">$x->[0]: $x->[1]</option>";
  }
  $master_list .= "</select>";
  my $S = Util->makeSelect("action", 
        "M=$L->{'push.p_m'}|B=$L->{'push.p_b'}|C=$L->{'push.p_c'}", $q->{action});

  print "<table border=1 cellspacing=0 bgcolor=white width=90%>
  <form><input type=hidden name=GO value=GUI::Hosts::pushSlaves>
  <tr><td colspan=2 bgcolor=$Style::DARK><font color=white><b>$G->{select_action}
  <tr><td colspan=2>
    <table border=0 cellpadding=4 cellspacing=1 bgcolor=$Style::LIGHT width=100%>
       <tr><td><b> $S </td>
       <td><b>$L->{'push.l1'}:
             <td><b>$master_list</td>
    </table>
  <tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>$L->{'push.l2'}</td>";

  my $tot;
  my ($col2, @L);
  foreach $h (@$hosts) {
     $tot++;
    if ($h->{dh} eq "Y"){
       $col2 .= "&nbsp;N/A DataHost: $h->{hostname}<br>"; 
    }else{
       push(@L, $h->{hostname});
       $col2 .= "<input type=checkbox name=sel_$h->{hostname}> $h->{hostname}<br>";
    }

  }
  @L = sort @L;

  if ($tot > 0) {
    print "<tr><td>$col2&nbsp;</td>";
  }  else {
    print "<tr><td colspan=2><b>&nbsp;<font color=red>$L->{'push.err_3'}</td>";
  }

  print "</table>
   <table border=0 width=90%>
   <tr><td><b><input type=submit name=ACTION_u value=\"$L->{'push.submit1'}\">
       <td align=right><b><input type=submit name=ACTION_a value=\"$L->{'push.submit2'}\">
   </table>
        ";
  
}


sub list {
  my($q) = @_;
  my($ho, $o);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts');
  $q->{SORT} = 1 if (!$q->{SORT});

  print Html->body();
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  my $ruser = System->get_ruser();
  $q->{GROUP} = $ruser->{adm_group} if (!exists $q->{GROUP} && $ruser->{adm_group});
 
  my $groups = AdminGroup->new();

  if ($q->{ACTION_upd2} || $q->{ACTION_upd}) {
     my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
     my ($err, $done, %MAP) ;
     foreach my $e (keys %$q) {
       if (substr($e,0,6) eq "group_") {
          my $no = substr($e,6);
          my $val = Util->trim($q->{$e});
          #next if (!$val);
          if ($val && (!exists $groups->{$val}) ) {
            $err .= "$val, ";
          } elsif ($no == 0) {
            $renv->{adm_group} = $val;
            $MAP{""} = $val;
            $done++;
          } else {
            $hosts->[$no-1]{adm_group} = $val;
            $MAP{$hosts->[$no-1]{hostname}} = $val;
            $done++;
          }
       }
     }
     if ($q->{ACTION_upd2}) {
       foreach my $dev (@$devs) {
          $dev->{adm_group} = $MAP{$dev->{host}} if (exists $MAP{$dev->{host}});
       }
     }
     PDM::ConfigFile->write($renv, $devs, $hosts, $notifs) if ($done);
     print Html->warning("Invalid group(s): $err") if ($err);

  } elsif ($q->{ACTION_1}) {
     &add($q);
     return;
  } elsif ($q->{ACTION_3}) {
     &pushSlaves($q);
     return;
  }
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  if (!$renv->{site_country}) {
     $q->{SITE_FIRST} = 1;
     GUI::Config::site($q);
     return;
  }
  my($ping) = ($q->{ACTION_2})? 1:0;

  print Html->header2("admin.gen_maint.maintain_hosts");

  my(%CNT);

  for ($x=0; $x <= $#$dev; $x++) {
    $h = $dev->[$x];
    my $hh = $h->{host} || $renv->{hostname};
    $CNT{$hh}++;
  }
  my @H;

  for ($x=0; $x <= $#$host; $x++) {
     next if ($q->{GROUP} && ($host->[$x]{adm_group} ne $q->{GROUP}));
     push(@H, "$host->[$x]{hostname} | $x");
  } 
  my @array;

  my $gr2    = $renv->{adm_group} ;
  my $hname  = System->hostname();
  my $sol    = "SE-".$renv->{solution_model} if ($renv->{solution} ne "N");
  my $IPS    = System->ifconfigs();
  $local_active = (-f System->get_home() . "/DATA/start")? "Y":"N";
  my $c1     = ($local_active eq "N")? "bgcolor=#FFC0C0":"";
  my $ip = "";
  foreach my $i (@$IPS) {
     $ip .= " $i->[1]," if ($i->[1] ne "127.0.0.1");
  }
  chop($ip) if ($ip);
  push(@array, [
        "<a href=$Http::WEBPROC?GO=GUI::Config::upd>$hname</a>",
        "$G->{master} $sol",
         $CNT{$renv->{hostname}},
         $ip,
        " $c1><center>$G->{$local_active}",
        "&nbsp;",
        $gr2 ,
        ]);

  foreach my $h2 (sort @H) {
    my ($name1, $x) = split(/ \| /, $h2);
    my ($hostid, $version);
    $h = $host->[$x];
    $lnk = "<hide>$h->{hostname}</hide><a href=$Http::WEBPROC?GO=GUI::Hosts::upd&no=$x><b>$h->{hostname}</b></a>";

    $alive = "";
    if ($ping) {
      if ($h->{active} eq "N") {
        $alive = "(Inactive)";
      } else {
        print "$G->{pinging} $h->{ip}...<br>";
        $ix = index($h->{ip}, ":");
        $ip = ($ix > 0)? substr($h->{ip},0,$ix) : $h->{ip};
        my $ss;
        if (Util->ping($ip,4)) {
           $alive = $L->{'hosts.alive'};
           $ss = Util::Http->getCommand($h->{ip},"INFO1", 30) || "Error";
        } else {
           $alive = "<font color=red><b>" . $L->{'hosts.unaccessible'};
        }
        if ($ss ne "Error") {
          ($hostid, $version) = split(/ *\| */, $ss);
          $h->{hostid} = $hostid if (!$h->{hostid});
        }
      }
    }
    $cnt = $CNT{$h->{hostname}} + 0;
#    use POSIX2;
#    if ($h->{last_push}) {
#       $push .= POSIX::strftime("%b", 0,0,0,0,substr($h->{last_push},0,2),0) 
#                . substr($h->{last_push},2);
#    }
    $active = $h->{active} || "N";
    my $c1 = ($active eq "N")? "bgcolor=#FFC0C0":"";
    $active = $active eq "Y" ? $G->{yes} : $G->{no};
    $x2 = "&nbsp;$alive";
    $x2 .= "/ $hostid - $version" if ($hostid);
    $am = $h->{role} eq "AM" ? $G->{alt}: $G->{slave}; 
    $am = " $G->{dh}" if ($h->{dh} eq "Y");
    my $sol= "SE-".$h->{solution_model} if ($h->{solution} ne "N");

    $push = $h->{last_push};
    if ($push =~ /FAILED/) {
      $push = "<td nowrap bgcolor=#F0D0D0>&nbsp;$push</td>";
    } else {
      $push = "<td nowrap>&nbsp;$push</td>";
    }
    my $gr2 = $h->{adm_group} ; 
    # "<input type=text size=8 maxlength=8 name=group_" . ($x+1) . " value=\"$h->{adm_group}\">";

    push(@array, [$lnk,"$am $sol", $cnt, $h->{ipno}, "$c1><center> $active", $x2, $gr2]);
  }

  if ($ping) {
      PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
  }
  $comment = GUI->needToPush($host);

  my $no_slaves;
  if ($#$host < 0 && $renv->{solution} eq "N") {
     $no_slaves = "<b>$L->{'hosts.no_sl'}</b>";
  }

  my $groupsD = $groups->select("GROUP", $q->{GROUP}, $L->{'hosts.all_groups'});
     #"<input type=text size=8 maxlength=8 name=group_0 value=\"$renv->{adm_group}\">";
  my $all_hosts = "[ <a href=$Http::WEBPROC?GO=GUI::Hosts::updAll>$L->{'hosts.l2'}</a> ]" 
     if ($renv->{solution} eq "N" && !$deny);

  my $scr = Html::Screen->new();
  $scr->add("<form> <input type=hidden name=GO value=GUI::Hosts::list> $q->{ERR} $comment");

  $scr->add("<table border=0 cellspacing=0 width=$Style::WIDTH><tr><td align=right> $all_hosts </table>");

  my @leftbuttons;
  if (!$deny && $renv->{solution} eq "N") {
      push(@leftbuttons, 
               [ l => 'ACTION_1', $L->{'hosts.submit1'} ],
               [ l => 'ACTION_2', $L->{'hosts.submit2'} ],
           );
  } 

  $scr->list($q, { title => $L->{'hosts.l1'}, interactive => 1 },
    [
    [ l => $L->{'hosts.l3'}, '+' ],
    [ l => $L->{'hosts.type'} ],
    [ l => $L->{'hosts.l4'} ],
    [ l => $L->{'hosts.l5'} ],
    [ h => $L->{'hosts.l7'} ],
    [ l => $L->{'hosts.l8'} ],
    [ l => $L->{'hosts.group'}, '+' ],
    ], 
    \@array,
    \@leftbuttons,
    );
   $scr->add("$no_slaves</form>");
   print $scr->out();
}


sub push_slaves {
  my($q, $hostlist) = @_;

  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read();
  foreach $h (@$hosts) {
     next if ($hostlist and index(",$hostlist," , ",$h->{hostname},") < 0);
     print "Pushing Config to $h->{hostname} /$h->{ip} ... <br>";
     my $rc = Logic::Slave->push($h);
     print substr($rc,3) if ($rc);
  }
  PDM::ConfigFile->write($renv, $dev, $hosts, $notifs);
}



sub add {
  my($q) = @_;
  my($ho, $o, $err, $cat, $err1);

  print Html->body();
  my($categories) = Agent->findSelectableAgents();
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts');

  if ($q->{ACTION_back}) {
    &list($q);
    return;

  } elsif ($q->{ACTION_add}) {
    $q->{hostid} = lc($q->{hostid});
    while (1) {
     if ($q->{hostid} eq System->hostid) {
        $err = $L->expand('host_add.err_1') . "<br>";
        last;
     } elsif ($err1) {
        $err1 = "<font color=red>$err1</font>";
        $err .=  $L->expand('host_add.err_1') ;
        last;
     } elsif (!$q->{hostname}) {
        $err .=  $L->expand('host_add.err_3') ;
        last;
     } else {
        $done = 0;
        if (index($q->{hostname} , ".") < 0) {
           $save = $q->{hostname};
           $q->{hostname} .= "." . lc(System->domain());
           $ipno = Util->name2ip($q->{hostname});
           if (!$ipno) {
             $q->{hostname} = $save;
           } else {
             $done = 1;
           }
        }
        if (!$done) {
          $ipno = Util->name2ip($q->{hostname});
          if (!$ipno) {
             $err .= $G->expand("e_111", $q->{hostname});
             last;
          }
        }
        my $sp_info = Util->rasInfo($ipno);
        if ($sp_info->{solution} =~ /se/) {
           $err .= "Cannot add a Sun Solution ($sp_info->{solutionModel}) as a host!";
           last;
        }

	if(!$sp_info->{master}){
	  # This host doesn't have an active SUNWstade package
	  $err .= $L->expand('host_add.no_package' => $q->{hostname});
	  last;
	}
   
        ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
        my %EXIST;
        foreach $x (@$host) {
          $EXIST{$x->{ipno}}= 1; 
        }
        if ($EXIST{$ipno}) {
           print Html->error($L->expand('host_add.err_4', "IPNO"));
           last;
        }
        $x = $#$host + 1;
        $cat = "";
        foreach my $c (@$categories) {
          my(@bb) = split(/=/, $c);
          $cat .= "$bb[0]|" if ($q->{$bb[0]});
        }
        my $hostid = $sp_info->{hostid};

        if ($hostid ne "Error") {
           $host->[$x]{hostid}   = $hostid;
        } else {
           if ($q->{hostid} !~ /^\w\w\w\w\w\w\w\w$/ && lc(System->os) !~ /linux/) {
             $err .= $L->expand('host_add.err_5') . "<br>";
             last;
           }
           $host->[$x]{hostid}   = $q->{hostid};
        }
        if ($sp_info->{master} =~ /=Y/) {
            print Html->warning($L->expand('host_add.err_6', $q->{hostname}));
        }
        if ($sp_info->{master} =~ /=N/) {  # already a slave
           my $master1 = Util->trim(Util::Http->readFile($ipno, "MASTER", 10));
           if ($master1) {
             my $ip1 = Util->name2ip($master1);
             my $ip2 = Util->name2ip($renv->{hostname});
             if ($ip1 ne $ip2) {
                print Html->warning(
                 $L->expand('host_add.already_slave', $master1, "$ip1 != $ip2") );
             }
           }
        }

        chop($cat) if ($cat);
        $host->[$x]{categories} = $cat;
        $host->[$x]{_name}    = "host" . ($x+1);
        $host->[$x]{hostname} = $q->{hostname};
        $host->[$x]{ip}       = $q->{hostname};
        $host->[$x]{active}   = "Y";
        $host->[$x]{role}     = $q->{role}? "AM" : "S";
        $host->[$x]{ipno}     = Util->name2ip($q->{hostname});
        $host->[$x]{skip_luxadm} = $q->{skip_luxadm} ? 1:0;
        
        $host->[$x]{show_monitored_only} = $q->{show_monitored_only}? "Y":"N";
        $host->[$x]{frequency}= $q->{frequency} || 10;
        $host->[$x]{contract} = $q->{contract} if ($q->{contract});
        $host->[$x]{logfile}  = "/var/adm/messages";
        my $t3l    = $q->{t300logfile};
        $t3l =~ s/[\n\r]/ /g;
        $host->[$x]{t300logfile} = $t3l;
#        $q->{ping} =~ s/ *[\|\:\#]+ */#/g;
#        $q->{ping} =~ s/ *[\n\r]+ */|/g;
#        $host->[$x]{ping}       = $q->{ping};

        GUIAdmin->clearSlave($q->{hostname}, $host);
        unlink System->get_home() . "/DATA/snapshot_db";
        Events->saveEvent("AH", $q->{hostid}, $q->{hostname});

        Util::Http->saveFile($host->[$x]{ipno}, "MASTER", $renv->{hostname});

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print Error->error(101, $CONF)->toHtml();
           
        } else {
           $info = Html->error($L->expand('host_add.added'));
#           &main::save_event("AH", $q->{hostid});
           print $L->expand('host_add.added');
        }
        &list($q);
        return;
      }
    }
  }


  print Html->header2("admin.gen_maint.add_hosts");
  print Html->error($err) if ($err);

  $q->{logfile}     = "/var/adm/messages";
  $q->{hostid}      = "12345678" if (!$q->{hostid});

  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr><td>
   <table border=0 cellspacing=0 cellpadding=0 >";
  my $cnt = -1;
  foreach my $mod (@$categories) {
     $modules_html .= "</table></td><td valign=top><table border=0 cellspacing=0 cellpadding=0 >" if (++$cnt % 9 == 0);
     my(@bb) = split(/=/, $mod);
     my $ck  = "checked" if (!$q->{AGAIN} || $q->{$bb[0]});
     $modules_html .= "<tr><td valign=top><input type=checkbox name=$bb[0] $ck>:</td><td nowrap>$bb[1]";
  }
  $modules_html .= "</table></table>";
  $frequency = Html->select_frequency($q, $L->{'hosts.select'});

  my $AGAIN = $q->{AGAIN} + 1;
  my $scr = Html::Screen->new();
  $scr->add(" <form  method=get> 
      <input type=hidden name=AGAIN value=$AGAIN>
      <input type=hidden name=GO value=GUI::Hosts::add> <center>");
  $scr->script(" 
    function win1(a) {
      var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
      O.focus();
    }
    ");

  $scr->table( { title => $L->{'host_add.title'} },
   [
   [ f => $L->{'host_add.l1'}, "<input type=text name=hostid size=8 maxlength=8 value=\"$q->{hostid}\">" ],
   [ f => $L->{'host_add.l2'}, "<input type=text name=hostname size=40 maxlength=40 value=\"$q->{hostname}\">"],
   [ f => $L->{'host_add.l3'}, "<input type=ip size=20 maxlength=20 name=contract value=\"$q->{contract}\">"],
   [ f => "$L->{'host_add.l4'}<br><a href=javascript:win1()>$L->{'host_add.l5'}",
          $modules_html],
   [ f => $L->{'host_add.l6'}, $frequency ],
   [ f => $L->{'host_add.l7'}, "<input type=checkbox name=role>" ],
   [ f => $L->{'host_add.l9'}, "<input type=checkbox name=skip_luxadm>"],
   [ f => $L->{'host_add.l10'}, "<input type=checkbox name=show_monitored_only>"],
   [ l => $L->{'host_add.l11'} ],
   [ f => $L->{'host_add.l12'}, "<big>$q->{logfile}"],
   [ f => $L->{'host_add.l13'}, "<input type=text name=t300logfile size=50 maxlength=60 value=\"$q->{t300logfile}\">"],
   ]);
   $scr->button2([
    [ l => 'ACTION_add', $L->{'host_add.submit1'} ],
    [ l => 'ACTION_back', $L->{'host_add.submit2'} ],
    ]);
   $scr->add("</form>");
   print $scr->out();

}

sub dh_upd {
  my($q) = @_;
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts')->section('host_upd');
  print Html->body();

  if ($q->{ACTION_back}) {
    &list($q);
    return;

  } elsif ($q->{ACTION_delete}) {
    &delete_host($q);
    &list($q);
    return;
  }
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

  my $h = $host->[$q->{no}];
  if (open(O, System->get_home() . "/DATA/DataHost/$h->{hostname}.info")) {
     while ($l = <O>) {
        chop($l);
        my ($a, $b) = split(/\=/, $l, 2);
        $h->{$a} = $b;
     }
     close(O);
  }

  $active = ($h->{active} eq "Y")? $L->{host_on} : $L->{host_off} ;

  print Html->header2("admin.gen_maint.maintain_host", undef, undef, "data_host_upd");

  my $scr = Html::Screen->new();
  $scr->add(" <form  method=get> <input type=hidden name=GO value=GUI::Hosts::dh_upd> 
              <input type=hidden name=no value=$q->{no}> <input type=hidden name=hostid value=$h->{hostid}>");

  $scr->table({ title => $L->{dh_label} },
   [
   [ f => $L->{hostid}, $h->{hostid} ],
   [ f => "Active",     $active ],
   [ f => $L->{name},   $h->{hostname} ],
   [ f => $L->{ip},     $h->{ipno} ],
   [ f => $L->{freq},   $h->{frequency} ],
   [ f => $L->{dh},     "DataHost Slave"],
   [ f => $L->{push_only},     "Yes" ],
   [ f => "Admin Email", $h->{admin_email} ],
   [ f => $L->{log1}, $h->{logfile} ],
   ]);

   $scr->button2( [
         [ l => 'ACTION_delete', $G->{submit_delete}, $deny ],
         [ l => 'ACTION_back',   $G->{submit_back},   $deny   ],
         ]);
   $scr->add("</form>");
   print $scr->out();

}

#<tr><td colspan=2 bgcolor=silver><b>&nbsp;Enter DataPing Directories (One dir/file per line)</td>
#<tr><td colspan=2>$err1
#      <textarea name=ping cols=60 rows=12>$q->{ping}</textarea></td>

sub delete_host {
  my($q) = @_;

  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts')->section('host_upd');

  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my $x = $q->{no};
  my $hostid = $host->[$x]{hostid};
  my $hn = $host->[$x]{hostname};
  unlink(System->get_home() . "/DATA/topo/$hn") if ($hn);
  State->clearComponent("host:$hn");
  $host->[$x]{_name} = "";
  unlink System->get_home() . "/DATA/REMOTE_LISTS/$hn";

  $name = $host->[$x]{hostname} . "/ " . $host->[$x]{ip};
  my $del;
  foreach my $d (@$dev) {
      if ($d->{host} eq $hn) {
          $del++;
          delete $d->{_name};
      }
  }
  PDM::ConfigFile->write( $renv, $dev, $host,$notifs);

  &main::log_change($L->expand('deleted',  $name));
  my $n = " (with $del devices)" if ($del);
  $q->{ERR} = Html->error($L->expand('deleted', $name, $n )); 
  Events->saveEvent("DH", $hn);
  $rc = Util::Http->getCommand($host->[$x]{ip}, "DELET&file=start",  30);
}

sub upd {
  my($q) = @_;
  my($ho, $o, $err2);
  my($name, $err);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts')->section('host_upd');

  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  my $h = $host->[$q->{no}];
  if ($h->{dh} eq "Y") {
    &dh_upd($q);
    return;
  }
  print Html->body();
  my($categories) = Agent->findSelectableAgents($h->{solution} );

  if ($q->{ACTION_back}) {
    &list($q);
    return;
  } elsif ($q->{ACTION_delete}) {
    &delete_host($q);
    &list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    $q->{hostid} = lc($q->{hostid});
    while (1) {
#     if ($q->{ping}) {
#        @a = split(/ *[\n\r]+ */, $q->{ping});
#        $err1 = "";
#        foreach $p (@a) {
#           @l = split(/ *[\:\|\#] */, $p);
#           if (!(-d $l[0] || -f $l[0])) {
#              $err1 .= "Cannot read path: $l[0]<br>";
#           }
#        }
#     }
     if ($err1) {
        $err1 = "<font color=red>$err1</font>";
        $err = Html->error($L->{err_1});
        last;
     } elsif ($q->{hostid} eq System->hostid) {
        $err = Html->error($L->{err_2});
        last;
     } else {
        $x = $q->{no};
        $cat = "";
        foreach my $h (@$host) {
             $h->{role} = "S" if ($q->{role});
        }
        foreach my $c (@$categories) {
          my(@bb) = split(/=/, $c);
          $cat .= "$bb[0]|" if ($q->{$bb[0]});
        }
        chop($cat) if ($cat);
        my($H) = $host->[$x];

        if ($H->{categories} ne $cat) {
          &main::log_change($L->expand('err_3',$H->{hostname}, $H->{categories}, $cat) );
        }
        $host->[$x]{categories} = $cat;

        $host->[$x]{role}     = $q->{role} ? "AM" : "S";
        if (!$host->[$x]{ipno}) {
           $host->[$x]{ipno} = Util->name2ip($host->[$x]{hostname});
        }
        $host->[$x]{last_push}  = "";
        $host->[$x]{contract} = $q->{contract};
        if ($H->{frequency} ne $q->{frequency}) {
           &main::log_change($L->expand('err_4', $H->{hostame}, $H->{frequency}, $q->{frequency}));
        }
        $host->[$x]{frequency}= $q->{frequency} || 5;
        $host->[$x]{skip_luxadm} = $q->{skip_luxadm} ? 1:0;
        $host->[$x]{dh}       = $q->{dh} ? "Y":"N";
        $host->[$x]{show_monitored_only} = $q->{show_monitored_only}? "Y":"N";
        $host->[$x]{logfile}  = "/var/adm/messages";
        my $t3l =  $q->{t300logfile};
        $t3l =~ s/[\n\r]/ /g;
        $t3l =~ s/\s+/ /g;
        $host->[$x]{t300logfile} = $t3l;
#        $q->{ping} =~ s/ *[\|\:\#] */#/g;
#        $q->{ping} =~ s/ *[\n\r]+ */|/g;
#         $host->[$x]{ping}       = $q->{ping};

        GUIAdmin->clearSlave($host->[$x]{hostname}, $host);

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print "Cannot write to ConfigFile $CONF<br>";
        } else {
           $err2 = Html->info($L->{updated_1});
        }
     }
     last;
    }
  }
out:

  print Html->header2("admin.gen_maint.maintain_host");

  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr>";
  my $cnt;
  foreach my $mod (@$categories) {
     my(@bb) = split(/=/, $mod);
     $modules_html .= "</td><td valign=top>" if ($cnt++ % 9 == 0);
     my($ck) = "checked"  if (index("|$h->{categories}|", "|$bb[0]|" ) >= 0);
     $modules_html .= "<input type=checkbox name=$bb[0] $ck>:$bb[1]<br>";
  }
  $modules_html .= "</table>";
  # my $topoType = Util->makeSelect("topo_type","ib=$G->{inband}|oob=$G->{oob}", $h->{topo_type});
  $ping = $h->{ping};
  $ping =~ s/\|/\n/g;
  $ping =~ s/#/  #/g;
  $frequency = Html->select_frequency($h);

  my $role_ck = "checked" if ($h->{role} eq "AM");

  $active = ($h->{active} eq "Y")? $L->{host_on} : $L->{host_off} ;
  my $skip_luxadm = $h->{skip_luxadm} ? "checked" : "";

  my $dh = ($h->{dh} eq "Y") ? "checked":"";
  my $ck2 = ($h->{show_monitored_only} eq "Y") ? "checked":"";

  my $scr = Html::Screen->new();

  $scr->add(" <form  method=get> <input type=hidden name=GO value=GUI::Hosts::upd> 
              <input type=hidden name=no value=$q->{no}> <input type=hidden name=hostid value=$h->{hostid}> 
             $h1 $err $err2");
  $scr->script("
    function win1(a) {
      var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
      O.focus();
    }
    ");

  $scr->table( { title => $L->{label} },
   [
   [ f => $L->{hostid}, $h->{hostid} ],
   [ f => "Active",     $active      ],
   [ f => $L->{name},   $h->{hostname} ],
   [ f => $L->{ip},     $h->{ipno}   ],
   [ f => $L->{contract},  "<input type=ip size=20 maxlength=20 name=contract value=\"$h->{contract}\">"],
   [ f => "$L->{cat} <br><a href=javascript:win1()>$L->{abb}",
           $modules_html ],
   [ f => $L->{freq}, $frequency ],
   [ f => $L->{alt},    "<input type=checkbox $role_ck name=role>" ],
   [ f => $L->{inband}, "<input type=checkbox name=skip_luxadm $skip_luxadm>" ], 
   [ f => $L->{show},   "<input type=checkbox name=show_monitored_only $ck2>" ],
   [ l => $L->{label2} ],
   [ f => $L->{log1}, $h->{logfile} ],
   [ f => $L->{log2}, "<textarea name=t300logfile cols=50 rows=3 wrap=virtual>$h->{t300logfile}</textarea>" ],
   ]);

   $scr->button2( [ 
     [ l => 'ACTION_update',  $G->{submit_update}, $deny ],
     [ l => 'ACTION_delete',  $G->{submit_delete} , $deny ],
     [ l => 'ACTION_back',    $G->{submit_back}, $deny ],
     ]);
   $scr->add("</form>");
   print $scr->out();

}

sub uniq {
  my($v1, $v2) = @_;
  my @NEW = split(/\|/, $v2);
  foreach my $x (@NEW) {
    if (index("|$v1|", "|$x|") < 0) {
       $v1 .= "|$x";
    }
  }
  return $v1;
}

sub updAll {
  my($q) = @_;
  my($ho, $o, $err, $cat, $err1);

  print Html->body();
  my($categories) = Agent->findSelectableAgents();

  my $LB = Labels->read('GUI::Hosts')->section('all');

  if ($q->{ACTION_back}) {
    &list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    $q->{hostid} = lc($q->{hostid});

    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    foreach my $c (@$categories) {
          my(@bb) = split(/=/, $c);
          if ($q->{$bb[0]}) {
             $cat .= "|" if ($cat);
             $cat .= $bb[0];
          }
    }
    $renv->{categories} = $cat;
    $renv->{frequency}   = $q->{frequency} || 10;
    my %CAT;
    if ($q->{autocheck}) {
      foreach my $d (@$dev)  {
         my $h = $d->{host} || "LOCAL";
         $CAT{$h} .= "$d->{type}|" if (index("|$CAT{$h}|", "|$d->{type}|") < 0);
      } 
      $renv->{categories} = &uniq($cat, $CAT{LOCAL});
    }

    foreach my $h (@$host) {
       if ($q->{autocheck}) {
          $h->{categories} = &uniq($cat, $CAT{$h->{hostname}}) ;
       } else {
          $h->{categories} = $cat;
       }
       $h->{frequency}  = $q->{frequency} || 10;
    }

    if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
       print "Cannot write to ConfigFile $CONF<br>";
    } else {
       print "All hosts are updated!";
    }
    &list($q);
    return;
  }
out:

  $h = Html->header($LB->{title});
  $q->{logfile}     = "/var/adm/messages";
#  $q->{t300logfile} = "/var/adm/messages.t3" if (!$q->{t300logfile} && !$err);

  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr>";
  my $cnt;
  foreach my $mod (@$categories) {
     $modules_html .= "</td><td valign=top>" if ($cnt++ % 5 == 0);
     my(@bb) = split(/=/, $mod);
     my($ck) = "checked" if ($q->{$bb[0]});
     $modules_html .= "<input type=checkbox name=$bb[0] $ck>:$bb[1]<br>";
  }
  $modules_html .= "</table>";
  $frequency = Html->select_frequency($q);

  my $scr = Html::Screen->new();
  $scr->add(" <form  method=get> <input type=hidden name=GO value=GUI::Hosts::updAll> $h $err");
  $scr->script("
     function win1(a) {
       var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
       O.focus();
     }
     ");

  $scr->table( { header => $LB->{all_slaves} },
   [
   [ f => "$LB->{cat}<br><a href=javascript:win1()>$LB->{abb}",  $modules_html ],
   [ f => $LB->{also}, "<input type=checkbox name=autocheck>" ],
   [ f => $LB->{freq}, $frequency ],
   ]);

   $scr->button2( [ 
    [ l => 'ACTION_update', $LB->{submit_update} ],
    [ l => 'ACTION_back',   $LB->{submit_back}   ],
    ]);
   $scr->add("</form>");
   print $scr->out();
}



#<tr><td colspan=2 bgcolor=silver><b>&nbsp;Enter DataPing Directories (One dir/file per line)</td>
#<tr><td colspan=2>$err1
#      <textarea name=ping cols=60 rows=12>$ping</textarea></td>

#<tr><td colspan=2 bgcolor=silver><b>&nbsp;Enter DataPing Directories (One dir/file per line)</td>
#<tr><td colspan=2>$err1
#      <textarea name=ping cols=60 rows=12>$ping</textarea></td>
1;
