package GUI::Grid;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>



use strict;
use System;
use GUIAdmin;
use Html;
use Roles;
use Html::List;
use Html::Screen;
use Grid;
use  Html::Tabs;

sub info {
  my($q) = @_;
  my($email, $field);
  my $deny = Roles->verifyRole($q, "admin");

  print Html->body();

  my $renv = System->get_renv();
  my ($cat, $type, $comp);
  if ($q->{code}) {
     ($cat, $type, $comp) = split(/\./, $q->{code}, 3);
     &Events({ cat => $cat , type => $type, comp => $comp});
     return;
  } else {
     print Html->header2("service.event.grid", undef, undef, undef, 
         {noCrumb => 1, noDoc => 1, noTabs => 1, popup => 1});
  }
  $q->{info} =~ s/ /+/g;
  ($type, $comp) = split(/\:/, $q->{info});

  if ($q->{ACTION_suggest}) {

     my $ff = substr($q->{file}, 0, -5);
     my $date = substr(Util->get_today(), 0, 10);
     my $dir1 = "/u04/StorADE/Events/" . substr($date,0,7);
     mkdir $dir1,0777 if (!-d $dir1);
     my $FN = "/u04/StorADE/Events/" . substr($date,0,7) . "/" . substr($date,8) . ".$ff";
     open(O, ">>$FN");

my $req =<<EOF;
From: EGrid System
Subject: EGrid request from $q->{email}


Event Grid Request
From Login: $q->{_LOGIN}
From Email: $q->{email}

Stored in : $FN
Grid File : $q->{file}
Event Type: $q->{info}

Information:
$q->{Info}

Probable Cause:
$q->{Cause}

Recommended Action:
$q->{Action}
EOF

     print O $req;
     print O "=" x 80 . "\n";
     close(O);
     Util->run_command("/usr/bin/mail Tony.Mullen\@Sun.COM", "mail", 10, 
        { data => $req });

     print "<center><table border=1 cellspacing=0 cellpadding=2 width=60% bgcolor=#FFFFC0><tr><td><b>Your new text for the event '$q->{info}' was sent for approval. You will receive an email when it is 
   reviewed !</table>&nbsp;";
     delete $q->{option};

  } elsif ($q->{ACTION_update}) {
    Grid->updateEvent($q->{file}, $type, $comp, $q->{Info}, $q->{Cause}, $q->{Action});
  }

  open(O, System->get_home() . "/System/EGrid/Grid.idx");

  my ($info, $in, $l, $cause, $file, $desc2);
  my ($which, $action_event, $actionable, $sev, $desc, $ev, $code);
  while ($l = <O>) {
      chop($l);
      my($t, $c, $f) = split(/ \| /, $l);
      if ($t eq $type && $comp eq $c) {
        $file = $f;
        $ev = Grid->readEvent($f, $type, $comp);
        $sev    = $ev->{severity};
        $info   = $ev->{info};
        $cause  = $ev->{cause};
        $action_event = $ev->{action};
        $actionable = $ev->{actionable};
        last;
     }
  }
  if ($q->{info} =~ /message.LogEvent:driver/) { 
    my($o1, $o2) = Thresholds->toString("driver", substr($comp,7));
    $desc2 = "<tr><td align=right> Threshold:</td><td colspan=3> $o1</td>";
  }
  close(O);
  $actionable = ($actionable)? "Y":"N";
  my $LB = Labels->read("GUI::Grid");

  my $im = Grid->get_sev_image($sev) || "Information";
  my($cat, $rest) = split(/\./, $type, 2);
  print "
  <table border=1 cellspacing=0 cellpadding=2 width=100% bgcolor=white>
    <tr><td align=right ><form>$LB->{event}:</td><td><b>$ev->{type}
        <td align=right >$LB->{sev}:</td><td>$im</td>
    <tr><td align=right >$LB->{comp}:</td><td width=20%><b>$comp</td>
        <td align=right >$LB->{act}:</td><td width=20%><b>$actionable</td>
    <tr>
        <td align=right >$LB->{pattern}:</td><td width=20%><b>$ev->{pattern}&nbsp;</td>
        <td align=right >$LB->{code}:</td><td width=20%><b>$ev->{code}&nbsp;</td>
    <tr><td align=right >$LB->{sample}:</td><td colspan=3><b>$ev->{desc}</td>
    $desc2
  </table><table border=0><tr><td></table>";

  if ($renv->{update_grid} eq "Y") {
     $q->{option} = 9 if (!$q->{option});
     my $L =  ["9=Display","1=Update-Information","2=Update-Cause","3=Update-Action"];
     if ($deny) {
       $L =  ["9=Display","1=Suggest New Information/Cause/Action"]; # ,"2=Add-Cause","3=Add-Action"];
     }
     my $tab = Html::Tabs->create(list  => $L, 
                       url  => "$Http::WEBPROC?GO=GUI::Grid::info&info=$q->{info}&file=$q->{file}&_LOGIN=$q->{_LOGIN}",
                     width  => "100%",
             selectedColor  => "white",
         selectedTextColor  => "blue",
           backgroundColor  => $main'LIGHT,
        backgroundTextColor => 'black',
                  selection => $q->{option}
         );
    print $tab;
    $deny = 1 if ($deny);
    print "<input type=hidden name=GO value=GUI::Grid::info>
     <input type=hidden name=file value=\"$file\">
     <input type=hidden name=info value=\"$q->{info}\">
     <input type=hidden name=deny value=\"$deny\">
     <input type=hidden name=_LOGIN value=\"$q->{_LOGIN}\">
     <input type=hidden name=option value=\"$q->{option}\"></center>";
    if ($q->{option} == 9) {
       &display_all($info, $cause, $action_event);
    } else {
      #if ($q->{option} == 1) {
         print "<br><b>$LB->{info2}:</b>" . 
            ($info ? "<br>$info<br>" : " [none]<br>");
         $info = "" if ($deny);
         print "<textarea  cols=80 rows=25 name=Info>$info</textarea>";
      #} elsif ($q->{option} == 2) {
         print "<br><b>$LB->{cause}:</b>" .
            ($cause ? "<br><pre>$cause</pre>" : " [none]<br>");
         $cause = "" if ($deny);
         print "<textarea cols=80 rows=25 name=Cause>$cause</textarea>";
      #} else {
         print "<br><b>$LB->{action}:</b>" . 
            ($action_event ? "<br><pre>$action_event</pre>" : " [none]<br>");
         $action_event = "" if ($deny);
         print "<textarea cols=80 rows=25 name=Action>$action_event</textarea>";
      #}
      if ($deny) {
         if ($q->{_LOGIN}) {
            my $i = main::read_badge($q->{_LOGIN});
            my @L = split(/\|/, $i);
            $email = $L[15];
         }
         print "<br><b>Your Email:<input type=text name=email value=\"$email\" size=30>&nbsp;";
         print " <input type=submit name=ACTION_suggest value=\"Submit New Suggestion\"></form>";
      } else {
         print "<br><b><center><input type=submit name=ACTION_update value=\"UPDATE\"></form>";
      }
    }

  } else {
    display_all($info, $cause, $action_event);
  }
}

sub display_all  {
  my($info, $cause, $action_event) = @_;

  my $LB = Labels->read("GUI::Grid");

   $info =~ s/\n/<br>/g;
   $cause =~ s/\n/<br>/g;
   $action_event =~ s/\n/<br>/g;
   print "<table border=0 cellpadding=2 cellspacing=2 width=100% bgcolor=white>";
   my $flag = 0;
   if (length($info) > 1) {
      print "<tr><td><b>$LB->{info2}:</b><br>$info</td>"; $flag = 1;
   }
   if (length($cause) > 1) {
      print "<tr><td><b>$LB->{cause2}:</b><br>$cause"; $flag = 1;
   }
   if (length($action_event) > 1) {
      print "<tr><td><b>$LB->{action2}:</b><br>$action_event"; $flag = 1;
   }
   if (!$flag) {
      print "<tr><td><center>&nbsp;<p><h3>$LB->{no_info}<p>&nbsp;</td>";
   }
   print "</table>";
}
#
# called from Provider/SSRR.pm inn NSCC with $->{cat} and $q->{comp}
#

sub Events {
  my($q) = @_;

  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();
  my $lang  =  $ruser->{language} || $renv->{language};
  my $F1    = System->get_home() . "/Lang/System/EGrid/$lang";
  print Html->body();

  my $DIR;
  if (-d  $F1 && $lang) {
    $DIR = $F1;
  } else {
    $DIR = System->get_home() . "/System/EGrid";
  }
  opendir(O2, $DIR);
  my @G = readdir(O2);
  closedir(O2);
  my $LB = Labels->read("GUI::Grid");

  my $cat_select = "<select name=cat><option value=ALL>$LB->{all}</option>";
  my $INC = SE->device_included();

  my ($found);
  foreach my $k0 (sort @G) {
     next if (substr($k0,0,1) eq ".");
     next if ($k0 !~ /.grid/);
     my $k = substr($k0,0,-5);
     next if ($INC && index(",$INC,", ",$k,") < 0);

     my $sel = ($k eq $q->{cat}) ? "selected":"";
     my $k1 =  Util->abb("$k.medium");
     $cat_select .= "<option value=\"$k\" $sel>$k";
     $cat_select .= " ($k1)" if ($k1 && lc($k1) ne $k);
  }
  $cat_select .= "</select>";

  my($cat, $type, $sev, $action, $desc, $comp,  $last_type, $cause);
  my($l, $info, @R, %CAT, %COMP, %TYPE,  $curr, $action_event, $last_comp, $code);
  $curr = 0;
  my $which;
  my @SEV = ($LB->{notice}, $LB->{warning}, "<b>$LB->{error}", "<b>$LB->{critical}");
  my $search = lc($q->{search});
  my $category = $q->{cat};
  $q->{cat}  = "" if ($category eq "ALL");

  foreach my $f1 (sort @G) {
     next if ($f1 !~ /.grid$/);
     my $short = substr($f1,0,-5);
     next if ($INC && index(",$INC,", lc(",$short,")) < 0);
     open(O, "$DIR/$f1");
     while ($l = <O>) {
       chop($l);
       next if (substr($l,0,1) eq "#");
       my($name, $val) = split(/ *\= */, $l, 2);
       if (substr($l,0,1) eq "'") {
           if ($which == 1) {
             $info .= " " . substr($l,1);

           } elsif ($which == 2) {
             $action_event .= " <br>" if (substr($l,1,1) ne "<");
             $action_event .= substr($l,1);

           } elsif ($which == 3) {
             $cause .= " <br>" if (substr($l,1,1) ne "<");
             $cause .= substr($l,1);
           }
   
       } elsif ($name eq "type")  {
         $action = ($action) ? "Y" : "";
         my(@sevs) = split(/,/, $sev);
         my $im;
         foreach my $s (@sevs) {
           $im .=  $SEV[$s] . "|";
         }
         chop($im) if ($im);
         my $save = 1;
         if (($q->{type} && substr($type, 0,length($q->{type})) ne $q->{type}) ||
             ($q->{comp} && $q->{comp} ne $comp) ||
             ($q->{cat} && $q->{cat} ne $cat )) {
            $save = 0;
         }
         $save = 0 if ($search && 
          index(lc("$type $info $cause $action_event $desc $code $cat"), $search) < 0); 
         my ($links, $tag);
         $tag = $LB->{info3} if ($info);
         $tag .= "/$LB->{cause3}" if ($cause);
         $tag .= "/$LB->{action3}" if ($action_event);
         
         if (!$q->{REPORT}) { 
           $info = ""; $action_event = $cause = "";
           if ($tag) {
              $links = "[ <b><a href=javascript:openw('$last_type:$comp')>". 
                       "$tag</a></b> ]";
           } elsif ($renv->{update_grid} eq "Y") {
             $links = "[ <b><a href=javascript:openw('$last_type:$comp')>". 
                       "$LB->{add}</a></b> ]";
           }
         } else {
           $info = "<b>$LB->{sample}: </b><br>$desc<br>$info";
           $info .= "<br><b>$LB->{cause2}:</b><br>$cause" if (length($cause) > 1);
           $info .= "<br><b>$LB->{action2}:</b><br>$action_event" if (length($action_event) > 1);
           $desc = "";
         }
         my $t1 = $type; 
         my $s1;
         $t1 =~ s/\./. /;
         $t1 =~ s/Communication/Comm_/;
         $t1 =~ s/Event/ Event/;
         my $comp2 = $comp; $comp2 =~ s/\./. /;
         push(@R, [$cat, $code, $t1, $comp2,  $im , $action, 
                    ($q->{DOC} ? "":$desc) . "<br>$links", $info]) if ($cat && $save);

         $code = $info = $action_event = $cause = "";
         ($cat, $type, $comp) = split(/\./, $val, 3);
         $comp = "enclosure" if (!$comp);
         $last_type = "$cat.$type";
         $last_comp = $comp;
         if ($val ne "ZZ") {
           $code = $sev= $action= $desc= "";
           $COMP{$comp} = 1;
           $CAT{$cat} = 1;
           my $ix = index($type, ".");
           if ($ix > 0) {
             $TYPE{substr($type,0,$ix)} = 1;
           } else {
             $TYPE{$type} = 1;
           }  
         }
       #} elsif ($name eq "comp") {
       #  $COMP{$comp} = 1;
       #  $comp = $val;
       } elsif ($name eq "code"){
         $code = $val;
       } elsif ($name eq "severity"){
         $sev = $val;
       } elsif ($name eq "actionable"){
         $action = $val;
       } elsif ($name eq "desc"){
         $desc = $val;
       } elsif ($name eq "info"){
         $info = "<b>$LB->{info2}:</b><br> $val";  $which = 1;

       } elsif ($name eq "cause"){
         $cause = $val;  $which = 3;

       } elsif ($name eq "action"){
         $action_event = $val; $which = 2;
       }
    }
    close(O);
  }
  my $w1 = ($renv->{update_grid} eq "Y") ? 700:600;
  my $h1 = ($renv->{update_grid} eq "Y") ? 700:700;

  print Html->body();
  print Html->header2("service.event.grid", undef, undef, undef, {noHelp=>1});
  if (!$q->{REPORT}) {
     print "<table border=0 cellspacing=0 cellpadding=0 bgcolor=white width=$Style::WIDTH><tr><td>" . Util->readHtdocs("EventGrid") . "</table>";
  }

  my $comp_select = "<select name=comp><option value=\"\">$LB->{all}</option>";
  my $done;
  foreach my $k (sort keys %COMP) {
     next if ($k =~ /^driver\./);
     my $sel = ($k eq $q->{comp}) ? "selected":"";
     $comp_select .= "<option $sel>$k";
  }
  $comp_select .= "</select>";

  my $type_select = "<select name=type><option value=\"\">$LB->{all}</option>";
  foreach my $k (sort keys %TYPE) {
     my $sel = ($k eq $q->{type}) ? "selected":"";
     $type_select .= "<option $sel>$k";
  }
  $type_select .= "</select>";
  my $I = $q->{REPORT}? "<input type=checkbox name=REPORT checked>" :
                      "<input type=checkbox name=REPORT>";

  $q->{SORT} =1 if (!$q->{SORT});

  my $scr = Html::Screen->new({ });
  $scr->script( "
    function openw(a) {
       var b =  '$Http::WEBPROC?GO=GUI::Grid::info&_LOGIN=$q->{_LOGIN}&info=' + a;
       var O = 
       window.open(b,'eg','menubar=yes,resizable=yes,scrollbars=yes,width=$w1,height=$h1');
       O.focus();
    }
   ");

  $scr->add("<table border=0 cellspacing=0 cellpadding=0><tr><td>
              <form><input type=hidden name=GO value=GUI::Grid::Events>
              <input type=hidden name=_LOGIN value=\"$q->{_LOGIN}\">
             </table>
            ");

  $scr->table( { title => $LB->{title2} },
   [
   [ f => $LB->{cat}, $cat_select,     1 ],
   [ f => $LB->{search}, "<input type=text size=20 name=search value=\"$q->{search}\">", 2 ],
   [ f => $LB->{comp} ,  $comp_select, 1 ],
   [ f => $LB->{type},   $type_select, 2 ],
   [ f => $LB->{format}, $I,            ],
   ]);
  $scr->button2( [
    [ l => 'ACTION' , $LB->{submit}],
    ]);


  $scr->list( $q, { interactive => 1 , pageSize => 100, line2 => "7,2", xbreak => "#CCCCFF" },
    [
    [ l => $LB->{cat0} , '+s' ],
    [ l => $LB->{code0}  ],
    [ l => $LB->{event0} , '+s' ],
    [ c => $LB->{comp0}  , '+s' ],
    [ c => $LB->{sev0}   , '-s' ],
    [ l => $LB->{act0} , '-s' ],
    [ l => $LB->{desc0} ],
    ],
    \@R);
 
  $scr->add("</form>");
  print $scr->out();
  my $total = $#R +1;
  print "
    <table border=0 width=90% bgcolor=white>
     <tr><td> <li>$total $LB->{events} $LB->{info}
    </table>
    &nbsp;<p>&nbsp;<p>
    ";
}
 
1;
